/*
Copyright (C) 2001-2007 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef PRECOMPILED_H_
#define PRECOMPILED_H_

//*****************************************************************************
//	These are our various compilation options
//*****************************************************************************
#ifdef _MSC_VER

#define _CRT_SECURE_NO_DEPRECATE

#ifdef _DEBUG
#define _CRTDBG_MAP_ALLOC
#endif
#endif

//#define DAEDALUS_ENABLE_OS_HOOKS

//#define DAEDALUS_ENABLE_SYNCHRONISATION
#define DAEDALUS_ENABLE_DYNAREC
#define DAEDALUS_ZLIB_SUPPORT				// Undefine this if you don't have a local install of zlib. If you undefine this, you will need to remove unzip.c from the project too.
#define DAEDALUS_USE_EXCEPTIONS
#define DAEDALUS_BREAKPOINTS_ENABLED
//#define DAEDALUS_DEBUG_DYNAREC

#ifdef DAEDALUS_PSP
#define DAEDALUS_PSP_USE_VFPU
//#undef DAEDALUS_ENABLE_DYNAREC
#undef DAEDALUS_USE_EXCEPTIONS
#undef DAEDALUS_BREAKPOINTS_ENABLED
#endif

#ifdef DAEDALUS_OSX
#undef DAEDALUS_ENABLE_DYNAREC
#undef DAEDALUS_USE_EXCEPTIONS
#undef DAEDALUS_BREAKPOINTS_ENABLED
#endif

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

#if !defined( DAEDALUS_XB ) && defined( DAEDALUS_RELEASE_BUILD )
#define DAEDALUS_ALIGN_REGISTERS
#endif

//*****************************************************************************
//
//*****************************************************************************
#ifndef _MSC_VER
#define MAX_PATH 260
#define __cdecl        //No meaning on the PSP __attribute__((cdecl))
#define __fastcall     //No meaning on the PSP __attribute__((fastcall))
#define __stdcall      //No meaning on the PSP __attribute__((stdcall))
#define __forceinline	inline
#define __assume( x )
#define __declspec( x )

typedef long BOOL;
#define FALSE 0
#define TRUE 1

typedef int HRESULT;
typedef unsigned int DWORD;
typedef char CHAR;

typedef unsigned char BYTE;
typedef short WORD;
typedef int* HWND;
typedef int* HINSTANCE;
#endif

#ifdef DAEDALUS_W32
#include <atlbase.h>
extern CComModule _Module;
#include <atlwin.h>
#include <windows.h>
#include <windowsx.h>

#include <algorithm>
#include <vector>
#include <map>
#include <string>

#endif

#include <stdio.h>
#include <math.h>			// For sqrt()
#include <stdlib.h>
#include <string.h>

// Pull this in after all stl headers
#ifdef DAEDALUS_W32
#include <crtdbg.h>

#ifdef _DEBUG
#ifndef NEW_INLINE_WORKAROUND
#define NEW_INLINE_WORKAROUND new ( _NORMAL_BLOCK, __FILE__, __LINE__ )
#define new NEW_INLINE_WORKAROUND
#endif // NEW_INLINE_WORKAROUND
#endif // _DEBUG
#endif // DAEDALUS_W32


#include "Debug/DaedalusAssert.h"
#include "DaedalusTypes.h"

using namespace daedalus;

//*****************************************************************************
//
//*****************************************************************************
#ifdef _DEBUG

#define NODEFAULT		DAEDALUS_ERROR( "No default - we shouldn't be here" )

#else

#define NODEFAULT		__assume( 0 )

#endif
#define use(x)	do { } while(&(x) != &(x))


#ifndef SAFE_DELETE
#define SAFE_DELETE(p)  { if(p) { delete (p);     (p)=NULL; } }
#endif

#ifndef SAFE_RELEASE
#define SAFE_RELEASE(p)  { if(p) { (p)->Release();     (p)=NULL; } }
#endif

#ifndef SAFE_DELETEARRAY
#define SAFE_DELETEARRAY(p)  { if(p) { delete [](p);     (p)=NULL; } }
#endif

#ifndef ARRAYSIZE
#define ARRAYSIZE(arr)   (sizeof(arr) / sizeof(arr[0]))
#endif

#define DAEDALUS_VERSION		"0.08b"
#define DAEDALUS_SITE			"http://strmnnrmn.blogspot.com/"

//*****************************************************************************
//
//*****************************************************************************
extern const char * __cdecl DSPrintf( const char * fmt, ... );

#ifndef DAEDALUS_PSP
extern HINSTANCE	g_hInstance;
extern char			g_szDaedalusName[256];
#endif
extern char			gDaedalusExePath[MAX_PATH+1];

#include "ConfigOptions.h"
#include "Alignment.h"


// Windowsx.h type defines - hope these don't conflict with anything!
#define CheckBox_GetCheck(hwnd)			SendMessage(hwnd, BM_GETCHECK, 0,0)
#define CheckBox_SetCheck(hwnd, state)	SendMessage(hwnd, BM_SETCHECK, (WPARAM)state,0)

#define CheckBox_IsChecked( hwnd )		(CheckBox_GetCheck( (hwnd) ) == BST_CHECKED)

#endif // PRECOMPILED_H_
