/*
Copyright (C) 2007 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"

#include "GraphicsPluginXbox.h"

#include "Interface/MainWindow.h"
#include "Core/Interrupt.h"
#include "Core/Memory.h"
#include "Core/ROM.h"

//*****************************************************************************
//
//*****************************************************************************
extern BOOL		Graphics_InitiateGFX();
extern void		Graphics_ProcessDList();
extern HRESULT	Graphics_ExecuteCommand( const CHAR * pszCommand, void ** ppResult );
extern void		Graphics_RomClosed();
extern void		Graphics_CloseDLL();
extern void		Graphics_UpdateScreen();

//*****************************************************************************
//
//*****************************************************************************
CGraphicsPluginXbox::CGraphicsPluginXbox()
{
	Graphics_InitiateGFX();
}

//*****************************************************************************
//
//*****************************************************************************
CGraphicsPluginXbox::~CGraphicsPluginXbox()
{
}

//*****************************************************************************
//
//*****************************************************************************
bool	CGraphicsPluginXbox::StartEmulation()
{
	return true;
}

//*****************************************************************************
//
//*****************************************************************************
void CGraphicsPluginXbox::ProcessDList()
{
	Graphics_ProcessDList();
}

//*****************************************************************************
//
//*****************************************************************************
void	CGraphicsPluginXbox::UpdateScreen()
{
	Graphics_UpdateScreen();
}

//*****************************************************************************
//
//*****************************************************************************
void	CGraphicsPluginXbox::ViStatusChanged()
{
}

//*****************************************************************************
//
//*****************************************************************************
void	CGraphicsPluginXbox::ViWidthChanged()
{
}

//*****************************************************************************
//
//*****************************************************************************
void	CGraphicsPluginXbox::RomClosed()
{
	Graphics_RomClosed();
}

//*****************************************************************************
//
//*****************************************************************************
void	CGraphicsPluginXbox::CloseDll()
{
	Graphics_CloseDLL();
}

//*****************************************************************************
//
//*****************************************************************************
CGraphicsPlugin *		CreateGraphicsPlugin()
{
	return new CGraphicsPluginXbox;
}
