/*
Copyright (C) 2004 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"

#include "DBGConsole.h"


//*****************************************************************************
// Static variables
//*****************************************************************************

//*****************************************************************************
// Implementation of the debug console
//*****************************************************************************
class IDebugConsole : public CDebugConsole
{
	public:
		IDebugConsole();
		virtual ~IDebugConsole()	{ }

		void			EnableConsole( bool bEnable )
		{
		}

		bool			IsVisible() const
		{
			return true;
		}

		void			UpdateDisplay()
		{
		}

		void			DisplayProfile()
		{
		}

		void __cdecl	Msg(DWORD dwType, LPCTSTR szFormat, ...)
		{
			static	CHAR	str[ 1024 ];
			va_list marker;
			va_start( marker, szFormat );
			vsprintf( str, szFormat, marker );
			va_end( marker );

			OutputDebugString( str );
			OutputDebugString( "\n" );
		}
		void MsgOverwriteStart() {}
		void MsgOverwriteEnd() {}

		void __cdecl	MsgOverwrite(DWORD dwType, LPCTSTR szFormat, ...)
		{
			static	CHAR	str[ 1024 ];
			va_list marker;
			va_start( marker, szFormat );
			vsprintf( str, szFormat, marker );
			va_end( marker );

			OutputDebugString( str );
			OutputDebugString( "\n" );
		}

		void __cdecl	Stats( StatType stat, LPCTSTR szFormat, ...)
		{

		}

};

//*****************************************************************************
//
//*****************************************************************************
bool CSingleton< CDebugConsole >::Create()
{
	HRESULT hr;
	
	CDebugConsole * pNewInstance;
	
	_ASSERTE(mpInstance == NULL);
	
	pNewInstance = new IDebugConsole();
	if (!pNewInstance)
		hr = E_OUTOFMEMORY;
	else
		hr = S_OK;
	
	mpInstance = pNewInstance;
	return SUCCEEDED(hr);
};

//*****************************************************************************
//
//*****************************************************************************
IDebugConsole::IDebugConsole() 
{
}

