/*
Copyright (C) 2007 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "AudioPluginW32.h"

#include "Core/Interrupt.h"
#include "Core/Memory.h"
#include "Core/ROM.h"
#include "Core/CPU.h"
#include "Interface/MainWindow.h"
#include "DaedThread.h"

#include "Resources/resource.h"
#include "Utility/ResourceString.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//#define DAED_AUDIO_THREAD_ENABLED

#ifdef DAED_AUDIO_THREAD_ENABLED
static s32			gAudioThreadHandle( daedalus::INVALID_THREAD_HANDLE );
#endif

static bool			gKeepRunningAudioThread( true );


CAudioPluginDll::CAudioPluginDll(const char * dll_name) :
	pDacrateChanged(NULL),
	pLenChanged(NULL),
	pReadLength(NULL),
	pUpdate(NULL),
	pCloseDll(NULL),
	pDllAbout(NULL),
	pDllConfig(NULL),
	pDllTest(NULL),
	pInitiateAudio(NULL),
	pProcessAList(NULL),
	pRomClosed(NULL),
	hModule(NULL)
{
	lstrcpyn(mModuleName, dll_name, MAX_PATH);
}


CAudioPluginDll *	CAudioPluginDll::Create( const char * dll_name )
{
	CAudioPluginDll *		plugin( new CAudioPluginDll( dll_name ) );
	if( !plugin->OpenDll() )
	{
		delete plugin;
		plugin = NULL;
	}

	return plugin;
}


static void __cdecl CheckInterrupts(void)
{
	//DBGConsole_Msg(0, "AI Plugin called Check Interrupts");
	R4300_Interrupt_UpdateCause3();
}


CAudioPluginDll::~CAudioPluginDll()
{
#ifndef DAEDALUS_XB
	if (hModule != NULL)
	{
		// Only call if InitiateAudio called?
		AUTO_CRIT_SECT( mCritSect );
		if (pCloseDll)
		{
			AI_TRY { pCloseDll(); }
			AI_CATCH
		}

		FreeLibrary(hModule);
	}
#endif // DAEDALUS_XB
}


bool CAudioPluginDll::OpenDll()
{
#ifndef DAEDALUS_XB
	hModule = LoadLibrary(mModuleName);
	if (hModule == NULL)
		return false;


	void   (PLUGIN_SPEC_CALL * pGetDllInfo)(PLUGIN_INFO *);
	pGetDllInfo = (void (PLUGIN_SPEC_CALL *)(PLUGIN_INFO *))GetProcAddress(hModule, "GetDllInfo");
	if (pGetDllInfo == NULL)
		return false;

	pGetDllInfo(&mPluginInfo);
	if (mPluginInfo.Type != PLUGIN_TYPE_AUDIO)
	{
		return false;
	}

    pDacrateChanged = (void   (PLUGIN_SPEC_CALL * )(int))GetProcAddress(hModule, "AiDacrateChanged");
    pLenChanged     = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "AiLenChanged");
    pReadLength     = (DWORD  (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "AiReadLength");
    pUpdate         = (void   (PLUGIN_SPEC_CALL * )(BOOL))GetProcAddress(hModule, "AiUpdate");
    pCloseDll       = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "CloseDLL");
    pDllAbout       = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllAbout");
    pDllConfig      = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllConfig");
    pDllTest        = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllTest");
    pInitiateAudio  = (BOOL   (PLUGIN_SPEC_CALL * )(AUDIO_INFO))GetProcAddress(hModule, "InitiateAudio");
    pProcessAList   = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "ProcessAList");
    pRomClosed      = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "RomClosed");
#endif //DAEDALUS_XB

	return true;
}



#ifdef DAED_AUDIO_THREAD_ENABLED
//*****************************************************************************
//
//*****************************************************************************
static u32 __stdcall AudioThreadFunc()
{
	DBGConsole_Msg(0, "Audio thread started");

	daedalus::SetThreadPriority( gAudioThreadHandle, TP_TIME_CRITICAL );

#ifdef DAEDALUS_USE_EXCEPTIONS
	try 
#endif
	{
		// Audio plugin may die on us - in which case the wrapper will unload the plugin
		while ( g_pAiPlugin && gKeepRunningAudioThread )
		{
			g_pAiPlugin->Update( true );
		}
	}
#ifdef DAEDALUS_USE_EXCEPTIONS
	catch (...)
	{
		if ( g_DaedalusConfig.TrapExceptions )
		{
			CMainWindow::Get()->MessageBox(CResourceString(IDS_AUDIOTHREAD_EXCEPTION),
										   g_szDaedalusName,
										   MB_ICONEXCLAMATION|MB_OK);
		}
		else
			throw;
	}
#endif

	DBGConsole_Msg(0, "Audio thread stopping");
	return 0;
}
#endif // DAED_AUDIO_THREAD_ENABLED

bool CAudioPluginDll::StartEmulation()
{
	AUDIO_INFO ai;

	ai.hwnd = CMainWindow::Get()->GetWindow();
	ai.hinst = g_hInstance;
	ai.MemoryBswaped = TRUE;
	ai.HEADER = (BYTE*)&g_ROM.rh;
	ai.RDRAM = (BYTE*)g_pMemoryBuffers[MEM_RD_RAM];
	ai.DMEM = (BYTE*)g_pMemoryBuffers[MEM_SP_MEM] + SP_DMA_DMEM;
	ai.IMEM = (BYTE*)g_pMemoryBuffers[MEM_SP_MEM] + SP_DMA_IMEM;

	ai.xMI_INTR_REG = MI_REG_ADDRESS(MI_INTR_REG);
	ai.xAI_DRAM_ADDR_REG = AI_REG_ADDRESS(AI_DRAM_ADDR_REG); 
	ai.xAI_LEN_REG = AI_REG_ADDRESS(AI_LEN_REG); 
	ai.xAI_CONTROL_REG = AI_REG_ADDRESS(AI_CONTROL_REG); 
	ai.xAI_STATUS_REG = AI_REG_ADDRESS(AI_STATUS_REG); 
	ai.xAI_DACRATE_REG = AI_REG_ADDRESS(AI_DACRATE_REG); 
	ai.xAI_BITRATE_REG = AI_REG_ADDRESS(AI_BITRATE_REG); 

	ai.CheckInterrupts = CheckInterrupts;

	BOOL bAudio = InitiateAudio(ai);
	if (!bAudio)
	{
		DBGConsole_Msg(0, "Unable to initialise audio plugin");
		return false;
	}
	
	DBGConsole_Msg(0, "Audio plugin initialised ok");

	// Stupid hack to force plugins to create the sound buffer
	DacrateChanged(ST_NTSC);

	gKeepRunningAudioThread = true;
#ifdef DAED_AUDIO_THREAD_ENABLED
	DAEDALUS_ASSERT( gAudioThreadHandle == daedalus::INVALID_THREAD_HANDLE, "Why is there already an audio thread?" );
	gAudioThreadHandle = daedalus::CreateThread( AudioThreadFunc, true );
#endif

	return true;
}

void CAudioPluginDll::StopEmulation()
{
	gKeepRunningAudioThread = false;
#ifdef DAED_AUDIO_THREAD_ENABLED
	DAEDALUS_ASSERT( gAudioThreadHandle != daedalus::INVALID_THREAD_HANDLE, "Why is there no audio thread?" );
	daedalus::WaitForThreadTermination( gAudioThreadHandle, 1000 );
	daedalus::ReleaseThreadHandle( gAudioThreadHandle );
	gAudioThreadHandle = daedalus::INVALID_THREAD_HANDLE;
#endif
}

//*****************************************************************************
//
//*****************************************************************************
CAudioPlugin *		CreateAudioPlugin()
{
	CAudioPlugin *	audio_plugin( NULL );
	//
	// Only try to init if an audio plugin has been specified
	//
	if (strlen(g_DaedalusConfig.szAiPluginFileName) > 0)
	{
		DBGConsole_Msg(0, "Initialising Audio Plugin [C%s]", g_DaedalusConfig.szAiPluginFileName);

		audio_plugin = CAudioPluginDll::Create(g_DaedalusConfig.szAiPluginFileName);
		if ( audio_plugin == NULL )
		{
			DBGConsole_Msg(0, "Error loading audio plugin");
		}
	}
	return audio_plugin;
}
