/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "Debug/DaedalusAssert.h"

#ifndef DAEDALUS_RELEASE_BUILD

#ifdef _DEBUG

int __cdecl DaedalusAssert( const char * msg, const char * expression, const char * file, unsigned int line )
{
	// Lkb: I suspect this won't be defined when compiling for GNU C - can you suggest an alterative? StrmnNrmn

	// Returns 1 for retry
	// Returns 0 for ignore
	return _CrtDbgReport(_CRT_ASSERT, file, line, "Daedalus.exe", "%s\nMessage: %s", expression, msg );	
}

#else

int DaedalusAssert( const char * msg, const char * expression, const char * file, unsigned int line )
{
#ifdef DAEDALUS_XB
	return 0;
#else
	CHAR text[1024];

	wsprintf( text, "Debug Assertion Failed!\n"
					"\n"
					"File: %s\n"
					"Line: %d\n"
					"\n"
					"Expression: %s\n"
					"Message: %s\n"
					"\n"
					"(Press Retry to debug the appliation)",
					file,
					line,
					expression,
					msg );

	int ret = ::MessageBox( NULL, text, "Assert", MB_ABORTRETRYIGNORE | MB_ICONERROR );

	if ( ret == IDIGNORE )
		return 0;
	if ( ret == IDRETRY )
		return 1;

	exit( 1 );
#endif
}


#endif		// _DEBUG
#endif		// DAEDALUS_RELEASE_BUILD