/*
Copyright (C) 2007 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "GraphicsPluginPSP.h"

#include "PSPGraphics/DaedalusGraphics.h"
#include "Debug/DBGConsole.h"

//*****************************************************************************
//
//*****************************************************************************
CGraphicsPluginPsp::CGraphicsPluginPsp()
{

}

//*****************************************************************************
//
//*****************************************************************************
CGraphicsPluginPsp::~CGraphicsPluginPsp()
{

}

//*****************************************************************************
//
//*****************************************************************************
bool CGraphicsPluginPsp::Initialise()
{
	return PSPGraphics_Initialise();
}

//*****************************************************************************
//
//*****************************************************************************
bool CGraphicsPluginPsp::StartEmulation()
{
	return true;
}

//*****************************************************************************
//
//*****************************************************************************
void CGraphicsPluginPsp::ViStatusChanged()
{
}

//*****************************************************************************
//
//*****************************************************************************
void CGraphicsPluginPsp::ViWidthChanged()
{
}

//*****************************************************************************
//
//*****************************************************************************
void CGraphicsPluginPsp::ProcessDList()
{
	PSPGraphics_ProcessDisplayList();
}

//*****************************************************************************
//
//*****************************************************************************
void CGraphicsPluginPsp::UpdateScreen()
{
	PSPGraphics_OnVbl();
}

//*****************************************************************************
//
//*****************************************************************************
void CGraphicsPluginPsp::RomClosed()
{
	//
	//	Clean up resources used by the PSP build
	//
	DBGConsole_Msg(0, "Finalising PSPGraphics");
	PSPGraphics_Finalise();
}

//*****************************************************************************
//
//*****************************************************************************
CGraphicsPlugin *		CreateGraphicsPlugin()
{
	DBGConsole_Msg( 0, "Initialising Graphics Plugin [CPSP]" );

	CGraphicsPluginPsp *	plugin( new CGraphicsPluginPsp );
	if( !plugin->Initialise() )
	{
		delete plugin;
		plugin = NULL;
	}

	return plugin;
}
