/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// TODO: Add a CriticalSection to stop multiple threads using the 
// Unique objects simultaneously

#include "stdafx.h"
#include "DaedalusGraphics.h"
#include "PSPRenderer.h"

#include "GraphicsContext.h"
#include "VideoMemoryManager.h"

#include "Utility/Profiler.h"
#include "Utility/FramerateLimiter.h"
#include "TextureCache.h"

#include "DLParser.h"
#include "PSPColour.h"

#include "DaedTiming.h"

#include <pspdisplay.h>
#include <pspdebug.h>
#include <pspgu.h>


#ifdef DAEDALUS_DEBUG_DISPLAYLIST
#include "DisplayListDebugger.h"
#endif

#include "Core/Memory.h"
#include "ultra_rcp.h"

//#define DAEDALUS_FRAMERATE_ANALYSIS

extern void HandleEndOfFrame();

bool	gFrameskipActive = false;
bool	gTakeScreenshot = false;
bool	gDebugDisplayList = false;

EFrameskipValue		gFrameskipValue = FV_DISABLED;

//*************************************************************************************
//
//*************************************************************************************
bool PSPGraphics_Initialise()
{
	if(!PSPRenderer::Create())
	{
		return false;
	}

	if(!CTextureCache::Create())
	{
		return false;
	}

	if (!DLParser_Initialise()) 
	{
		return false;
	}

	return true;
}

//*************************************************************************************
//
//*************************************************************************************
void PSPGraphics_Finalise()
{
	DLParser_Finalise();
	CTextureCache::Destroy();
	PSPRenderer::Destroy();
}


//*************************************************************************************
//
//*************************************************************************************
void PSPGraphics_ProcessDisplayList(void)
{
#ifdef DAEDALUS_DEBUG_DISPLAYLIST
	if(!gDebugDisplayList)
#endif
	{
		DLParser_Process();
	}

#ifdef DAEDALUS_DEBUG_DISPLAYLIST
	// DLParser_Process may set this flag, so check again after execution
	if(gDebugDisplayList)
	{
		CDisplayListDebugger *	p_debugger( CDisplayListDebugger::Create() );
		p_debugger->Run();
		delete p_debugger;
		gDebugDisplayList = false;
	}
#endif
}

namespace
{
	u32					gTotalFrames = 0;
	u32					gVblCount = 0;
	u32					gFlipCount = 0;
	float				gCurrentVblrate = 0.0f;
	float				gCurrentFramerate = 0.0f;
	u64					gLastFramerateCalcTime = 0;
	u64					gTicksPerSecond = 0;

#ifdef DAEDALUS_FRAMERATE_ANALYSIS
	u64					gFirstFrameTime = 0;
	FILE *				gFramerateFile = NULL;
#endif

void	UpdateFramerate()
{
	gTotalFrames++;
	gFlipCount++;

	u64			now;
	NTiming::GetPreciseTime( &now );

	if(gLastFramerateCalcTime == 0)
	{
		u64		freq;
		gLastFramerateCalcTime = now;

		NTiming::GetPreciseFrequency( &freq );
		gTicksPerSecond = freq;
	}

#ifdef DAEDALUS_FRAMERATE_ANALYSIS
	if( gFramerateFile == NULL )
	{
		gFirstFrameTime = now;
		gFramerateFile = fopen( "framerate.csv", "w" );
	}
	fprintf( gFramerateFile, "%d,%f\n", gTotalFrames, f32(now - gFirstFrameTime) / f32(gTicksPerSecond) );
#endif

	// If 1 second has elapsed since last recalculation, do it now
	u64		ticks_since_recalc( now - gLastFramerateCalcTime );
	if(ticks_since_recalc > gTicksPerSecond)
	{
		gCurrentVblrate = float( gVblCount * gTicksPerSecond ) / float( ticks_since_recalc );
		gCurrentFramerate = float( gFlipCount * gTicksPerSecond ) / float( ticks_since_recalc );

		gVblCount = 0;
		gFlipCount = 0;
		gLastFramerateCalcTime = now;

	#ifdef DAEDALUS_FRAMERATE_ANALYSIS
		if( gFramerateFile != NULL )
		{
			fflush( gFramerateFile );
		}
	#endif
	}

	if( gGlobalPreferences.DisplayFramerate )
	{
		//pspDebugScreenSetOffset( int(p_front) & ~0x40000000 );
		pspDebugScreenSetTextColor( 0xffffffff );
		pspDebugScreenSetXY(0, 0);
		pspDebugScreenPrintf( "Frames/sec: %#.1f | Vbls/sec: %d/%d | Sync: %#.2f%%   ", gCurrentFramerate, u32( gCurrentVblrate ), FramerateLimiter_GetTvFrequencyHz(), FramerateLimiter_GetSync() * 100.0f );
	}

}
}

//*************************************************************************************
//
//*************************************************************************************
void PSPGraphics_OnVbl()
{
	gVblCount++;

	static u32		last_origin = 0;
	u32 current_origin = Memory_VI_GetRegister(VI_ORIGIN_REG);
	if( current_origin != last_origin )
	{
		//printf( "Flip (%08x, %08x)\n", current_origin, last_origin );
		UpdateFramerate();

		if(!gFrameskipActive)
		{			
			if(gTakeScreenshot)
			{
				CGraphicsContext::Get()->DumpNextScreen();
				gTakeScreenshot = false;
			}
			CGraphicsContext::Get()->UpdateFrame( false );
		}

		static u32 current_frame = 0;
		current_frame++;
		if( gFrameskipValue == FV_DISABLED )
		{
			gFrameskipActive = false;
		}
		else
		{
			gFrameskipActive = (current_frame % gFrameskipValue) != 0;
		}

		last_origin = current_origin;
#ifdef DAEDALUS_ENABLE_PROFILING
		CProfiler::Get()->Update();
		CProfiler::Get()->Display();
#endif
	}

	HandleEndOfFrame();
}
