/*
Copyright (C) 2003 Azimer
Copyright (C) 2001,2006 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//
//	N.B. This source code is derived from Azimer's Audio plugin (v0.55?)
//	and modified by StrmnNrmn to work with Daedalus PSP. Thanks Azimer!
//	Drop me a line if you get chance :)
//

#include "stdafx.h"

#include "AudioPluginPSP.h"
#include "AudioCode.h"
#include "audiohle.h"

#include "Core/Interrupt.h"
#include "Core/Memory.h"
#include "Core/ROM.h"

//*****************************************************************************
//
//*****************************************************************************
bool gAudioPluginEnabled( false );
bool gAdaptFrequency( false );


//*****************************************************************************
//
//*****************************************************************************
CAudioPluginPsp::CAudioPluginPsp()
:	mAudioCode( new AudioCode )
,	mLastDACRate( 0 )
{
	mAudioCode->SetAdaptFrequency( gAdaptFrequency );
}

//*****************************************************************************
//
//*****************************************************************************
CAudioPluginPsp::~CAudioPluginPsp()
{
	ChangeABI(0);
	delete mAudioCode;
}

//*****************************************************************************
//
//*****************************************************************************
CAudioPluginPsp *	CAudioPluginPsp::Create()
{
	return new CAudioPluginPsp();
}

//*****************************************************************************
//
//*****************************************************************************
void	CAudioPluginPsp::SetAdaptFrequecy( bool adapt )
{
	mAudioCode->SetAdaptFrequency( adapt );
}

//*****************************************************************************
//
//*****************************************************************************
bool		CAudioPluginPsp::StartEmulation()
{
	//PluginInfo->MemoryBswaped = TRUE;
	//PluginInfo->NormalMemory  = FALSE;
	//strcpy (PluginInfo->Name, "Azimer's HLE Audio v");
	//strcat (PluginInfo->Name, PLUGIN_VERSION);
	//PluginInfo->Type = PLUGIN_TYPE_AUDIO;
	//PluginInfo->Version = 0x0101; // Set this to retain backwards compatibility

	ChangeABI(0);
	return true;
}

//*****************************************************************************
//
//*****************************************************************************
void	CAudioPluginPsp::StopEmulation()
{
	mAudioCode->StopAudio();
}

//*****************************************************************************
//
//*****************************************************************************
void	CAudioPluginPsp::DacrateChanged( ESystemType system_type )
{
	printf( "DacrateChanged( %d )\n", system_type );

	if (mLastDACRate != Memory_AI_GetRegister(AI_DACRATE_REG))
	{
		mLastDACRate = Memory_AI_GetRegister(AI_DACRATE_REG);

		u32		frequency;
		switch (system_type)
		{
			case ST_NTSC: frequency = 48681812 / (mLastDACRate + 1); break;
			case ST_PAL:  frequency = 49656530 / (mLastDACRate + 1); break;
			case ST_MPAL: frequency = 48628316 / (mLastDACRate + 1); break;
			default:
				DAEDALUS_ERROR( "Unrecognised system type" );
				frequency = 48681812 / (mLastDACRate + 1);
				break;
		}
		mAudioCode->SetFrequency( frequency );
	}

}

//*****************************************************************************
//
//*****************************************************************************
void	CAudioPluginPsp::LenChanged()
{
	if( gAudioPluginEnabled )
	{
		mAudioCode->SetAdaptFrequency( gAdaptFrequency );

		u32		address( Memory_AI_GetRegister(AI_DRAM_ADDR_REG) & 0x00FFFFF8 );
		u32		length( Memory_AI_GetRegister(AI_LEN_REG) & 0x3FFF8 );

		u32		result( mAudioCode->AddBuffer( g_pu8RamBase + address, length ) );
		//if (result & SND_IS_FULL)
		//	Memory_AI_GetRegister(AI_STATUS_REG) |= AI_STATUS_FIFO_FULL;
		//Memory_AI_GetRegister(AI_STATUS_REG) |= AI_STATUS_DMA_BUSY;
		use(result);
	}
	else
	{
		mAudioCode->StopAudio();
	}
}

//*****************************************************************************
//
//*****************************************************************************
u32		CAudioPluginPsp::ReadLength()
{
	u32		length( mAudioCode->GetReadStatus() );

	Memory_AI_SetRegister( AI_LEN_REG, length );

	return length;
}

//*****************************************************************************
//
//*****************************************************************************
void	CAudioPluginPsp::Update( bool wait )
{
	// if(Wait) WaitMessage();
}

//*****************************************************************************
//
//*****************************************************************************
void	CAudioPluginPsp::ProcessAList()
{
	if( gAudioPluginEnabled )
	{
		HLEStart();
	}
}

//*****************************************************************************
//
//*****************************************************************************
void	CAudioPluginPsp::RomClosed()
{
	ChangeABI(0);
	mAudioCode->StopAudio();
	mLastDACRate = 0;
}

//*****************************************************************************
//
//*****************************************************************************
CAudioPlugin *		CreateAudioPlugin()
{
	return CAudioPluginPsp::Create();
}
