/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "Patch.h"

#ifdef DAEDALUS_ENABLE_OS_HOOKS

#include "Daedalus_CRC.h"

#include "Debug/DebugLog.h"
#include "Core/Memory.h"
#include "Core/CPU.h"		// For CPU_AddJob()
#include "Interface/MainWindow.h"	// For Main_SetStatus
#include "Core/R4300.h"
#include "Core/R4300_Regs.h"
#include "Core/Registers.h"
#include "Core/ROM.h"

#include "patch_symbols.h"
#include "os.h"

#include "ultra_os.h"
#include "ultra_rcp.h"
#include "ultra_sptask.h"
#include "ultra_r4300.h"

#include "OSMesgQueue.h"

//#include "rdp.h"		// RDP_LoadTask
#include "Debug/DBGConsole.h"

#include <stddef.h>		// offsetof

extern PatchSymbol g___osDispatchThread_s;
extern PatchSymbol g___osEnqueueAndYield_s;


typedef struct 
{
	DWORD dwThread;
	DWORD dwTime;
} ThreadTimes;

//std::vector<ThreadTimes> g_ThreadTimes;

/*
osSystemTimeHi is 0x80367110
osSystemTimeLo is 0x80367114
osSystemCount is 0x80367118
osSystemLastCount is 0x80367120
osNullMsgQueue is 0x803359a0
osThreadQueue is 0x803359a8
osActiveThread is 0x803359b0
osEventMesgArray is 0x80364ba0
osThreadDieRA is 0x80327ea8
osGlobalThreadList is 0x803359ac

osDispatchThreadRCPThingamy is 0x80339a40
*****osMarioKartUnk is 0x80000000
osEepPifBuffer is 0x80367170
osEepPifThingamy is 0x803671ac
osEepPifThingamy2 is 0x80367090
osAiSetNextBufferThingy is 0x80335930
osPiAccessQueueCreated is 0x80335a50
osPiAccessQueueBuffer is 0x80367130


// MarioKart
osSystemTimeHi is 0x80197600
osSystemTimeLo is 0x80197604
osSystemCount is 0x80197608
osSystemLastCount is 0x80197610
osNullMsgQueue is 0x800eb3a0
osEventMesgArray is 0x80196440
osThreadDieRA is 0x800d1aa0
osGlobalThreadList is 0x800eb3ac
osThreadQueue is 0x800eb3a8
osActiveThread is 0x800eb3b0


osDispatchThreadRCPThingamy is 0x800f3c10
osMarioKartUnk is 0x800ea5ec
osEepPifBuffer is 0x80197660
osEepPifThingamy is 0x8019769c
osEepPifThingamy2 is 0x80196540
osAiSetNextBufferThingy is 0x800eb370
osPiAccessQueueCreated is 0x800eb440
osPiAccessQueueBuffer is 0x80197620

*/


//static const u32 g_dwSystemTimeHi		= 0x80367110;
//static const u32 g_dwSystemTimeLo		= 0x80367114;
//static const u32 g_dwSystemCount		= 0x80367118;
//static const u32 g_dwNullMsgQueue		= 0x803359a0;	
//static const u32 g_dwThreadQueue		= 0x803359a8;
//static const u32 g_dwActiveThread		= 0x803359b0;
//static const u32 g_dwEventMsgBase		= 0x80364ba0;
//static const u32 g_dwThreadDieRA		= 0x80327ea8;
//static const u32 g_dwGlobalThreadList	= 0x803359ac;
//static const u32 g_dwosDispatchThreadRCPThingamy = 0x80339a40;
//static const u32 g_dwPiAccessQueueCreated = 0x80335a50;
//static const u32 g_dwPiAccessQueueBuffer = 0x80367130;


//static const u32 g_dwTimerList		= 0x80335940;
//static const u32 g_dwFrameCount		= 0x8036711c;

//static const u32 g_dwFaultedThread	= 0x803359b4;
//static const u32 g_dwActiveQueue		= 0x80335a20; - not sure if this is correct - ultrahle seems to incorrectly identify
//static const u32 g_dwIP7Flag			= 0x80335a44;
//static const u32 g_dwIP6Flag			= 0x80335a48;
//static const u32 g_dwIntLookup		= 0x80339980;	// fuddle interrupt bits and lookup byte value
//static const u32 g_dwIntLookup2		= 0x803399a0;	// fuddle interrupt bits and lookup word value
//static const u32 g_dwKernelHWThread	= 0x803672b0;
//static const u32 g_dwLastCount		= 0x80367120;
//static const u32 g_dwSiAccessQueueCreated = 0x80335a60;
//static const u32 g_dwSiAccessQueueBuffer = 0x80367150;
//static const u32 g_dwSiAccessQueue = 0x80367158;
//static const u32 g_dwPiAccessQueue = 0x80367138;
// osEepBuffer 0x80367170

//g_dwViThingamme 0x80335a24 points to Vi info of some description
//static const DWORD dwSpTempTask = 0x80364c20;
// 
static DWORD g_dwControllerMQ = 0;

//static DWORD g_dwNumNormalize = 0;
//static DWORD g_dwNumMtxF2L = 0;
//static DWORD g_dwNumMtxIdent = 0;
//static DWORD g_dwNumMtxTranslate = 0;
//static DWORD g_dwNumMtxScale = 0;
//static DWORD g_dwNumMtxRotate = 0;
//static DWORD g_dwNumCosSin = 0;



static const char * g_szEventStrings[23] = 
{
	"OS_EVENT_SW1",
	"OS_EVENT_SW2",
	"OS_EVENT_CART", 
	"OS_EVENT_COUNTER",
	"OS_EVENT_SP",
	"OS_EVENT_SI",
	"OS_EVENT_AI",
	"OS_EVENT_VI",
	"OS_EVENT_PI",
	"OS_EVENT_DP",
	"OS_EVENT_CPU_BREAK",
	"OS_EVENT_SP_BREAK",
	"OS_EVENT_FAULT",
	"OS_EVENT_THREADSTATUS",
	"OS_EVENT_PRENMI",
	"OS_EVENT_RDB_READ_DONE",
	"OS_EVENT_RDB_LOG_DONE",
	"OS_EVENT_RDB_DATA_DONE",
	"OS_EVENT_RDB_REQ_RAMROM",
	"OS_EVENT_RDB_FREE_RAMROM",
	"OS_EVENT_RDB_DBG_DONE",
	"OS_EVENT_RDB_FLUSH_PROF",
	"OS_EVENT_RDB_ACK_PROF"
};


inline bool IsSpDeviceBusy()
{
	u32 status = Read32Bits(PHYS_TO_K1(SP_STATUS_REG));

	if (status & (SP_STATUS_IO_FULL | SP_STATUS_DMA_FULL | SP_STATUS_DMA_BUSY))
		return true;
	else
		return false;
}

inline u32 SpGetStatus()
{
	return Read32Bits(PHYS_TO_K1(SP_STATUS_REG));
}

#define TEST_DISABLE_FUNCS //return PATCH_RET_NOT_PROCESSED;





BOOL g_bPatchesInstalled = FALSE;

//DWORD g_dwOSStart = 0x00240000;
//DWORD g_dwOSEnd   = 0x00380000;


void Patch_ResetSymbolTable();
void Patch_RecurseAndFind();
BOOL Patch_LocateFunction(PatchSymbol * ps);
static BOOL Patch_VerifyLocation(PatchSymbol * ps, DWORD dwIndex);
static BOOL Patch_VerifyLocation_CheckSignature(PatchSymbol * ps, PatchSignature * psig, DWORD dwIndex);

static void Patch_ApplyPatch(DWORD i);


void Patch_Reset()
{
	g_bPatchesInstalled = FALSE;

	Patch_ResetSymbolTable();
}

void Patch_ResetSymbolTable()
{
	// Loops through all symbols, until name is null
	for (u32 i = 0; i < ARRAYSIZE(g_PatchSymbols); i++)
	{
		g_PatchSymbols[i]->bFound = false;
	}

	for (u32 i = 0; i < ARRAYSIZE(g_PatchVariables); i++)
	{
		g_PatchVariables[i]->bFound = false;
		g_PatchVariables[i]->bFoundHi = false;
		g_PatchVariables[i]->bFoundLo = false;
	}
}


void Patch_ApplyPatches()
{
	if (!gOSHooksEnabled)
		return;

	Patch_RecurseAndFind();

	// Do this every time or just when originally patched
	/*result = */OS_Reset();

	// This may already be set if this function has been called before
	g_bPatchesInstalled = TRUE;
}


void Patch_ApplyPatch(DWORD i)
{
	u32 dwPC = g_PatchSymbols[i]->dwLocation;
	OpCode  * p_mem_base = (OpCode*)(g_pu32RamBase + (dwPC>>2));
	OpCode original_op;
	
	original_op = *p_mem_base;

	// Check not alreay patched...
	if ( original_op.op == OP_PATCH)
	{
		// Already patched
		//DBGConsole_Msg(0, "[M%s is already patched]", g_PatchSymbols[i]->szName);
	}
	else
	{
		// Not been patched before
		g_PatchSymbols[i]->opReplaced = original_op;
		p_mem_base->op = OP_PATCH;			// Write patch
		p_mem_base->patch_index = i;
	}
}

// Return the location of a symbol
u32 Patch_GetSymbolAddress(const char * szName)
{
	// Search new list
	for (u32 p = 0; p < ARRAYSIZE(g_PatchSymbols); p++)
	{
		// Skip symbol if already found, or if it is a variable
		if (!g_PatchSymbols[p]->bFound)
			continue;

		if (_strcmpi(g_PatchSymbols[p]->szName, szName) == 0)
			return PHYS_TO_K0(g_PatchSymbols[p]->dwLocation);

	}

	// The patch was not found
	return u32(~0);

}

// Given a location, this function returns the name of the matching
// symbol (if there is one)
const char * Patch_GetJumpAddressName(u32 dwJumpTarget)
{
	u32 * pdwOpBase;
	u32 * pdwPatchBase;

	if (!Memory_GetInternalReadAddress(dwJumpTarget, (void **)&pdwOpBase))
		return "??";

	// Search new list
	for (u32 p = 0; p < ARRAYSIZE(g_PatchSymbols); p++)
	{
		// Skip symbol if already found, or if it is a variable
		if (!g_PatchSymbols[p]->bFound)
			continue;

		pdwPatchBase = g_pu32RamBase + (g_PatchSymbols[p]->dwLocation>>2);

		// Symbol not found, attempt to locate on this pass. This may
		// fail if all dependent symbols are not found
		if (pdwPatchBase == pdwOpBase)
		{
			return g_PatchSymbols[p]->szName;
		}

	}

	// The patch was not found
	return "?";
}


void Patch_DumpOsThreadInfo()
{
	DWORD dwThread;
	DWORD dwCurrentThread;
	
	DWORD dwPri;
	DWORD dwQueue;
	u16 wState;
	u16 wFlags;
	DWORD dwID;
	DWORD dwFP;

	DWORD dwFirstThread;
	
	dwCurrentThread = Read32Bits(VAR_ADDRESS(osActiveThread));

	dwFirstThread = Read32Bits(VAR_ADDRESS(osGlobalThreadList));

	dwThread = dwFirstThread;
	DBGConsole_Msg(0, "");
	  DBGConsole_Msg(0, "Threads:      Pri   Queue       State   Flags   ID          FP Used");
	//DBGConsole_Msg(0, "  0x01234567, xxxx, 0x01234567, 0x0123, 0x0123, 0x01234567, 0x01234567",
	while (dwThread)
	{
		dwPri = Read32Bits(dwThread + offsetof(OSThread, priority));
		dwQueue = Read32Bits(dwThread + offsetof(OSThread, queue));
		wState = Read16Bits(dwThread + offsetof(OSThread, state));
		wFlags = Read16Bits(dwThread + offsetof(OSThread, flags));
		dwID = Read32Bits(dwThread + offsetof(OSThread, id));
		dwFP = Read32Bits(dwThread + offsetof(OSThread, fp));

		// Hack to avoid null thread
		if (dwPri == 0xFFFFFFFF)
			break;

		if (dwThread == dwCurrentThread)
		{
			DBGConsole_Msg(0, "->0x%08x, % 4d, 0x%08x, 0x%04x, 0x%04x, 0x%08x, 0x%08x",
				dwThread, dwPri, dwQueue, wState, wFlags, dwID, dwFP);
		}
		else
		{
			DBGConsole_Msg(0, "  0x%08x, % 4d, 0x%08x, 0x%04x, 0x%04x, 0x%08x, 0x%08x",
				dwThread, dwPri, dwQueue, wState, wFlags, dwID, dwFP);
		}
		dwThread = Read32Bits(dwThread + offsetof(OSThread, tlnext));

		if (dwThread == dwFirstThread)
			break;
	}


	/*for (u32 i = 0; i < g_ThreadTimes.size(); i++)
	{
		DBGConsole_Msg(0, "0x%08x: 0x%08x", g_ThreadTimes[i].dwThread, g_ThreadTimes[i].dwTime);
	}*/

}


void Patch_DumpOsQueueInfo()
{
#ifdef DAED_OS_MESSAGE_QUEUES
	DWORD dwQueue;


	// List queue info:
	DWORD i;
	DWORD dwEmptyQ;
	DWORD dwFullQ;
	DWORD dwValidCount;
	DWORD dwFirst;
	DWORD dwMsgCount;
	DWORD dwMsg;


	DBGConsole_Msg(0, "There are %d Queues", g_MessageQueues.size());
	  DBGConsole_Msg(0, "Queues:   Empty     Full      Valid First MsgCount Msg");
	//DBGConsole_Msg(0, "01234567, 01234567, 01234567, xxxx, xxxx, xxxx, 01234567",
	for (i = 0; i <	g_MessageQueues.size(); i++)
	{
		CHAR szFullQueue[30];
		CHAR szEmptyQueue[30];
		char szType[60] = "";

		dwQueue = g_MessageQueues[i];

		COSMesgQueue q(dwQueue);

		dwEmptyQ	 = q.GetEmptyQueue();
		dwFullQ		 = q.GetFullQueue();
		dwValidCount = q.GetValidCount();
		dwFirst      = q.GetFirst();
		dwMsgCount   = q.GetMsgCount();
		dwMsg        = q.GetMesgArray();

		if ((s32)dwFirst < 0 ||
			(s32)dwValidCount < 0 ||
			(s32)dwMsgCount < 0)
		{
			continue;
		}


		if (dwFullQ == VAR_ADDRESS(osNullMsgQueue))
			sprintf(szFullQueue, "       -");
		else
			sprintf(szFullQueue, "%08x", dwFullQ);

		if (dwEmptyQ == VAR_ADDRESS(osNullMsgQueue))
			sprintf(szEmptyQueue, "       -");
		else
			sprintf(szEmptyQueue, "%08x", dwEmptyQ);


		if (dwQueue == g_dwControllerMQ)
		{
			sprintf(szType, "<- Controller");

		}
		else if (dwQueue == VAR_ADDRESS(osSiAccessQueue))
		{
			sprintf(szType, "<- Si Access");

		}
		else if (dwQueue == VAR_ADDRESS(osPiAccessQueue))
		{
			sprintf(szType, "<- Pi Access");
		}


		// Try and find in the event mesg array
		if (strlen(szType) == 0 && VAR_FOUND(osEventMesgArray))
		{
			for (u32 j = 0; j <	23; j++)
			{
				if (dwQueue == Read32Bits(VAR_ADDRESS(osEventMesgArray) + (j * 8) + 0x0))
				{
					sprintf(szType, "<- %s", g_szEventStrings[j]);
					break;
				}
			}
		}
		DBGConsole_Msg(0, "%08x, %s, %s, % 4d, % 4d, % 4d, %08x %s",
			dwQueue, szEmptyQueue, szFullQueue, dwValidCount, dwFirst, dwMsgCount, dwMsg, szType);
	}
#endif
}


void Patch_DumpOsEventInfo()
{
	DWORD dwQueue;
	DWORD dwMsg;

	if (!VAR_FOUND(osEventMesgArray))
	{
		DBGConsole_Msg(0, "osSetEventMesg not patched, event table unknown");
		return;
	}

	DBGConsole_Msg(0, "");
	DBGConsole_Msg(0, "Events:                      Queue      Message");
	//DBGConsole_Msg(0, "  xxxxxxxxxxxxxxxxxxxxxxxxxx 0x01234567 0x01234567",..);
	for (u32 i = 0; i <	23; i++)
	{
		dwQueue = Read32Bits(VAR_ADDRESS(osEventMesgArray) + (i * 8) + 0x0);
		dwMsg   = Read32Bits(VAR_ADDRESS(osEventMesgArray) + (i * 8) + 0x4);

		
		DBGConsole_Msg(0, "  %-26s 0x%08x 0x%08x",
			g_szEventStrings[i], dwQueue, dwMsg);
	}
}






void Patch_RecurseAndFind()
{
	s32 nFound;
	DWORD dwFirst;
	DWORD dwLast;

	DBGConsole_Msg(0, "Searching for os functions. This may take several seconds...");

	// Keep looping until a pass does not resolve any more symbols
	nFound = 0;
	
	CDebugConsole::Get()->MsgOverwriteStart();

	// Loops through all symbols, until name is null
	for (u32 i = 0; i < ARRAYSIZE(g_PatchSymbols) && !CPU_IsJobSet( CPU_STOP_RUNNING ); i++)
	{
		CDebugConsole::Get()->MsgOverwrite(0, "OS HLE: %d / %d Looking for [G%s]",
			i, ARRAYSIZE(g_PatchSymbols), g_PatchSymbols[i]->szName);

	#ifdef DAEDALUS_W32
		CMainWindow::Get()->SetStatus(0,
									  "OS HLE: %d / %d Looking for %s",
									  i,
									  ARRAYSIZE(g_PatchSymbols),
									  g_PatchSymbols[i]->szName);
	#endif


		// Skip symbol if already found, or if it is a variable
		if (g_PatchSymbols[i]->bFound)
			continue;

		// Symbol not found, attempt to locate on this pass. This may
		// fail if all dependent symbols are not found
		if (Patch_LocateFunction(g_PatchSymbols[i]))
			nFound++;
	}

	if ( CPU_IsJobSet( CPU_STOP_RUNNING ) )
	{
		CDebugConsole::Get()->MsgOverwrite( 0, "OS HLE: Aborted" );
		CDebugConsole::Get()->MsgOverwriteEnd();
	#ifdef DAEDALUS_W32
		CMainWindow::Get()->SetStatus( 0, "OS HLE: Aborted" );
	#endif
		return;
	}

	CDebugConsole::Get()->MsgOverwrite(0, "OS HLE: %d / %d All done",
		ARRAYSIZE(g_PatchSymbols), ARRAYSIZE(g_PatchSymbols));

	CDebugConsole::Get()->MsgOverwriteEnd();

	#ifdef DAEDALUS_W32
	CMainWindow::Get()->SetStatus(0,
								  "OS HLE: %d / %d All done",
								  ARRAYSIZE(g_PatchSymbols),
								  ARRAYSIZE(g_PatchSymbols));
	#endif

	dwFirst = u32(~0);
	dwLast = 0;

	nFound = 0;
	for (u32 i = 0; i < ARRAYSIZE(g_PatchSymbols); i++)
	{
		if (!g_PatchSymbols[i]->bFound)
		{
			DBGConsole_Msg(0, "[W%s] not found", g_PatchSymbols[i]->szName);			
		}
		else
		{
			BOOL bFoundDuplicate;

			// Find duplicates! (to avoid showing the same clash twice, only scan up to the first symbol)
			bFoundDuplicate = FALSE;
			for (u32 j = 0; j < i; j++)
			{
				if (g_PatchSymbols[i]->bFound &&
					g_PatchSymbols[j]->bFound &&
					(g_PatchSymbols[i]->dwLocation ==
					g_PatchSymbols[j]->dwLocation))
				{
						DBGConsole_Msg(0, "Warning [C%s==%s]",
							g_PatchSymbols[i]->szName,
							g_PatchSymbols[j]->szName);

					// Don't patch!
					g_PatchSymbols[i]->bFound = false;
					g_PatchSymbols[j]->bFound = false;
					bFoundDuplicate = TRUE;
					break;
				}
			}

			if (!bFoundDuplicate)
			{
				DWORD dwLocation = g_PatchSymbols[i]->dwLocation;
				if (dwLocation < dwFirst) dwFirst = dwLocation;
				if (dwLocation > dwLast)  dwLast = dwLocation;


				// Actually patch:
				Patch_ApplyPatch(i);

				nFound++;

			}
		}
	}

	DBGConsole_Msg(0, "%d/%d symbols identified, in range 0x%08x -> 0x%08x",
		nFound, ARRAYSIZE(g_PatchSymbols), dwFirst, dwLast);

	nFound = 0;
	for (u32 i = 0; i < ARRAYSIZE(g_PatchVariables); i++)
	{
		if (!g_PatchVariables[i]->bFound)
		{
			DBGConsole_Msg(0, "[W%s] not found", g_PatchVariables[i]->szName);			
		}
		else
		{

			// Find duplicates! (to avoid showing the same clash twice, only scan up to the first symbol)
			for (u32 j = 0; j < i; j++)
			{
				if (g_PatchVariables[i]->bFound &&
					g_PatchVariables[j]->bFound &&
					(g_PatchVariables[i]->dwLocation ==
					g_PatchVariables[j]->dwLocation))
				{
						DBGConsole_Msg(0, "Warning [C%s==%s]",
							g_PatchVariables[i]->szName,
							g_PatchVariables[j]->szName);
				}
			}

			nFound++;
		}
	}
	DBGConsole_Msg(0, "%d/%d variables identified", nFound, ARRAYSIZE(g_PatchVariables));

}


// Attempt to locate this symbol. 
BOOL Patch_LocateFunction(PatchSymbol * ps)
{
	BOOL bFound;
	OpCode op;
	u32 * pdwCodeBase;

	pdwCodeBase = g_pu32RamBase;


	for (u32 s = 0; s < ps->pSignatures[s].nNumOps; s++)
	{
		PatchSignature * psig;
		psig = &ps->pSignatures[s];

		// Sweep through OS range
		for (u32 i = 0; i < (gRamSize>>2); i++)
		{
			op._u32 = pdwCodeBase[i];
			op = GetCorrectOp( op );

			// First op must match!
			if ( psig->firstop != op.op )
				continue;

			// See if function i exists at this location
			bFound = Patch_VerifyLocation_CheckSignature(ps, psig, i);
			if (bFound)
				return TRUE;

		}
	}

	return FALSE;	

}


#define JumpTarget(op, dwAddr) (((dwAddr) & 0xF0000000) | ( op.target << 2 ))


// Check that the function i is located at address dwIndex 
BOOL Patch_VerifyLocation(PatchSymbol * ps, DWORD dwIndex)
{
	BOOL bFound;

	// We may have already located this symbol. 
	if (ps->bFound)
	{	
		// The location must match!
		return (ps->dwLocation == (dwIndex<<2));
	}

	// Fail if index is outside of indexable memory
	if (dwIndex > gRamSize>>2)
		return FALSE;


	for (u32 s = 0; s < ps->pSignatures[s].nNumOps; s++)
	{
		bFound = Patch_VerifyLocation_CheckSignature(ps, &ps->pSignatures[s], dwIndex);
		if (bFound)
			return TRUE;
	}

	// Not found!
	return FALSE;
}


BOOL Patch_VerifyLocation_CheckSignature(PatchSymbol * ps,
										 PatchSignature * psig,
										 DWORD dwIndex)
{
	OpCode op;
	PatchCrossRef * pcr = psig->pCrossRefs;
	BOOL bCrossRefVarSet = FALSE;
	u32 crc;
	u32 partial_crc;

	if ( ( dwIndex + psig->nNumOps ) * 4 > gRamSize )
	{
		return FALSE;
	}

	u32 * pdwCodeBase = g_pu32RamBase;

	PatchCrossRef dummy_cr = {~0, PX_JUMP, NULL };

	if (pcr == NULL)
		pcr = &dummy_cr;



	DWORD dwLastOffset = pcr->dwOffset;

	crc = 0;
	partial_crc = 0;
	for (u32 m = 0; m < psig->nNumOps; m++)
	{
		// Get the actual opcode at this address, not patched/compiled code
		op._u32 = pdwCodeBase[dwIndex+m];
		op = GetCorrectOp( op );
		// This should be ok - so long as we patch all functions at once.

		// Check if a cross reference is in effect here
		if (pcr->dwOffset == m)
		{
			// This is a cross reference. 
			switch (pcr->nType)
			{
			case PX_JUMP:
				{
					BOOL bJumpFound;
					DWORD dwTargetIndex = JumpTarget( op, (dwIndex+m)<<2 )>>2;

					// If the opcode at this address is not a Jump/Jal then
					// this can't match
					if ( op.op != OP_JAL && op.op != OP_J )
						goto fail_find;

					// This is a jump, the jump target must match the 
					// symbol pointed to by this function. Recurse
					bJumpFound = Patch_VerifyLocation(pcr->pSymbol, dwTargetIndex);
					if (!bJumpFound)
						goto fail_find;

					op.target = 0;		// Mask out jump location
				}
				break;
			case PX_VARIABLE_HI:
				{
					// The data element should be consistant with the symbol
					if (pcr->pVariable->bFoundHi)
					{
						if (pcr->pVariable->wHiPart != (op._u32 & 0xFFFF))
							goto fail_find;
	
					}
					else
					{
						// Assume this is the correct symbol
						pcr->pVariable->bFoundHi = true;
						pcr->pVariable->wHiPart = (u16)(op._u32 & 0xFFFF);

						bCrossRefVarSet = TRUE;

						// If other half has been identified, set the location
						if (pcr->pVariable->bFoundLo)
							pcr->pVariable->dwLocation = (pcr->pVariable->wHiPart<<16) + (short)(pcr->pVariable->wLoPart);
					}

					op._u32 &= ~0x0000ffff;		// Mask out low halfword
				}
				break;
			case PX_VARIABLE_LO:
				{
					// The data element should be consistant with the symbol
					if (pcr->pVariable->bFoundLo)
					{
						if (pcr->pVariable->wLoPart != (op._u32 & 0xFFFF))
							goto fail_find;
	
					}
					else
					{
						// Assume this is the correct symbol
						pcr->pVariable->bFoundLo = true;
						pcr->pVariable->wLoPart = (u16)(op._u32 & 0xFFFF);

						bCrossRefVarSet = TRUE;

						// If other half has been identified, set the location
						if (pcr->pVariable->bFoundHi)
							pcr->pVariable->dwLocation = (pcr->pVariable->wHiPart<<16) + (short)(pcr->pVariable->wLoPart);
					}

					op._u32 &= ~0x0000ffff;		// Mask out low halfword
				}
				break;
			}
			
			// We've handled this cross ref - point to the next one
			// ready for the next match.
			pcr++;

			// If pcr->dwOffset == ~0, then there are no more in the array
			// This is okay, as the comparison with m above will never match
			if (pcr->dwOffset < dwLastOffset)
			{
				DBGConsole_Msg(0, "%s: CrossReference offsets out of order", ps->szName);
			}
			dwLastOffset = pcr->dwOffset;

		}
		else
		{
			if ( op.op  == OP_J )
			{
				op.target = 0;		// Mask out jump location				
			}
		}

		// If this is currently less than 4 ops in, add to the partial crc
		if (m < PATCH_PARTIAL_CRC_LEN)
			partial_crc = daedalus_crc32(partial_crc, (u8*)&op, 4);

		// Here, check the partial crc if m == 3
		if (m == (PATCH_PARTIAL_CRC_LEN-1))
		{
			if (partial_crc != psig->partial_crc)
			{
				goto fail_find;
			}
		}

		// Add to the total crc
		crc = daedalus_crc32(crc, (u8*)&op, 4);


	}

	// Check if the complete crc matches!
	if (crc != psig->crc)
	{
		goto fail_find;
	}


	// We have located the symbol
	ps->bFound = true;
	ps->dwLocation = dwIndex<<2;
	ps->pFunction = psig->pFunction;		// Install this function

	if (bCrossRefVarSet)
	{
		// Loop through symbols, setting variables if both high/low found
		for (pcr = psig->pCrossRefs; pcr->dwOffset != u32(~0); pcr++)
		{
			if (pcr->nType == PX_VARIABLE_HI ||
				pcr->nType == PX_VARIABLE_LO)
			{
				if (pcr->pVariable->bFoundLo && pcr->pVariable->bFoundHi)
				{
					pcr->pVariable->bFound = true;
				}
			}
		}

	}

	return TRUE;

// Goto - ugh
fail_find:

	// Loop through symbols, clearing variables if they have been set
	if (bCrossRefVarSet)
	{
		for (pcr = psig->pCrossRefs; pcr->dwOffset != u32(~0); pcr++)
		{
			if (pcr->nType == PX_VARIABLE_HI ||
				pcr->nType == PX_VARIABLE_LO)
			{
				if (!pcr->pVariable->bFound)
				{
					pcr->pVariable->bFoundLo = false;
					pcr->pVariable->bFoundHi = false;
				}
			}
		}
	}

	return FALSE;

}




/////////////////////////
/////////////////////////


inline u32 VirtToPhys(u32 dwVAddr)
{
	if (IS_KSEG0(dwVAddr))
	{
		return K0_TO_PHYS(dwVAddr);
	}
	else if (IS_KSEG1(dwVAddr))
	{
		return K1_TO_PHYS(dwVAddr);
	}
	else
	{
		//Patch_osProbeTLB();			// a0 holds correct address
		DBGConsole_Msg(0, "VirtToPhys failed!");
		return 0;
	}
}


#include "patch_thread_hle.inl"
#include "patch_cache_hle.inl"
#include "patch_ai_hle.inl"
#include "patch_eeprom_hle.inl"
#include "patch_gu_hle.inl"
#include "patch_math_hle.inl"
#include "patch_mesg_hle.inl"
#include "patch_pi_hle.inl"
#include "patch_regs_hle.inl"
#include "patch_si_hle.inl"
#include "patch_sp_hle.inl"
#include "patch_timer_hle.inl"
#include "patch_tlb_hle.inl"
#include "patch_util_hle.inl"
#include "patch_vi_hle.inl"





/////////////////////////////////////////////////////




u32 Patch_osContInit()
{
TEST_DISABLE_FUNCS
	//s32		osContInit(OSMesgQueue * mq, u8 *, OSContStatus * cs);
	u32 dwMQ       = gGPR[REG_a0]._u32[0];
	u32 dwAttached = gGPR[REG_a1]._u32[0];
	u32 dwCS       = gGPR[REG_a2]._u32[0];

	g_dwControllerMQ = dwMQ;

	DBGConsole_Msg(0, "osContInit(0x%08x, 0x%08x, 0x%08x), ra = 0x%08x",
		dwMQ, dwAttached, dwCS, gGPR[REG_ra]._u32[0]);

	return PATCH_RET_NOT_PROCESSED;
}



u32 Patch___osContAddressCrc()
{
TEST_DISABLE_FUNCS
	u32 dwAddress = gGPR[REG_a0]._u32[0];

	DBGConsole_Msg(0, "__osContAddressCrc(0x%08x)", dwAddress);
	return PATCH_RET_NOT_PROCESSED;
}


u32 Patch_osSpTaskYield_Mario()
{
	return PATCH_RET_NOT_PROCESSED;
}
u32 Patch_osSpTaskYield_Rugrats()
{
	return PATCH_RET_NOT_PROCESSED;
}



u32 Patch_osSpTaskYielded()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___osSpTaskLoadInitTask()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___osSpRawReadIo_Mario()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___osSpRawReadIo_Zelda()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___osSpRawWriteIo_Mario()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___osSpRawWriteIo_Zelda()
{
	return PATCH_RET_NOT_PROCESSED;
}


u32 Patch___osSiDeviceBusy()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___osSiRawStartDma_Mario()
{
	return PATCH_RET_NOT_PROCESSED;
}
u32 Patch___osSiRawStartDma_Rugrats()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch_osMapTLBRdb()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch_osUnmapTLBAll_Mario()
{
	return PATCH_RET_NOT_PROCESSED;
}
// Identical to mario, different loop structure
u32 Patch_osUnmapTLBAll_Rugrats()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch_osViSetEvent()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___osAiDeviceBusy()
{
	return PATCH_RET_NOT_PROCESSED;
}


u32 Patch_A__ull_rem()
{
	return PATCH_RET_NOT_PROCESSED;
}





u32 Patch___ull_rem()
{
	return PATCH_RET_NOT_PROCESSED;
}



u32 Patch___ull_divremi()
{
	return PATCH_RET_NOT_PROCESSED;
}


u32 Patch___lldiv()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___ldiv()
{
	return PATCH_RET_NOT_PROCESSED;
}


u32 Patch___osPackRequestData()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch___osContGetInitData()
{
	return PATCH_RET_NOT_PROCESSED;
}

u32 Patch_osSetTimer()
{
	return PATCH_RET_NOT_PROCESSED;
}
u32 Patch_osSetIntMask()
{
	return PATCH_RET_NOT_PROCESSED;
}
u32 Patch___osEepromRead_Prepare()
{
	return PATCH_RET_NOT_PROCESSED;
}
u32 Patch___osEepromWrite_Prepare()
{
	return PATCH_RET_NOT_PROCESSED;
}

#include "patch_symbols.inl"

#endif
