#define SR_LOAD_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_LOAD_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_LOAD		//return FALSE;

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_LB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_LOAD
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);

	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_LB);
	}
	else
	{
		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateLB( rt, base, nOffset );
	}
		
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_LBU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_LOAD
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);

	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_LBU);
	}
	else
	{
		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateLBU( rt, base, nOffset );
	}
		
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_LH(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_LOAD
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);
	
	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_LH);
	}
	else
	{
		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateLH( rt, base, nOffset );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_LHU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_LOAD
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	pCode->Stat_Load_B_D(base, rt);
	
	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_LHU);
	}
	else
	{
		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateLHU( rt, base, nOffset );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_LW(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_LOAD
	const EN64Reg rt = EN64Reg( op_code.rt );
	const EN64Reg base = EN64Reg( op_code.base );

	//DWORD	dwAddress = (u32)((s32)gGPR[base] + nOffset);
	//gGPR[rt] = (s64)(s32)Read32Bits(dwAddress);

	pCode->Stat_Load_B_D(base, rt);

	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_LW);
	}
	else
	{
		s16  offset = (s16)op_code.immediate;

		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateLW( rt, base, offset );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_LWC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_LOAD
	const EN64Reg base = EN64Reg( op_code.base );
	const u32 reg_ft = op_code.ft;

	/*
	DWORD dwAddress = (u32)((s32)gGPR[base] + (s32)wOffset);
	StoreFPR_Word(reg_ft, Read32Bits(dwAddress));
	*/

	pCode->Stat_Load_B(base);
	pCode->Stat_Single_D(reg_ft);

	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_LWC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		s32  nOffset = (s32)(s16)op_code.immediate;

		pCode->mpCodeGenerator->GenerateLWC1( reg_ft, base, nOffset );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************

/*
00452D58 8B 40 0A             mov         eax,dword ptr [eax+0Ah]
00452D5B 8B 50 0A             mov         edx,dword ptr [eax+0Ah]
00452D5E 8B 80 EF BE AD DE    mov         eax,dword ptr [eax-21524111h]
00452D64 8B 90 EF BE AD DE    mov         edx,dword ptr [eax-21524111h]


00452D28 8B 46 0A             mov         eax,dword ptr [esi+0Ah]
00452D2B 8B 56 0A             mov         edx,dword ptr [esi+0Ah]

00453258 8B 86 EF BE AD DE    mov         eax,dword ptr [esi-21524111h]
0045325E 8B 96 EF BE AD DE    mov         edx,dword ptr [esi-21524111h]
00453264 8B 00                mov         eax,dword ptr [eax]
00453266 8B 50 04             mov         edx,dword ptr [eax+4]
*/

BOOL SR_Emit_LDC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_LOAD
return FALSE;
	const EN64Reg base = EN64Reg( op_code.base );
	const u32 reg_ft = op_code.ft;

	pCode->Stat_Load_B(base);
	pCode->Stat_Double_D(reg_ft);

	//if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_LDC1);
	}

	return TRUE;
}







