#define SR_COP1_S_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_COP1_S_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_COP1_S		//return FALSE;

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_ADD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S

	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_D_S_S(reg_fd, reg_fs, reg_ft);


	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_ADD);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs+ft
		pCode->mpCodeGenerator->GenerateADD_S( reg_fd, reg_fs, reg_ft );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_SUB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_D_S_S(reg_fd, reg_fs, reg_ft);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_SUB);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs-ft
		pCode->mpCodeGenerator->GenerateSUB_S( reg_fd, reg_fs, reg_ft );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_MUL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_D_S_S(reg_fd, reg_fs, reg_ft);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_MUL);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Simulate SR_FP stuff
		// fd = fs*ft
		pCode->mpCodeGenerator->GenerateMUL_S( reg_fd, reg_fs, reg_ft );
	
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_DIV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_D_S_S(reg_fd, reg_fs, reg_ft);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_DIV);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs/ft
		pCode->mpCodeGenerator->GenerateDIV_S( reg_fd, reg_fs, reg_ft );
	}
		
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_SQRT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_D_S(reg_fd, reg_fs);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_SQRT);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Simulate SR_FP stuff
		// fd = sqrtf(fs)
		pCode->mpCodeGenerator->GenerateSQRT_S( reg_fd, reg_fs );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_MOV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_D_S(reg_fd, reg_fs);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_MOV);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs
		pCode->mpCodeGenerator->GenerateMOV_S( reg_fd, reg_fs );
	}
		
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_NEG(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_D_S(reg_fd, reg_fs);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_NEG);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = -fs
		pCode->mpCodeGenerator->GenerateNEG_S( reg_fd, reg_fs );
	}
	
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_ABS(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_D_S(reg_fd, reg_fs);
	
	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_ABS);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_ROUND_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_ROUND_L);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_TRUNC_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_TRUNC_L);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_CEIL_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_CEIL_L);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_FLOOR_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_FLOOR_L);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_ROUND_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_ROUND_W);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_TRUNC_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	//if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_TRUNC_W);
	}
/*	else
	{
		pCode->dwNumOptimised++;

		// TODO: This should really TRUNC
		// This does the same as R4300.cpp, but it's possibly wrong
		SR_FP_S_TRUNC_W(reg_fd, reg_fs);
	}
*/

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_CEIL_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_CEIL_W);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_FLOOR_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_FLOOR_W);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_CVT_D(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Double_D(reg_fd);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_CVT_D);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateCVT_D_S( reg_fd, reg_fs );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_CVT_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Word_D(reg_fd);


	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_CVT_W);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateCVT_W_S(reg_fd, reg_fs);
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_CVT_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	pCode->Stat_Single_S(reg_fs);
	pCode->Stat_Long_D(reg_fd);

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_CVT_L);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_F(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_F);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_UN(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_UN);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_UEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_UEQ);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_OLT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_OLT);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_ULT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_ULT);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_OLE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_OLE);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_ULE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_ULE);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_SF(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_SF);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_NGLE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_NGLE);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_SEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_SEQ);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_NGL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_NGL);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_EQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	
	pCode->Stat_Single_S_S(reg_fs, reg_ft);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_EQ);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs == ft?
		pCode->mpCodeGenerator->GenerateCompare_S(reg_fs, reg_ft, FLAG_C_EQ);
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_LT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	
	pCode->Stat_Single_S_S(reg_fs, reg_ft);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_LT);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs < ft?
		pCode->mpCodeGenerator->GenerateCompare_S(reg_fs, reg_ft, FLAG_C_LT);

	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_LE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_ft = op_code.ft;
	const u32 reg_fs = op_code.fs;
	
	pCode->Stat_Single_S_S(reg_fs, reg_ft);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_LE);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs <= ft?
		pCode->mpCodeGenerator->GenerateCompare_S(reg_fs, reg_ft, FLAG_C_LE);
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_NGE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_NGE);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_S_NGT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_S_NGT);
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
// Notice source is Word, dest is single!
BOOL SR_Emit_Cop1_W_CVT_S(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1_S
	const u32 reg_fs = op_code.fs;
	const u32 reg_fd = op_code.fd;

	//pCode->Stat_Word_S(reg_fs);
	//pCode->Stat_Single_D(reg_fd);
	pCode->Stat_Single_D_S(reg_fd, reg_fs);


	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_W_CVT_S);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateCVT_S_W( reg_fd, reg_fs );
	}
	return TRUE;
}
