#define SR_COP1_OPTIMISE_FLAG		(pCode->dwOptimiseLevel < 1)
//#define SR_COP1_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_COP1		//return FALSE;

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_MFC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1
	const EN64Reg rt = EN64Reg( op_code.rt );
	const u32 reg_fs = op_code.fs;

	pCode->Stat_D(rt);
	pCode->Stat_Single_S(reg_fs);
	
	if (SR_COP1_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_MFC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateMFC1( rt, reg_fs );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_MTC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1
	const EN64Reg rt = EN64Reg( op_code.rt );
	const u32 reg_fs = op_code.fs;

	pCode->Stat_S(rt);
	pCode->Stat_Single_D(reg_fs);

	if (SR_COP1_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_MTC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateMTC1( reg_fs, rt );
	}
	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_CFC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1
	const u32 reg_fs = op_code.fs;
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_D(rt);

	// Uses CCR reg
	if (SR_COP1_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_CFC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateCFC1( rt, reg_fs );
	}

	return TRUE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL SR_Emit_Cop1_CTC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags)
{
TEST_DISABLE_SR_COP1
	const u32 reg_fs = op_code.fs;
	const EN64Reg rt = EN64Reg( op_code.rt );

	pCode->Stat_S(rt);
	// USes CCR

	if (SR_COP1_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, op_code, R4300_Cop1_CTC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		pCode->mpCodeGenerator->GenerateCTC1( reg_fs, rt );
	}

	return TRUE;
}

