/*
Copyright (C) 2001,2005 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "DynarecCode.h"
#include "DynaRecInternal.h"
#include "CodeBufferManager.h"

#include "CodeGenerator.h"

#include "Debug\Debug.h"
#include "Core\Registers.h"

#include "OSHLE\ultra_R4300.h"

static const u32 NUM_MIPS_REGISTERS = 32;

//*****************************************************************************
//
//*****************************************************************************
CDynarecCode::CDynarecCode(u32 dwPC, u32 dwOp)
:	mpFunctionPointer( NULL )
,	mpCodeGenerator( NULL )
{
	dwStartPC = dwPC;
	dwEndPC = 0;
	mOriginalOp._u32 = dwOp;
	dwNumOps = 0;
	dwNumOptimised = 0;

	HitCount = 0;
	dwOptimiseLevel = 0;

	Stats.Reset();

	dwBranchTarget = ~0;		// Target address if we take the branch

	dwEntry = 0;				// Entry into global array
}

//*****************************************************************************
//
//*****************************************************************************
CDynarecCode::~CDynarecCode()
{
	delete mpCodeGenerator;
}

//*****************************************************************************
//
//*****************************************************************************
void	CDynarecCode::AllocateCodeBuffer( CCodeBufferManager * p_manager )
{
	mpCodeGenerator = p_manager->StartNewBlock();
	if(mpCodeGenerator != NULL)
	{
		mpFunctionPointer = reinterpret_cast< DynarecFunctionType >( mpCodeGenerator->GetEntryPoint().GetTarget() );
	}
}

//*****************************************************************************
//
//*****************************************************************************
void	CDynarecCode::FinaliseCodeBuffer( CCodeBufferManager * p_manager )
{
	if(mpCodeGenerator != NULL)
	{
		p_manager->FinaliseCurrentBlock( mpCodeGenerator );
	}
}

//*****************************************************************************
//
//*****************************************************************************
u32		CDynarecCode::GetCompiledCodeSize() const
{
	if(mpCodeGenerator != NULL)
	{
		return mpCodeGenerator->GetCompiledCodeSize();
	}

	return 0;
}

//*****************************************************************************
//
//*****************************************************************************
void SRegisterStats::Reset()
{
	memset(RegReads, 0, sizeof(RegReads));
	memset(RegUpdates, 0, sizeof(RegUpdates));
	memset(RegBaseUse, 0, sizeof(RegBaseUse));

	memset(SRegReads, 0, sizeof(SRegReads));
	memset(SRegUpdates, 0, sizeof(SRegUpdates));

	memset(DRegReads, 0, sizeof(DRegReads));
	memset(DRegUpdates, 0, sizeof(DRegUpdates));
}

//*****************************************************************************
//
//*****************************************************************************
void SRegisterStats::Display() const
{
	u32  i;
	bool displayed_header;
	
	// Integer registers
	DPF(DEBUG_DYNREC, "");
	DPF(DEBUG_DYNREC, " Reg:   r   w   b");
	for (i = 0; i < NUM_MIPS_REGISTERS; i++)
	{
		if (RegReads[i] > 0 ||
			RegUpdates[i] > 0 ||
			RegBaseUse[i] > 0)
		{
			DPF(DEBUG_DYNREC, DSPrintf( "  %s: %3d %3d %3d", RegNames[i], RegReads[i], RegUpdates[i], RegBaseUse[i] ) );
		}
	}

	// Single registers:
	displayed_header = false;
	for (i = 0; i < NUM_MIPS_REGISTERS; i++)
	{
		if (SRegReads[i] > 0 ||
			SRegUpdates[i] > 0)
		{
			if (!displayed_header)
			{
				DPF(DEBUG_DYNREC, "");
				DPF(DEBUG_DYNREC, " SReg:   r   w");
				displayed_header = true;
			}

			DPF(DEBUG_DYNREC, DSPrintf( " FP%02d: %3d %3d", i, SRegReads[i], SRegUpdates[i] ) );
		}
	}

	// Double registers:
	displayed_header = false;
	for (i = 0; i < NUM_MIPS_REGISTERS; i++)
	{
		if (DRegReads[i] > 0 ||
			DRegUpdates[i] > 0)
		{
			if (!displayed_header)
			{
				DPF(DEBUG_DYNREC, "");
				DPF(DEBUG_DYNREC, " DReg:   r   w");
				displayed_header = true;
			}
		
			DPF(DEBUG_DYNREC, DSPrintf( "   FP%02d: %3d %3d", i, DRegReads[i], DRegUpdates[i] ) );
		}
	}
	DPF(DEBUG_DYNREC, "");
}
