/*
Copyright (C) 2005 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DYNARECINSTRUCTION_H_
#define DYNARECINSTRUCTION_H_

#include "Core/R4300OpCode.h"

class CDynarecCode;

BOOL SR_Emit_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_DBG_BreakPoint(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SRHack_UnOpt(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SRHack_Opt(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SRHack_NoOpt(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_J(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_JAL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_BEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_BNE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_BLEZ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_BGTZ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_ADDI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_ADDIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SLTI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SLTIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_ANDI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_ORI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_XORI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LUI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_CoPro0(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_CoPro1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_BEQL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_BNEL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_BLEZL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_BGTZL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_DADDI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_DADDIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LDL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LDR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_LB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LH(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LWL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LW(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LBU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LHU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LWR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LWU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_SB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SH(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SWL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SW(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SDL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SDR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SWR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_CACHE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_LL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LWC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LLD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LDC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LDC2(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_LD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_SC(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SWC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SCD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SDC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SDC2(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_SD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Special_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SLL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SRL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SRA(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SLLV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SRLV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SRAV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Special_JR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_JALR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SYSCALL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_BREAK(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SYNC(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Special_MFHI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_MTHI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_MFLO(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_MTLO(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSLLV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSRLV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSRAV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Special_MULT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_MULTU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DIV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DIVU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DMULT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DMULTU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DDIV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DDIVU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Special_ADD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_ADDU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SUB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SUBU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_AND(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_OR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_XOR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_NOR(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Special_SLT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_SLTU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DADD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DADDU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSUB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSUBU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Special_TGE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_TGEU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_TLT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_TLTU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_TEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_TNE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Special_DSLL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSRL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSRA(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSLL32(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSRL32(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Special_DSRA32(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);


BOOL SR_Emit_RegImm_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_BLTZ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_BGEZ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_BLTZL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_BGEZL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_RegImm_TGEI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_TGEIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_TLTI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_TLTIU(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_TEQI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_TNEI(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_RegImm_BLTZAL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_BGEZAL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_BLTZALL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_RegImm_BGEZALL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);


BOOL SR_Emit_Cop0_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop0_MFC0(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop0_MTC0(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop0_TLB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_MFC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_DMFC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_CFC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_MTC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_DMTC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_CTC1(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_BCInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_SInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_DInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_WInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_LInstr(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);


BOOL SR_BC1_BC1F(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_BC1_BC1T(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_BC1_BC1FL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_BC1_BC1TL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);


BOOL SR_Emit_Cop1_S_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_ADD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_SUB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_MUL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_DIV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_SQRT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_ABS(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_MOV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_NEG(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_S_ROUND_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_TRUNC_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_CEIL_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_FLOOR_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_ROUND_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_TRUNC_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_CEIL_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_FLOOR_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_S_CVT_D(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_CVT_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_CVT_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_S_F(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_UN(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_EQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_UEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_OLT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_ULT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_OLE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_ULE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_S_SF(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_NGLE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_SEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_NGL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_LT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_NGE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_LE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_S_NGT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_D_Unk(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_ADD(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_SUB(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_MUL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_DIV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_SQRT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_ABS(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_MOV(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_NEG(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_D_ROUND_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_TRUNC_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_CEIL_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_FLOOR_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_ROUND_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_TRUNC_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_CEIL_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_FLOOR_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_D_CVT_S(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_CVT_W(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_CVT_L(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_D_F(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_UN(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_EQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_UEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_OLT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_ULT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_OLE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_ULE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);

BOOL SR_Emit_Cop1_D_SF(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_NGLE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_SEQ(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_NGL(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_LT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_NGE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_LE(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);
BOOL SR_Emit_Cop1_D_NGT(CDynarecCode *pCode, OpCode op_code, u32 * p_flags);




#endif // DYNARECINSTRUCTION_H_
