/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#ifndef DBGCONSOLE_H_
#define DBGCONSOLE_H_

#include "DaedSingleton.h"

class CDebugConsole : public CSingleton< CDebugConsole >
{
	public:
		virtual ~CDebugConsole() {}
		virtual void EnableConsole( bool bEnable) = 0;
		virtual bool IsVisible() const = 0;

		virtual void UpdateDisplay() = 0;

		enum StatType
		{
			STAT_MIPS = 0,
			STAT_VIS,
			STAT_GEOM,
			STAT_SYNC,
			STAT_TEX,
			STAT_TLB,
			STAT_EXCEP,
			STAT_DYNAREC,
			STAT_TEXIGNORE,
			STAT_DLCULL,
			STAT_PI,
			STAT_SP,

			NUM_STAT_ITEMS 
		};

		virtual void __cdecl Msg(u32 type, const char * szFormat, ...) = 0;

		virtual void MsgOverwriteStart() = 0;
		virtual void __cdecl MsgOverwrite(u32 type, const char * szFormat, ...) = 0;
		virtual void MsgOverwriteEnd() = 0;

		virtual void __cdecl Stats( StatType stat, const char * szFormat, ...) = 0;
};

#define DBGConsole_UpdateDisplay	CDebugConsole::Get()->UpdateDisplay

#define DBGConsole_Stats		CDebugConsole::Get()->Stats

#ifdef DAEDALUS_PUBLIC_RELEASE

#ifdef __GNUC__
	#define DBGConsole_Msg(...) do {} while(0)
#else
	#if _MSC_VER >= 1300
		#define DBGConsole_Msg __noop
	#else
		// avoid warning C4390: ';' : empty controlled statement found; is this the intent?
		#define DBGConsole_Msg(x) do {} while(0)
		#pragma warning(disable : 4002) 
	#endif
#endif

#else

#ifdef DAEDALUS_GFX_PLUGIN
//*****************************************************************************
// For the graphics plugin, we need to make sure that the debug console exists!
//*****************************************************************************
inline void DBGConsole_Msg( u32 i, const char * szFormat, ... )
{
    char szBuffer[1000];

	va_list va;
	va_start(va, szFormat);
	vsprintf(szBuffer, szFormat, va);
	va_end(va);
	
	if ( CDebugConsole::IsAvailable() )
	{
		CDebugConsole::Get()->Msg( i, "%s", szBuffer );
	}
	else
	{
		OutputDebugString( szBuffer );
		OutputDebugString( "\r\n" );	

	}
}
#else

#define DBGConsole_Msg			CDebugConsole::Get()->Msg

#endif

#endif // DAEDALUS_PUBLIC_RELEASE

#endif // DBGCONSOLE_H_

