#include "../gui/menu.h"
#include "sasound.h"
#if HAS_ES5506
#include "es5506.h"
#endif
#ifdef NEO
#include "neocd/neocd.h"
#endif

menu_item_t sound_menu[] =
{
  { "Emulate sound", NULL, &RaineSoundCard, 2, { 0, 1 }, { "No", "Yes" } },
  // we are obliged to give labels for the sample rates because a list of
  // 3 values is now considered to be an interval (start, end, step).
  { "Sample rate", NULL, &audio_sample_rate, 3, { 11025, 22050, 44100 }, 
    { "11025", "22050", "44100" } },
#if HAS_ES5506
  { "ES5506 voice filters", NULL, &es5506_voice_filters, 2, { 0, 1 }, { "No", "Yes" } },
#endif
#ifdef NEO
  { "sfx volume", NULL, &sfx_volume, 3, { 0, 100, 10 }, },
  { "music volume", NULL, &music_volume, 3, { 0, 100, 10 }, },
#endif
  { "Record to raine_sound.wav", NULL, &recording, 3, { 0, 1, 2 }, { "No", "Without monitoring", "With monitoring" } },
  { NULL },
};

int do_sound_options(int sel) {
  TMenu *menu = new TMenu("Sound options", sound_menu);
  menu->execute();
  delete menu;
  if (recording == 2)
    monitoring = 1;
  else
    monitoring = 0;
  return 0;
}
