#include "tlift.h"
#include <SDL.h>
#include "../SDL_gfx/SDL_gfxPrimitives.h"
#include "menu.h"
#include "sdl/display_sdl.h"

/* Deluxe lift, with auto-repeat arrow keys, and the thumb is moveable with
 * the mouse, either directly or page by page */

extern int repeat_interval, repeat_delay; // in gui.cpp

TLift::TLift(int myx,int myy,int myh,int *mytop, int *mydispitems,int *myrows,
  int *myupdate_count,
  SDL_Surface *surf, int myfgcol, int mybgcol,int mythumbcol)
{
  x = myx; y = myy; h = myh; w = 20;
  top = mytop; nb_disp_items = mydispitems; rows = myrows;
  s = surf;
  fgcol = myfgcol;
  bgcol = mybgcol;
  thumbcol = mythumbcol;
  update_count = myupdate_count;
  thumb_pos = phase_repeat = pressed = 0; // No button pressed
}

void TLift::press(int pressed) {
  if (pressed == 1) {
    if (*top > 0) {
      (*top)--;
    }
  } else if (pressed == 2) {
    if (*top + *rows < *nb_disp_items) {
      (*top)++;
    } 
  }
}

void TLift::handle_mouse(SDL_Event *event) {
  // This one is called only when the mouse is in the lift area
  int my;
  switch(event->type) {
    case SDL_MOUSEBUTTONDOWN:
      my = event->button.y;
      if (my > y && my < y+12) { // button up
	pressed = 1;
	press(pressed);
	timer = *update_count;
      } else if (my > y+h-12 && my < y+h) { // button down
	pressed = 2;
	press(pressed);
	timer = *update_count;
      } else if (my > y+12 && my < y+h-12) {
	if (my < ylift) {
	  *top -= *rows;
	  if (*top < 0)
	    *top = 0;
	} else if (my > ylift + size) {
	  *top += *rows;
	  if (*top >= *nb_disp_items)
	    *top = *nb_disp_items - *rows;
	} else { // clicked in the thumb
	  thumb_pos = my;
	  orig_top = *top;
	}
      }
      break;
    case SDL_MOUSEBUTTONUP:
      phase_repeat = pressed = thumb_pos = 0;
      break;
    case SDL_MOUSEMOTION:
      if (thumb_pos && event->motion.y < 4000) {
	my = event->motion.y-thumb_pos;
	*top = (my ) * (*nb_disp_items- *rows)/ ymax + orig_top;
	if (*top > *nb_disp_items-*rows)
	  *top = *nb_disp_items-*rows;
	else if (*top < 0)
	  *top = 0;
      }
      break;
  }
}

void TLift::update() {
  // Automatic repeat of the arrow keys !
  if (pressed) {
    int delay = (*update_count - timer)*33; // delay in ms
    if (!phase_repeat) { // didn't start repeat yet
      if (delay >= repeat_delay) {
	phase_repeat = 1; // start to repeat
	press(pressed);
	timer = *update_count;
      }
    } else {
      if (delay >= repeat_interval) {
	press(pressed);
	timer = *update_count;
      }
    }
  }
}

void TLift::draw() {
  int locked = lock_surface(s);
  rectangleColor(s,x,y,x+w-1,y+h-1,fgcol);
  boxColor(s,x+1,y+1,x+w-2,y+h-2,bgcol);

  // Now draw 2 arrows on top and bottom
  filledTrigonColor(s,x+3,y+10,x+w/2,y+2,x+w-4,y+10,fgcol);
  lineColor(s,x+1,y+12,x+w-1,y+12,fgcol);

  filledTrigonColor(s,x+3,y+h-11,x+w/2,y+h-3,x+w-4,y+h-11,fgcol);
  lineColor(s,x+1,y+h-13,x+w-1,y+h-13,fgcol);

  // Now compute the size & location of the "thumb"
  int height_lift = h-24;
  size = *rows * height_lift / *nb_disp_items;
  if (size < 10)
    size = 10;
  ymax = height_lift - size; // (relatively to the lift coords)
  // top varies from 0 to nb_disp_items-rows...
  ylift = *top*ymax/ (*nb_disp_items-*rows) + y+12;

  rectangleColor(s,x+1,ylift,x+w-2,ylift+size,fgcol);
  boxColor(s,x+1,ylift+1,x+w-2,ylift+size-1,thumbcol);
  if (locked)
    SDL_UnlockSurface(s);
}

