#ifndef TFONT_CPP
#define TFONT_CPP

#include <SDL_ttf.h>

extern int min_font_size;
void save_font_config();
void read_font_config();

class TFont {
  protected:
    char *loaded_font;
    int charWidth,charHeight;
    TFont(char *font,SDL_Surface *myscreen);
    void select_ideal_font(int width, int height);
    SDL_Surface *my_screen;
  public:
    TFont(int size,char *myfont,SDL_Surface *myscreen);
    TFont(int ideal_width, int ideal_height,SDL_Surface *myscreen);
    virtual ~TFont();
    virtual int get_font_width() { return (charWidth ? charWidth : 8); }
    virtual int get_font_height() { return (charHeight ? charHeight : 8); }
    virtual void dimensions(const char *s,int *w, int *h);
    virtual void put_string(int x, int y, const char *s, int color);
    virtual void put_string(int x, int y, const char *s, int color, int bgcolor);
    virtual void surf_string(SDL_Surface *surf,int x, int y, const char *s, int color);
    virtual void surf_string(SDL_Surface *surf,int x, int y, const char *s, int color, int bgcolor);
    virtual void load_font(char *myfont);
};

class TFont_ttf :
  public TFont
{
  protected:
    TTF_Font *ttf;
  public:
    TFont_ttf(SDL_Surface *myscreen,int size=12,char *font="Vera.ttf");
    virtual ~TFont_ttf();
    virtual void dimensions(const char *s, int *w, int *h);
    virtual void put_string(int x, int y, const char *s, int color);
    virtual void put_string(int x, int y, const char *s, int color, int bgcolor);
    virtual void surf_string(SDL_Surface *surf,int x, int y, const char *s, int color);
    virtual void surf_string(SDL_Surface *surf,int x, int y, const char *s, int color, int bgcolor);
    virtual void load_font(char *myfont);
};

#endif

