	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE cpu.h

	EXPORT GFX_init
	EXPORT GFX_reset
	EXPORT scanlinebp_reset
	EXPORT debug_
	EXPORT AGBinput
	EXPORT EMUinput
	EXPORT paletteinit
	EXPORT PaletteTxAll
	EXPORT makeborder
	EXPORT newframe
	EXPORT midframe
	EXPORT endframe
	EXPORT VDPctrl_W
	EXPORT VDPctrl1_W
	EXPORT VDPctrl3_W
	EXPORT BG_scr_x_W
	EXPORT BG_scr_y_W
	EXPORT FG_scr_x_W
	EXPORT FG_scr_y_W
	EXPORT TileMapBase_W
	EXPORT SpriteTableBase_W
	EXPORT VCounter_R
;	EXPORT HCounter_R
	EXPORT gfxstate
	EXPORT gammavalue
	EXPORT bcolor
	EXPORT toprows
	EXPORT gfxlayermask
	EXPORT oambufferready
	EXPORT twitch
	EXPORT flicker
	EXPORT fpsenabled
	EXPORT FPSValue
	EXPORT SPRS
	EXPORT vbldummy
	EXPORT vblankfptr
	EXPORT vblankinterrupt
	EXPORT irqhandler
	EXPORT SpriteScanner
	EXPORT VDPreg0_Update
	EXPORT g_lockpanel

	EXPORT DIRTYTILES

	IMPORT |wram_globals0$$Base|
;	IMPORT RumbleInterrupt
;	IMPORT StartRumbleComs

 AREA rom_code, CODE, READONLY

;----------------------------------------------------------------------------
GFX_init	;(called from main.c) only need to call once
;----------------------------------------------------------------------------
	mov addy,lr

	mov r0,#AGB_VRAM
	mov r1,#0
	mov r2,#0x900
	bl memset_					;clear GBA VRAM
;	mov r0,#AGB_VRAM
	add r0,r0,#0x4000
	mov r1,#0
	mov r2,#0x4000
	bl memset_					;clear GBA VRAM
	mov r0,#AGB_VRAM
	add r0,r0,#0x0040
	ldr r1,=0x10101010
	mov r2,#0x10
	bl memset_					;BGR color 0
	add r0,r0,#0x40
	ldr r1,=0x20202020
	mov r2,#0x10
	bl memset_					;BGR color 1

	mov r1,#0xffffff00			;build chr decode tbl
	ldr r2,=CHR_DECODE			;0x400
ppi
	mov r0,#0
	tst r1,#0x01
	orrne r0,r0,#0x10000000
	tst r1,#0x02
	orrne r0,r0,#0x01000000
	tst r1,#0x04
	orrne r0,r0,#0x00100000
	tst r1,#0x08
	orrne r0,r0,#0x00010000
	tst r1,#0x10
	orrne r0,r0,#0x00001000
	tst r1,#0x20
	orrne r0,r0,#0x00000100
	tst r1,#0x40
	orrne r0,r0,#0x00000010
	tst r1,#0x80
	orrne r0,r0,#0x00000001
	str r0,[r2],#4
	adds r1,r1,#1
	bne ppi

	bl paletteinit				;do palette mapping

	bx addy
;----------------------------------------------------------------------------
GFX_reset	;called with CPU reset
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	ldr r0,=gfxstate
	mov r1,#0
	mov r2,#10				;10*4
	bl memset_				;clear GFX regs

	str r1,windowtop
	strb r1,ystart

	mov r1,#0x16
	bl VDPreg0_W
	mov r1,#0xA0
	bl VDPreg1_W
	mov r1,#0x26
	bl TileMapBase_W		;nametable
	mov r1,#0xFF
	bl VDPregA_W			;IRQ counter

	mov r0,#0x0A00
	str r0,BGoffset1
	mov r0,#0x0C00
	str r0,BGoffset2
	mov r0,#0x0E00
	str r0,BGoffset3

	mov r0,#AGB_OAM
	mov r1,#0x2a0
	mov r2,#0x100
	bl memset_				;no stray sprites please
	ldr r0,=OAM_BUFFER1
	mov r2,#0x200
	bl memset_
	bl makeborder
	bl scanlinebp_reset

	ldr pc,[sp],#4


;----------------------------------------------------------------------------
scanlinebp_reset
;----------------------------------------------------------------------------
	ldr r0,emuflags
	tst r0,#PALTIMING

	moveq r0,#0xDA			;NTSC
	moveq r1,#6
	movne r0,#0xF2			;PAL
	movne r1,#0x39

	str r0,scanlinebp
	strb r1,scanlineminus

	bx lr
;----------------------------------------------------------------------------
makeborder;		also called from UI.c
;----------------------------------------------------------------------------
;	mov r1,#REG_BASE
;	ldr r0,=0x08B8				;8-184
;	strh r0,[r1,#REG_WIN0H]		;Win0H
;	ldr r0,=0x0898				;8-152
;	strh r0,[r1,#REG_WIN0V]		;Win0V
;	strh r0,[r1,#REG_WIN1V]		;Win1V
;	ldrne r0,=0x08D8			;8-232
;	strh r0,[r1,#REG_WIN1H]		;Win1H

;	ldrneb r0,bcolor
;	cmpne r0,#2

;	moveq r0,#0x1B40			;Disable Win0/1
;	ldrne r0,=0x5B40			;Enable Win1
;	ldr r2,=DisplayControl
;	strh r0,[r2]

;	ldr r0,=0x3F37
;	biceq r0,r0,#0x0300			;r0=0x3C27
;	ldr r2,=WindowIn01
;	strh r0,[r2]
;	mov r0,#0x3F
;	bicne r0,r0,#0x17			;r0=0x28
;	strh r0,[r1,#REG_WINOUT]	;WinOUT0/1, SPR, BG0, BG1 & BG2 disable outside Win0
;	bx lr



	mov r1,#AGB_VRAM
	add r1,r1,#0x0800
	adr r2,WSBorder
	mov r3,#32*20
;	cmp r0,#3
;	movpl r0,#0x120
;	bpl bordloopt
;	mov r0,r0,lsl#12
;	add r0,r0,#0x3100
bordloop
	ldrb addy,[r2],#1
;	orr addy,addy,r0
	strh addy,[r1],#2
	subs r3,r3,#1
	bne bordloop
	bx lr
bordloopt
	strh r0,[r1],#2
	subs r3,r3,#1
	bne bordloopt
	bx lr
;----------------------------------------------------------------------------
WSBorder
	DCB 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01
	DCB 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01
;----------------------------------------------------------------------------
paletteinit;	r0-r3 modified.
;called by ui.c:  void map_palette(char gammavalue)
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r8,lr}
	mov r7,#0xF			;mask
	ldr r6,=MAPPED_RGB
	ldrb r1,gammavalue	;gamma value = 0 -> 4
	mov r4,#4096*2
	sub r4,r4,#2
nomap					;map 0000rrrrggggbbbb  ->  0bbbbbgggggrrrrr
	and r0,r7,r4,lsr#1	;Red ready
	bl gprefix
	mov r5,r0

	and r0,r7,r4,lsr#5	;Green ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	and r0,r7,r4,lsr#9	;Blue ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	strh r5,[r6,r4]
	subs r4,r4,#2
	bpl nomap

MapSG_Pal
	adr r7,SG_Palette
	ldr r8,=AGB_PALETTE+0x202
	ldr r6,=SMSPALBUFF+0x100
	mov r4,#16
nomapSG					;map rrrrrrrrggggggggbbbbbbbb  ->  0bbbbbgggggrrrrr
	ldrb r0,[r7,#2]		;Blue ready
	bl gammaconvert
	mov r5,r0

	ldrb r0,[r7,#1]		;Green ready
	bl gammaconvert
	orr r5,r0,r5,lsl#5

	ldrb r0,[r7],#3		;Red ready
	bl gammaconvert
	orr r5,r0,r5,lsl#5

	strh r5,[r6],#2
	strh r5,[r8],#0x20
	subs r4,r4,#1
	bne nomapSG

	ldmfd sp!,{r4-r8,lr}
	bx lr

;----------------------------------------------------------------------------
SG_Palette
	DCB 0,0,0,          0,0,0,          36,218,36,      109,255,109,    36,36,255,      72,109,255,     182,36,36,      72,218,255
	DCB 255,36,36,      255,109,109,    218,218,36,     218,218,145,    36,145,36,      218,72,182,     182,182,182,    255,255,255

;----------------------------------------------------------------------------
gprefix
	orr r0,r0,r0,lsl#4
;----------------------------------------------------------------------------
gammaconvert;	takes value in r0(0-0xFF), gamma in r1(0-4),returns new value in r0=0x1F
;----------------------------------------------------------------------------
	rsb r2,r0,#0x100
	mul r3,r2,r2
	rsb r2,r3,#0x10000
	rsb r3,r1,#4
	orr r0,r0,r0,lsl#8
	mul r2,r1,r2
	mla r0,r3,r0,r2
	mov r0,r0,lsr#13

	bx lr
;----------------------------------------------------------------------------
PaletteTxAll		; Called from ui.c
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r9,lr}
	ldr r3,=EMU_RAM+0xFE00
	ldr r4,=MAPPED_RGB
	ldr r5,=SMSPALBUFF
	ldr r2,=0x1FFE
	mov r1,#0x100
	mov r6,#0
txloop
	ldrh r0,[r3],#2
	and r0,r2,r0,lsl#1
	ldrh r0,[r4,r0]
	cmp r6,#0x10
	cmpne r6,#0x20
	strneh r0,[r5],#2			;background palette
	addeq r5,r5,#2
	cmp r6,#0x80
	strplh r0,[r5,#0xFE]		;sprite palette

	add r6,r6,#1
	cmp r6,#0x100
	bmi txloop

	ldmfd sp!,{r4-r9,lr}
	bx lr

;----------------------------------------------------------------------------
SpriteScanner_start
	stmfd sp!,{r3-r9}
;	mov r11,r11

	ldr r9,=EMU_RAM
	ldrb r0,satoffset
	and r0,r0,#0x7E
	add r9,r9,r0,lsl#7
	add r8,r9,#0x80

	ldrb r0,ntmask
	cmp r0,#0xC
	movne r2,#0xFFFFFFD0		;208 = 0xD0
	moveq r2,#0x200

	ldr r4,=OAM_BUFFER3
	add r3,r4,#0x80
	ldrb r5,scrstartline
	sub r1,r5,#0xF
	mov r6,#0
	mov r7,#0
ss1_loop
	ldrsb r0,[r9,r7]			;MasterSystem OBJ, r0=Ypos.
	cmp r0,r2
	beq ss1_end
	cmp r0,r5
	bgt ss1_chk
	cmp r0,r1
	bpl ss1_add
ss1_chk
	add r7,r7,#1
	cmp r7,#0x40
	bne ss1_loop
ss1_end
	ldr r0,=smsoamptr
	str r6,[r0]
	strb r2,[r4,r6,lsr#1]
	ldmfd sp!,{r3-r9}
	bx lr
	
ss1_add
	strb r0,[r4,r6,lsr#1]
	mov r0,r7,lsl#1
	ldrh r0,[r8,r0]				;MasterSystem OBJ, r4=Tile,Xpos.
	strh r0,[r3,r6]
	cmp r6,#0xFE
	addmi r6,r6,#2
	bmi ss1_chk
	b ss1_end

;----------------------------------------------------------------------------
VDPreg0_Update		;called from ui.c
;----------------------------------------------------------------------------
	stmfd sp!,{globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|
	ldrb r0,vdpmode1
	and r0,r0,#0x80
	mov r0,r0,lsr#5
	strb r0,lockpanel
	ldmfd sp!,{globalptr,lr}
	bx lr
;------------------------------------------------------------------------------
midframe	;called at line 0,16 or 32	(r0,r2 safe to use)
;------------------------------------------------------------------------------
	stmfd sp!,{r1,r3-r9,r11,lr}

mid_end
	ldmfd sp!,{r1,r3-r9,r11,pc}

;-------------------------------------------------------------------------------
bg_finish	;end of frame...
;-------------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,lr}


;	b bg_cont

;	ldrb r0,frame
;	tst r0,#0x7
;	ldmnefd sp!,{r3-r9,r11,pc}
bg_cont
;	mov r0,#0
;	strb r0,[r4]

	mov addy,#AGB_VRAM
	ldr r0,BGoffset2
	add addy,addy,r0,lsl#3
	ldr r5,=0xF000F000
	ldr r7,=0x00010001
	mov r6,#0
;	ldr r6,=0x000003FF
;	ldrb r6,vdpyscroll1
;	and r0,r6,#7
;	mov r6,r6,lsr#3
;	rsbs r1,r0,#4
;	movmi r1,#0
	ldr r8,=TMAPBUFF
;	ldrb r1,[r8,r1]!
	ldr r11,=EMU_RAM
	mov r9,#32

	bl fgcolor

	mov addy,#AGB_VRAM
	ldr r0,BGoffset2
	add addy,addy,r0,lsl#3
	add addy,addy,#0x800
	ldr r5,=0xF000F000
	ldr r7,=0x00010001
	mov r6,#0
;	ldr r6,=0x000003FF
;	ldrb r6,vdpyscroll1
;	and r0,r6,#7
;	mov r6,r6,lsr#3
;	rsbs r1,r0,#4
;	movmi r1,#0
	ldr r8,=TMAPBUFF
;	ldrb r1,[r8,r1]!
	ldr r11,=EMU_RAM
	mov r9,#32

	bl bgcolor

	ldmfd sp!,{r3-r9,r11,pc}
;----------------------------------------------------------------------------
showfps_		;fps output, r0-r3=used.
;----------------------------------------------------------------------------
	ldrb r0,fpschk
	subs r0,r0,#1
	movmi r0,#59
	strb r0,fpschk
	bxpl lr					;End if not 60 frames has passed

;	str lr,[sp,#-4]!
;	ldr r1,=StartRumbleComs
;	adr lr,ret_
;	bx r1
ret_
;	ldr lr,[sp],#4

	ldrb r0,fpsenabled
	tst r0,#1
	bxeq lr					;End if not enabled

	ldr r0,fpsvalue
	cmp r0,#0
	bxeq lr					;End if fps==0, to keep it from appearing in the menu
	mov r1,#0
	str r1,fpsvalue

	mov r1,#100
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+5
	mov r0,r1
	mov r1,#10
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+6
	add r1,r1,#0x30
	strb r1,fpstext+7
	

	adr r0,fpstext
	ldr r2,=DEBUGSCREEN
;	add r2,r2,r1,lsl#6
db1
	ldrb r1,[r0],#1
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#0xE
	bne db1

	bx lr
;----------------------------------------------------------------------------
fpstext			DCB "FPS:    "
fpsenabled		DCB 0
fpschk			DCB 0
gammavalue		DCB 0
bcolor			DCB 0
toprows			DCB 0
				DCB 0
				DCB 0,0
;----------------------------------------------------------------------------
debug_		;debug output, r0=val, r1=line, r2=used.
;----------------------------------------------------------------------------
; [ DEBUG
	ldr r2,=DEBUGSCREEN
	add r2,r2,r1,lsl#6
db0
	mov r0,r0,ror#28
	and r1,r0,#0x0f
	cmp r1,#9
	addhi r1,r1,#7
	add r1,r1,#0x30
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#15
	bne db0
; ]
	bx lr
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
	AREA wram_code2, CODE, READWRITE
irqhandler	;r0-r3,r12 are safe to use
;----------------------------------------------------------------------------
	mov r2,#REG_BASE
	mov r3,#REG_BASE
	ldr r1,[r2,#REG_IE]!
	and r1,r1,r1,lsr#16	;r1=IE&IF
	ldrh r0,[r3,#-8]
	orr r0,r0,r1
	strh r0,[r3,#-8]

		;---these CAN'T be interrupted
		ands r0,r1,#0x80
		strneh r0,[r2,#2]		;IF clear
;		bne RumbleInterrupt
		bne serialinterrupt
		;---

		;---these CAN be interrupted
		ands r0,r1,#0x01
		ldrne r12,vblankfptr
		bne jmpintr
		;----
		adreq r12,irq0
		moveq r0,r1		;if unknown interrupt occured clear it.
jmpintr
	strh r0,[r2,#2]		;IF clear

	mrs r3,spsr
	stmfd sp!,{r3,lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x1f			;--> Enable IRQ . Set CPU mode to System.
	msr cpsr_cf,r3
	stmfd sp!,{lr}
	adr lr,irq0

	mov pc,r12


irq0
	ldmfd sp!,{lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x92        		;--> Disable IRQ. Set CPU mode to IRQ
	msr cpsr_cf,r3
	ldmfd sp!,{r0,lr}
	msr spsr_cf,r0
vbldummy
	bx lr
;----------------------------------------------------------------------------
vblankfptr		DCD vbldummy			;later switched to vblankinterrupt
twitch			DCB 0
flicker 		DCB 1
SPRS			DCB 0					;SpriteScanning On/Off
gfxlayermask	DCB 0
vblankinterrupt;
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r9,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

	bl showfps_

	ldr r2,=DMA0BUFF	;setup DMA buffer for scrolling:
	mov r3,#160
	ldr r1,dmascrollbuff
vbl7
	ldr r4,[r1],#4
	str r4,[r2],#4
	ldr r4,[r1],#4
	str r4,[r2],#4
	subs r3,r3,#1
	bhi vbl7



	mov r1,#REG_BASE
	strh r1,[r1,#REG_DM0CNT_H]		;DMA0 stop
	strh r1,[r1,#REG_DM3CNT_H]		;DMA3 stop

	add r2,r1,#REG_DM3SAD

	ldr r0,oambufferready
	cmp r0,#0
	ldrne r3,dmaoambuffer			;DMA3 src, OAM transfer:
	movne r4,#AGB_OAM				;DMA3 dst
	movne r6,#0x84000000			;noIRQ 32bit incsrc incdst
	orrne r5,r6,#0x100				;128 sprites (1024 bytes)
	stmneia r2,{r3-r5}				;DMA3 go

	ldrne r3,=SMSPALBUFF			;DMA3 src, Palette transfer:
	movne r4,#AGB_PALETTE			;DMA3 dst
	orrne r5,r6,#0xC0				;384 words (768 bytes)
	stmneia r2,{r3-r5}				;DMA3 go
	mov r0,#0
	str r0,oambufferready

	ldr r3,=DMA0BUFF				;setup HBLANK DMA for display scroll:
	add r4,r1,#REG_BG0HOFS			;set 1st value manually, HBL is AFTER 1st line
	ldmia r3!,{r5-r6}
	stmia r4,{r5-r6}
	add r2,r1,#REG_DM0SAD
	ldr r5,=0xA6600002				;noIRQ hblank 32bit repeat incsrc inc_reloaddst
	stmia r2,{r3-r5}				;DMA0 go

	ldr r2,BGoffset1
	add r0,r2,#0x000A
	strh r0,[r1,#REG_BG0CNT]
	ldr r3,=0x0181010B
	add r0,r2,r3
	strh r0,[r1,#REG_BG1CNT]
	mov r0,r3,lsr#16
	strh r0,[r1,#REG_BG2CNT]
	mov r0,#0x4600
	strh r0,[r1,#REG_BG3CNT]

	ldr r2,=IO_regs
	ldr r0,[r2,#8]					;FG-win pos
	mov r3,#0x08000000
	add r0,r3,r0,ror#8
	add r0,r3,r0,ror#8
	add r0,r3,r0,ror#8
	add r0,r3,r0,ror#8
	and r3,r0,#0x00FF0000
	orr r3,r3,r0,lsl#24
	mov r3,r3,lsr#16
	strh r3,[r1,#REG_WIN0H]
	and r3,r0,#0xFF00
	orr r3,r3,r0,lsr#24
	strh r3,[r1,#REG_WIN0V]

	ldrb r2,[r2]
	tst r2,#0x10
	mov r0,#0x3F
	bicne r0,r0,#0x01				;Turn off fg in win
	strh r0,[r1,#REG_WININ]			;WinIN0, Everything enabled inside Windows
	mov r0,#0x3F
	biceq r0,r0,#0x01				;Turn off fg out win
	strh r0,[r1,#REG_WINOUT]		;WinOUT0, SPR, BG0, BG1 & BG2 disable outside Win0

	ldrh r0,DisplayControl			;1d sprites, Win0, OBJ, BG0/1/2/3 enable. mode0.
	tst r2,#0x01
	biceq r0,r0,#0x0200				;Turn off bg
	tst r2,#0x02
	biceq r0,r0,#0x0100				;Turn off fg
	tst r2,#0x04
	biceq r0,r0,#0x1000				;Turn off sprites
	tst r2,#0x20
	biceq r0,r0,#0x2000				;Turn off fg-window
	ldrb r2,gfxlayermask
	bic r0,r0,r2,lsl#8
	strh r0,[r1,#REG_DISPCNT]		;set value manually

exit_vbl
	ldmfd sp!,{r4-r9,globalptr,pc}

DisplayControl
	DCW 0x3F40
WindowIn01
	DCW 0x3F37

;------------------------------------------------------------------------------
panelscale
;------------------------------------------------------------------------------
	stmfd sp!,{r2-r3,lr}
	add r2,r2,#12+2
	mov r4,#0
paloop	
	strh r4,[r2],#16
	strh r4,[r2],#16
	add r4,r4,#1
	strh r4,[r2],#16
	strh r4,[r2],#16
	strh r4,[r2],#16
	subs r3,r3,#5
	bpl paloop

	ldmfd sp!,{r2-r3,pc}
;------------------------------------------------------------------------------
newframe	;called before line 0	(r0-r9 safe to use)
;------------------------------------------------------------------------------
	mov r0,#-1
	str r0,scanline			;reset scanline count
	mov r0,#0
	str r0,nametableline

	ldrb r0,vdpcounter
	str r0,lineirq
	ldrb r0,vdpyscroll
	strb r0,vdpyscroll1

	mov r0,#-1
	str r0,BGscrollXline
	str r0,BGscrollYline
	str r0,FGscrollXline
	str r0,FGscrollYline

	bx lr

;------------------------------------------------------------------------------
endframe	;called just before screen end (line 144)	(r0,r2 safe to use)
;------------------------------------------------------------------------------
	stmfd sp!,{r1,r3-r9,r11,lr}

	ldr globalptr,=|wram_globals0$$Base|
;	ldr r0,=default_scanlinehook
;	str r0,scanlinehook
	ldrb r0,nametable
	mov addy,#160
	bl NT_finnish
	bl bg_finish
;--------------------------
	bl sprDMA_do
;--------------------------
	bl PaletteTxAll
;--------------------------
	ldr r2,=IO_regs
	ldrb r1,[r2,#0x10]
	bl BG_scr_x_W
	ldr r2,=IO_regs
	ldrb r1,[r2,#0x11]
	bl BG_scr_y_W
	ldr r2,=IO_regs
	ldrb r1,[r2,#0x12]
	bl FG_scr_x_W
	ldr r2,=IO_regs
	ldrb r1,[r2,#0x13]
	bl FG_scr_y_W



	mrs r5,cpsr
	orr r1,r5,#0x80			;--> Disable IRQ.
	msr cpsr_cf,r1

	ldrb r0,vdpyscroll1
	strb r0,vdpyscroll2

	ldrb r0,vdpmode2_bak1
	strb r0,vdpmode2_bak2

	ldr r0,dmaoambuffer
	ldr r1,tmpoambuffer
	str r1,dmaoambuffer
	ldr r1,wscoambuffer
	str r1,tmpoambuffer
	str r0,wscoambuffer

	ldr r0,scrollbuff
	ldr r1,dmascrollbuff
	str r0,dmascrollbuff
	str r1,scrollbuff

	adrl r0,BGoffset1
	ldmib r0,{r1-r2}		;load with pre increment
	ldr r3,BGoffset1
	stmia r0,{r1-r3}		;store with post increment

	mov r0,#1
	str r0,oambufferready

	msr cpsr_cf,r5			;--> restore mode,Enable IRQ.


	ldrb r4,novblankwait
	cmp r4,#2
	beq l03
l01
	ldr r0,emuflags
	tst r0,#PALTIMING
	moveq r1,#0x01			;VBL wait
	movne r1,#0x20			;Timer2 wait

	cmp r4,#1
	movne r0,#0				;wait for vblank if it hasn't allready happened.
	moveq r0,#1				;wait for next vblank.
	swi 0x040000			; Turn of CPU until IRQ if not too late allready.
	cmp r4,#3				;Check for slomo
	moveq r4,#0
	beq l01
l03

	adr lr,TransRet
	ldr r0,=IO_regs
	ldrb r0,[r0,#0x60]
	and r0,r0,#0xE0
	cmp r0,#0xC0
	beq Transfer_VRAM_16_layered
	b Transfer_VRAM_16_packed
TransRet
	ldmfd sp!,{r1,r3-r9,r11,lr}
	bx lr
;------------------------------------------------------------------------------
VDPctrl_W
;------------------------------------------------------------------------------
	ldrb r1,toggle
	eors r1,r1,#1
	strb r1,toggle

	ldr r1,vramaddr
	and r0,r0,#0xFF
	biceq r1,r1,#0xFC000000
	bicne r1,r1,#0x03FC0000
	orreq r1,r1,r0,lsl#26
	orrne r1,r1,r0,lsl#18
	str r1,vramaddr
	movne pc,lr

	movs r2,r0,lsr#6
	strb r2,vdpctrl
	ldr pc,[pc,r2,lsl#2]
	DCD 0
VDPdest
	DCD VDPctrl0_W
	DCD VDPctrl1_W
	DCD VDPctrl2_W
	DCD VDPctrl3_W
;------------------------------------------------------------------------------
VDPctrl0_W					;set read address, fill buffer.
;------------------------------------------------------------------------------
	mov r0,r1,ror#18
	ldrb r0,[r0]
	strb r0,vdpbuff
	add r1,r1,#0x00040000
	str r1,vramaddr
VDPctrl1_W
	mov pc,lr
;------------------------------------------------------------------------------
VDPctrl3_W
;------------------------------------------------------------------------------
	mov pc,lr
;------------------------------------------------------------------------------
VDPctrl2_W
;------------------------------------------------------------------------------
	mov r1,r1,lsr#18
	and r0,r0,#0xF
	ldr pc,[pc,r0,lsl#2]
	DCD 0
VDPregs
	DCD VDPreg0_W
	DCD VDPreg1_W
	DCD TileMapBase_W
	DCD VDPreg3_W
	DCD VDPreg4_W
	DCD SpriteTableBase_W
	DCD VDPreg6_W
	DCD VDPreg7_W
	DCD VDPregF_W
	DCD VDPreg9_W
	DCD VDPregA_W
	DCD VDPregF_W
	DCD VDPregF_W
	DCD VDPregF_W
	DCD VDPregF_W
	DCD VDPregF_W

;------------------------------------------------------------------------------
VDPreg0_W
;------------------------------------------------------------------------------
	strb r1,vdpmode1
	ldrb r0,dontstop
	tst r0,#1
	andne r1,r1,#0x80
	movne r1,r1,lsr#5
	strneb r1,lockpanel
	b SetHeight
;------------------------------------------------------------------------------
VDPreg1_W
;------------------------------------------------------------------------------
	strb r1,vdpmode2
;------------------------------------------------------------------------------
SetHeight
;------------------------------------------------------------------------------
	ldr r0,emuflags
	tst r0,#PALTIMING
	mov r2,#0
	movne r2,#0x18			;NTSC/PAL diff

	ldr r0,vdpmode1			;Both vdpmode regs
	tst r0,#2
	tstne r0,#0x1800		;224 and/or 240 height
	addeq r2,r2,#0xDA
	addne r2,r2,#0xEA
	str r2,scanlinebp
	moveq r0,#0xE
	movne r0,#0xC
	strb r0,ntmask
	moveq r0,#208
	movne r0,#0x200
	str r0,sprstop

	moveq r1,#32		;maxpan
	movne r1,#64
	add r0,r1,#192		;224/256
	str r0,scrollmask
	sub r0,r0,#32
	str r0,vblline
	moveq r0,#0
	movne r0,#6
	strb r0,ystart

	mov r0,#152
	add r0,r0,r1,lsr#1
	str r0,endframeline

	mov r0,#0
	moveq r0,r1,lsr#1
	moveq r1,r1,lsr#1
	strb r0,minpan
	strb r1,maxpan
	addeq r0,r0,#8
	strb r0,scrstartline

	mov pc,lr
;------------------------------------------------------------------------------
TileMapBase_W
;------------------------------------------------------------------------------
	ldrb r0,nametable
	strb r1,nametable

	ldr addy,scanline	;addy=scanline
NT_finnish
;	add addy,addy,#1	;maybe check cycles and add 2 sometimes?
	cmp addy,#160
	movhi addy,#160
	adr r2,nametableline
	swp r1,addy,[r2]	;r1=lastline, lastline=scanline

	ldr r2,=TMAPBUFF
	add r1,r2,r1
	add r2,r2,addy
nt1
	strb r0,[r2],#-1	;fill backwards from scanline to lastline
	cmp r2,r1
	bpl nt1
	bx lr

nametableline DCD 0 ;..was when?

;------------------------------------------------------------------------------
VDPreg3_W						;Color Table - offset
;------------------------------------------------------------------------------
	strb r1,ctoffset
	mov pc,lr
;------------------------------------------------------------------------------
VDPreg4_W						;Pattern Generator Table - offset
;------------------------------------------------------------------------------
	strb r1,pgoffset
	mov pc,lr
;------------------------------------------------------------------------------
SpriteTableBase_W				;Sprite Attribute Table - offset
;------------------------------------------------------------------------------
	strb r1,satoffset
	bx lr
;------------------------------------------------------------------------------
VDPreg6_W						;Sprite tiles - offset
;------------------------------------------------------------------------------
	strb r1,sproffset
	mov pc,lr
;------------------------------------------------------------------------------
VDPreg7_W						;Backdrop Color
;------------------------------------------------------------------------------
	strb r1,bdcolor
	mov pc,lr
;------------------------------------------------------------------------------
BG_scr_x_W						;Background Horizontal Scroll register
;------------------------------------------------------------------------------
	ldr r2,=IO_regs
	ldrb r0,[r2,#0x10]
	strb r1,[r2,#0x10]
	sub r0,r0,#8

	ldr addy,scanline			;addy=scanline
	add addy,addy,#8
	cmp addy,#159
	movhi addy,#159
	ldr r1,BGscrollXline
	cmp r1,addy
	bxpl lr
	str addy,BGscrollXline

	ldr r2,scrollbuff
	add r2,r2,#4
	add r1,r2,r1,lsl#3
	add r2,r2,addy,lsl#3
sx1
	strh r0,[r2],#-8			;fill backwards from scanline to lastline
	cmp r2,r1
	bhi sx1
	bx lr

BGscrollXline DCD 0 ;..was when?

;------------------------------------------------------------------------------
BG_scr_y_W						;Background Vertical Scroll register
;------------------------------------------------------------------------------
	ldr r2,=IO_regs
	ldrb r0,[r2,#0x11]
	strb r1,[r2,#0x11]
	sub r0,r0,#8

	ldr addy,scanline			;addy=scanline
	add addy,addy,#8
	cmp addy,#159
	movhi addy,#159
	ldr r1,BGscrollYline
	cmp r1,addy
	bxpl lr
	str addy,BGscrollYline

	ldr r2,scrollbuff
	add r2,r2,#6
	add r1,r2,r1,lsl#3
	add r2,r2,addy,lsl#3
sy1
	strh r0,[r2],#-8			;fill backwards from scanline to lastline
	cmp r2,r1
	bhi sy1
	bx lr

BGscrollYline DCD 0 ;..was when?

;------------------------------------------------------------------------------
FG_scr_x_W						;Foreground Horizontal Scroll register
;------------------------------------------------------------------------------
	ldr r2,=IO_regs
	ldrb r0,[r2,#0x12]
	strb r1,[r2,#0x12]
	sub r0,r0,#8

	ldr addy,scanline			;addy=scanline
	add addy,addy,#8
	cmp addy,#159
	movhi addy,#159
	ldr r1,FGscrollXline
	cmp r1,addy
	bxpl lr
	str addy,FGscrollXline

	ldr r2,scrollbuff
	add r1,r2,r1,lsl#3
	add r2,r2,addy,lsl#3
sx2
	strh r0,[r2],#-8			;fill backwards from scanline to lastline
	cmp r2,r1
	bhi sx2
	bx lr

FGscrollXline DCD 0 ;..was when?

;------------------------------------------------------------------------------
FG_scr_y_W						;Background Vertical Scroll register
;------------------------------------------------------------------------------
	ldr r2,=IO_regs
	ldrb r0,[r2,#0x13]
	strb r1,[r2,#0x13]
	sub r0,r0,#8

	ldr addy,scanline			;addy=scanline
	add addy,addy,#8
	cmp addy,#159
	movhi addy,#159
	ldr r1,FGscrollYline
	cmp r1,addy
	bxpl lr
	str addy,FGscrollYline

	ldr r2,scrollbuff
	add r2,r2,#2
	add r1,r2,r1,lsl#3
	add r2,r2,addy,lsl#3
sy2
	strh r0,[r2],#-8			;fill backwards from scanline to lastline
	cmp r2,r1
	bhi sy2
	bx lr

FGscrollYline DCD 0 ;..was when?

;------------------------------------------------------------------------------
VDPreg9_W						;Vertical Scroll register
;------------------------------------------------------------------------------
	strb r1,vdpyscroll
	mov pc,lr
;------------------------------------------------------------------------------
VDPregA_W						;HBlank value
;------------------------------------------------------------------------------
	strb r1,vdpcounter
;	mov pc,lr
;------------------------------------------------------------------------------
VDPregF_W
;------------------------------------------------------------------------------
	mov pc,lr

;------------------------------------------------------------------------------
VCounter_R
;------------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldr r0,=vdpscanline
	ldr r0,[r0]
	bx lr
;------------------------------------------------------------------------------
;HCounter_R
;------------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,scanline
	mov pc,lr

;----------------------------------------------------------------------------
SpriteScanner
	stmfd sp!,{r4-r9}

	ldr r9,=EMU_RAM
	ldrb r0,satoffset
	and r0,r0,#0x7E
	add r9,r9,r0,lsl#7
	add r8,r9,#0x100

	ldr r2,sprstop
	ldr r4,=OAM_BUFFER3
	add r5,r4,#0x80
;	ldr r1,scanline				;r1 is allready scanline.
	ldr r6,smsoamptr
	mov r7,#-0x80
ss0_loop
	ldrb r0,[r9],#1				;MasterSystem OBJ, r0=Ypos.
	cmp r0,r2
	cmpne r0,r1
	beq ss0_add
ss0_chk
	adds r7,r7,#2
	bne ss0_loop
ss0_end
	str r6,smsoamptr
	strb r2,[r4,r6,lsr#1]
	ldmfd sp!,{r4-r9}
;	b default_scanlinehook
	
ss0_add
	cmp r0,r2
	beq ss0_end

	strb r0,[r4,r6,lsr#1]
	ldrh r0,[r8,r7]				;MasterSystem OBJ, r4=Tile,Xpos.
	strh r0,[r5,r6]
	cmp r6,#0xFE
	addmi r6,r6,#2
	bmi ss0_chk
	b ss0_end

;----------------------------------------------------------------------------
;sprDMA_do			;Called from endframe. YATX
;----------------------------------------------------------------------------
PRIORITY EQU 0x800				;0x800=AGB OBJ priority 2

sprDMA_do						;Called from endframe.


	ldr addy,=EMU_RAM			;Source
	ldr r1,=IO_regs
	ldrb r0,[r1,#0x04]
	and r0,r0,#0x3F
	add addy,addy,r0,lsl#9
	ldrb r0,[r1,#0x05]
	add addy,addy,r0,lsl#2
	ldr r2,wscoambuffer			;Destination

	ldr r3,=IO_regs
	ldrb r9,[r3,#0x06]			;number of sprites
	mov r8,#128					;total number of sprites
	cmp r9,#0
	beq dm4_3

	mov r6,#0
	mov r1,#0x08000000
dm4_2
	ldr r0,[addy],#4			;WonderSwan OBJ.
	add r3,r1,r0,lsl#8
	mov r3,r3,lsr#24			;Ypos
	mov r4,r0,lsr#24
	cmp r4,#240
	addpl r4,r4,#0x100
	add r4,r4,#8
	mov r4,r4,lsl#23
	orr r3,r3,r4,lsr#7			;Xpos
	and r4,r0,#0xC000
	orr r3,r3,r4,lsl#14			;flip

	str r3,[r2],#4				;store OBJ Atr 0,1. Xpos, ypos, flip, scale/rot, size, shape.

	mov r3,r0,lsl#23
	mov r4,#0x0C00
	orr r3,r4,r3,lsr#23
	and r4,r0,#0x0E00
	orr r3,r3,r4,lsl#3
	tst r0,#0x2000
	bicne r3,r3,#0x0400			;priority

	strh r3,[r2],#4				;store OBJ Atr 2. Pattern, palette.
	subs r9,r9,#1
	beq dm4_3
	subs r8,r8,#1
	bne dm4_2
	bx lr
dm4_3
	mov r0,#0x2a0				;double, y=160
dm4_4
	subs r8,r8,#1
	strhi r0,[r2],#8
	bne dm4_4
	bx lr


;----------------------------------------------------------------------------
T_data
	DCD DIRTYTILES+0x200
VDP_RAM_ptr
	DCD EMU_RAM+0x4000
	DCD CHR_DECODE
	DCD AGB_VRAM+0x08000		;BGR tiles
	DCD AGB_VRAM+0x10000		;SPR tiles
;----------------------------------------------------------------------------
Transfer_VRAM_16_packed
;----------------------------------------------------------------------------
	stmfd sp!,{lr}
	adr r0,T_data
	ldmia r0,{r4-r8}
	ldr r6,=0xF0F0F0F0
	mov r9,#-1
	mov r1,#0

tileloop16_0p
	ldr addy,[r4]
	str r9,[r4],#4
	tst addy,#0x000000FF
	addne r1,r1,#0x20
	bleq tileloop16_1p
	tst addy,#0x0000FF00
	addne r1,r1,#0x20
	bleq tileloop16_1p
	tst addy,#0x00FF0000
	addne r1,r1,#0x20
	bleq tileloop16_1p
	tst addy,#0xFF000000
	addne r1,r1,#0x20
	bleq tileloop16_1p
	cmp r1,#0x8000
	bne tileloop16_0p

	ldmfd sp!,{pc}

tileloop16_1p
	ldr r0,[r5,r1]

	and r3,r6,r0,lsl#4
	and r0,r0,r6
	orr r3,r3,r0,lsr#4

	str r3,[r7,r1]
	str r3,[r8,r1]
	add r1,r1,#4
	tst r1,#0x1C
	bne tileloop16_1p

	mov pc,lr

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
tileloop0_2
	ldrb r2,[r11,r1,lsr#6]
	b tileloop2_4
tileloop2_2
	ldrb r2,[r11,r1]
tileloop2_4
	ldrb r0,[r5,r1]

	ldr r0,[r6,r0,lsl#2]
	ands r3,r2,#0x10
	movne r3,r0
	tst r2,#0x20
	orrne r3,r3,r0,lsl#1
	tst r2,#0x40
	orrne r3,r3,r0,lsl#2
	tst r2,#0x80
	orrne r3,r3,r0,lsl#3

	eor r0,r0,r8

	tst r2,#0x01
	orrne r3,r3,r0
	tst r2,#0x02
	orrne r3,r3,r0,lsl#1
	tst r2,#0x04
	orrne r3,r3,r0,lsl#2
	tst r2,#0x08
	orrne r3,r3,r0,lsl#3

	str r3,[r7,r1,lsl#2]
	add r1,r1,#1
	tst r1,#0x1F
	movne pc,r10

	mov pc,lr

tileloop2_3
	ldrb r0,[r5,r1]
	ldr r0,[r6,r0,lsl#2]
	str r0,[r7,r1,lsl#2]
	add r1,r1,#1
	tst r1,#0x1F
	bne tileloop2_3

	mov pc,lr

;----------------------------------------------------------------------------
Transfer_VRAM_16_layered
;----------------------------------------------------------------------------
	stmfd sp!,{lr}
	adr r0,T_data
	ldmia r0,{r4-r8}
	mov r9,#-1
	mov r1,#0

tileloop16_0
	ldr addy,[r4]
	str r9,[r4],#4
	tst addy,#0x000000FF
	addne r1,r1,#0x20
	bleq tileloop16_1
	tst addy,#0x0000FF00
	addne r1,r1,#0x20
	bleq tileloop16_1
	tst addy,#0x00FF0000
	addne r1,r1,#0x20
	bleq tileloop16_1
	tst addy,#0xFF000000
	addne r1,r1,#0x20
	bleq tileloop16_1
	cmp r1,#0x8000
	bne tileloop16_0

	ldmfd sp!,{pc}

tileloop16_1
	ldr r0,[r5,r1]

	ands r3,r0,#0x000000FF
	ldrne r3,[r6,r3,lsl#2]
	ands r2,r0,#0x0000FF00
	ldrne r2,[r6,r2,lsr#6]
	orrne r3,r3,r2,lsl#1
	ands r2,r0,#0x00FF0000
	ldrne r2,[r6,r2,lsr#14]
	orrne r3,r3,r2,lsl#2
	ands r2,r0,#0xFF000000
	ldrne r2,[r6,r2,lsr#22]
	orrne r3,r3,r2,lsl#3

	str r3,[r7,r1]
	str r3,[r8,r1]
	add r1,r1,#4
	tst r1,#0x1C
	bne tileloop16_1

	mov pc,lr

;-------------------------------------------------------------------------------
;bgchrfinish	;end of frame...
;-------------------------------------------------------------------------------
bgmode02			;fake

bgm2loop2
	mov r5,#16*8
bgm2loop
	ldrh r1,[r3],#2				;Read from MasterSystem Tilemap RAM
	orr r1,r1,r1,lsl#8
	bic r1,r1,#0xFF00
	orr r1,r1,r7

	str r9,[r4,r9,lsr#5]		;Write to GBA Tilemap RAM, BGR color
	str r1,[r4,#0x800]			;Write to GBA Tilemap RAM, behind sprites
	str r0,[r4],#4				;Write to GBA Tilemap RAM, in front of sprites
	subs r5,r5,#1
	bne bgm2loop
	add r7,r7,r8
	subs r6,r6,#1
	bne bgm2loop2

	ldmfd sp!,{r3-r9,r11,pc}


;-------------------------------------------------------------------------------
;fgchrfinish	;end of frame...
;-------------------------------------------------------------------------------
;	ldr r5,=0xF000F000
;	ldr r7,=0x00010001
; MSB          LSB
; ---pcvhnnnnnnnnn
fgcolor
	ldrb r1,[r8],#1				;need to fix this up later!!!
;	ldrb r0,ntmask
;	and r1,r1,r0
	and r1,r1,#0x70
	add r3,r11,r1,lsl#7
	add r3,r3,r6,lsl#6
	add r4,addy,r6,lsl#6
	add r6,r6,#1
	and r6,r6,#0x1F

fgm4loop
	ldr r0,[r3],#4				;Read from MasterSystem Tilemap RAM

	bic r1,r0,r5,lsr#3
	and r0,r0,r5,lsr#3
	and r2,r1,r5
	bic r1,r1,r5
	orr r1,r1,r2,lsr#4			;XY flip
	orr r1,r1,r0,lsl#3			;color

	str r1,[r4],#4				;Write to GBA Tilemap RAM, foreground
	tst r4,#0x3C				;32 tiles wide
	bne fgm4loop
	subs r9,r9,#1
	bne fgcolor

	bx lr

;-------------------------------------------------------------------------------
;bgchrfinish	;end of frame...
;-------------------------------------------------------------------------------
;	ldr r5,=0xF000F000
;	ldr r7,=0x00010001
; MSB          LSB
; ---pcvhnnnnnnnnn
bgcolor
	ldrb r1,[r8],#1				;need to fix this up later!!!
;	ldrb r0,ntmask
;	and r1,r1,r0
	and r1,r1,#0x07
	add r3,r11,r1,lsl#11
	add r3,r3,r6,lsl#6
	add r4,addy,r6,lsl#6
	add r6,r6,#1
	and r6,r6,#0x1F

bgm4loop
	ldr r0,[r3],#4				;Read from MasterSystem Tilemap RAM

	bic r1,r0,r5,lsr#3
	and r0,r0,r5,lsr#3
	and r2,r1,r5
	bic r1,r1,r5
	orr r1,r1,r2,lsr#4			;XY flip
	orr r1,r1,r0,lsl#3			;color

	str r1,[r4],#4				;Write to GBA Tilemap RAM, foreground
	tst r4,#0x3C				;32 tiles wide
	bne bgm4loop
	subs r9,r9,#1
	bne bgcolor

	bx lr


;----------------------------------------------------------------------------
Mod6			;In: r4. Out: r4 = MOD result.
;----------------------------------------------------------------------------
	stmfd sp!,{r1,r2}

	ldr r1,=0x2AAAAAAB
	umull r2,r1,r4,r1
	add r2,r1,r1,lsl#1
	sub r4,r4,r2,lsl#1

	ldmfd sp!,{r1,r2}
	bx lr
;----------------------------------------------------------------------------


wscoambuffer	DCD OAM_BUFFER1
tmpoambuffer	DCD OAM_BUFFER2
dmaoambuffer	DCD OAM_BUFFER3

scrollbuff		DCD SCROLLBUFF1
dmascrollbuff	DCD SCROLLBUFF2

smsoamptr		DCD 0
oambufferready	DCD 0

;	DCD 0
 LTORG
;------------------------------------------------------------------------------
VDPdata_W
;------------------------------------------------------------------------------
	bx lr
;----------------------------------------------------------------------------
	AREA wram_globals1, CODE, READWRITE

FPSValue
	DCD 0
AGBinput			;this label here for main.c to use
	DCD 0 			;AGBjoypad (why is this in gfx.s again?  um.. i forget)
EMUinput	DCD 0	;EMUjoypad (this is what the EMU sees)
	DCD 1			;adjustblend
	DCD 0			;windowtop
wtop	DCD 0,0,0	;windowtop  (this label too)   L/R scrolling in unscaled mode
gfxstate
	DCD 0 ;vramaddr
	DCD 0 ;lineirq
vdpscanline
	DCD 0 ;scanline
	DCD 0 ;endframeline
	DCD 0 ;vblline
	DCD 0 ;scanlinebp
	DCD 0 ;scrollmask
	DCD 0 ;sprstop
vdpregs
	DCB 0 ;vdpmode1
	DCB 0 ;vdpmode2
	DCB 0 ;nametable
	DCB 0 ;ctoffset
	DCB 0 ;pgoffset
	DCB 0 ;satoffset
	DCB 0 ;sproffset
	DCB 0 ;bdcolor
	DCB 0 ;vdpxscroll
	DCB 0 ;vdpyscroll
	DCB 0 ;vdpcounter

	DCB 0 ;vdpctrl
	DCB 0,0 ;vdpbuff		vdpbuff + toggle need to be together in this way.
	DCB 0,0 ;toggle
	DCB 0 ;vdpstat		VBlank + spr stat
	DCB 0 ;vdppending	line interrupt pending
	DCB 0 ;vdpmode2_bak1
	DCB 0 ;vdpmode2_bak2
	DCB 0 ;vdpyscroll1	tripple buffering
	DCB 0 ;vdpyscroll2
	DCB 0 ;ntmask
	DCB 0 ;minpan
	DCB 0 ;maxpan
	DCB 0 ;scrstartline
	DCB 0 ;irqControl
	DCB 0 ;irqPending
	DCB 0 ;ystart
	DCB 0 ;sprBank
	DCB 0 ;scanlineminus
g_lockpanel
	DCB 0 ;lockpanel
;...update load/savestate if you move things around in here
;----------------------------------------------------------------------------
	END

