	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE gfx.h
	INCLUDE cpu.h

	IMPORT |wram_globals0$$Base|
	IMPORT findrom			;from main.c
	IMPORT pogoshell		;from main.c
	IMPORT pogosize			;from main.c

	EXPORT loadcart
	EXPORT savestate
	EXPORT loadstate
	EXPORT g_emuflags
	EXPORT romstart			;used in sram.c
	EXPORT romnum
	EXPORT g_cartflags
	EXPORT g_config
;-------------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
loadcart ;called from C:  r0=rom number, r1=emuflags
;-------------------------------------------------------------------------------
	stmfd sp!,{r0-r1,r4-r11,lr}

	ldr r1,=findrom
	bl thumbcall_r1
	add r3,r0,#64		;r0 now points to rom image (including header)

	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd

	ldmfd sp!,{r0-r1}
	str r0,romnumber
	str r1,emuflags

	ldr r1,=pogoshell
	ldrb r1,[r1]
	cmp r1,#0
							;r3=rombase til end of loadcart so DON'T FUCK IT UP
	ldrne r1,=pogosize
	ldrne r1,[r1]			;Size from Pogoshell
	ldreq r1,[r3,#-60]		;size of rom in bytes (from rombuilder).
	str r3,rombase			;set rom base

	movs r2,r1,lsr#16		;64kB blocks.
	subne r2,r2,#1
	str r2,rommask			;rommask=romsize-1


	ldr r4,=MEMMAPTBL_
	mov r0,#4
	mov r5,#0xF4
tbloop1
	and r1,r5,r2
	add r1,r3,r1,lsl#16		;64kB blocks.
	str r1,[r4,r0,lsl#2]
	add r0,r0,#1
	add r5,r5,#1
	cmp r5,#0x100
	bne tbloop1

	ldr r1,=EMU_RAM
	str r1,[r4,#0x0*4]		;0 RAM
	ldr r1,=EMU_SRAM
	str r1,[r4,#0x1*4]		;1 SRAM
	ldr r1,[r4,#0xF*4]		;MemMap
	str r1,[r4,#0x2*4]		;2 ROM
	str r1,[r4,#0x3*4]		;3 ROM


	ldr r0,=EMU_RAM			;clear RAM
	mov r1,#0		
	mov r2,#0x10000/4
	bl memset_

	ldr r0,=EMU_RAM+0x75AC	;simulate BIOS leftovers?
	mov r1,#0x41
	strb r1,[r0],#1
	mov r1,#0x5F
	strb r1,[r0],#1
	mov r1,#0x43
	strb r1,[r0],#1
	mov r1,#0x31
	strb r1,[r0],#1
	mov r1,#0x6E
	strb r1,[r0],#1
	mov r1,#0x5F
	strb r1,[r0],#1
	mov r1,#0x63
	strb r1,[r0],#1
	mov r1,#0x31
	strb r1,[r0],#1


	bl GFX_reset
	bl IO_reset
	bl CPU_reset
	ldmfd sp!,{r4-r11,lr}
	bx lr


;-------------------------------------------------------------------------------
savestate	;called from ui.c.
;int savestate(void): return size.
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r9,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

	bl fixCpuPC_save			;adjust cpu pc (so savestates are valid after moving roms around)

;	mov r6,r0					;r6=where to copy state
	ldr r6,=STATEPTR			;r6=where state is at
	mov r0,#0					;r0 holds total size (return value)

	adr r4,savelst				;r4=list of stuff to copy
	mov r3,#(lstend-savelst)/8	;r3=items in list
ss1	ldmia r4!,{r1,r2}			;r1=what to copy, r2=how much to copy
	add r0,r0,r2
ss0	ldr r5,[r1],#4
	str r5,[r6],#4
	subs r2,r2,#4
	bne ss0
	subs r3,r3,#1
	bne ss1

	mov r4,r0					;save r0.
	bl fixCpuPC_load
	ldr r1,=0xE040
	add r0,r1,r4

	ldmfd sp!,{r4-r9,globalptr,lr}
	bx lr

;savelst	DCD rominfo,8,EMU_SRAM,0xE000,cpustate,104,gfxstate-16,72,SoundVariables,56,BankState,16,SMSPALBUFF,544
;savelst	DCD rominfo,8,cpustate,104,gfxstate-16,72,SoundVariables,56,BankState,16,PALETTE_RAM,0xE040
savelst		;DCD rominfo,8,cpustate,104,gfxstate-16,72,SoundVariables,56,BankState,16
lstend

fixCpuPC_save
;	ldr r2,lastbank
;	ldr r3,cpuregs+6*4	;Z80 PC
;	sub r3,r3,r2
;	str r3,cpuregs+6*4

	mov pc,lr

fixCpuPC_load
;	ldr z80pc,cpuregs+6*4	;Z80 PC
;	encodePC
;	str z80pc,cpuregs+6*4

	mov pc,lr
;-------------------------------------------------------------------------------
loadstate	;called from ui.c
;void loadstate(int rom#)	 (stateptr must be word aligned)
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r9,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

;	ldr r0,romnumber
;	mov r6,r1					;r6=where state is at
	ldr r6,=STATEPTR			;r6=where state is at
;	ldrb r4,scalemode			;preserve scalmode config

	ldr r1,[r6]					;emuflags
;	ldrb r1,[r6]				;emuflags
	ldrb r2,[r6,#1]				;emuflags
;	strb r2,scalemode			;change scalemode before loadcart
;	orr r1,r1,r2,lsl#8
;	ldrb r2,[r6,#2]				;emuflags
;	orr r1,r1,r2,lsl#16
;	ldrb r2,[r6,#3]				;emuflags
;	orr r1,r1,r2,lsl#24

	mov r2,#1
;	bl loadcartnew				;cart init, without memclear.
;	strb r4,scalemode			;restore scalemode config

	mov r0,#(lstend-savelst)/8	;read entire state
	adr r4,savelst
ls1	ldmia r4!,{r1,r2}
ls0	ldr r5,[r6],#4
	str r5,[r1],#4
	subs r2,r2,#4
	bne ls0
	subs r0,r0,#1
	bne ls1


;	bl reBankSwitch0_W
;	bl reBankSwitch1_W
;	bl reBankSwitch2_W

	bl fixCpuPC_load

	ldrb r2,vdpctrl
	cmp r2,#3
	adr lr,state_ret
	ldreq pc,=VDPctrl3_W
	ldr pc,=VDPctrl1_W
state_ret

	ldr r0,=DIRTYTILES
	mov r1,#0
	mov r2,#128
	bl memset_

	bl PaletteTxAll

	ldmfd sp!,{r4-r9,globalptr,lr}
	bx lr



;-------------------------------------------------------------------------------
 AREA wram_globals2, CODE, READWRITE

romstart
	DCD 0 ;rombase
romnum
	DCD 0 ;romnumber
rominfo                 ;keep emuflags/BGmirror together for savestate/loadstate
g_emuflags	DCB 0 ;emuflags        (label this so UI.C can take a peek) see equates.h for bitfields
			DCB SCALED_SPRITES ;(display type)
	% 2   ;(sprite follow val)

	DCD 0 ;rommask
	DCD 0 ;BGoffset1
	DCD 0 ;BGoffset2
	DCD 0 ;BGoffset3
g_cartflags
	DCB 0 ;cartflags
g_config
	DCB 0		;config, bit 7=BIOS on/off, bit 6=R as Start,
	DCB 0,0
BankState
	DCB 0,0,0,0	;BankMap0,1,2,3
	DCB 0,0,0,0	;BankMap4, IO control (BIOS select), + alignment.
;----------------------------------------------------------------------------
	END

