	INCLUDE equates.h

	EXPORT empty_IO_R
	EXPORT empty_W
	EXPORT cpuWriteByte
	EXPORT cpuReadByte
	EXPORT bytecopy_
	EXPORT memset_
	EXPORT memorr_

;----------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
bytecopy_		;void bytecopy(u8 *dst,u8 *src,int count)
;----------------------------------------------------------------------------
bytecopy_l
	subs r2,r2,#1
	ldrplb r3,[r1,r2]
	strplb r3,[r0,r2]
	bhi bytecopy_l
	bx lr

;----------------------------------------------------------------------------
empty_IO_R		;read bad IO address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xFF			;
	bx lr
;----------------------------------------------------------------------------
empty_W			;write bad address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xBA
	bx lr
;----------------------------------------------------------------------------
rom_W			;write ROM address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xB0
	bx lr
;----------------------------------------------------------------------------
	AREA wram_code3, CODE, READWRITE
;----------------------------------------------------------------------------
cpuWriteByte	;r0=address, r1=value
;----------------------------------------------------------------------------
	movs r2,r0,lsr#16
	beq ram_W
	cmp r2,#1
	beq sram_W
	b rom_W
;----------------------------------------------------------------------------
ram_W			;write ram ($000000-$00FFFF)
;----------------------------------------------------------------------------
	mov r0,r0,lsl#16
	ldr r2,=EMU_RAM
	strb r1,[r2,r0,lsr#16]
	mov r1,#0
	ldr r2,=DIRTYTILES
	strb r1,[r2,r0,lsr#21]
	bx lr
;----------------------------------------------------------------------------
sram_W			;write sram ($010000-$017FFF)
;----------------------------------------------------------------------------
	mov r0,r0,lsl#17
	ldr r2,=EMU_SRAM
	strb r1,[r2,r0,lsr#17]
	bx lr
;----------------------------------------------------------------------------
cpuReadByte		;r0=address
;----------------------------------------------------------------------------
	and r2,r0,#0x0F0000
	mov r0,r0,lsl#16
	ldr r1,=MEMMAPTBL_
	ldr r1,[r1,r2,lsr#14]
	ldrb r0,[r1,r0,lsr#16]
	bx lr
;----------------------------------------------------------------------------
memset_ ;r0=dest r1=data r2=word count
;	exit with r0 & r1 unchanged, r2=0
;----------------------------------------------------------------------------
	subs r2,r2,#1
	strpl r1,[r0,r2,lsl#2]
	bhi memset_
	bx lr
;----------------------------------------------------------------------------
memorr_ ;r0=dest r1=data r2=word count
;	exit with r0 & r1 unchanged, r2=0, r3 trashed
;----------------------------------------------------------------------------
	subs r2,r2,#1
	ldrpl r3,[r0,r2,lsl#2]
	orrpl r3,r3,r1
	strpl r3,[r0,r2,lsl#2]
	bhi memorr_
	bx lr
;----------------------------------------------------------------------------
	END
