	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE gfx.h
	INCLUDE cart.h

	EXPORT IO_init
	EXPORT IO_reset
	EXPORT ioReadByte
	EXPORT ioWriteByte
	EXPORT joycfg
	EXPORT spriteinit
	EXPORT suspend
	EXPORT refreshEMUjoypads
	EXPORT serialinterrupt
	EXPORT resetSIO
	EXPORT joy0state
	EXPORT joy1state
	EXPORT thumbcall_r1
	EXPORT gettime
	EXPORT vbaprint
	EXPORT waitframe
	EXPORT UnCompVram
	EXPORT LZ77UnCompVram
	EXPORT HuffUnComp
	EXPORT RLEUnCompVram
	EXPORT CheckGBAVersion
	EXPORT IO_regs



;----------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -
;----------------------------------------------------------------------------

UnCompVram
	ldrb r2,[r0]
	mov r2,r2,lsr#4
	cmp r2,#1
	beq LZ77UnCompVram
	cmp r2,#2
	beq HuffUnComp
	cmp r2,#3
	beq RLEUnCompVram
	bx lr

LZ77UnCompVram
	swi 0x120000
	bx lr

HuffUnComp
	swi 0x130000
	bx lr

RLEUnCompVram
	swi 0x150000
	bx lr


vbaprint
	swi 0xFF0000		;!!!!!!! Doesn't work on hardware !!!!!!!
	bx lr
waitframe
VblWait
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until VBLIRQ if not too late allready.
	bx lr
CheckGBAVersion
	ldr r0,=0x5AB07A6E		;Fool proofing
	mov r12,#0
	swi 0x0D0000			;GetBIOSChecksum
	ldr r1,=0xABBE687E		;Proto GBA
	cmp r0,r1
	moveq r12,#1
	ldr r1,=0xBAAE187F		;Normal GBA
	cmp r0,r1
	moveq r12,#2
	ldr r1,=0xBAAE1880		;Nintendo DS
	cmp r0,r1
	moveq r12,#4
	mov r0,r12
	bx lr

;----------------------------------------------------------------------------
IO_init
;----------------------------------------------------------------------------
	mov r1,#REG_BASE
	mov r0,#0x0008
	strh r0,[r1,#REG_DISPSTAT]	;vblank en

	add r2,r1,#REG_IE
	mov r0,#-1
	strh r0,[r2,#2]			;stop pending interrupts
	ldr r0,=irqhandler
	str r0,[r1,#-4]			;=AGB_IRQVECT
	ldr r0,=0x10A1			;key,serial,timer2,vblank. (serial interrupt=0x80)
	strh r0,[r2]
	mov r0,#1
	strh r0,[r2,#8]			;master irq enable

	ldr r0,=0x00C1EB84		;5244, pre *64. for 50Hz timing
	str r0,[r1,#REG_TM2CNT_L]

	bx lr
;----------------------------------------------------------------------------

scaleparms;
	DCD 0x0000,0x0100,0x0120,0x0080,0x0099,OAM_BUFFER1+6
;----------------------------------------------------------------------------
IO_reset
;----------------------------------------------------------------------------
	adr r5,scaleparms		;set sprite scaling params
	ldmia r5,{r0-r5}

	mov r6,#2
scaleloop
	strh r1,[r5],#8				;buffer1, buffer2. scaled normal sprites
	strh r0,[r5],#8
	strh r0,[r5],#8
	strh r2,[r5],#8
		strh r3,[r5],#8			;unscaled double sprites
		strh r0,[r5],#8
		strh r0,[r5],#8
		strh r3,[r5],#40
			strh r3,[r5],#8		;scaled double sprites
			strh r0,[r5],#8
			strh r0,[r5],#8
			strh r4,[r5],#136
		add r5,r5,#0x300
	subs r6,r6,#1
	bne scaleloop


	adr r1,IO_Default
	ldr r2,=IO_regs
	mov r3,#0x100
io_loop
	ldr r0,[r1],#4
	str r0,[r2],#4
	subs r3,r3,#4
	bne io_loop

;	ldr r0,=IN_Table
;	ldreq r1,=Low0_IO_R
;	ldrne r1,=empty_IO_R
;	str r1,[r0],#4
;	ldreq r1,=Low1_IO_R
;	str r1,[r0]

;	ldr r2,=GGIO_Default
;	ldmia r2!,{r0-r1}
;	stmia r2,{r0-r1}
	
	;..to spriteinit
;----------------------------------------------------------------------------
spriteinit	;build yscale_lookup tbl (called by ui.c) r0=scaletype
;called by ui.c:  void spriteinit(char scaletype) (pass scaletype in r0 because globals ptr isn't set up to read it)
;----------------------------------------------------------------------------
	ldr r3,=YSCALE_LOOKUP-16

;------------------ unscaled
si5
	sub r2,r3,#192-160
	mov r0,#164
si2	strb r0,[r2],#1
	cmp r2,r3
	bne si2

	add r2,r3,#256+16
	mov r0,#-31
si3	strb r0,[r3],#1
	add r0,r0,#1
	cmp r0,#164
	movpl r0,#164
	cmp r2,r3
	bne si3
	bx lr


;----------------------------------------------------------------------------
IO_Default
	DCB	0x00, 0x00, 0x9d, 0xbb, 0x00, 0x00, 0x00, 0x26, 0xfe, 0xde, 0xf9, 0xfb, 0xdb, 0xd7, 0x7f, 0xf5
	DCB 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x9e, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x99, 0xfd, 0xb7, 0xdf
	DCB 0x30, 0x57, 0x75, 0x76, 0x15, 0x73, 0x77, 0x77, 0x20, 0x75, 0x50, 0x36, 0x70, 0x67, 0x50, 0x77
	DCB 0x57, 0x54, 0x75, 0x77, 0x75, 0x17, 0x37, 0x73, 0x50, 0x57, 0x60, 0x77, 0x70, 0x77, 0x10, 0x73
	DCB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	DCB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	DCB 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00
	DCB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	DCB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00
	DCB 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00
	DCB 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	DCB 0x00, 0xdb, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x42, 0x00, 0x83, 0x00
	DCB 0x2f, 0x3f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1
	DCB 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1
	DCB 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1
	DCB 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1

;----------------------------------------------------------------------------
suspend	;called from ui.c and z80.s
;----------------------------------------------------------------------------
	mov r3,#REG_BASE

	ldr r1,=REG_P1CNT
	ldr r0,=0xc00c			;interrupt on start+sel
	strh r0,[r3,r1]

	ldrh r1,[r3,#REG_SGCNT_L]
	strh r3,[r3,#REG_SGCNT_L]	;sound off

	ldrh r0,[r3,#REG_DISPCNT]
	orr r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD off

	swi 0x030000

	ldrh r0,[r3,#REG_DISPCNT]
	bic r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD on

	strh r1,[r3,#REG_SGCNT_L]	;sound on

	ldr r1,=REG_P1
susloop
	ldrh r0,[r1]
	and r0,r0,#0xc
	eors r0,r0,#0xc
	bne susloop

	bx lr
;----------------------------------------------------------------------------
gettime	;called from ui.c
;----------------------------------------------------------------------------
	ldr r3,=0x080000c4		;base address for RTC
	mov r1,#1
	strh r1,[r3,#4]			;enable RTC
	mov r1,#7
	strh r1,[r3,#2]			;enable write

	mov r1,#1
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]			;State=Command

	mov r2,#0x65			;r2=Command, YY:MM:DD 00 hh:mm:ss
	mov addy,#8
RTCLoop1
	mov r1,#2
	and r1,r1,r2,lsr#6
	orr r1,r1,#4
	strh r1,[r3]
	mov r1,r2,lsr#6
	orr r1,r1,#5
	strh r1,[r3]
	mov r2,r2,lsl#1
	subs addy,addy,#1
	bne RTCLoop1

	mov r1,#5
	strh r1,[r3,#2]			;enable read
	mov r2,#0
	mov addy,#32
RTCLoop2
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r2,r2,lsr#1
	orr r2,r2,r1,lsl#30
	subs addy,addy,#1
	bne RTCLoop2

	mov r0,#0
	mov addy,#24
RTCLoop3
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r0,r0,lsr#1
	orr r0,r0,r1,lsl#22
	subs addy,addy,#1
	bne RTCLoop3

	bx lr
;----------------------------------------------------------------------------
resetSIO	;r0=joycfg
;----------------------------------------------------------------------------
	bic r0,r0,#0x0f000000
	str r0,joycfg

	bx lr
;----------------------------------------------------------------------------
serialinterrupt
;----------------------------------------------------------------------------
	mov r3,#REG_BASE

	bx lr
;----------------------------------------------------------------------------
refreshEMUjoypads	;call every frame
;exits with Z flag clear if update incomplete (waiting for other player)
;is my multiplayer code butt-ugly?  yes, I thought so.
;i'm not trying to win any contests here.
;----------------------------------------------------------------------------

		ldr r4,frame
		movs r0,r4,lsr#2		;C=frame&2 (autofire alternates every other frame)
	ldr r1,EMUjoypad
	mov r4,r1
	and r0,r1,#0xf0
		ldr r2,joycfg
		andcs r1,r1,r2
		movcss addy,r1,lsr#9	;R?
		andcs r1,r1,r2,lsr#16
	adr addy,dulr2dlur
	ldrb r0,[addy,r0,lsr#4]		;downupleftright



	ands r3,r1,#3
	cmpne r3,#3
	eorne r3,r3,#3

	tst r2,#0x400				;Swap A/B?
	andeq r3,r1,#3
	orr r0,r0,r3,lsl#6

	and r1,r1,#0x08				;Start
	orr r0,r0,r1,lsl#2

	strb r0,joy0state
fin	ands r0,r0,#0				;Z=1
	bx lr

joycfg DCD 0x00ff01ff ;byte0=auto mask, byte1=(saves R), byte2=R auto mask
;bit 31=single/multi, 30=1P/2P, 27=(multi) link active, 24=reset signal received
joy0state	DCB 0
joy1state	DCB 0
joy2state	DCB 0
joyExtra	DCB 0
paddle0x	DCB 0x80
			DCB 0,0,0
dulr2dlur	DCB 0x00,0x02,0x08,0x0A, 0x01,0x03,0x09,0x0B, 0x04,0x06,0x0C,0x0E, 0x05,0x07,0x0D,0x0F

;----------------------------------------------------------------------------
IOPortA_R		;Player1...
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldr r1,=IO_regs
	ldrb r1,[r1,#0xB5]
	and r1,r1,#0xF0
	ldrb r0,joy0state
	tst r1,#0x20
	andne r0,r0,#0x0F
	tst r1,#0x40
	movne r0,r0,lsr#4

	orr r0,r0,r1
	
	bx lr


;----------------------------------------------------------------------------
IO_machine_R
;----------------------------------------------------------------------------
	ldr r1,=IO_regs
	ldrb r0,[r1,r0]
	orr r0,r0,#2
	bx lr

;----------------------------------------------------------------------------
empty_IO_W
;----------------------------------------------------------------------------
	b empty_W

;----------------------------------------------------------------------------
	INCLUDE visoly.s
 AREA wram_code1, CODE, READWRITE
;-- - - - - - - - - - - - - - - - - - - - - -

thumbcall_r1 bx r1


;----------------------------------------------------------------------------
ioReadByte
;----------------------------------------------------------------------------
	and r0,r0,#0xFF
	ldr pc,[pc,r0,lsl#2]
	DCD 0
IN_Table
	DCD IO_reg_R				; 0x00
	DCD IO_reg_R
	DCD VCounter_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x08
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x10
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x18
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x20
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x28
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x30
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x38
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x40
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_important_R			; 0x48
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x50
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x58
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x60
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x68
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x70
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x78
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x80
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x88
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0x90
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0x98
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_machine_R			; 0xA0, color or mono
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0xA8
	DCD IO_reg_R
	DCD IO_important_R			; 0xAA vcounter?
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0xB0
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_important_R			; 0xB3 communication direction
	DCD IO_reg_R
	DCD IOPortA_R				; 0xB5 keypad
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0xB8
	DCD IO_reg_R
	DCD IO_important_R			; 0xBA int-eeprom even byte read
	DCD IO_important_R			; 0xBB int-eeprom odd byte read
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_important_R			; 0xBE int-eeprom status
	DCD IO_reg_R

	DCD BankSwitch4_F_R			; 0xC0
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_important_R			; 0xC4 ext-eeprom even byte read
	DCD IO_important_R			; 0xC5 ext-eeprom odd byte read
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_important_R			; 0xC8 ext-eeprom status
	DCD IO_reg_R
	DCD IO_important_R			; 0xCA rtc status
	DCD IO_important_R			; 0xCB rtc read
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0xD0
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0xD8
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0xE0
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0xE8
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R

	DCD IO_reg_R				; 0xF0
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R				; 0xF8
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R
	DCD IO_reg_R


;----------------------------------------------------------------------------
ioWriteByte
;----------------------------------------------------------------------------
	and r0,r0,#0xFF
	ldr pc,[pc,r0,lsl#2]
	DCD 0
OUT_Table
	DCD IO_reg_W				; 0x00
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; last sprite, start sprite DMA?
	DCD TileMapBase_W
	DCD IO_reg_W				; 0x08
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD BG_scr_x_W				; 0x10
	DCD BG_scr_y_W
	DCD FG_scr_x_W
	DCD FG_scr_y_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0x18
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0x20
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0x28
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0x30
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0x38
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0x40	DMA, source
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W			;DMA destination
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W			;DMA length
	DCD IO_reg_W
	DCD DMA_Start_W				; 0x48
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0x50
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0x58
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0x60
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0x68
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0x70
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0x78
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0x80
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0x88
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0x90
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0x98
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0xA0
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0xA8
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0xB0
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0xB8
	DCD IO_reg_W
	DCD IO_important_W			; 0xBA int-eeprom even byte write
	DCD IO_important_W			; 0xBB int-eeprom odd byte write
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD BankSwitch4_F_W			; 0xC0
	DCD IO_reg_W
	DCD BankSwitch2_W
	DCD BankSwitch3_W
	DCD IO_important_W			; 0xC4 ext-eeprom even byte write
	DCD IO_important_W			; 0xC5 ext-eeprom odd byte write
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0xC8
	DCD IO_reg_W
	DCD IO_important_W			; 0xCA rtc reset
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0xD0
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0xD8
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0xE0
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0xE8
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

	DCD IO_reg_W				; 0xF0
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W				; 0xF8
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W
	DCD IO_reg_W

;------------------------------------------------------------------------------
IO_important_W
	mov r11,r11					;No$GBA breakpoint
;------------------------------------------------------------------------------
IO_reg_W
	adr r2,IO_regs
	strb r1,[r2,r0]
	bx lr
;------------------------------------------------------------------------------
IO_important_R
	mov r11,r11					;No$GBA breakpoint
;------------------------------------------------------------------------------
IO_reg_R
	ldrb r0,[pc,r0]
	bx lr
;------------------------------------------------------------------------------
IO_regs
	% 0x100

;------------------------------------------------------------------------------
DMA_Start_W
;------------------------------------------------------------------------------
	tst r1,#0x80
	bxeq lr

	stmfd sp!,{r4-r7,lr}
	adr r7,IO_regs
	ldrb r4,[r7,#0x40]
	ldrb r0,[r7,#0x41]
	orr r4,r4,r0,lsl#8
	ldrb r0,[r7,#0x42]
	orr r4,r4,r0,lsl#16			;r4=source

	ldrb r5,[r7,#0x44]
	ldrb r0,[r7,#0x45]
	orr r5,r5,r0,lsl#8
	ldrb r0,[r7,#0x43]
	orr r5,r5,r0,lsl#16			;r5=destination

	ldrb r6,[r7,#0x46]
	ldrb r0,[r7,#0x47]
	orr r6,r6,r0,lsl#8			;r6=length

dma_loop
	mov r0,r4
	bl cpuReadByte
	mov r1,r0
	mov r0,r5
	bl cpuWriteByte
	add r4,r4,#1
	add r5,r5,#1
	subs r6,r6,#1
	bne dma_loop

	strb r4,[r7,#0x40]
	mov r4,r4,lsr#8
	strb r4,[r7,#0x41]

	strb r5,[r7,#0x44]
	mov r5,r5,lsr#8
	strb r5,[r7,#0x45]

	mov r0,#0
	strb r0,[r7,#0x46]
	strb r0,[r7,#0x47]
	strb r0,[r7,#0x48]



	ldmfd sp!,{r4-r7,lr}
	bx lr
;------------------------------------------------------------------------------
;SpriteDMA_W
;------------------------------------------------------------------------------
;	mov r11,r11
;	ldr r0,scanline

;	ldr r0,=IO_regs
;	strb r1,[r0,#0x06]			;number of sprites
;	mov r2,r1,lsl#2
;	ldr r1,=EMU_RAM
;	ldrb r0,satoffset
;	and r0,r0,#0x3F
;	add r1,r1,r0,lsl#9
;	ldr r0,=WSCOAMBUFF
;	b bytecopy_

;------------------------------------------------------------------------------
BankSwitch4_F_R						;0x40000-0xFFFFF
;------------------------------------------------------------------------------
	adr r1,IO_regs
	ldrb r0,[r1,#0xC0]
	and r0,r0,#0x0F
	orr r0,r0,#0x20
	bx lr
;------------------------------------------------------------------------------
reBankSwitch4_F_W					;0x40000-0xFFFFF
;------------------------------------------------------------------------------
	adr r0,IO_regs
	ldrb r1,[r0,#0xC0]
;------------------------------------------------------------------------------
BankSwitch4_F_W						;0x40000-0xFFFFF
;------------------------------------------------------------------------------
	adr r0,IO_regs
	strb r1,[r0,#0xC0]
	mov r1,r1,lsl#4
	orr r1,r1,#4

	ldr r0,rommask
	ldr r2,rombase
	ldr addy,=MEMMAPTBL_+4*4
tbloop1
	and r3,r1,r0
	add r3,r2,r3,lsl#16		;64kB blocks.
	str r3,[addy],#4
	add r1,r1,#1
	cmp r1,#0x100
	bne tbloop1

	bx lr
;------------------------------------------------------------------------------
reBankSwitch2_W					;0x20000-0x2FFFF
;------------------------------------------------------------------------------
	adr r0,IO_regs
	ldrb r1,[r0,#0xC2]
;------------------------------------------------------------------------------
BankSwitch2_W					;0x20000-0x2FFFF
;------------------------------------------------------------------------------
	adr r0,IO_regs
	strb r1,[r0,#0xC2]

	ldr r0,rommask
	ldr r2,rombase
	ldr addy,=MEMMAPTBL_+2*4
	and r3,r1,r0
	add r3,r2,r3,lsl#16		;64kB blocks.
	str r3,[addy],#4

	bx lr

;------------------------------------------------------------------------------
reBankSwitch3_W					;0x30000-0x3FFFF
;------------------------------------------------------------------------------
	adr r0,IO_regs
	ldrb r1,[r0,#0xC3]
;------------------------------------------------------------------------------
BankSwitch3_W					;0x30000-0x3FFFF
;------------------------------------------------------------------------------
	adr r0,IO_regs
	strb r1,[r0,#0xC3]

	ldr r0,rommask
	ldr r2,rombase
	ldr addy,=MEMMAPTBL_+3*4
	and r3,r1,r0
	add r3,r2,r3,lsl#16		;64kB blocks.
	str r3,[addy],#4

	bx lr

;----------------------------------------------------------------------------
	END
