	AREA wram_code1, CODE, READWRITE

	INCLUDE equates.h
	INCLUDE io.h
	INCLUDE gfx.h

	IMPORT |wram_globals0$$Base|
	IMPORT ui	;ui.c
	IMPORT nec_reset
	IMPORT nec_execute
	IMPORT nec_int


	EXPORT CPU_reset
	EXPORT run
	EXPORT sleeptime
	EXPORT dontstop
	EXPORT novblankwait
	EXPORT gbadetect
	EXPORT frametotal



;----------------------------------------------------------------------------
run	;r0=0 to return after frame
;----------------------------------------------------------------------------
;	mov r11,r11			;No$GBA breakpoint
	mov r1,#0
	strb r1,novblankwait

	strb r0,dontstop
	tst r0,#1
	stmeqfd sp!,{r4-r11,lr}

	ldr globalptr,=|wram_globals0$$Base|
	b line0x
;----------------------------------------------------------------------------
;cycles ran out
;----------------------------------------------------------------------------
line0
waitformulti
	ldr r1,=REG_P1		;refresh input every frame
	ldrh r0,[r1]
		eor r0,r0,#0xff
		eor r0,r0,#0x300	;r0=button state (raw)
	ldr r1,AGBjoypad
	eor r1,r1,r0
	and r1,r1,r0		;r1=button state (0->1)
	str r0,AGBjoypad

	ldrb r2,emuflags+1
	cmp r2,#SCALED
	bhs %F0			;if unscaled
	ldr r2,windowtop
	tst r0,#0x100			;R=scroll down
	addne r2,r2,#2
	cmp r2,#80
	movgt r2,#80
	tst r0,#0x200			;L=scroll up
	subne r2,r2,#2
	cmp r2,#16
	movmi r2,#16
	str r2,windowtop
0

	ldrb r2,dontstop
	tst r2,#1
	ldmeqfd sp!,{r4-r11,lr}	;exit here if doing single frame:
	bxeq lr							;return to rommenu()

	;----anything from here til line0x won't get executed while rom menu is active---

	mov r2,#REG_BASE
	mov r3,#0x0110				;was 0x0310
	strh r3,[r2,#REG_BLDCNT]	;stop darkened screen,OBJ blend to BG0/1
	mov r3,#0x1000				;BG0/1=16, OBJ=0
	strh r3,[r2,#REG_BLDALPHA]	;Alpha values

	adr lr,line0x			;return here after doing L/R + SEL/START

	tst r1,#0x300			;if L or R was pressed
	tstne r0,#0x100
	tstne r0,#0x200			;and both L+R are held..
	ldrne r1,=ui
	bxne r1					;do menu


	ands r3,r0,#0x300		;if either L or R is pressed (not both)
	eornes r3,r3,#0x300
	bicne r0,r0,#0x0c		;	hide sel,start from EMU
	str r0,EMUjoypad
	beq line0x				;skip ahead if neither or both are pressed

;	tst r0,#0x200
;	tstne r1,#4				;L+SEL for BG adjust
;	ldrne r2,adjustblend
;	addne r2,r2,#1
;	strne r2,adjustblend

	tst r0,#0x200			;L?
	tstne r1,#8				;START?
	ldrb r2,novblankwait	;0=Normal, 1=Force, 2=No wait, 3=Slomo
	addne r2,r2,#1
	cmp r2,#4
	moveq r2,#0
	strb r2,novblankwait

line0x
	bl refreshEMUjoypads	;Z=1 if communication ok
	bne waitformulti		;waiting on other GBA..

	ldr r0,AGBjoypad
	ldr r2,fiveminutes		;sleep after 5/10/30 minutes of inactivity
	cmp r0,#0				;(left out of the loop so waiting on multi-link
	ldrne r2,sleeptime		;doesn't accelerate time)
	subs r2,r2,#1
	str r2,fiveminutes
	bleq suspend

	mov r1,#0
	str r1,scanline			;reset scanline count
	bl newframe				;display update


	ldr r0,fpsvalue
	add r0,r0,#1
	str r0,fpsvalue

	ldr r4,=nec_execute
	ldr r5,=nec_int

line0_to_143 ;------------------------
	bl scanlinehook
	bl execute_line
	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#144
	bmi line0_to_143
;--------------------------------------------- between 143 and 144
	bl endframe					;display update
 [ DEBUG
	mov r1,#REG_BASE			;darken screen during EMU vblank
	mov r0,#0x00f1
	strh r0,[r1,#REG_BLDCNT]
	ldrh r0,[r1,#REG_VCOUNT]
	mov r1,#19
	bl debug_
 ]

	ldr r2,=IO_regs
	ldrb r0,[r2,#0xB2]
	tst r0,#0x40
	beq novbirq
	mov r0,#6
	bl set_interrupt
novbirq


line144_to_158 ;------------------------
	bl scanlinehook
	bl execute_line
	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#159
	bmi line144_to_158

line159 ;------------------------
	ldr r2,=IO_regs
	ldrb r0,[r2,#0xB2]
	tst r0,#0x20
	beq line0
	ldrb r0,[r2,#0xA7]
	cmp r0,#0x35
	beq line0
	mov r0,#5
	bl set_interrupt

	b line0

;----------------------------------------------------------------------------
execute_line
;----------------------------------------------------------------------------
	mov r0,#256
	bx r4
;----------------------------------------------------------------------------
scanlinehook
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	ldr r2,=IO_regs
	ldrb r0,[r2,#0xA4]
	cmp r0,#0
	beq nohblirq
	ldrb r1,[r2,#0xB2]
	tst r1,#0x80
	beq nohblirq
	ldrb r3,[r2,#0xA5]
	cmp r3,#0
	moveq r3,r0
	subs r3,r3,#1
	strb r3,[r2,#0xA5]
	bne nohblirq
	mov r0,#7
	bl set_interrupt

nohblirq

	ldr r1,scanline
	ldrb r0,[r2,#0x03]
	cmp r0,r1
	bne nolineirq
	ldrb r1,[r2,#0xB2]
	tst r1,#0x10
	beq nolineirq
	mov r0,#4
	bl set_interrupt

nolineirq

	ldr lr,[sp],#4
	bx lr
;----------------------------------------------------------------------------
set_interrupt			;r0=int number
;----------------------------------------------------------------------------
	ldr r2,=IO_regs
	ldrb r1,[r2,#0xB6]
	mov r3,#1
	bic r1,r1,r3,lsl r0
	strb r1,[r2,#0xB6]
	ldrb r1,[r2,#0xB0]
	add r0,r0,r1
	mov r0,r0,lsl#2
	bx r5
;----------------------------------------------------------------------------
fiveminutes		DCD 5*60*60
sleeptime		DCD 5*60*60
dontstop		DCB 0
novblankwait	DCB 0
gbadetect		DCB 0
				DCB 0
;----------------------------------------------------------------------------
	AREA wram_globals0, CODE, READWRITE
;----------------------------------------------------------------------------
frametotal
	DCD 0	;frame
	DCD 0	;lastscanline (158)
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
	AREA rom_code, CODE, READONLY
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
CPU_reset	;called by loadcart (r0-r9 are free to use)
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	mov r0,#0
	ldr r1,=nec_reset
	bl thumbcall_r1
	ldr lr,[sp],#4
	bx lr

;----------------------------------------------------------------------------
	END

