/*
 *  Basic_ROM.h - C64 BASIC ROM
 *
 *  Frodo (C) 1994-1997,2002-2005 Christian Bauer
 *  C64/1541 ROMs (C) Commodore Business Machines
 */

static const uint8 builtin_basic_rom[BASIC_ROM_SIZE] = {
 0x94, 0xe3, 0x7b, 0xe3, 0x43, 0x42, 0x4d, 0x42,
 0x41, 0x53, 0x49, 0x43, 0x30, 0xa8, 0x41, 0xa7,
 0x1d, 0xad, 0xf7, 0xa8, 0xa4, 0xab, 0xbe, 0xab,
 0x80, 0xb0, 0x05, 0xac, 0xa4, 0xa9, 0x9f, 0xa8,
 0x70, 0xa8, 0x27, 0xa9, 0x1c, 0xa8, 0x82, 0xa8,
 0xd1, 0xa8, 0x3a, 0xa9, 0x2e, 0xa8, 0x4a, 0xa9,
 0x2c, 0xb8, 0x67, 0xe1, 0x55, 0xe1, 0x64, 0xe1,
 0xb2, 0xb3, 0x23, 0xb8, 0x7f, 0xaa, 0x9f, 0xaa,
 0x56, 0xa8, 0x9b, 0xa6, 0x5d, 0xa6, 0x85, 0xaa,
 0x29, 0xe1, 0xbd, 0xe1, 0xc6, 0xe1, 0x7a, 0xab,
 0x41, 0xa6, 0x39, 0xbc, 0xcc, 0xbc, 0x58, 0xbc,
 0x10, 0x03, 0x7d, 0xb3, 0x9e, 0xb3, 0x71, 0xbf,
 0x97, 0xe0, 0xea, 0xb9, 0xed, 0xbf, 0x64, 0xe2,
 0x6b, 0xe2, 0xb4, 0xe2, 0x0e, 0xe3, 0x0d, 0xb8,
 0x7c, 0xb7, 0x65, 0xb4, 0xad, 0xb7, 0x8b, 0xb7,
 0xec, 0xb6, 0x00, 0xb7, 0x2c, 0xb7, 0x37, 0xb7,
 0x79, 0x69, 0xb8, 0x79, 0x52, 0xb8, 0x7b, 0x2a,
 0xba, 0x7b, 0x11, 0xbb, 0x7f, 0x7a, 0xbf, 0x50,
 0xe8, 0xaf, 0x46, 0xe5, 0xaf, 0x7d, 0xb3, 0xbf,
 0x5a, 0xd3, 0xae, 0x64, 0x15, 0xb0, 0x45, 0x4e,
 0xc4, 0x46, 0x4f, 0xd2, 0x4e, 0x45, 0x58, 0xd4,
 0x44, 0x41, 0x54, 0xc1, 0x49, 0x4e, 0x50, 0x55,
 0x54, 0xa3, 0x49, 0x4e, 0x50, 0x55, 0xd4, 0x44,
 0x49, 0xcd, 0x52, 0x45, 0x41, 0xc4, 0x4c, 0x45,
 0xd4, 0x47, 0x4f, 0x54, 0xcf, 0x52, 0x55, 0xce,
 0x49, 0xc6, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52,
 0xc5, 0x47, 0x4f, 0x53, 0x55, 0xc2, 0x52, 0x45,
 0x54, 0x55, 0x52, 0xce, 0x52, 0x45, 0xcd, 0x53,
 0x54, 0x4f, 0xd0, 0x4f, 0xce, 0x57, 0x41, 0x49,
 0xd4, 0x4c, 0x4f, 0x41, 0xc4, 0x53, 0x41, 0x56,
 0xc5, 0x56, 0x45, 0x52, 0x49, 0x46, 0xd9, 0x44,
 0x45, 0xc6, 0x50, 0x4f, 0x4b, 0xc5, 0x50, 0x52,
 0x49, 0x4e, 0x54, 0xa3, 0x50, 0x52, 0x49, 0x4e,
 0xd4, 0x43, 0x4f, 0x4e, 0xd4, 0x4c, 0x49, 0x53,
 0xd4, 0x43, 0x4c, 0xd2, 0x43, 0x4d, 0xc4, 0x53,
 0x59, 0xd3, 0x4f, 0x50, 0x45, 0xce, 0x43, 0x4c,
 0x4f, 0x53, 0xc5, 0x47, 0x45, 0xd4, 0x4e, 0x45,
 0xd7, 0x54, 0x41, 0x42, 0xa8, 0x54, 0xcf, 0x46,
 0xce, 0x53, 0x50, 0x43, 0xa8, 0x54, 0x48, 0x45,
 0xce, 0x4e, 0x4f, 0xd4, 0x53, 0x54, 0x45, 0xd0,
 0xab, 0xad, 0xaa, 0xaf, 0xde, 0x41, 0x4e, 0xc4,
 0x4f, 0xd2, 0xbe, 0xbd, 0xbc, 0x53, 0x47, 0xce,
 0x49, 0x4e, 0xd4, 0x41, 0x42, 0xd3, 0x55, 0x53,
 0xd2, 0x46, 0x52, 0xc5, 0x50, 0x4f, 0xd3, 0x53,
 0x51, 0xd2, 0x52, 0x4e, 0xc4, 0x4c, 0x4f, 0xc7,
 0x45, 0x58, 0xd0, 0x43, 0x4f, 0xd3, 0x53, 0x49,
 0xce, 0x54, 0x41, 0xce, 0x41, 0x54, 0xce, 0x50,
 0x45, 0x45, 0xcb, 0x4c, 0x45, 0xce, 0x53, 0x54,
 0x52, 0xa4, 0x56, 0x41, 0xcc, 0x41, 0x53, 0xc3,
 0x43, 0x48, 0x52, 0xa4, 0x4c, 0x45, 0x46, 0x54,
 0xa4, 0x52, 0x49, 0x47, 0x48, 0x54, 0xa4, 0x4d,
 0x49, 0x44, 0xa4, 0x47, 0xcf, 0x00, 0x54, 0x4f,
 0x4f, 0x20, 0x4d, 0x41, 0x4e, 0x59, 0x20, 0x46,
 0x49, 0x4c, 0x45, 0xd3, 0x46, 0x49, 0x4c, 0x45,
 0x20, 0x4f, 0x50, 0x45, 0xce, 0x46, 0x49, 0x4c,
 0x45, 0x20, 0x4e, 0x4f, 0x54, 0x20, 0x4f, 0x50,
 0x45, 0xce, 0x46, 0x49, 0x4c, 0x45, 0x20, 0x4e,
 0x4f, 0x54, 0x20, 0x46, 0x4f, 0x55, 0x4e, 0xc4,
 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x20, 0x4e,
 0x4f, 0x54, 0x20, 0x50, 0x52, 0x45, 0x53, 0x45,
 0x4e, 0xd4, 0x4e, 0x4f, 0x54, 0x20, 0x49, 0x4e,
 0x50, 0x55, 0x54, 0x20, 0x46, 0x49, 0x4c, 0xc5,
 0x4e, 0x4f, 0x54, 0x20, 0x4f, 0x55, 0x54, 0x50,
 0x55, 0x54, 0x20, 0x46, 0x49, 0x4c, 0xc5, 0x4d,
 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x20, 0x46,
 0x49, 0x4c, 0x45, 0x20, 0x4e, 0x41, 0x4d, 0xc5,
 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x20,
 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x20, 0x4e,
 0x55, 0x4d, 0x42, 0x45, 0xd2, 0x4e, 0x45, 0x58,
 0x54, 0x20, 0x57, 0x49, 0x54, 0x48, 0x4f, 0x55,
 0x54, 0x20, 0x46, 0x4f, 0xd2, 0x53, 0x59, 0x4e,
 0x54, 0x41, 0xd8, 0x52, 0x45, 0x54, 0x55, 0x52,
 0x4e, 0x20, 0x57, 0x49, 0x54, 0x48, 0x4f, 0x55,
 0x54, 0x20, 0x47, 0x4f, 0x53, 0x55, 0xc2, 0x4f,
 0x55, 0x54, 0x20, 0x4f, 0x46, 0x20, 0x44, 0x41,
 0x54, 0xc1, 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41,
 0x4c, 0x20, 0x51, 0x55, 0x41, 0x4e, 0x54, 0x49,
 0x54, 0xd9, 0x4f, 0x56, 0x45, 0x52, 0x46, 0x4c,
 0x4f, 0xd7, 0x4f, 0x55, 0x54, 0x20, 0x4f, 0x46,
 0x20, 0x4d, 0x45, 0x4d, 0x4f, 0x52, 0xd9, 0x55,
 0x4e, 0x44, 0x45, 0x46, 0x27, 0x44, 0x20, 0x53,
 0x54, 0x41, 0x54, 0x45, 0x4d, 0x45, 0x4e, 0xd4,
 0x42, 0x41, 0x44, 0x20, 0x53, 0x55, 0x42, 0x53,
 0x43, 0x52, 0x49, 0x50, 0xd4, 0x52, 0x45, 0x44,
 0x49, 0x4d, 0x27, 0x44, 0x20, 0x41, 0x52, 0x52,
 0x41, 0xd9, 0x44, 0x49, 0x56, 0x49, 0x53, 0x49,
 0x4f, 0x4e, 0x20, 0x42, 0x59, 0x20, 0x5a, 0x45,
 0x52, 0xcf, 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41,
 0x4c, 0x20, 0x44, 0x49, 0x52, 0x45, 0x43, 0xd4,
 0x54, 0x59, 0x50, 0x45, 0x20, 0x4d, 0x49, 0x53,
 0x4d, 0x41, 0x54, 0x43, 0xc8, 0x53, 0x54, 0x52,
 0x49, 0x4e, 0x47, 0x20, 0x54, 0x4f, 0x4f, 0x20,
 0x4c, 0x4f, 0x4e, 0xc7, 0x46, 0x49, 0x4c, 0x45,
 0x20, 0x44, 0x41, 0x54, 0xc1, 0x46, 0x4f, 0x52,
 0x4d, 0x55, 0x4c, 0x41, 0x20, 0x54, 0x4f, 0x4f,
 0x20, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0xd8,
 0x43, 0x41, 0x4e, 0x27, 0x54, 0x20, 0x43, 0x4f,
 0x4e, 0x54, 0x49, 0x4e, 0x55, 0xc5, 0x55, 0x4e,
 0x44, 0x45, 0x46, 0x27, 0x44, 0x20, 0x46, 0x55,
 0x4e, 0x43, 0x54, 0x49, 0x4f, 0xce, 0x56, 0x45,
 0x52, 0x49, 0x46, 0xd9, 0x4c, 0x4f, 0x41, 0xc4,
 0x9e, 0xa1, 0xac, 0xa1, 0xb5, 0xa1, 0xc2, 0xa1,
 0xd0, 0xa1, 0xe2, 0xa1, 0xf0, 0xa1, 0xff, 0xa1,
 0x10, 0xa2, 0x25, 0xa2, 0x35, 0xa2, 0x3b, 0xa2,
 0x4f, 0xa2, 0x5a, 0xa2, 0x6a, 0xa2, 0x72, 0xa2,
 0x7f, 0xa2, 0x90, 0xa2, 0x9d, 0xa2, 0xaa, 0xa2,
 0xba, 0xa2, 0xc8, 0xa2, 0xd5, 0xa2, 0xe4, 0xa2,
 0xed, 0xa2, 0x00, 0xa3, 0x0e, 0xa3, 0x1e, 0xa3,
 0x24, 0xa3, 0x83, 0xa3, 0x0d, 0x4f, 0x4b, 0x0d,
 0x00, 0x20, 0x20, 0x45, 0x52, 0x52, 0x4f, 0x52,
 0x00, 0x20, 0x49, 0x4e, 0x20, 0x00, 0x0d, 0x0a,
 0x52, 0x45, 0x41, 0x44, 0x59, 0x2e, 0x0d, 0x0a,
 0x00, 0x0d, 0x0a, 0x42, 0x52, 0x45, 0x41, 0x4b,
 0x00, 0xa0, 0xba, 0xe8, 0xe8, 0xe8, 0xe8, 0xbd,
 0x01, 0x01, 0xc9, 0x81, 0xd0, 0x21, 0xa5, 0x4a,
 0xd0, 0x0a, 0xbd, 0x02, 0x01, 0x85, 0x49, 0xbd,
 0x03, 0x01, 0x85, 0x4a, 0xdd, 0x03, 0x01, 0xd0,
 0x07, 0xa5, 0x49, 0xdd, 0x02, 0x01, 0xf0, 0x07,
 0x8a, 0x18, 0x69, 0x12, 0xaa, 0xd0, 0xd8, 0x60,
 0x20, 0x08, 0xa4, 0x85, 0x31, 0x84, 0x32, 0x38,
 0xa5, 0x5a, 0xe5, 0x5f, 0x85, 0x22, 0xa8, 0xa5,
 0x5b, 0xe5, 0x60, 0xaa, 0xe8, 0x98, 0xf0, 0x23,
 0xa5, 0x5a, 0x38, 0xe5, 0x22, 0x85, 0x5a, 0xb0,
 0x03, 0xc6, 0x5b, 0x38, 0xa5, 0x58, 0xe5, 0x22,
 0x85, 0x58, 0xb0, 0x08, 0xc6, 0x59, 0x90, 0x04,
 0xb1, 0x5a, 0x91, 0x58, 0x88, 0xd0, 0xf9, 0xb1,
 0x5a, 0x91, 0x58, 0xc6, 0x5b, 0xc6, 0x59, 0xca,
 0xd0, 0xf2, 0x60, 0x0a, 0x69, 0x3e, 0xb0, 0x35,
 0x85, 0x22, 0xba, 0xe4, 0x22, 0x90, 0x2e, 0x60,
 0xc4, 0x34, 0x90, 0x28, 0xd0, 0x04, 0xc5, 0x33,
 0x90, 0x22, 0x48, 0xa2, 0x09, 0x98, 0x48, 0xb5,
 0x57, 0xca, 0x10, 0xfa, 0x20, 0x26, 0xb5, 0xa2,
 0xf7, 0x68, 0x95, 0x61, 0xe8, 0x30, 0xfa, 0x68,
 0xa8, 0x68, 0xc4, 0x34, 0x90, 0x06, 0xd0, 0x05,
 0xc5, 0x33, 0xb0, 0x01, 0x60, 0xa2, 0x10, 0x6c,
 0x00, 0x03, 0x8a, 0x0a, 0xaa, 0xbd, 0x26, 0xa3,
 0x85, 0x22, 0xbd, 0x27, 0xa3, 0x85, 0x23, 0x20,
 0xcc, 0xff, 0xa9, 0x00, 0x85, 0x13, 0x20, 0xd7,
 0xaa, 0x20, 0x45, 0xab, 0xa0, 0x00, 0xb1, 0x22,
 0x48, 0x29, 0x7f, 0x20, 0x47, 0xab, 0xc8, 0x68,
 0x10, 0xf4, 0x20, 0x7a, 0xa6, 0xa9, 0x69, 0xa0,
 0xa3, 0x20, 0x1e, 0xab, 0xa4, 0x3a, 0xc8, 0xf0,
 0x03, 0x20, 0xc2, 0xbd, 0xa9, 0x76, 0xa0, 0xa3,
 0x20, 0x1e, 0xab, 0xa9, 0x80, 0x20, 0x90, 0xff,
 0x6c, 0x02, 0x03, 0x20, 0x60, 0xa5, 0x86, 0x7a,
 0x84, 0x7b, 0x20, 0x73, 0x00, 0xaa, 0xf0, 0xf0,
 0xa2, 0xff, 0x86, 0x3a, 0x90, 0x06, 0x20, 0x79,
 0xa5, 0x4c, 0xe1, 0xa7, 0x20, 0x6b, 0xa9, 0x20,
 0x79, 0xa5, 0x84, 0x0b, 0x20, 0x13, 0xa6, 0x90,
 0x44, 0xa0, 0x01, 0xb1, 0x5f, 0x85, 0x23, 0xa5,
 0x2d, 0x85, 0x22, 0xa5, 0x60, 0x85, 0x25, 0xa5,
 0x5f, 0x88, 0xf1, 0x5f, 0x18, 0x65, 0x2d, 0x85,
 0x2d, 0x85, 0x24, 0xa5, 0x2e, 0x69, 0xff, 0x85,
 0x2e, 0xe5, 0x60, 0xaa, 0x38, 0xa5, 0x5f, 0xe5,
 0x2d, 0xa8, 0xb0, 0x03, 0xe8, 0xc6, 0x25, 0x18,
 0x65, 0x22, 0x90, 0x03, 0xc6, 0x23, 0x18, 0xb1,
 0x22, 0x91, 0x24, 0xc8, 0xd0, 0xf9, 0xe6, 0x23,
 0xe6, 0x25, 0xca, 0xd0, 0xf2, 0x20, 0x59, 0xa6,
 0x20, 0x33, 0xa5, 0xad, 0x00, 0x02, 0xf0, 0x88,
 0x18, 0xa5, 0x2d, 0x85, 0x5a, 0x65, 0x0b, 0x85,
 0x58, 0xa4, 0x2e, 0x84, 0x5b, 0x90, 0x01, 0xc8,
 0x84, 0x59, 0x20, 0xb8, 0xa3, 0xa5, 0x14, 0xa4,
 0x15, 0x8d, 0xfe, 0x01, 0x8c, 0xff, 0x01, 0xa5,
 0x31, 0xa4, 0x32, 0x85, 0x2d, 0x84, 0x2e, 0xa4,
 0x0b, 0x88, 0xb9, 0xfc, 0x01, 0x91, 0x5f, 0x88,
 0x10, 0xf8, 0x20, 0x59, 0xa6, 0x20, 0x33, 0xa5,
 0x4c, 0x80, 0xa4, 0xa5, 0x2b, 0xa4, 0x2c, 0x85,
 0x22, 0x84, 0x23, 0x18, 0xa0, 0x01, 0xb1, 0x22,
 0xf0, 0x1d, 0xa0, 0x04, 0xc8, 0xb1, 0x22, 0xd0,
 0xfb, 0xc8, 0x98, 0x65, 0x22, 0xaa, 0xa0, 0x00,
 0x91, 0x22, 0xa5, 0x23, 0x69, 0x00, 0xc8, 0x91,
 0x22, 0x86, 0x22, 0x85, 0x23, 0x90, 0xdd, 0x60,
 0xa2, 0x00, 0x20, 0x12, 0xe1, 0xc9, 0x0d, 0xf0,
 0x0d, 0x9d, 0x00, 0x02, 0xe8, 0xe0, 0x59, 0x90,
 0xf1, 0xa2, 0x17, 0x4c, 0x37, 0xa4, 0x4c, 0xca,
 0xaa, 0x6c, 0x04, 0x03, 0xa6, 0x7a, 0xa0, 0x04,
 0x84, 0x0f, 0xbd, 0x00, 0x02, 0x10, 0x07, 0xc9,
 0xff, 0xf0, 0x3e, 0xe8, 0xd0, 0xf4, 0xc9, 0x20,
 0xf0, 0x37, 0x85, 0x08, 0xc9, 0x22, 0xf0, 0x56,
 0x24, 0x0f, 0x70, 0x2d, 0xc9, 0x3f, 0xd0, 0x04,
 0xa9, 0x99, 0xd0, 0x25, 0xc9, 0x30, 0x90, 0x04,
 0xc9, 0x3c, 0x90, 0x1d, 0x84, 0x71, 0xa0, 0x00,
 0x84, 0x0b, 0x88, 0x86, 0x7a, 0xca, 0xc8, 0xe8,
 0xbd, 0x00, 0x02, 0x38, 0xf9, 0x9e, 0xa0, 0xf0,
 0xf5, 0xc9, 0x80, 0xd0, 0x30, 0x05, 0x0b, 0xa4,
 0x71, 0xe8, 0xc8, 0x99, 0xfb, 0x01, 0xb9, 0xfb,
 0x01, 0xf0, 0x36, 0x38, 0xe9, 0x3a, 0xf0, 0x04,
 0xc9, 0x49, 0xd0, 0x02, 0x85, 0x0f, 0x38, 0xe9,
 0x55, 0xd0, 0x9f, 0x85, 0x08, 0xbd, 0x00, 0x02,
 0xf0, 0xdf, 0xc5, 0x08, 0xf0, 0xdb, 0xc8, 0x99,
 0xfb, 0x01, 0xe8, 0xd0, 0xf0, 0xa6, 0x7a, 0xe6,
 0x0b, 0xc8, 0xb9, 0x9d, 0xa0, 0x10, 0xfa, 0xb9,
 0x9e, 0xa0, 0xd0, 0xb4, 0xbd, 0x00, 0x02, 0x10,
 0xbe, 0x99, 0xfd, 0x01, 0xc6, 0x7b, 0xa9, 0xff,
 0x85, 0x7a, 0x60, 0xa5, 0x2b, 0xa6, 0x2c, 0xa0,
 0x01, 0x85, 0x5f, 0x86, 0x60, 0xb1, 0x5f, 0xf0,
 0x1f, 0xc8, 0xc8, 0xa5, 0x15, 0xd1, 0x5f, 0x90,
 0x18, 0xf0, 0x03, 0x88, 0xd0, 0x09, 0xa5, 0x14,
 0x88, 0xd1, 0x5f, 0x90, 0x0c, 0xf0, 0x0a, 0x88,
 0xb1, 0x5f, 0xaa, 0x88, 0xb1, 0x5f, 0xb0, 0xd7,
 0x18, 0x60, 0xd0, 0xfd, 0xa9, 0x00, 0xa8, 0x91,
 0x2b, 0xc8, 0x91, 0x2b, 0xa5, 0x2b, 0x18, 0x69,
 0x02, 0x85, 0x2d, 0xa5, 0x2c, 0x69, 0x00, 0x85,
 0x2e, 0x20, 0x8e, 0xa6, 0xa9, 0x00, 0xd0, 0x2d,
 0x20, 0xe7, 0xff, 0xa5, 0x37, 0xa4, 0x38, 0x85,
 0x33, 0x84, 0x34, 0xa5, 0x2d, 0xa4, 0x2e, 0x85,
 0x2f, 0x84, 0x30, 0x85, 0x31, 0x84, 0x32, 0x20,
 0x1d, 0xa8, 0xa2, 0x19, 0x86, 0x16, 0x68, 0xa8,
 0x68, 0xa2, 0xfa, 0x9a, 0x48, 0x98, 0x48, 0xa9,
 0x00, 0x85, 0x3e, 0x85, 0x10, 0x60, 0x18, 0xa5,
 0x2b, 0x69, 0xff, 0x85, 0x7a, 0xa5, 0x2c, 0x69,
 0xff, 0x85, 0x7b, 0x60, 0x90, 0x06, 0xf0, 0x04,
 0xc9, 0xab, 0xd0, 0xe9, 0x20, 0x6b, 0xa9, 0x20,
 0x13, 0xa6, 0x20, 0x79, 0x00, 0xf0, 0x0c, 0xc9,
 0xab, 0xd0, 0x8e, 0x20, 0x73, 0x00, 0x20, 0x6b,
 0xa9, 0xd0, 0x86, 0x68, 0x68, 0xa5, 0x14, 0x05,
 0x15, 0xd0, 0x06, 0xa9, 0xff, 0x85, 0x14, 0x85,
 0x15, 0xa0, 0x01, 0x84, 0x0f, 0xb1, 0x5f, 0xf0,
 0x43, 0x20, 0x2c, 0xa8, 0x20, 0xd7, 0xaa, 0xc8,
 0xb1, 0x5f, 0xaa, 0xc8, 0xb1, 0x5f, 0xc5, 0x15,
 0xd0, 0x04, 0xe4, 0x14, 0xf0, 0x02, 0xb0, 0x2c,
 0x84, 0x49, 0x20, 0xcd, 0xbd, 0xa9, 0x20, 0xa4,
 0x49, 0x29, 0x7f, 0x20, 0x47, 0xab, 0xc9, 0x22,
 0xd0, 0x06, 0xa5, 0x0f, 0x49, 0xff, 0x85, 0x0f,
 0xc8, 0xf0, 0x11, 0xb1, 0x5f, 0xd0, 0x10, 0xa8,
 0xb1, 0x5f, 0xaa, 0xc8, 0xb1, 0x5f, 0x86, 0x5f,
 0x85, 0x60, 0xd0, 0xb5, 0x4c, 0x86, 0xe3, 0x6c,
 0x06, 0x03, 0x10, 0xd7, 0xc9, 0xff, 0xf0, 0xd3,
 0x24, 0x0f, 0x30, 0xcf, 0x38, 0xe9, 0x7f, 0xaa,
 0x84, 0x49, 0xa0, 0xff, 0xca, 0xf0, 0x08, 0xc8,
 0xb9, 0x9e, 0xa0, 0x10, 0xfa, 0x30, 0xf5, 0xc8,
 0xb9, 0x9e, 0xa0, 0x30, 0xb2, 0x20, 0x47, 0xab,
 0xd0, 0xf5, 0xa9, 0x80, 0x85, 0x10, 0x20, 0xa5,
 0xa9, 0x20, 0x8a, 0xa3, 0xd0, 0x05, 0x8a, 0x69,
 0x0f, 0xaa, 0x9a, 0x68, 0x68, 0xa9, 0x09, 0x20,
 0xfb, 0xa3, 0x20, 0x06, 0xa9, 0x18, 0x98, 0x65,
 0x7a, 0x48, 0xa5, 0x7b, 0x69, 0x00, 0x48, 0xa5,
 0x3a, 0x48, 0xa5, 0x39, 0x48, 0xa9, 0xa4, 0x20,
 0xff, 0xae, 0x20, 0x8d, 0xad, 0x20, 0x8a, 0xad,
 0xa5, 0x66, 0x09, 0x7f, 0x25, 0x62, 0x85, 0x62,
 0xa9, 0x8b, 0xa0, 0xa7, 0x85, 0x22, 0x84, 0x23,
 0x4c, 0x43, 0xae, 0xa9, 0xbc, 0xa0, 0xb9, 0x20,
 0xa2, 0xbb, 0x20, 0x79, 0x00, 0xc9, 0xa9, 0xd0,
 0x06, 0x20, 0x73, 0x00, 0x20, 0x8a, 0xad, 0x20,
 0x2b, 0xbc, 0x20, 0x38, 0xae, 0xa5, 0x4a, 0x48,
 0xa5, 0x49, 0x48, 0xa9, 0x81, 0x48, 0x20, 0x2c,
 0xa8, 0xa5, 0x7a, 0xa4, 0x7b, 0xc0, 0x02, 0xea,
 0xf0, 0x04, 0x85, 0x3d, 0x84, 0x3e, 0xa0, 0x00,
 0xb1, 0x7a, 0xd0, 0x43, 0xa0, 0x02, 0xb1, 0x7a,
 0x18, 0xd0, 0x03, 0x4c, 0x4b, 0xa8, 0xc8, 0xb1,
 0x7a, 0x85, 0x39, 0xc8, 0xb1, 0x7a, 0x85, 0x3a,
 0x98, 0x65, 0x7a, 0x85, 0x7a, 0x90, 0x02, 0xe6,
 0x7b, 0x6c, 0x08, 0x03, 0x20, 0x73, 0x00, 0x20,
 0xed, 0xa7, 0x4c, 0xae, 0xa7, 0xf0, 0x3c, 0xe9,
 0x80, 0x90, 0x11, 0xc9, 0x23, 0xb0, 0x17, 0x0a,
 0xa8, 0xb9, 0x0d, 0xa0, 0x48, 0xb9, 0x0c, 0xa0,
 0x48, 0x4c, 0x73, 0x00, 0x4c, 0xa5, 0xa9, 0xc9,
 0x3a, 0xf0, 0xd6, 0x4c, 0x08, 0xaf, 0xc9, 0x4b,
 0xd0, 0xf9, 0x20, 0x73, 0x00, 0xa9, 0xa4, 0x20,
 0xff, 0xae, 0x4c, 0xa0, 0xa8, 0x38, 0xa5, 0x2b,
 0xe9, 0x01, 0xa4, 0x2c, 0xb0, 0x01, 0x88, 0x85,
 0x41, 0x84, 0x42, 0x60, 0x20, 0xe1, 0xff, 0xb0,
 0x01, 0x18, 0xd0, 0x3c, 0xa5, 0x7a, 0xa4, 0x7b,
 0xa6, 0x3a, 0xe8, 0xf0, 0x0c, 0x85, 0x3d, 0x84,
 0x3e, 0xa5, 0x39, 0xa4, 0x3a, 0x85, 0x3b, 0x84,
 0x3c, 0x68, 0x68, 0xa9, 0x81, 0xa0, 0xa3, 0x90,
 0x03, 0x4c, 0x69, 0xa4, 0x4c, 0x86, 0xe3, 0xd0,
 0x17, 0xa2, 0x1a, 0xa4, 0x3e, 0xd0, 0x03, 0x4c,
 0x37, 0xa4, 0xa5, 0x3d, 0x85, 0x7a, 0x84, 0x7b,
 0xa5, 0x3b, 0xa4, 0x3c, 0x85, 0x39, 0x84, 0x3a,
 0x60, 0x08, 0xa9, 0x00, 0x20, 0x90, 0xff, 0x28,
 0xd0, 0x03, 0x4c, 0x59, 0xa6, 0x20, 0x60, 0xa6,
 0x4c, 0x97, 0xa8, 0xa9, 0x03, 0x20, 0xfb, 0xa3,
 0xa5, 0x7b, 0x48, 0xa5, 0x7a, 0x48, 0xa5, 0x3a,
 0x48, 0xa5, 0x39, 0x48, 0xa9, 0x8d, 0x48, 0x20,
 0x79, 0x00, 0x20, 0xa0, 0xa8, 0x4c, 0xae, 0xa7,
 0x20, 0x6b, 0xa9, 0x20, 0x09, 0xa9, 0x38, 0xa5,
 0x39, 0xe5, 0x14, 0xa5, 0x3a, 0xe5, 0x15, 0xb0,
 0x0b, 0x98, 0x38, 0x65, 0x7a, 0xa6, 0x7b, 0x90,
 0x07, 0xe8, 0xb0, 0x04, 0xa5, 0x2b, 0xa6, 0x2c,
 0x20, 0x17, 0xa6, 0x90, 0x1e, 0xa5, 0x5f, 0xe9,
 0x01, 0x85, 0x7a, 0xa5, 0x60, 0xe9, 0x00, 0x85,
 0x7b, 0x60, 0xd0, 0xfd, 0xa9, 0xff, 0x85, 0x4a,
 0x20, 0x8a, 0xa3, 0x9a, 0xc9, 0x8d, 0xf0, 0x0b,
 0xa2, 0x0c, 0x2c, 0xa2, 0x11, 0x4c, 0x37, 0xa4,
 0x4c, 0x08, 0xaf, 0x68, 0x68, 0x85, 0x39, 0x68,
 0x85, 0x3a, 0x68, 0x85, 0x7a, 0x68, 0x85, 0x7b,
 0x20, 0x06, 0xa9, 0x98, 0x18, 0x65, 0x7a, 0x85,
 0x7a, 0x90, 0x02, 0xe6, 0x7b, 0x60, 0xa2, 0x3a,
 0x2c, 0xa2, 0x00, 0x86, 0x07, 0xa0, 0x00, 0x84,
 0x08, 0xa5, 0x08, 0xa6, 0x07, 0x85, 0x07, 0x86,
 0x08, 0xb1, 0x7a, 0xf0, 0xe8, 0xc5, 0x08, 0xf0,
 0xe4, 0xc8, 0xc9, 0x22, 0xd0, 0xf3, 0xf0, 0xe9,
 0x20, 0x9e, 0xad, 0x20, 0x79, 0x00, 0xc9, 0x89,
 0xf0, 0x05, 0xa9, 0xa7, 0x20, 0xff, 0xae, 0xa5,
 0x61, 0xd0, 0x05, 0x20, 0x09, 0xa9, 0xf0, 0xbb,
 0x20, 0x79, 0x00, 0xb0, 0x03, 0x4c, 0xa0, 0xa8,
 0x4c, 0xed, 0xa7, 0x20, 0x9e, 0xb7, 0x48, 0xc9,
 0x8d, 0xf0, 0x04, 0xc9, 0x89, 0xd0, 0x91, 0xc6,
 0x65, 0xd0, 0x04, 0x68, 0x4c, 0xef, 0xa7, 0x20,
 0x73, 0x00, 0x20, 0x6b, 0xa9, 0xc9, 0x2c, 0xf0,
 0xee, 0x68, 0x60, 0xa2, 0x00, 0x86, 0x14, 0x86,
 0x15, 0xb0, 0xf7, 0xe9, 0x2f, 0x85, 0x07, 0xa5,
 0x15, 0x85, 0x22, 0xc9, 0x19, 0xb0, 0xd4, 0xa5,
 0x14, 0x0a, 0x26, 0x22, 0x0a, 0x26, 0x22, 0x65,
 0x14, 0x85, 0x14, 0xa5, 0x22, 0x65, 0x15, 0x85,
 0x15, 0x06, 0x14, 0x26, 0x15, 0xa5, 0x14, 0x65,
 0x07, 0x85, 0x14, 0x90, 0x02, 0xe6, 0x15, 0x20,
 0x73, 0x00, 0x4c, 0x71, 0xa9, 0x20, 0x8b, 0xb0,
 0x85, 0x49, 0x84, 0x4a, 0xa9, 0xb2, 0x20, 0xff,
 0xae, 0xa5, 0x0e, 0x48, 0xa5, 0x0d, 0x48, 0x20,
 0x9e, 0xad, 0x68, 0x2a, 0x20, 0x90, 0xad, 0xd0,
 0x18, 0x68, 0x10, 0x12, 0x20, 0x1b, 0xbc, 0x20,
 0xbf, 0xb1, 0xa0, 0x00, 0xa5, 0x64, 0x91, 0x49,
 0xc8, 0xa5, 0x65, 0x91, 0x49, 0x60, 0x4c, 0xd0,
 0xbb, 0x68, 0xa4, 0x4a, 0xc0, 0xbf, 0xd0, 0x4c,
 0x20, 0xa6, 0xb6, 0xc9, 0x06, 0xd0, 0x3d, 0xa0,
 0x00, 0x84, 0x61, 0x84, 0x66, 0x84, 0x71, 0x20,
 0x1d, 0xaa, 0x20, 0xe2, 0xba, 0xe6, 0x71, 0xa4,
 0x71, 0x20, 0x1d, 0xaa, 0x20, 0x0c, 0xbc, 0xaa,
 0xf0, 0x05, 0xe8, 0x8a, 0x20, 0xed, 0xba, 0xa4,
 0x71, 0xc8, 0xc0, 0x06, 0xd0, 0xdf, 0x20, 0xe2,
 0xba, 0x20, 0x9b, 0xbc, 0xa6, 0x64, 0xa4, 0x63,
 0xa5, 0x65, 0x4c, 0xdb, 0xff, 0xb1, 0x22, 0x20,
 0x80, 0x00, 0x90, 0x03, 0x4c, 0x48, 0xb2, 0xe9,
 0x2f, 0x4c, 0x7e, 0xbd, 0xa0, 0x02, 0xb1, 0x64,
 0xc5, 0x34, 0x90, 0x17, 0xd0, 0x07, 0x88, 0xb1,
 0x64, 0xc5, 0x33, 0x90, 0x0e, 0xa4, 0x65, 0xc4,
 0x2e, 0x90, 0x08, 0xd0, 0x0d, 0xa5, 0x64, 0xc5,
 0x2d, 0xb0, 0x07, 0xa5, 0x64, 0xa4, 0x65, 0x4c,
 0x68, 0xaa, 0xa0, 0x00, 0xb1, 0x64, 0x20, 0x75,
 0xb4, 0xa5, 0x50, 0xa4, 0x51, 0x85, 0x6f, 0x84,
 0x70, 0x20, 0x7a, 0xb6, 0xa9, 0x61, 0xa0, 0x00,
 0x85, 0x50, 0x84, 0x51, 0x20, 0xdb, 0xb6, 0xa0,
 0x00, 0xb1, 0x50, 0x91, 0x49, 0xc8, 0xb1, 0x50,
 0x91, 0x49, 0xc8, 0xb1, 0x50, 0x91, 0x49, 0x60,
 0x20, 0x86, 0xaa, 0x4c, 0xb5, 0xab, 0x20, 0x9e,
 0xb7, 0xf0, 0x05, 0xa9, 0x2c, 0x20, 0xff, 0xae,
 0x08, 0x86, 0x13, 0x20, 0x18, 0xe1, 0x28, 0x4c,
 0xa0, 0xaa, 0x20, 0x21, 0xab, 0x20, 0x79, 0x00,
 0xf0, 0x35, 0xf0, 0x43, 0xc9, 0xa3, 0xf0, 0x50,
 0xc9, 0xa6, 0x18, 0xf0, 0x4b, 0xc9, 0x2c, 0xf0,
 0x37, 0xc9, 0x3b, 0xf0, 0x5e, 0x20, 0x9e, 0xad,
 0x24, 0x0d, 0x30, 0xde, 0x20, 0xdd, 0xbd, 0x20,
 0x87, 0xb4, 0x20, 0x21, 0xab, 0x20, 0x3b, 0xab,
 0xd0, 0xd3, 0xa9, 0x00, 0x9d, 0x00, 0x02, 0xa2,
 0xff, 0xa0, 0x01, 0xa5, 0x13, 0xd0, 0x10, 0xa9,
 0x0d, 0x20, 0x47, 0xab, 0x24, 0x13, 0x10, 0x05,
 0xa9, 0x0a, 0x20, 0x47, 0xab, 0x49, 0xff, 0x60,
 0x38, 0x20, 0xf0, 0xff, 0x98, 0x38, 0xe9, 0x0a,
 0xb0, 0xfc, 0x49, 0xff, 0x69, 0x01, 0xd0, 0x16,
 0x08, 0x38, 0x20, 0xf0, 0xff, 0x84, 0x09, 0x20,
 0x9b, 0xb7, 0xc9, 0x29, 0xd0, 0x59, 0x28, 0x90,
 0x06, 0x8a, 0xe5, 0x09, 0x90, 0x05, 0xaa, 0xe8,
 0xca, 0xd0, 0x06, 0x20, 0x73, 0x00, 0x4c, 0xa2,
 0xaa, 0x20, 0x3b, 0xab, 0xd0, 0xf2, 0x20, 0x87,
 0xb4, 0x20, 0xa6, 0xb6, 0xaa, 0xa0, 0x00, 0xe8,
 0xca, 0xf0, 0xbc, 0xb1, 0x22, 0x20, 0x47, 0xab,
 0xc8, 0xc9, 0x0d, 0xd0, 0xf3, 0x20, 0xe5, 0xaa,
 0x4c, 0x28, 0xab, 0xa5, 0x13, 0xf0, 0x03, 0xa9,
 0x20, 0x2c, 0xa9, 0x1d, 0x2c, 0xa9, 0x3f, 0x20,
 0x0c, 0xe1, 0x29, 0xff, 0x60, 0xa5, 0x11, 0xf0,
 0x11, 0x30, 0x04, 0xa0, 0xff, 0xd0, 0x04, 0xa5,
 0x3f, 0xa4, 0x40, 0x85, 0x39, 0x84, 0x3a, 0x4c,
 0x08, 0xaf, 0xa5, 0x13, 0xf0, 0x05, 0xa2, 0x18,
 0x4c, 0x37, 0xa4, 0xa9, 0x0c, 0xa0, 0xad, 0x20,
 0x1e, 0xab, 0xa5, 0x3d, 0xa4, 0x3e, 0x85, 0x7a,
 0x84, 0x7b, 0x60, 0x20, 0xa6, 0xb3, 0xc9, 0x23,
 0xd0, 0x10, 0x20, 0x73, 0x00, 0x20, 0x9e, 0xb7,
 0xa9, 0x2c, 0x20, 0xff, 0xae, 0x86, 0x13, 0x20,
 0x1e, 0xe1, 0xa2, 0x01, 0xa0, 0x02, 0xa9, 0x00,
 0x8d, 0x01, 0x02, 0xa9, 0x40, 0x20, 0x0f, 0xac,
 0xa6, 0x13, 0xd0, 0x13, 0x60, 0x20, 0x9e, 0xb7,
 0xa9, 0x2c, 0x20, 0xff, 0xae, 0x86, 0x13, 0x20,
 0x1e, 0xe1, 0x20, 0xce, 0xab, 0xa5, 0x13, 0x20,
 0xcc, 0xff, 0xa2, 0x00, 0x86, 0x13, 0x60, 0xc9,
 0x22, 0xd0, 0x0b, 0x20, 0xbd, 0xae, 0xa9, 0x3b,
 0x20, 0xff, 0xae, 0x20, 0x21, 0xab, 0x20, 0xa6,
 0xb3, 0xa9, 0x2c, 0x8d, 0xff, 0x01, 0x20, 0xf9,
 0xab, 0xa5, 0x13, 0xf0, 0x0d, 0x20, 0xb7, 0xff,
 0x29, 0x02, 0xf0, 0x06, 0x20, 0xb5, 0xab, 0x4c,
 0xf8, 0xa8, 0xad, 0x00, 0x02, 0xd0, 0x1e, 0xa5,
 0x13, 0xd0, 0xe3, 0x20, 0x06, 0xa9, 0x4c, 0xfb,
 0xa8, 0xa5, 0x13, 0xd0, 0x06, 0x20, 0x45, 0xab,
 0x20, 0x3b, 0xab, 0x4c, 0x60, 0xa5, 0xa6, 0x41,
 0xa4, 0x42, 0xa9, 0x98, 0x2c, 0xa9, 0x00, 0x85,
 0x11, 0x86, 0x43, 0x84, 0x44, 0x20, 0x8b, 0xb0,
 0x85, 0x49, 0x84, 0x4a, 0xa5, 0x7a, 0xa4, 0x7b,
 0x85, 0x4b, 0x84, 0x4c, 0xa6, 0x43, 0xa4, 0x44,
 0x86, 0x7a, 0x84, 0x7b, 0x20, 0x79, 0x00, 0xd0,
 0x20, 0x24, 0x11, 0x50, 0x0c, 0x20, 0x24, 0xe1,
 0x8d, 0x00, 0x02, 0xa2, 0xff, 0xa0, 0x01, 0xd0,
 0x0c, 0x30, 0x75, 0xa5, 0x13, 0xd0, 0x03, 0x20,
 0x45, 0xab, 0x20, 0xf9, 0xab, 0x86, 0x7a, 0x84,
 0x7b, 0x20, 0x73, 0x00, 0x24, 0x0d, 0x10, 0x31,
 0x24, 0x11, 0x50, 0x09, 0xe8, 0x86, 0x7a, 0xa9,
 0x00, 0x85, 0x07, 0xf0, 0x0c, 0x85, 0x07, 0xc9,
 0x22, 0xf0, 0x07, 0xa9, 0x3a, 0x85, 0x07, 0xa9,
 0x2c, 0x18, 0x85, 0x08, 0xa5, 0x7a, 0xa4, 0x7b,
 0x69, 0x00, 0x90, 0x01, 0xc8, 0x20, 0x8d, 0xb4,
 0x20, 0xe2, 0xb7, 0x20, 0xda, 0xa9, 0x4c, 0x91,
 0xac, 0x20, 0xf3, 0xbc, 0xa5, 0x0e, 0x20, 0xc2,
 0xa9, 0x20, 0x79, 0x00, 0xf0, 0x07, 0xc9, 0x2c,
 0xf0, 0x03, 0x4c, 0x4d, 0xab, 0xa5, 0x7a, 0xa4,
 0x7b, 0x85, 0x43, 0x84, 0x44, 0xa5, 0x4b, 0xa4,
 0x4c, 0x85, 0x7a, 0x84, 0x7b, 0x20, 0x79, 0x00,
 0xf0, 0x2d, 0x20, 0xfd, 0xae, 0x4c, 0x15, 0xac,
 0x20, 0x06, 0xa9, 0xc8, 0xaa, 0xd0, 0x12, 0xa2,
 0x0d, 0xc8, 0xb1, 0x7a, 0xf0, 0x6c, 0xc8, 0xb1,
 0x7a, 0x85, 0x3f, 0xc8, 0xb1, 0x7a, 0xc8, 0x85,
 0x40, 0x20, 0xfb, 0xa8, 0x20, 0x79, 0x00, 0xaa,
 0xe0, 0x83, 0xd0, 0xdc, 0x4c, 0x51, 0xac, 0xa5,
 0x43, 0xa4, 0x44, 0xa6, 0x11, 0x10, 0x03, 0x4c,
 0x27, 0xa8, 0xa0, 0x00, 0xb1, 0x43, 0xf0, 0x0b,
 0xa5, 0x13, 0xd0, 0x07, 0xa9, 0xfc, 0xa0, 0xac,
 0x4c, 0x1e, 0xab, 0x60, 0x3f, 0x45, 0x58, 0x54,
 0x52, 0x41, 0x20, 0x49, 0x47, 0x4e, 0x4f, 0x52,
 0x45, 0x44, 0x0d, 0x00, 0x3f, 0x52, 0x45, 0x44,
 0x4f, 0x20, 0x46, 0x52, 0x4f, 0x4d, 0x20, 0x53,
 0x54, 0x41, 0x52, 0x54, 0x0d, 0x00, 0xd0, 0x04,
 0xa0, 0x00, 0xf0, 0x03, 0x20, 0x8b, 0xb0, 0x85,
 0x49, 0x84, 0x4a, 0x20, 0x8a, 0xa3, 0xf0, 0x05,
 0xa2, 0x0a, 0x4c, 0x37, 0xa4, 0x9a, 0x8a, 0x18,
 0x69, 0x04, 0x48, 0x69, 0x06, 0x85, 0x24, 0x68,
 0xa0, 0x01, 0x20, 0xa2, 0xbb, 0xba, 0xbd, 0x09,
 0x01, 0x85, 0x66, 0xa5, 0x49, 0xa4, 0x4a, 0x20,
 0x67, 0xb8, 0x20, 0xd0, 0xbb, 0xa0, 0x01, 0x20,
 0x5d, 0xbc, 0xba, 0x38, 0xfd, 0x09, 0x01, 0xf0,
 0x17, 0xbd, 0x0f, 0x01, 0x85, 0x39, 0xbd, 0x10,
 0x01, 0x85, 0x3a, 0xbd, 0x12, 0x01, 0x85, 0x7a,
 0xbd, 0x11, 0x01, 0x85, 0x7b, 0x4c, 0xae, 0xa7,
 0x8a, 0x69, 0x11, 0xaa, 0x9a, 0x20, 0x79, 0x00,
 0xc9, 0x2c, 0xd0, 0xf1, 0x20, 0x73, 0x00, 0x20,
 0x24, 0xad, 0x20, 0x9e, 0xad, 0x18, 0x24, 0x38,
 0x24, 0x0d, 0x30, 0x03, 0xb0, 0x03, 0x60, 0xb0,
 0xfd, 0xa2, 0x16, 0x4c, 0x37, 0xa4, 0xa6, 0x7a,
 0xd0, 0x02, 0xc6, 0x7b, 0xc6, 0x7a, 0xa2, 0x00,
 0x24, 0x48, 0x8a, 0x48, 0xa9, 0x01, 0x20, 0xfb,
 0xa3, 0x20, 0x83, 0xae, 0xa9, 0x00, 0x85, 0x4d,
 0x20, 0x79, 0x00, 0x38, 0xe9, 0xb1, 0x90, 0x17,
 0xc9, 0x03, 0xb0, 0x13, 0xc9, 0x01, 0x2a, 0x49,
 0x01, 0x45, 0x4d, 0xc5, 0x4d, 0x90, 0x61, 0x85,
 0x4d, 0x20, 0x73, 0x00, 0x4c, 0xbb, 0xad, 0xa6,
 0x4d, 0xd0, 0x2c, 0xb0, 0x7b, 0x69, 0x07, 0x90,
 0x77, 0x65, 0x0d, 0xd0, 0x03, 0x4c, 0x3d, 0xb6,
 0x69, 0xff, 0x85, 0x22, 0x0a, 0x65, 0x22, 0xa8,
 0x68, 0xd9, 0x80, 0xa0, 0xb0, 0x67, 0x20, 0x8d,
 0xad, 0x48, 0x20, 0x20, 0xae, 0x68, 0xa4, 0x4b,
 0x10, 0x17, 0xaa, 0xf0, 0x56, 0xd0, 0x5f, 0x46,
 0x0d, 0x8a, 0x2a, 0xa6, 0x7a, 0xd0, 0x02, 0xc6,
 0x7b, 0xc6, 0x7a, 0xa0, 0x1b, 0x85, 0x4d, 0xd0,
 0xd7, 0xd9, 0x80, 0xa0, 0xb0, 0x48, 0x90, 0xd9,
 0xb9, 0x82, 0xa0, 0x48, 0xb9, 0x81, 0xa0, 0x48,
 0x20, 0x33, 0xae, 0xa5, 0x4d, 0x4c, 0xa9, 0xad,
 0x4c, 0x08, 0xaf, 0xa5, 0x66, 0xbe, 0x80, 0xa0,
 0xa8, 0x68, 0x85, 0x22, 0xe6, 0x22, 0x68, 0x85,
 0x23, 0x98, 0x48, 0x20, 0x1b, 0xbc, 0xa5, 0x65,
 0x48, 0xa5, 0x64, 0x48, 0xa5, 0x63, 0x48, 0xa5,
 0x62, 0x48, 0xa5, 0x61, 0x48, 0x6c, 0x22, 0x00,
 0xa0, 0xff, 0x68, 0xf0, 0x23, 0xc9, 0x64, 0xf0,
 0x03, 0x20, 0x8d, 0xad, 0x84, 0x4b, 0x68, 0x4a,
 0x85, 0x12, 0x68, 0x85, 0x69, 0x68, 0x85, 0x6a,
 0x68, 0x85, 0x6b, 0x68, 0x85, 0x6c, 0x68, 0x85,
 0x6d, 0x68, 0x85, 0x6e, 0x45, 0x66, 0x85, 0x6f,
 0xa5, 0x61, 0x60, 0x6c, 0x0a, 0x03, 0xa9, 0x00,
 0x85, 0x0d, 0x20, 0x73, 0x00, 0xb0, 0x03, 0x4c,
 0xf3, 0xbc, 0x20, 0x13, 0xb1, 0x90, 0x03, 0x4c,
 0x28, 0xaf, 0xc9, 0xff, 0xd0, 0x0f, 0xa9, 0xa8,
 0xa0, 0xae, 0x20, 0xa2, 0xbb, 0x4c, 0x73, 0x00,
 0x82, 0x49, 0x0f, 0xda, 0xa1, 0xc9, 0x2e, 0xf0,
 0xde, 0xc9, 0xab, 0xf0, 0x58, 0xc9, 0xaa, 0xf0,
 0xd1, 0xc9, 0x22, 0xd0, 0x0f, 0xa5, 0x7a, 0xa4,
 0x7b, 0x69, 0x00, 0x90, 0x01, 0xc8, 0x20, 0x87,
 0xb4, 0x4c, 0xe2, 0xb7, 0xc9, 0xa8, 0xd0, 0x13,
 0xa0, 0x18, 0xd0, 0x3b, 0x20, 0xbf, 0xb1, 0xa5,
 0x65, 0x49, 0xff, 0xa8, 0xa5, 0x64, 0x49, 0xff,
 0x4c, 0x91, 0xb3, 0xc9, 0xa5, 0xd0, 0x03, 0x4c,
 0xf4, 0xb3, 0xc9, 0xb4, 0x90, 0x03, 0x4c, 0xa7,
 0xaf, 0x20, 0xfa, 0xae, 0x20, 0x9e, 0xad, 0xa9,
 0x29, 0x2c, 0xa9, 0x28, 0x2c, 0xa9, 0x2c, 0xa0,
 0x00, 0xd1, 0x7a, 0xd0, 0x03, 0x4c, 0x73, 0x00,
 0xa2, 0x0b, 0x4c, 0x37, 0xa4, 0xa0, 0x15, 0x68,
 0x68, 0x4c, 0xfa, 0xad, 0x38, 0xa5, 0x64, 0xe9,
 0x00, 0xa5, 0x65, 0xe9, 0xa0, 0x90, 0x08, 0xa9,
 0xa2, 0xe5, 0x64, 0xa9, 0xe3, 0xe5, 0x65, 0x60,
 0x20, 0x8b, 0xb0, 0x85, 0x64, 0x84, 0x65, 0xa6,
 0x45, 0xa4, 0x46, 0xa5, 0x0d, 0xf0, 0x26, 0xa9,
 0x00, 0x85, 0x70, 0x20, 0x14, 0xaf, 0x90, 0x1c,
 0xe0, 0x54, 0xd0, 0x18, 0xc0, 0xc9, 0xd0, 0x14,
 0x20, 0x84, 0xaf, 0x84, 0x5e, 0x88, 0x84, 0x71,
 0xa0, 0x06, 0x84, 0x5d, 0xa0, 0x24, 0x20, 0x68,
 0xbe, 0x4c, 0x6f, 0xb4, 0x60, 0x24, 0x0e, 0x10,
 0x0d, 0xa0, 0x00, 0xb1, 0x64, 0xaa, 0xc8, 0xb1,
 0x64, 0xa8, 0x8a, 0x4c, 0x91, 0xb3, 0x20, 0x14,
 0xaf, 0x90, 0x2d, 0xe0, 0x54, 0xd0, 0x1b, 0xc0,
 0x49, 0xd0, 0x25, 0x20, 0x84, 0xaf, 0x98, 0xa2,
 0xa0, 0x4c, 0x4f, 0xbc, 0x20, 0xde, 0xff, 0x86,
 0x64, 0x84, 0x63, 0x85, 0x65, 0xa0, 0x00, 0x84,
 0x62, 0x60, 0xe0, 0x53, 0xd0, 0x0a, 0xc0, 0x54,
 0xd0, 0x06, 0x20, 0xb7, 0xff, 0x4c, 0x3c, 0xbc,
 0xa5, 0x64, 0xa4, 0x65, 0x4c, 0xa2, 0xbb, 0x0a,
 0x48, 0xaa, 0x20, 0x73, 0x00, 0xe0, 0x8f, 0x90,
 0x20, 0x20, 0xfa, 0xae, 0x20, 0x9e, 0xad, 0x20,
 0xfd, 0xae, 0x20, 0x8f, 0xad, 0x68, 0xaa, 0xa5,
 0x65, 0x48, 0xa5, 0x64, 0x48, 0x8a, 0x48, 0x20,
 0x9e, 0xb7, 0x68, 0xa8, 0x8a, 0x48, 0x4c, 0xd6,
 0xaf, 0x20, 0xf1, 0xae, 0x68, 0xa8, 0xb9, 0xea,
 0x9f, 0x85, 0x55, 0xb9, 0xeb, 0x9f, 0x85, 0x56,
 0x20, 0x54, 0x00, 0x4c, 0x8d, 0xad, 0xa0, 0xff,
 0x2c, 0xa0, 0x00, 0x84, 0x0b, 0x20, 0xbf, 0xb1,
 0xa5, 0x64, 0x45, 0x0b, 0x85, 0x07, 0xa5, 0x65,
 0x45, 0x0b, 0x85, 0x08, 0x20, 0xfc, 0xbb, 0x20,
 0xbf, 0xb1, 0xa5, 0x65, 0x45, 0x0b, 0x25, 0x08,
 0x45, 0x0b, 0xa8, 0xa5, 0x64, 0x45, 0x0b, 0x25,
 0x07, 0x45, 0x0b, 0x4c, 0x91, 0xb3, 0x20, 0x90,
 0xad, 0xb0, 0x13, 0xa5, 0x6e, 0x09, 0x7f, 0x25,
 0x6a, 0x85, 0x6a, 0xa9, 0x69, 0xa0, 0x00, 0x20,
 0x5b, 0xbc, 0xaa, 0x4c, 0x61, 0xb0, 0xa9, 0x00,
 0x85, 0x0d, 0xc6, 0x4d, 0x20, 0xa6, 0xb6, 0x85,
 0x61, 0x86, 0x62, 0x84, 0x63, 0xa5, 0x6c, 0xa4,
 0x6d, 0x20, 0xaa, 0xb6, 0x86, 0x6c, 0x84, 0x6d,
 0xaa, 0x38, 0xe5, 0x61, 0xf0, 0x08, 0xa9, 0x01,
 0x90, 0x04, 0xa6, 0x61, 0xa9, 0xff, 0x85, 0x66,
 0xa0, 0xff, 0xe8, 0xc8, 0xca, 0xd0, 0x07, 0xa6,
 0x66, 0x30, 0x0f, 0x18, 0x90, 0x0c, 0xb1, 0x6c,
 0xd1, 0x62, 0xf0, 0xef, 0xa2, 0xff, 0xb0, 0x02,
 0xa2, 0x01, 0xe8, 0x8a, 0x2a, 0x25, 0x12, 0xf0,
 0x02, 0xa9, 0xff, 0x4c, 0x3c, 0xbc, 0x20, 0xfd,
 0xae, 0xaa, 0x20, 0x90, 0xb0, 0x20, 0x79, 0x00,
 0xd0, 0xf4, 0x60, 0xa2, 0x00, 0x20, 0x79, 0x00,
 0x86, 0x0c, 0x85, 0x45, 0x20, 0x79, 0x00, 0x20,
 0x13, 0xb1, 0xb0, 0x03, 0x4c, 0x08, 0xaf, 0xa2,
 0x00, 0x86, 0x0d, 0x86, 0x0e, 0x20, 0x73, 0x00,
 0x90, 0x05, 0x20, 0x13, 0xb1, 0x90, 0x0b, 0xaa,
 0x20, 0x73, 0x00, 0x90, 0xfb, 0x20, 0x13, 0xb1,
 0xb0, 0xf6, 0xc9, 0x24, 0xd0, 0x06, 0xa9, 0xff,
 0x85, 0x0d, 0xd0, 0x10, 0xc9, 0x25, 0xd0, 0x13,
 0xa5, 0x10, 0xd0, 0xd0, 0xa9, 0x80, 0x85, 0x0e,
 0x05, 0x45, 0x85, 0x45, 0x8a, 0x09, 0x80, 0xaa,
 0x20, 0x73, 0x00, 0x86, 0x46, 0x38, 0x05, 0x10,
 0xe9, 0x28, 0xd0, 0x03, 0x4c, 0xd1, 0xb1, 0xa0,
 0x00, 0x84, 0x10, 0xa5, 0x2d, 0xa6, 0x2e, 0x86,
 0x60, 0x85, 0x5f, 0xe4, 0x30, 0xd0, 0x04, 0xc5,
 0x2f, 0xf0, 0x22, 0xa5, 0x45, 0xd1, 0x5f, 0xd0,
 0x08, 0xa5, 0x46, 0xc8, 0xd1, 0x5f, 0xf0, 0x7d,
 0x88, 0x18, 0xa5, 0x5f, 0x69, 0x07, 0x90, 0xe1,
 0xe8, 0xd0, 0xdc, 0xc9, 0x41, 0x90, 0x05, 0xe9,
 0x5b, 0x38, 0xe9, 0xa5, 0x60, 0x68, 0x48, 0xc9,
 0x2a, 0xd0, 0x05, 0xa9, 0x13, 0xa0, 0xbf, 0x60,
 0xa5, 0x45, 0xa4, 0x46, 0xc9, 0x54, 0xd0, 0x0b,
 0xc0, 0xc9, 0xf0, 0xef, 0xc0, 0x49, 0xd0, 0x03,
 0x4c, 0x08, 0xaf, 0xc9, 0x53, 0xd0, 0x04, 0xc0,
 0x54, 0xf0, 0xf5, 0xa5, 0x2f, 0xa4, 0x30, 0x85,
 0x5f, 0x84, 0x60, 0xa5, 0x31, 0xa4, 0x32, 0x85,
 0x5a, 0x84, 0x5b, 0x18, 0x69, 0x07, 0x90, 0x01,
 0xc8, 0x85, 0x58, 0x84, 0x59, 0x20, 0xb8, 0xa3,
 0xa5, 0x58, 0xa4, 0x59, 0xc8, 0x85, 0x2f, 0x84,
 0x30, 0xa0, 0x00, 0xa5, 0x45, 0x91, 0x5f, 0xc8,
 0xa5, 0x46, 0x91, 0x5f, 0xa9, 0x00, 0xc8, 0x91,
 0x5f, 0xc8, 0x91, 0x5f, 0xc8, 0x91, 0x5f, 0xc8,
 0x91, 0x5f, 0xc8, 0x91, 0x5f, 0xa5, 0x5f, 0x18,
 0x69, 0x02, 0xa4, 0x60, 0x90, 0x01, 0xc8, 0x85,
 0x47, 0x84, 0x48, 0x60, 0xa5, 0x0b, 0x0a, 0x69,
 0x05, 0x65, 0x5f, 0xa4, 0x60, 0x90, 0x01, 0xc8,
 0x85, 0x58, 0x84, 0x59, 0x60, 0x90, 0x80, 0x00,
 0x00, 0x00, 0x20, 0xbf, 0xb1, 0xa5, 0x64, 0xa4,
 0x65, 0x60, 0x20, 0x73, 0x00, 0x20, 0x9e, 0xad,
 0x20, 0x8d, 0xad, 0xa5, 0x66, 0x30, 0x0d, 0xa5,
 0x61, 0xc9, 0x90, 0x90, 0x09, 0xa9, 0xa5, 0xa0,
 0xb1, 0x20, 0x5b, 0xbc, 0xd0, 0x7a, 0x4c, 0x9b,
 0xbc, 0xa5, 0x0c, 0x05, 0x0e, 0x48, 0xa5, 0x0d,
 0x48, 0xa0, 0x00, 0x98, 0x48, 0xa5, 0x46, 0x48,
 0xa5, 0x45, 0x48, 0x20, 0xb2, 0xb1, 0x68, 0x85,
 0x45, 0x68, 0x85, 0x46, 0x68, 0xa8, 0xba, 0xbd,
 0x02, 0x01, 0x48, 0xbd, 0x01, 0x01, 0x48, 0xa5,
 0x64, 0x9d, 0x02, 0x01, 0xa5, 0x65, 0x9d, 0x01,
 0x01, 0xc8, 0x20, 0x79, 0x00, 0xc9, 0x2c, 0xf0,
 0xd2, 0x84, 0x0b, 0x20, 0xf7, 0xae, 0x68, 0x85,
 0x0d, 0x68, 0x85, 0x0e, 0x29, 0x7f, 0x85, 0x0c,
 0xa6, 0x2f, 0xa5, 0x30, 0x86, 0x5f, 0x85, 0x60,
 0xc5, 0x32, 0xd0, 0x04, 0xe4, 0x31, 0xf0, 0x39,
 0xa0, 0x00, 0xb1, 0x5f, 0xc8, 0xc5, 0x45, 0xd0,
 0x06, 0xa5, 0x46, 0xd1, 0x5f, 0xf0, 0x16, 0xc8,
 0xb1, 0x5f, 0x18, 0x65, 0x5f, 0xaa, 0xc8, 0xb1,
 0x5f, 0x65, 0x60, 0x90, 0xd7, 0xa2, 0x12, 0x2c,
 0xa2, 0x0e, 0x4c, 0x37, 0xa4, 0xa2, 0x13, 0xa5,
 0x0c, 0xd0, 0xf7, 0x20, 0x94, 0xb1, 0xa5, 0x0b,
 0xa0, 0x04, 0xd1, 0x5f, 0xd0, 0xe7, 0x4c, 0xea,
 0xb2, 0x20, 0x94, 0xb1, 0x20, 0x08, 0xa4, 0xa0,
 0x00, 0x84, 0x72, 0xa2, 0x05, 0xa5, 0x45, 0x91,
 0x5f, 0x10, 0x01, 0xca, 0xc8, 0xa5, 0x46, 0x91,
 0x5f, 0x10, 0x02, 0xca, 0xca, 0x86, 0x71, 0xa5,
 0x0b, 0xc8, 0xc8, 0xc8, 0x91, 0x5f, 0xa2, 0x0b,
 0xa9, 0x00, 0x24, 0x0c, 0x50, 0x08, 0x68, 0x18,
 0x69, 0x01, 0xaa, 0x68, 0x69, 0x00, 0xc8, 0x91,
 0x5f, 0xc8, 0x8a, 0x91, 0x5f, 0x20, 0x4c, 0xb3,
 0x86, 0x71, 0x85, 0x72, 0xa4, 0x22, 0xc6, 0x0b,
 0xd0, 0xdc, 0x65, 0x59, 0xb0, 0x5d, 0x85, 0x59,
 0xa8, 0x8a, 0x65, 0x58, 0x90, 0x03, 0xc8, 0xf0,
 0x52, 0x20, 0x08, 0xa4, 0x85, 0x31, 0x84, 0x32,
 0xa9, 0x00, 0xe6, 0x72, 0xa4, 0x71, 0xf0, 0x05,
 0x88, 0x91, 0x58, 0xd0, 0xfb, 0xc6, 0x59, 0xc6,
 0x72, 0xd0, 0xf5, 0xe6, 0x59, 0x38, 0xa5, 0x31,
 0xe5, 0x5f, 0xa0, 0x02, 0x91, 0x5f, 0xa5, 0x32,
 0xc8, 0xe5, 0x60, 0x91, 0x5f, 0xa5, 0x0c, 0xd0,
 0x62, 0xc8, 0xb1, 0x5f, 0x85, 0x0b, 0xa9, 0x00,
 0x85, 0x71, 0x85, 0x72, 0xc8, 0x68, 0xaa, 0x85,
 0x64, 0x68, 0x85, 0x65, 0xd1, 0x5f, 0x90, 0x0e,
 0xd0, 0x06, 0xc8, 0x8a, 0xd1, 0x5f, 0x90, 0x07,
 0x4c, 0x45, 0xb2, 0x4c, 0x35, 0xa4, 0xc8, 0xa5,
 0x72, 0x05, 0x71, 0x18, 0xf0, 0x0a, 0x20, 0x4c,
 0xb3, 0x8a, 0x65, 0x64, 0xaa, 0x98, 0xa4, 0x22,
 0x65, 0x65, 0x86, 0x71, 0xc6, 0x0b, 0xd0, 0xca,
 0x85, 0x72, 0xa2, 0x05, 0xa5, 0x45, 0x10, 0x01,
 0xca, 0xa5, 0x46, 0x10, 0x02, 0xca, 0xca, 0x86,
 0x28, 0xa9, 0x00, 0x20, 0x55, 0xb3, 0x8a, 0x65,
 0x58, 0x85, 0x47, 0x98, 0x65, 0x59, 0x85, 0x48,
 0xa8, 0xa5, 0x47, 0x60, 0x84, 0x22, 0xb1, 0x5f,
 0x85, 0x28, 0x88, 0xb1, 0x5f, 0x85, 0x29, 0xa9,
 0x10, 0x85, 0x5d, 0xa2, 0x00, 0xa0, 0x00, 0x8a,
 0x0a, 0xaa, 0x98, 0x2a, 0xa8, 0xb0, 0xa4, 0x06,
 0x71, 0x26, 0x72, 0x90, 0x0b, 0x18, 0x8a, 0x65,
 0x28, 0xaa, 0x98, 0x65, 0x29, 0xa8, 0xb0, 0x93,
 0xc6, 0x5d, 0xd0, 0xe3, 0x60, 0xa5, 0x0d, 0xf0,
 0x03, 0x20, 0xa6, 0xb6, 0x20, 0x26, 0xb5, 0x38,
 0xa5, 0x33, 0xe5, 0x31, 0xa8, 0xa5, 0x34, 0xe5,
 0x32, 0xa2, 0x00, 0x86, 0x0d, 0x85, 0x62, 0x84,
 0x63, 0xa2, 0x90, 0x4c, 0x44, 0xbc, 0x38, 0x20,
 0xf0, 0xff, 0xa9, 0x00, 0xf0, 0xeb, 0xa6, 0x3a,
 0xe8, 0xd0, 0xa0, 0xa2, 0x15, 0x2c, 0xa2, 0x1b,
 0x4c, 0x37, 0xa4, 0x20, 0xe1, 0xb3, 0x20, 0xa6,
 0xb3, 0x20, 0xfa, 0xae, 0xa9, 0x80, 0x85, 0x10,
 0x20, 0x8b, 0xb0, 0x20, 0x8d, 0xad, 0x20, 0xf7,
 0xae, 0xa9, 0xb2, 0x20, 0xff, 0xae, 0x48, 0xa5,
 0x48, 0x48, 0xa5, 0x47, 0x48, 0xa5, 0x7b, 0x48,
 0xa5, 0x7a, 0x48, 0x20, 0xf8, 0xa8, 0x4c, 0x4f,
 0xb4, 0xa9, 0xa5, 0x20, 0xff, 0xae, 0x09, 0x80,
 0x85, 0x10, 0x20, 0x92, 0xb0, 0x85, 0x4e, 0x84,
 0x4f, 0x4c, 0x8d, 0xad, 0x20, 0xe1, 0xb3, 0xa5,
 0x4f, 0x48, 0xa5, 0x4e, 0x48, 0x20, 0xf1, 0xae,
 0x20, 0x8d, 0xad, 0x68, 0x85, 0x4e, 0x68, 0x85,
 0x4f, 0xa0, 0x02, 0xb1, 0x4e, 0x85, 0x47, 0xaa,
 0xc8, 0xb1, 0x4e, 0xf0, 0x99, 0x85, 0x48, 0xc8,
 0xb1, 0x47, 0x48, 0x88, 0x10, 0xfa, 0xa4, 0x48,
 0x20, 0xd4, 0xbb, 0xa5, 0x7b, 0x48, 0xa5, 0x7a,
 0x48, 0xb1, 0x4e, 0x85, 0x7a, 0xc8, 0xb1, 0x4e,
 0x85, 0x7b, 0xa5, 0x48, 0x48, 0xa5, 0x47, 0x48,
 0x20, 0x8a, 0xad, 0x68, 0x85, 0x4e, 0x68, 0x85,
 0x4f, 0x20, 0x79, 0x00, 0xf0, 0x03, 0x4c, 0x08,
 0xaf, 0x68, 0x85, 0x7a, 0x68, 0x85, 0x7b, 0xa0,
 0x00, 0x68, 0x91, 0x4e, 0x68, 0xc8, 0x91, 0x4e,
 0x68, 0xc8, 0x91, 0x4e, 0x68, 0xc8, 0x91, 0x4e,
 0x68, 0xc8, 0x91, 0x4e, 0x60, 0x20, 0x8d, 0xad,
 0xa0, 0x00, 0x20, 0xdf, 0xbd, 0x68, 0x68, 0xa9,
 0xff, 0xa0, 0x00, 0xf0, 0x12, 0xa6, 0x64, 0xa4,
 0x65, 0x86, 0x50, 0x84, 0x51, 0x20, 0xf4, 0xb4,
 0x86, 0x62, 0x84, 0x63, 0x85, 0x61, 0x60, 0xa2,
 0x22, 0x86, 0x07, 0x86, 0x08, 0x85, 0x6f, 0x84,
 0x70, 0x85, 0x62, 0x84, 0x63, 0xa0, 0xff, 0xc8,
 0xb1, 0x6f, 0xf0, 0x0c, 0xc5, 0x07, 0xf0, 0x04,
 0xc5, 0x08, 0xd0, 0xf3, 0xc9, 0x22, 0xf0, 0x01,
 0x18, 0x84, 0x61, 0x98, 0x65, 0x6f, 0x85, 0x71,
 0xa6, 0x70, 0x90, 0x01, 0xe8, 0x86, 0x72, 0xa5,
 0x70, 0xf0, 0x04, 0xc9, 0x02, 0xd0, 0x0b, 0x98,
 0x20, 0x75, 0xb4, 0xa6, 0x6f, 0xa4, 0x70, 0x20,
 0x88, 0xb6, 0xa6, 0x16, 0xe0, 0x22, 0xd0, 0x05,
 0xa2, 0x19, 0x4c, 0x37, 0xa4, 0xa5, 0x61, 0x95,
 0x00, 0xa5, 0x62, 0x95, 0x01, 0xa5, 0x63, 0x95,
 0x02, 0xa0, 0x00, 0x86, 0x64, 0x84, 0x65, 0x84,
 0x70, 0x88, 0x84, 0x0d, 0x86, 0x17, 0xe8, 0xe8,
 0xe8, 0x86, 0x16, 0x60, 0x46, 0x0f, 0x48, 0x49,
 0xff, 0x38, 0x65, 0x33, 0xa4, 0x34, 0xb0, 0x01,
 0x88, 0xc4, 0x32, 0x90, 0x11, 0xd0, 0x04, 0xc5,
 0x31, 0x90, 0x0b, 0x85, 0x33, 0x84, 0x34, 0x85,
 0x35, 0x84, 0x36, 0xaa, 0x68, 0x60, 0xa2, 0x10,
 0xa5, 0x0f, 0x30, 0xb6, 0x20, 0x26, 0xb5, 0xa9,
 0x80, 0x85, 0x0f, 0x68, 0xd0, 0xd0, 0xa6, 0x37,
 0xa5, 0x38, 0x86, 0x33, 0x85, 0x34, 0xa0, 0x00,
 0x84, 0x4f, 0x84, 0x4e, 0xa5, 0x31, 0xa6, 0x32,
 0x85, 0x5f, 0x86, 0x60, 0xa9, 0x19, 0xa2, 0x00,
 0x85, 0x22, 0x86, 0x23, 0xc5, 0x16, 0xf0, 0x05,
 0x20, 0xc7, 0xb5, 0xf0, 0xf7, 0xa9, 0x07, 0x85,
 0x53, 0xa5, 0x2d, 0xa6, 0x2e, 0x85, 0x22, 0x86,
 0x23, 0xe4, 0x30, 0xd0, 0x04, 0xc5, 0x2f, 0xf0,
 0x05, 0x20, 0xbd, 0xb5, 0xf0, 0xf3, 0x85, 0x58,
 0x86, 0x59, 0xa9, 0x03, 0x85, 0x53, 0xa5, 0x58,
 0xa6, 0x59, 0xe4, 0x32, 0xd0, 0x07, 0xc5, 0x31,
 0xd0, 0x03, 0x4c, 0x06, 0xb6, 0x85, 0x22, 0x86,
 0x23, 0xa0, 0x00, 0xb1, 0x22, 0xaa, 0xc8, 0xb1,
 0x22, 0x08, 0xc8, 0xb1, 0x22, 0x65, 0x58, 0x85,
 0x58, 0xc8, 0xb1, 0x22, 0x65, 0x59, 0x85, 0x59,
 0x28, 0x10, 0xd3, 0x8a, 0x30, 0xd0, 0xc8, 0xb1,
 0x22, 0xa0, 0x00, 0x0a, 0x69, 0x05, 0x65, 0x22,
 0x85, 0x22, 0x90, 0x02, 0xe6, 0x23, 0xa6, 0x23,
 0xe4, 0x59, 0xd0, 0x04, 0xc5, 0x58, 0xf0, 0xba,
 0x20, 0xc7, 0xb5, 0xf0, 0xf3, 0xb1, 0x22, 0x30,
 0x35, 0xc8, 0xb1, 0x22, 0x10, 0x30, 0xc8, 0xb1,
 0x22, 0xf0, 0x2b, 0xc8, 0xb1, 0x22, 0xaa, 0xc8,
 0xb1, 0x22, 0xc5, 0x34, 0x90, 0x06, 0xd0, 0x1e,
 0xe4, 0x33, 0xb0, 0x1a, 0xc5, 0x60, 0x90, 0x16,
 0xd0, 0x04, 0xe4, 0x5f, 0x90, 0x10, 0x86, 0x5f,
 0x85, 0x60, 0xa5, 0x22, 0xa6, 0x23, 0x85, 0x4e,
 0x86, 0x4f, 0xa5, 0x53, 0x85, 0x55, 0xa5, 0x53,
 0x18, 0x65, 0x22, 0x85, 0x22, 0x90, 0x02, 0xe6,
 0x23, 0xa6, 0x23, 0xa0, 0x00, 0x60, 0xa5, 0x4f,
 0x05, 0x4e, 0xf0, 0xf5, 0xa5, 0x55, 0x29, 0x04,
 0x4a, 0xa8, 0x85, 0x55, 0xb1, 0x4e, 0x65, 0x5f,
 0x85, 0x5a, 0xa5, 0x60, 0x69, 0x00, 0x85, 0x5b,
 0xa5, 0x33, 0xa6, 0x34, 0x85, 0x58, 0x86, 0x59,
 0x20, 0xbf, 0xa3, 0xa4, 0x55, 0xc8, 0xa5, 0x58,
 0x91, 0x4e, 0xaa, 0xe6, 0x59, 0xa5, 0x59, 0xc8,
 0x91, 0x4e, 0x4c, 0x2a, 0xb5, 0xa5, 0x65, 0x48,
 0xa5, 0x64, 0x48, 0x20, 0x83, 0xae, 0x20, 0x8f,
 0xad, 0x68, 0x85, 0x6f, 0x68, 0x85, 0x70, 0xa0,
 0x00, 0xb1, 0x6f, 0x18, 0x71, 0x64, 0x90, 0x05,
 0xa2, 0x17, 0x4c, 0x37, 0xa4, 0x20, 0x75, 0xb4,
 0x20, 0x7a, 0xb6, 0xa5, 0x50, 0xa4, 0x51, 0x20,
 0xaa, 0xb6, 0x20, 0x8c, 0xb6, 0xa5, 0x6f, 0xa4,
 0x70, 0x20, 0xaa, 0xb6, 0x20, 0xca, 0xb4, 0x4c,
 0xb8, 0xad, 0xa0, 0x00, 0xb1, 0x6f, 0x48, 0xc8,
 0xb1, 0x6f, 0xaa, 0xc8, 0xb1, 0x6f, 0xa8, 0x68,
 0x86, 0x22, 0x84, 0x23, 0xa8, 0xf0, 0x0a, 0x48,
 0x88, 0xb1, 0x22, 0x91, 0x35, 0x98, 0xd0, 0xf8,
 0x68, 0x18, 0x65, 0x35, 0x85, 0x35, 0x90, 0x02,
 0xe6, 0x36, 0x60, 0x20, 0x8f, 0xad, 0xa5, 0x64,
 0xa4, 0x65, 0x85, 0x22, 0x84, 0x23, 0x20, 0xdb,
 0xb6, 0x08, 0xa0, 0x00, 0xb1, 0x22, 0x48, 0xc8,
 0xb1, 0x22, 0xaa, 0xc8, 0xb1, 0x22, 0xa8, 0x68,
 0x28, 0xd0, 0x13, 0xc4, 0x34, 0xd0, 0x0f, 0xe4,
 0x33, 0xd0, 0x0b, 0x48, 0x18, 0x65, 0x33, 0x85,
 0x33, 0x90, 0x02, 0xe6, 0x34, 0x68, 0x86, 0x22,
 0x84, 0x23, 0x60, 0xc4, 0x18, 0xd0, 0x0c, 0xc5,
 0x17, 0xd0, 0x08, 0x85, 0x16, 0xe9, 0x03, 0x85,
 0x17, 0xa0, 0x00, 0x60, 0x20, 0xa1, 0xb7, 0x8a,
 0x48, 0xa9, 0x01, 0x20, 0x7d, 0xb4, 0x68, 0xa0,
 0x00, 0x91, 0x62, 0x68, 0x68, 0x4c, 0xca, 0xb4,
 0x20, 0x61, 0xb7, 0xd1, 0x50, 0x98, 0x90, 0x04,
 0xb1, 0x50, 0xaa, 0x98, 0x48, 0x8a, 0x48, 0x20,
 0x7d, 0xb4, 0xa5, 0x50, 0xa4, 0x51, 0x20, 0xaa,
 0xb6, 0x68, 0xa8, 0x68, 0x18, 0x65, 0x22, 0x85,
 0x22, 0x90, 0x02, 0xe6, 0x23, 0x98, 0x20, 0x8c,
 0xb6, 0x4c, 0xca, 0xb4, 0x20, 0x61, 0xb7, 0x18,
 0xf1, 0x50, 0x49, 0xff, 0x4c, 0x06, 0xb7, 0xa9,
 0xff, 0x85, 0x65, 0x20, 0x79, 0x00, 0xc9, 0x29,
 0xf0, 0x06, 0x20, 0xfd, 0xae, 0x20, 0x9e, 0xb7,
 0x20, 0x61, 0xb7, 0xf0, 0x4b, 0xca, 0x8a, 0x48,
 0x18, 0xa2, 0x00, 0xf1, 0x50, 0xb0, 0xb6, 0x49,
 0xff, 0xc5, 0x65, 0x90, 0xb1, 0xa5, 0x65, 0xb0,
 0xad, 0x20, 0xf7, 0xae, 0x68, 0xa8, 0x68, 0x85,
 0x55, 0x68, 0x68, 0x68, 0xaa, 0x68, 0x85, 0x50,
 0x68, 0x85, 0x51, 0xa5, 0x55, 0x48, 0x98, 0x48,
 0xa0, 0x00, 0x8a, 0x60, 0x20, 0x82, 0xb7, 0x4c,
 0xa2, 0xb3, 0x20, 0xa3, 0xb6, 0xa2, 0x00, 0x86,
 0x0d, 0xa8, 0x60, 0x20, 0x82, 0xb7, 0xf0, 0x08,
 0xa0, 0x00, 0xb1, 0x22, 0xa8, 0x4c, 0xa2, 0xb3,
 0x4c, 0x48, 0xb2, 0x20, 0x73, 0x00, 0x20, 0x8a,
 0xad, 0x20, 0xb8, 0xb1, 0xa6, 0x64, 0xd0, 0xf0,
 0xa6, 0x65, 0x4c, 0x79, 0x00, 0x20, 0x82, 0xb7,
 0xd0, 0x03, 0x4c, 0xf7, 0xb8, 0xa6, 0x7a, 0xa4,
 0x7b, 0x86, 0x71, 0x84, 0x72, 0xa6, 0x22, 0x86,
 0x7a, 0x18, 0x65, 0x22, 0x85, 0x24, 0xa6, 0x23,
 0x86, 0x7b, 0x90, 0x01, 0xe8, 0x86, 0x25, 0xa0,
 0x00, 0xb1, 0x24, 0x48, 0x98, 0x91, 0x24, 0x20,
 0x79, 0x00, 0x20, 0xf3, 0xbc, 0x68, 0xa0, 0x00,
 0x91, 0x24, 0xa6, 0x71, 0xa4, 0x72, 0x86, 0x7a,
 0x84, 0x7b, 0x60, 0x20, 0x8a, 0xad, 0x20, 0xf7,
 0xb7, 0x20, 0xfd, 0xae, 0x4c, 0x9e, 0xb7, 0xa5,
 0x66, 0x30, 0x9d, 0xa5, 0x61, 0xc9, 0x91, 0xb0,
 0x97, 0x20, 0x9b, 0xbc, 0xa5, 0x64, 0xa4, 0x65,
 0x84, 0x14, 0x85, 0x15, 0x60, 0xa5, 0x15, 0x48,
 0xa5, 0x14, 0x48, 0x20, 0xf7, 0xb7, 0xa0, 0x00,
 0xb1, 0x14, 0xa8, 0x68, 0x85, 0x14, 0x68, 0x85,
 0x15, 0x4c, 0xa2, 0xb3, 0x20, 0xeb, 0xb7, 0x8a,
 0xa0, 0x00, 0x91, 0x14, 0x60, 0x20, 0xeb, 0xb7,
 0x86, 0x49, 0xa2, 0x00, 0x20, 0x79, 0x00, 0xf0,
 0x03, 0x20, 0xf1, 0xb7, 0x86, 0x4a, 0xa0, 0x00,
 0xb1, 0x14, 0x45, 0x4a, 0x25, 0x49, 0xf0, 0xf8,
 0x60, 0xa9, 0x11, 0xa0, 0xbf, 0x4c, 0x67, 0xb8,
 0x20, 0x8c, 0xba, 0xa5, 0x66, 0x49, 0xff, 0x85,
 0x66, 0x45, 0x6e, 0x85, 0x6f, 0xa5, 0x61, 0x4c,
 0x6a, 0xb8, 0x20, 0x99, 0xb9, 0x90, 0x3c, 0x20,
 0x8c, 0xba, 0xd0, 0x03, 0x4c, 0xfc, 0xbb, 0xa6,
 0x70, 0x86, 0x56, 0xa2, 0x69, 0xa5, 0x69, 0xa8,
 0xf0, 0xce, 0x38, 0xe5, 0x61, 0xf0, 0x24, 0x90,
 0x12, 0x84, 0x61, 0xa4, 0x6e, 0x84, 0x66, 0x49,
 0xff, 0x69, 0x00, 0xa0, 0x00, 0x84, 0x56, 0xa2,
 0x61, 0xd0, 0x04, 0xa0, 0x00, 0x84, 0x70, 0xc9,
 0xf9, 0x30, 0xc7, 0xa8, 0xa5, 0x70, 0x56, 0x01,
 0x20, 0xb0, 0xb9, 0x24, 0x6f, 0x10, 0x57, 0xa0,
 0x61, 0xe0, 0x69, 0xf0, 0x02, 0xa0, 0x69, 0x38,
 0x49, 0xff, 0x65, 0x56, 0x85, 0x70, 0xb9, 0x04,
 0x00, 0xf5, 0x04, 0x85, 0x65, 0xb9, 0x03, 0x00,
 0xf5, 0x03, 0x85, 0x64, 0xb9, 0x02, 0x00, 0xf5,
 0x02, 0x85, 0x63, 0xb9, 0x01, 0x00, 0xf5, 0x01,
 0x85, 0x62, 0xb0, 0x03, 0x20, 0x47, 0xb9, 0xa0,
 0x00, 0x98, 0x18, 0xa6, 0x62, 0xd0, 0x4a, 0xa6,
 0x63, 0x86, 0x62, 0xa6, 0x64, 0x86, 0x63, 0xa6,
 0x65, 0x86, 0x64, 0xa6, 0x70, 0x86, 0x65, 0x84,
 0x70, 0x69, 0x08, 0xc9, 0x20, 0xd0, 0xe4, 0xa9,
 0x00, 0x85, 0x61, 0x85, 0x66, 0x60, 0x65, 0x56,
 0x85, 0x70, 0xa5, 0x65, 0x65, 0x6d, 0x85, 0x65,
 0xa5, 0x64, 0x65, 0x6c, 0x85, 0x64, 0xa5, 0x63,
 0x65, 0x6b, 0x85, 0x63, 0xa5, 0x62, 0x65, 0x6a,
 0x85, 0x62, 0x4c, 0x36, 0xb9, 0x69, 0x01, 0x06,
 0x70, 0x26, 0x65, 0x26, 0x64, 0x26, 0x63, 0x26,
 0x62, 0x10, 0xf2, 0x38, 0xe5, 0x61, 0xb0, 0xc7,
 0x49, 0xff, 0x69, 0x01, 0x85, 0x61, 0x90, 0x0e,
 0xe6, 0x61, 0xf0, 0x42, 0x66, 0x62, 0x66, 0x63,
 0x66, 0x64, 0x66, 0x65, 0x66, 0x70, 0x60, 0xa5,
 0x66, 0x49, 0xff, 0x85, 0x66, 0xa5, 0x62, 0x49,
 0xff, 0x85, 0x62, 0xa5, 0x63, 0x49, 0xff, 0x85,
 0x63, 0xa5, 0x64, 0x49, 0xff, 0x85, 0x64, 0xa5,
 0x65, 0x49, 0xff, 0x85, 0x65, 0xa5, 0x70, 0x49,
 0xff, 0x85, 0x70, 0xe6, 0x70, 0xd0, 0x0e, 0xe6,
 0x65, 0xd0, 0x0a, 0xe6, 0x64, 0xd0, 0x06, 0xe6,
 0x63, 0xd0, 0x02, 0xe6, 0x62, 0x60, 0xa2, 0x0f,
 0x4c, 0x37, 0xa4, 0xa2, 0x25, 0xb4, 0x04, 0x84,
 0x70, 0xb4, 0x03, 0x94, 0x04, 0xb4, 0x02, 0x94,
 0x03, 0xb4, 0x01, 0x94, 0x02, 0xa4, 0x68, 0x94,
 0x01, 0x69, 0x08, 0x30, 0xe8, 0xf0, 0xe6, 0xe9,
 0x08, 0xa8, 0xa5, 0x70, 0xb0, 0x14, 0x16, 0x01,
 0x90, 0x02, 0xf6, 0x01, 0x76, 0x01, 0x76, 0x01,
 0x76, 0x02, 0x76, 0x03, 0x76, 0x04, 0x6a, 0xc8,
 0xd0, 0xec, 0x18, 0x60, 0x81, 0x00, 0x00, 0x00,
 0x00, 0x03, 0x7f, 0x5e, 0x56, 0xcb, 0x79, 0x80,
 0x13, 0x9b, 0x0b, 0x64, 0x80, 0x76, 0x38, 0x93,
 0x16, 0x82, 0x38, 0xaa, 0x3b, 0x20, 0x80, 0x35,
 0x04, 0xf3, 0x34, 0x81, 0x35, 0x04, 0xf3, 0x34,
 0x80, 0x80, 0x00, 0x00, 0x00, 0x80, 0x31, 0x72,
 0x17, 0xf8, 0x20, 0x2b, 0xbc, 0xf0, 0x02, 0x10,
 0x03, 0x4c, 0x48, 0xb2, 0xa5, 0x61, 0xe9, 0x7f,
 0x48, 0xa9, 0x80, 0x85, 0x61, 0xa9, 0xd6, 0xa0,
 0xb9, 0x20, 0x67, 0xb8, 0xa9, 0xdb, 0xa0, 0xb9,
 0x20, 0x0f, 0xbb, 0xa9, 0xbc, 0xa0, 0xb9, 0x20,
 0x50, 0xb8, 0xa9, 0xc1, 0xa0, 0xb9, 0x20, 0x43,
 0xe0, 0xa9, 0xe0, 0xa0, 0xb9, 0x20, 0x67, 0xb8,
 0x68, 0x20, 0x7e, 0xbd, 0xa9, 0xe5, 0xa0, 0xb9,
 0x20, 0x8c, 0xba, 0xd0, 0x03, 0x4c, 0x8b, 0xba,
 0x20, 0xb7, 0xba, 0xa9, 0x00, 0x85, 0x26, 0x85,
 0x27, 0x85, 0x28, 0x85, 0x29, 0xa5, 0x70, 0x20,
 0x59, 0xba, 0xa5, 0x65, 0x20, 0x59, 0xba, 0xa5,
 0x64, 0x20, 0x59, 0xba, 0xa5, 0x63, 0x20, 0x59,
 0xba, 0xa5, 0x62, 0x20, 0x5e, 0xba, 0x4c, 0x8f,
 0xbb, 0xd0, 0x03, 0x4c, 0x83, 0xb9, 0x4a, 0x09,
 0x80, 0xa8, 0x90, 0x19, 0x18, 0xa5, 0x29, 0x65,
 0x6d, 0x85, 0x29, 0xa5, 0x28, 0x65, 0x6c, 0x85,
 0x28, 0xa5, 0x27, 0x65, 0x6b, 0x85, 0x27, 0xa5,
 0x26, 0x65, 0x6a, 0x85, 0x26, 0x66, 0x26, 0x66,
 0x27, 0x66, 0x28, 0x66, 0x29, 0x66, 0x70, 0x98,
 0x4a, 0xd0, 0xd6, 0x60, 0x85, 0x22, 0x84, 0x23,
 0xa0, 0x04, 0xb1, 0x22, 0x85, 0x6d, 0x88, 0xb1,
 0x22, 0x85, 0x6c, 0x88, 0xb1, 0x22, 0x85, 0x6b,
 0x88, 0xb1, 0x22, 0x85, 0x6e, 0x45, 0x66, 0x85,
 0x6f, 0xa5, 0x6e, 0x09, 0x80, 0x85, 0x6a, 0x88,
 0xb1, 0x22, 0x85, 0x69, 0xa5, 0x61, 0x60, 0xa5,
 0x69, 0xf0, 0x1f, 0x18, 0x65, 0x61, 0x90, 0x04,
 0x30, 0x1d, 0x18, 0x2c, 0x10, 0x14, 0x69, 0x80,
 0x85, 0x61, 0xd0, 0x03, 0x4c, 0xfb, 0xb8, 0xa5,
 0x6f, 0x85, 0x66, 0x60, 0xa5, 0x66, 0x49, 0xff,
 0x30, 0x05, 0x68, 0x68, 0x4c, 0xf7, 0xb8, 0x4c,
 0x7e, 0xb9, 0x20, 0x0c, 0xbc, 0xaa, 0xf0, 0x10,
 0x18, 0x69, 0x02, 0xb0, 0xf2, 0xa2, 0x00, 0x86,
 0x6f, 0x20, 0x77, 0xb8, 0xe6, 0x61, 0xf0, 0xe7,
 0x60, 0x84, 0x20, 0x00, 0x00, 0x00, 0x20, 0x0c,
 0xbc, 0xa9, 0xf9, 0xa0, 0xba, 0xa2, 0x00, 0x86,
 0x6f, 0x20, 0xa2, 0xbb, 0x4c, 0x12, 0xbb, 0x20,
 0x8c, 0xba, 0xf0, 0x76, 0x20, 0x1b, 0xbc, 0xa9,
 0x00, 0x38, 0xe5, 0x61, 0x85, 0x61, 0x20, 0xb7,
 0xba, 0xe6, 0x61, 0xf0, 0xba, 0xa2, 0xfc, 0xa9,
 0x01, 0xa4, 0x6a, 0xc4, 0x62, 0xd0, 0x10, 0xa4,
 0x6b, 0xc4, 0x63, 0xd0, 0x0a, 0xa4, 0x6c, 0xc4,
 0x64, 0xd0, 0x04, 0xa4, 0x6d, 0xc4, 0x65, 0x08,
 0x2a, 0x90, 0x09, 0xe8, 0x95, 0x29, 0xf0, 0x32,
 0x10, 0x34, 0xa9, 0x01, 0x28, 0xb0, 0x0e, 0x06,
 0x6d, 0x26, 0x6c, 0x26, 0x6b, 0x26, 0x6a, 0xb0,
 0xe6, 0x30, 0xce, 0x10, 0xe2, 0xa8, 0xa5, 0x6d,
 0xe5, 0x65, 0x85, 0x6d, 0xa5, 0x6c, 0xe5, 0x64,
 0x85, 0x6c, 0xa5, 0x6b, 0xe5, 0x63, 0x85, 0x6b,
 0xa5, 0x6a, 0xe5, 0x62, 0x85, 0x6a, 0x98, 0x4c,
 0x4f, 0xbb, 0xa9, 0x40, 0xd0, 0xce, 0x0a, 0x0a,
 0x0a, 0x0a, 0x0a, 0x0a, 0x85, 0x70, 0x28, 0x4c,
 0x8f, 0xbb, 0xa2, 0x14, 0x4c, 0x37, 0xa4, 0xa5,
 0x26, 0x85, 0x62, 0xa5, 0x27, 0x85, 0x63, 0xa5,
 0x28, 0x85, 0x64, 0xa5, 0x29, 0x85, 0x65, 0x4c,
 0xd7, 0xb8, 0x85, 0x22, 0x84, 0x23, 0xa0, 0x04,
 0xb1, 0x22, 0x85, 0x65, 0x88, 0xb1, 0x22, 0x85,
 0x64, 0x88, 0xb1, 0x22, 0x85, 0x63, 0x88, 0xb1,
 0x22, 0x85, 0x66, 0x09, 0x80, 0x85, 0x62, 0x88,
 0xb1, 0x22, 0x85, 0x61, 0x84, 0x70, 0x60, 0xa2,
 0x5c, 0x2c, 0xa2, 0x57, 0xa0, 0x00, 0xf0, 0x04,
 0xa6, 0x49, 0xa4, 0x4a, 0x20, 0x1b, 0xbc, 0x86,
 0x22, 0x84, 0x23, 0xa0, 0x04, 0xa5, 0x65, 0x91,
 0x22, 0x88, 0xa5, 0x64, 0x91, 0x22, 0x88, 0xa5,
 0x63, 0x91, 0x22, 0x88, 0xa5, 0x66, 0x09, 0x7f,
 0x25, 0x62, 0x91, 0x22, 0x88, 0xa5, 0x61, 0x91,
 0x22, 0x84, 0x70, 0x60, 0xa5, 0x6e, 0x85, 0x66,
 0xa2, 0x05, 0xb5, 0x68, 0x95, 0x60, 0xca, 0xd0,
 0xf9, 0x86, 0x70, 0x60, 0x20, 0x1b, 0xbc, 0xa2,
 0x06, 0xb5, 0x60, 0x95, 0x68, 0xca, 0xd0, 0xf9,
 0x86, 0x70, 0x60, 0xa5, 0x61, 0xf0, 0xfb, 0x06,
 0x70, 0x90, 0xf7, 0x20, 0x6f, 0xb9, 0xd0, 0xf2,
 0x4c, 0x38, 0xb9, 0xa5, 0x61, 0xf0, 0x09, 0xa5,
 0x66, 0x2a, 0xa9, 0xff, 0xb0, 0x02, 0xa9, 0x01,
 0x60, 0x20, 0x2b, 0xbc, 0x85, 0x62, 0xa9, 0x00,
 0x85, 0x63, 0xa2, 0x88, 0xa5, 0x62, 0x49, 0xff,
 0x2a, 0xa9, 0x00, 0x85, 0x65, 0x85, 0x64, 0x86,
 0x61, 0x85, 0x70, 0x85, 0x66, 0x4c, 0xd2, 0xb8,
 0x46, 0x66, 0x60, 0x85, 0x24, 0x84, 0x25, 0xa0,
 0x00, 0xb1, 0x24, 0xc8, 0xaa, 0xf0, 0xc4, 0xb1,
 0x24, 0x45, 0x66, 0x30, 0xc2, 0xe4, 0x61, 0xd0,
 0x21, 0xb1, 0x24, 0x09, 0x80, 0xc5, 0x62, 0xd0,
 0x19, 0xc8, 0xb1, 0x24, 0xc5, 0x63, 0xd0, 0x12,
 0xc8, 0xb1, 0x24, 0xc5, 0x64, 0xd0, 0x0b, 0xc8,
 0xa9, 0x7f, 0xc5, 0x70, 0xb1, 0x24, 0xe5, 0x65,
 0xf0, 0x28, 0xa5, 0x66, 0x90, 0x02, 0x49, 0xff,
 0x4c, 0x31, 0xbc, 0xa5, 0x61, 0xf0, 0x4a, 0x38,
 0xe9, 0xa0, 0x24, 0x66, 0x10, 0x09, 0xaa, 0xa9,
 0xff, 0x85, 0x68, 0x20, 0x4d, 0xb9, 0x8a, 0xa2,
 0x61, 0xc9, 0xf9, 0x10, 0x06, 0x20, 0x99, 0xb9,
 0x84, 0x68, 0x60, 0xa8, 0xa5, 0x66, 0x29, 0x80,
 0x46, 0x62, 0x05, 0x62, 0x85, 0x62, 0x20, 0xb0,
 0xb9, 0x84, 0x68, 0x60, 0xa5, 0x61, 0xc9, 0xa0,
 0xb0, 0x20, 0x20, 0x9b, 0xbc, 0x84, 0x70, 0xa5,
 0x66, 0x84, 0x66, 0x49, 0x80, 0x2a, 0xa9, 0xa0,
 0x85, 0x61, 0xa5, 0x65, 0x85, 0x07, 0x4c, 0xd2,
 0xb8, 0x85, 0x62, 0x85, 0x63, 0x85, 0x64, 0x85,
 0x65, 0xa8, 0x60, 0xa0, 0x00, 0xa2, 0x0a, 0x94,
 0x5d, 0xca, 0x10, 0xfb, 0x90, 0x0f, 0xc9, 0x2d,
 0xd0, 0x04, 0x86, 0x67, 0xf0, 0x04, 0xc9, 0x2b,
 0xd0, 0x05, 0x20, 0x73, 0x00, 0x90, 0x5b, 0xc9,
 0x2e, 0xf0, 0x2e, 0xc9, 0x45, 0xd0, 0x30, 0x20,
 0x73, 0x00, 0x90, 0x17, 0xc9, 0xab, 0xf0, 0x0e,
 0xc9, 0x2d, 0xf0, 0x0a, 0xc9, 0xaa, 0xf0, 0x08,
 0xc9, 0x2b, 0xf0, 0x04, 0xd0, 0x07, 0x66, 0x60,
 0x20, 0x73, 0x00, 0x90, 0x5c, 0x24, 0x60, 0x10,
 0x0e, 0xa9, 0x00, 0x38, 0xe5, 0x5e, 0x4c, 0x49,
 0xbd, 0x66, 0x5f, 0x24, 0x5f, 0x50, 0xc3, 0xa5,
 0x5e, 0x38, 0xe5, 0x5d, 0x85, 0x5e, 0xf0, 0x12,
 0x10, 0x09, 0x20, 0xfe, 0xba, 0xe6, 0x5e, 0xd0,
 0xf9, 0xf0, 0x07, 0x20, 0xe2, 0xba, 0xc6, 0x5e,
 0xd0, 0xf9, 0xa5, 0x67, 0x30, 0x01, 0x60, 0x4c,
 0xb4, 0xbf, 0x48, 0x24, 0x5f, 0x10, 0x02, 0xe6,
 0x5d, 0x20, 0xe2, 0xba, 0x68, 0x38, 0xe9, 0x30,
 0x20, 0x7e, 0xbd, 0x4c, 0x0a, 0xbd, 0x48, 0x20,
 0x0c, 0xbc, 0x68, 0x20, 0x3c, 0xbc, 0xa5, 0x6e,
 0x45, 0x66, 0x85, 0x6f, 0xa6, 0x61, 0x4c, 0x6a,
 0xb8, 0xa5, 0x5e, 0xc9, 0x0a, 0x90, 0x09, 0xa9,
 0x64, 0x24, 0x60, 0x30, 0x11, 0x4c, 0x7e, 0xb9,
 0x0a, 0x0a, 0x18, 0x65, 0x5e, 0x0a, 0x18, 0xa0,
 0x00, 0x71, 0x7a, 0x38, 0xe9, 0x30, 0x85, 0x5e,
 0x4c, 0x30, 0xbd, 0x9b, 0x3e, 0xbc, 0x1f, 0xfd,
 0x9e, 0x6e, 0x6b, 0x27, 0xfd, 0x9e, 0x6e, 0x6b,
 0x28, 0x00, 0xa9, 0x71, 0xa0, 0xa3, 0x20, 0xda,
 0xbd, 0xa5, 0x3a, 0xa6, 0x39, 0x85, 0x62, 0x86,
 0x63, 0xa2, 0x90, 0x38, 0x20, 0x49, 0xbc, 0x20,
 0xdf, 0xbd, 0x4c, 0x1e, 0xab, 0xa0, 0x01, 0xa9,
 0x20, 0x24, 0x66, 0x10, 0x02, 0xa9, 0x2d, 0x99,
 0xff, 0x00, 0x85, 0x66, 0x84, 0x71, 0xc8, 0xa9,
 0x30, 0xa6, 0x61, 0xd0, 0x03, 0x4c, 0x04, 0xbf,
 0xa9, 0x00, 0xe0, 0x80, 0xf0, 0x02, 0xb0, 0x09,
 0xa9, 0xbd, 0xa0, 0xbd, 0x20, 0x28, 0xba, 0xa9,
 0xf7, 0x85, 0x5d, 0xa9, 0xb8, 0xa0, 0xbd, 0x20,
 0x5b, 0xbc, 0xf0, 0x1e, 0x10, 0x12, 0xa9, 0xb3,
 0xa0, 0xbd, 0x20, 0x5b, 0xbc, 0xf0, 0x02, 0x10,
 0x0e, 0x20, 0xe2, 0xba, 0xc6, 0x5d, 0xd0, 0xee,
 0x20, 0xfe, 0xba, 0xe6, 0x5d, 0xd0, 0xdc, 0x20,
 0x49, 0xb8, 0x20, 0x9b, 0xbc, 0xa2, 0x01, 0xa5,
 0x5d, 0x18, 0x69, 0x0a, 0x30, 0x09, 0xc9, 0x0b,
 0xb0, 0x06, 0x69, 0xff, 0xaa, 0xa9, 0x02, 0x38,
 0xe9, 0x02, 0x85, 0x5e, 0x86, 0x5d, 0x8a, 0xf0,
 0x02, 0x10, 0x13, 0xa4, 0x71, 0xa9, 0x2e, 0xc8,
 0x99, 0xff, 0x00, 0x8a, 0xf0, 0x06, 0xa9, 0x30,
 0xc8, 0x99, 0xff, 0x00, 0x84, 0x71, 0xa0, 0x00,
 0xa2, 0x80, 0xa5, 0x65, 0x18, 0x79, 0x19, 0xbf,
 0x85, 0x65, 0xa5, 0x64, 0x79, 0x18, 0xbf, 0x85,
 0x64, 0xa5, 0x63, 0x79, 0x17, 0xbf, 0x85, 0x63,
 0xa5, 0x62, 0x79, 0x16, 0xbf, 0x85, 0x62, 0xe8,
 0xb0, 0x04, 0x10, 0xde, 0x30, 0x02, 0x30, 0xda,
 0x8a, 0x90, 0x04, 0x49, 0xff, 0x69, 0x0a, 0x69,
 0x2f, 0xc8, 0xc8, 0xc8, 0xc8, 0x84, 0x47, 0xa4,
 0x71, 0xc8, 0xaa, 0x29, 0x7f, 0x99, 0xff, 0x00,
 0xc6, 0x5d, 0xd0, 0x06, 0xa9, 0x2e, 0xc8, 0x99,
 0xff, 0x00, 0x84, 0x71, 0xa4, 0x47, 0x8a, 0x49,
 0xff, 0x29, 0x80, 0xaa, 0xc0, 0x24, 0xf0, 0x04,
 0xc0, 0x3c, 0xd0, 0xa6, 0xa4, 0x71, 0xb9, 0xff,
 0x00, 0x88, 0xc9, 0x30, 0xf0, 0xf8, 0xc9, 0x2e,
 0xf0, 0x01, 0xc8, 0xa9, 0x2b, 0xa6, 0x5e, 0xf0,
 0x2e, 0x10, 0x08, 0xa9, 0x00, 0x38, 0xe5, 0x5e,
 0xaa, 0xa9, 0x2d, 0x99, 0x01, 0x01, 0xa9, 0x45,
 0x99, 0x00, 0x01, 0x8a, 0xa2, 0x2f, 0x38, 0xe8,
 0xe9, 0x0a, 0xb0, 0xfb, 0x69, 0x3a, 0x99, 0x03,
 0x01, 0x8a, 0x99, 0x02, 0x01, 0xa9, 0x00, 0x99,
 0x04, 0x01, 0xf0, 0x08, 0x99, 0xff, 0x00, 0xa9,
 0x00, 0x99, 0x00, 0x01, 0xa9, 0x00, 0xa0, 0x01,
 0x60, 0x80, 0x00, 0x00, 0x00, 0x00, 0xfa, 0x0a,
 0x1f, 0x00, 0x00, 0x98, 0x96, 0x80, 0xff, 0xf0,
 0xbd, 0xc0, 0x00, 0x01, 0x86, 0xa0, 0xff, 0xff,
 0xd8, 0xf0, 0x00, 0x00, 0x03, 0xe8, 0xff, 0xff,
 0xff, 0x9c, 0x00, 0x00, 0x00, 0x0a, 0xff, 0xff,
 0xff, 0xff, 0xff, 0xdf, 0x0a, 0x80, 0x00, 0x03,
 0x4b, 0xc0, 0xff, 0xff, 0x73, 0x60, 0x00, 0x00,
 0x0e, 0x10, 0xff, 0xff, 0xfd, 0xa8, 0x00, 0x00,
 0x00, 0x3c, 0xec, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
 0xaa, 0x20, 0x0c, 0xbc, 0xa9, 0x11, 0xa0, 0xbf,
 0x20, 0xa2, 0xbb, 0xf0, 0x70, 0xa5, 0x69, 0xd0,
 0x03, 0x4c, 0xf9, 0xb8, 0xa2, 0x4e, 0xa0, 0x00,
 0x20, 0xd4, 0xbb, 0xa5, 0x6e, 0x10, 0x0f, 0x20,
 0xcc, 0xbc, 0xa9, 0x4e, 0xa0, 0x00, 0x20, 0x5b,
 0xbc, 0xd0, 0x03, 0x98, 0xa4, 0x07, 0x20, 0xfe,
 0xbb, 0x98, 0x48, 0x20, 0xea, 0xb9, 0xa9, 0x4e,
 0xa0, 0x00, 0x20, 0x28, 0xba, 0x20, 0xed, 0xbf,
 0x68, 0x4a, 0x90, 0x0a, 0xa5, 0x61, 0xf0, 0x06,
 0xa5, 0x66, 0x49, 0xff, 0x85, 0x66, 0x60, 0x81,
 0x38, 0xaa, 0x3b, 0x29, 0x07, 0x71, 0x34, 0x58,
 0x3e, 0x56, 0x74, 0x16, 0x7e, 0xb3, 0x1b, 0x77,
 0x2f, 0xee, 0xe3, 0x85, 0x7a, 0x1d, 0x84, 0x1c,
 0x2a, 0x7c, 0x63, 0x59, 0x58, 0x0a, 0x7e, 0x75,
 0xfd, 0xe7, 0xc6, 0x80, 0x31, 0x72, 0x18, 0x10,
 0x81, 0x00, 0x00, 0x00, 0x00, 0xa9, 0xbf, 0xa0,
 0xbf, 0x20, 0x28, 0xba, 0xa5, 0x70, 0x69, 0x50,
 0x90, 0x03, 0x20, 0x23, 0xbc, 0x4c, 0x00, 0xe0
};
