//This is the IPLROM for the SPC700 coprocessor.
//This array is *read-only*. The SPC700 does not
//allow writing to the IPLROM, all writes are
//instead mapped to the extended SPC700 RAM region,
//accessible when $f1 bit 7 is clear.

const uint8 SMP::iplrom[64] = {
/*ffc0*/ 0xcd, 0xef,       //mov   x,#$ef
/*ffc2*/ 0xbd,             //mov   sp,x
/*ffc3*/ 0xe8, 0x00,       //mov   a,#$00
/*ffc5*/ 0xc6,             //mov   (x),a
/*ffc6*/ 0x1d,             //dec   x
/*ffc7*/ 0xd0, 0xfc,       //bne   $ffc5
/*ffc9*/ 0x8f, 0xaa, 0xf4, //mov   $f4,#$aa
/*ffcc*/ 0x8f, 0xbb, 0xf5, //mov   $f5,#$bb
/*ffcf*/ 0x78, 0xcc, 0xf4, //cmp   $f4,#$cc
/*ffd2*/ 0xd0, 0xfb,       //bne   $ffcf
/*ffd4*/ 0x2f, 0x19,       //bra   $ffef
/*ffd6*/ 0xeb, 0xf4,       //mov   y,$f4
/*ffd8*/ 0xd0, 0xfc,       //bne   $ffd6
/*ffda*/ 0x7e, 0xf4,       //cmp   y,$f4
/*ffdc*/ 0xd0, 0x0b,       //bne   $ffe9
/*ffde*/ 0xe4, 0xf5,       //mov   a,$f5
/*ffe0*/ 0xcb, 0xf4,       //mov   $f4,y
/*ffe2*/ 0xd7, 0x00,       //mov   ($00)+y,a
/*ffe4*/ 0xfc,             //inc   y
/*ffe5*/ 0xd0, 0xf3,       //bne   $ffda
/*ffe7*/ 0xab, 0x01,       //inc   $01
/*ffe9*/ 0x10, 0xef,       //bpl   $ffda
/*ffeb*/ 0x7e, 0xf4,       //cmp   y,$f4
/*ffed*/ 0x10, 0xeb,       //bpl   $ffda
/*ffef*/ 0xba, 0xf6,       //movw  ya,$f6
/*fff1*/ 0xda, 0x00,       //movw  $00,ya
/*fff3*/ 0xba, 0xf4,       //movw  ya,$f4
/*fff5*/ 0xc4, 0xf4,       //mov   $f4,a
/*fff7*/ 0xdd,             //mov   a,y
/*fff8*/ 0x5d,             //mov   x,a
/*fff9*/ 0xd0, 0xdb,       //bne   $ffd6
/*fffb*/ 0x1f, 0x00, 0x00, //jmp   ($0000+x)
/*fffe*/ 0xc0, 0xff        //---reset vector location ($ffc0)
};
