	INCLUDE equates.h
	INCLUDE z80.h
	INCLUDE gfx.h

	EXPORT empty_IO_R
	EXPORT empty_R
	EXPORT empty_IO_W
	EXPORT empty_W
	EXPORT ram_W
	EXPORT sram_W
	EXPORT rom_W
	EXPORT bytecopy_
	EXPORT memset_
	EXPORT memorr_

;----------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
bytecopy_		;void bytecopy(u8 *dst,u8 *src,int count)
;----------------------------------------------------------------------------
	subs r2,r2,#1
	ldrplb r3,[r1,r2]
	strplb r3,[r0,r2]
	bhi bytecopy_
	bx lr

;----------------------------------------------------------------------------
empty_IO_R		;read bad IO address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xFF			;SMS2
;	ldrb r0,[z80_pc,#-1]	;SMS
	mov pc,lr
;----------------------------------------------------------------------------
empty_R			;read bad address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0
	mov pc,lr
;----------------------------------------------------------------------------
empty_IO_W		;write bad IO address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0x10
	mov pc,lr
;----------------------------------------------------------------------------
empty_W			;write bad address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xBA
	mov pc,lr
;----------------------------------------------------------------------------
rom_W			;write ROM address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xB0
	mov pc,lr
;----------------------------------------------------------------------------
	AREA wram_code2, CODE, READWRITE
;----------------------------------------------------------------------------
ram_W			;write ram ($8000-$FFFF)
;----------------------------------------------------------------------------
	ldr r1,=EMU_RAM
	strb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
sram_W			;write sram ($8000-$9FFF),($A000-$BFFF)
;----------------------------------------------------------------------------
;	bic r1,addy,#0xFE000
;	ldr r2,=EMU_SRAM
;	strb r0,[r2,r1]
	ldr r2,=EMU_SRAM-0x8000
	strb r0,[r2,addy]
	mov pc,lr
;----------------------------------------------------------------------------
;rom_R7			;read rom
;----------------------------------------------------------------------------
;	ldr r1,memmap_tbl+28
;	ldrb r0,[r1,addy]
;	mov pc,lr
;----------------------------------------------------------------------------
;rom_R			;read rom
;----------------------------------------------------------------------------
;	adr r2,memmap_tbl
;	ldr r1,[r2,r1,lsr#11]	;r1=addy & 0xe000
;	ldrb r0,[r1,addy]
;	mov pc,lr
;----------------------------------------------------------------------------
memset_ ;r0=dest r1=data r2=word count
;	exit with r0 & r1 unchanged, r2=0
;----------------------------------------------------------------------------
	subs r2,r2,#1
	strpl r1,[r0,r2,lsl#2]
	bhi memset_
	bx lr
;----------------------------------------------------------------------------
memorr_ ;r0=dest r1=data r2=word count
;	exit with r0 & r1 unchanged, r2=0, r3 trashed
;----------------------------------------------------------------------------
	subs r2,r2,#1
	ldrpl r3,[r0,r2,lsl#2]
	orrpl r3,r3,r1
	strpl r3,[r0,r2,lsl#2]
	bhi memorr_
	bx lr
;----------------------------------------------------------------------------
	END
