	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE ..\SN76496\sn76496.h
	INCLUDE ..\SN76496\sn76496_equ.h

	EXPORT Sound_init
	EXPORT Sound_reset
	EXPORT soundmode
	EXPORT Vbl_Sound_1
	EXPORT Vbl_Sound_2
	EXPORT SN_0_W
	EXPORT SoundVariables


;----------------------------------------------------------------------------

 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -

;----------------------------------------------------------------------------
Sound_init
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r5,lr}
	mov r5,#REG_BASE

;	ldrh r0,[r5,#REG_SGBIAS]
;	bic r0,r0,#0xc000				;just change bits we know about.
;	orr r0,r0,#0x8000				;PWM 7-bit 131.072kHz
;	strh r0,[r5,#REG_SGBIAS]

	ldr r2,soundmode				;if r2=0, no sound.
	cmp r2,#1

	movmi r0,#0
	ldreq r0,=0x0b040000			;stop all channels, output ratio=100% dsA.  use directsound A for L&R, timer 0
	str r0,[r5,#REG_SGCNT_L]

	moveq r0,#0x80
	strh r0,[r5,#REG_SGCNT_X]		;sound master enable

	mov r0,#0						;triangle reset
	str r0,[r5,#REG_SG3CNT_L]		;sound3 disable, mute, write bank 0

									;Mixer channels
	strh r5,[r5,#REG_DM1CNT_H]		;DMA1 stop, SN76496
	add r0,r5,#REG_FIFO_A_L			;DMA1 destination..
	str r0,[r5,#REG_DM1DAD]
	ldr r0,pcmptr0
	str r0,[r5,#REG_DM1SAD]			;DMA1 src=..


	adr r0,SN76496_0
	mov r1,#1
	bl SN76496_set_mixrate			;sound, 0=low, 1=high mixrate
	ldr r1,=3579545
	bl SN76496_set_frequency		;sound, chip frequency
	bl SN76496_init					;sound


	ldr r2,soundmode				;if r2=0, no sound.
	cmp r2,#1

	add r1,r5,#REG_TM0CNT_L			;timer 0 controls sample rate:
	mov r4,#0
	str r4,[r1]						;stop timer 0
	ldr r3,mixrate					; 924=Low, 532=High.
	mov r2,#0x10000					;frequency = 0
	subeq r4,r2,r3					;frequency = 0x1000000/r3 Hz
	orreq r4,r4,#0x800000			;timer 0 on
	str r4,[r1]

	ldmfd sp!,{r3-r5,lr}
	bx lr

;----------------------------------------------------------------------------
Sound_reset
;----------------------------------------------------------------------------
	stmfd sp!,{lr}
	adr r0,SN76496_0
	bl SN76496_reset				;sound
	ldmfd sp!,{lr}
	bx lr

;----------------------------------------------------------------------------
Vbl_Sound_1
;----------------------------------------------------------------------------
	ldr r0,soundmode				;if r0=0, no sound.
	cmp r0,#0
	bxeq lr


	mov r1,#REG_BASE
	strh r1,[r1,#REG_DM1CNT_H]		;DMA1 stop
	ldr r2,pcmptr0
	str r2,[r1,#REG_DM1SAD]			;DMA1 src=..
	ldr r0,=0xB640					;noIRQ fifo 32bit repeat incsrc fixeddst
	strh r0,[r1,#REG_DM1CNT_H]		;DMA1 go

	ldr r1,pcmptr1
	str r1,pcmptr0
	str r2,pcmptr1

	adr r0,SN76496_0
	str r1,pcmptr

	bx lr
;----------------------------------------------------------------------------
Vbl_Sound_2
;----------------------------------------------------------------------------
	;update DMA buffer for PCM
	ldr r0,soundmode				;if r0=0, no sound.
	cmp r0,#0
	bxeq lr

	stmfd sp!,{lr}
	adr r0,SN76496_0
	bl SN76496_mixer
	ldmfd sp!,{pc}

;----------------------------------------------------------------------------
SN_0_W
;----------------------------------------------------------------------------
	stmfd sp!,{r3,lr}
	mov r1,r0
	adr r0,SN76496_0
	bl SN76496_w
	ldmfd sp!,{r3,pc}

;----------------------------------------------------------------------------

soundmode	DCD 1		;soundmode (OFF/ON)

pcmptr0 DCD PCMWAV
pcmptr1 DCD PCMWAV+PCMWAVSIZE

SoundVariables
SN76496_0
		% 68
;----------------------------------------------------------------------------
	END

