	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE gfx.h
	INCLUDE cart.h
	INCLUDE z80mac.h
	INCLUDE z80.h
	INCLUDE sound.h

	EXPORT IO_init
	EXPORT IO_reset
	EXPORT Z80_IN
	EXPORT Z80_OUT
	EXPORT Z80_IN_C
	EXPORT Z80_OUT_C
	EXPORT joycfg
	EXPORT spriteinit
	EXPORT suspend
	EXPORT refreshEMUjoypads
	EXPORT serialinterrupt
	EXPORT resetSIO
	EXPORT thumbcall_r1
	EXPORT gettime
	EXPORT vbaprint
	EXPORT waitframe
	EXPORT UnCompVram
	EXPORT LZ77UnCompVram
	EXPORT HuffUnComp
	EXPORT RLEUnCompVram
	EXPORT CheckGBAVersion
	EXPORT NoCashBreak
	EXPORT reBankSwitch0_W
	EXPORT reBankSwitch1_W
	EXPORT reBankSwitch2_W
	EXPORT reBankSwitch3_W
	EXPORT g_keymap_L
	EXPORT g_keymap_R
	EXPORT g_keymap_Start
	EXPORT g_keymap_Select
	EXPORT g_CfgKey
	EXPORT Keyboard_Control

	IMPORT AGBinput
;----------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -
;----------------------------------------------------------------------------

UnCompVram
	ldrb r2,[r0]
	mov r2,r2,lsr#4
	cmp r2,#1
	beq LZ77UnCompVram
	cmp r2,#2
	beq HuffUnComp
	cmp r2,#3
	beq RLEUnCompVram
	bx lr

LZ77UnCompVram
	swi 0x120000
	bx lr

HuffUnComp
	swi 0x130000
	bx lr

RLEUnCompVram
	swi 0x150000
	bx lr


vbaprint
	swi 0xFF0000		;!!!!!!! Doesn't work on hardware !!!!!!!
	bx lr
NoCashBreak
	mov r11,r11
	bx lr
waitframe
VblWait
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until VBLIRQ if not too late allready.
	bx lr
CheckGBAVersion
	ldr r0,=0x5AB07A6E		;Fool proofing
	mov r12,#0
	swi 0x0D0000			;GetBIOSChecksum
	ldr r1,=0xABBE687E		;Proto GBA
	cmp r0,r1
	moveq r12,#1
	ldr r1,=0xBAAE187F		;Normal GBA
	cmp r0,r1
	moveq r12,#2
	ldr r1,=0xBAAE1880		;Nintendo DS
	cmp r0,r1
	moveq r12,#4
	mov r0,r12
	bx lr

;----------------------------------------------------------------------------
IO_init
;----------------------------------------------------------------------------
	mov r1,#REG_BASE
	mov r0,#0x0008
	strh r0,[r1,#REG_DISPSTAT]	;vblank en

	add r2,r1,#REG_IE
	mov r0,#-1
	strh r0,[r2,#2]		;stop pending interrupts
	ldr r0,=irqhandler
	str r0,[r1,#-4]		;=AGB_IRQVECT
	ldr r0,=0x1081
	strh r0,[r2]		;key,serial,timer2,vblank. (serial interrupt=0x80)
	mov r0,#1
	strh r0,[r2,#8]		;master irq enable

	ldr r0,=0x00C1EB84		;5244, pre *64. for 50Hz timing
	str r0,[r1,#REG_TM2CNT_L]

	bx lr
;----------------------------------------------------------------------------

scaleparms;
	DCD 0x0000,0x0100,0x0120,0x0080,0x0099,OAM_BUFFER1+6
;----------------------------------------------------------------------------
IO_reset
;----------------------------------------------------------------------------
	adr r5,scaleparms		;set sprite scaling params
	ldmia r5,{r0-r5}

	mov r6,#2
scaleloop
	strh r1,[r5],#8				;buffer1, buffer2. scaled normal sprites
	strh r0,[r5],#8
	strh r0,[r5],#8
	strh r2,[r5],#8
		strh r3,[r5],#8			;unscaled double sprites
		strh r0,[r5],#8
		strh r0,[r5],#8
		strh r3,[r5],#40
			strh r3,[r5],#8		;scaled double sprites
			strh r0,[r5],#8
			strh r0,[r5],#8
			strh r4,[r5],#136
		add r5,r5,#0x300
	subs r6,r6,#1
	bne scaleloop


	str r0,joy0state			;r0=0
	ldrb r0,emuflags+1
	;..to spriteinit
;----------------------------------------------------------------------------
spriteinit	;build yscale_lookup tbl (called by ui.c) r0=scaletype
;called by ui.c:  void spriteinit(char scaletype) (pass scaletype in r0 because globals ptr isn't set up to read it)
;----------------------------------------------------------------------------
	ldr r3,=YSCALE_LOOKUP-16
	cmp r0,#SCALED
	bpl si1

;------------------ unscaled
si5
	sub r2,r3,#192-160
	mov r0,#164
si2	strb r0,[r2],#1
	cmp r2,r3
	bne si2

	add r2,r3,#256+16
	mov r0,#-31
si3	strb r0,[r3],#1
	add r0,r0,#1
	cmp r0,#164
	movpl r0,#164
	cmp r2,r3
	bne si3
	bx lr

;------------------ scaled
si1
	ldr r0,=0x00D55555		;5/6
	ldr r1,=0xe6000000		;-(16+16)*0.75
si4	mov r2,r1,lsr#24
	strb r2,[r3],#1
	add r1,r1,r0
	cmp r2,#0xe0
	bne si4
	bx lr
;----------------------------------------------------------------------------
suspend	;called from ui.c and z80.s
;----------------------------------------------------------------------------
	mov r3,#REG_BASE

	ldr r1,=REG_P1CNT
	ldr r0,=0xc00c			;interrupt on start+sel
	strh r0,[r3,r1]

	ldrh r1,[r3,#REG_SGCNT_L]
	strh r3,[r3,#REG_SGCNT_L]	;sound off

	ldrh r0,[r3,#REG_DISPCNT]
	orr r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD off

	swi 0x030000

	ldrh r0,[r3,#REG_DISPCNT]
	bic r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD on

	strh r1,[r3,#REG_SGCNT_L]	;sound on

	ldr r1,=REG_P1
susloop
	ldrh r0,[r1]
	and r0,r0,#0xc
	eors r0,r0,#0xc
	bne susloop

	bx lr
;----------------------------------------------------------------------------
gettime	;called from ui.c
;----------------------------------------------------------------------------
	ldr r3,=0x080000c4		;base address for RTC
	mov r1,#1
	strh r1,[r3,#4]			;enable RTC
	mov r1,#7
	strh r1,[r3,#2]			;enable write

	mov r1,#1
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]			;State=Command

	mov r2,#0x65			;r2=Command, YY:MM:DD 00 hh:mm:ss
	mov addy,#8
RTCLoop1
	mov r1,#2
	and r1,r1,r2,lsr#6
	orr r1,r1,#4
	strh r1,[r3]
	mov r1,r2,lsr#6
	orr r1,r1,#5
	strh r1,[r3]
	mov r2,r2,lsl#1
	subs addy,addy,#1
	bne RTCLoop1

	mov r1,#5
	strh r1,[r3,#2]			;enable read
	mov r2,#0
	mov addy,#32
RTCLoop2
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r2,r2,lsr#1
	orr r2,r2,r1,lsl#30
	subs addy,addy,#1
	bne RTCLoop2

	mov r0,#0
	mov addy,#24
RTCLoop3
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r0,r0,lsr#1
	orr r0,r0,r1,lsl#22
	subs addy,addy,#1
	bne RTCLoop3

	bx lr
;----------------------------------------------------------------------------
resetSIO	;r0=joycfg
;----------------------------------------------------------------------------
	bic r0,r0,#0x0f000000
	str r0,joycfg

	mov r2,#REG_BASE
	add r2,r2,#0x100

	mov r1,#0
	strh r1,[r2,#REG_RCNT]
	strb r1,joy0state
	strb r1,joy1state
	strb r1,joy0extra
	strb r1,joy1extra

	tst r0,#0x80000000
	moveq r1,#0x2000
	movne r1,   #0x6000
	addne r1,r1,#0x0002	;16bit multiplayer, 57600bps
	strh r1,[r2,#REG_SIOCNT]

	bx lr
;----------------------------------------------------------------------------
serialinterrupt
;----------------------------------------------------------------------------
	mov r3,#REG_BASE
	add r3,r3,#0x100

	mov r0,#0x1
serWait	subs r0,r0,#1
	bne serWait
	mov r0,#0x100			;time to wait.
	ldrh r1,[r3,#REG_SIOCNT]
	tst r1,#0x80			;Still transfering?
	bne serWait

	tst r1,#0x40			;communication error? resend?
	bne sio_err

	ldr r0,[r3,#REG_SIOMULTI0]	;Both SIOMULTI0&1

	and r2,r0,#0xff00		;From Master
	cmp r2,#0xaa00
	beq resetrequest		;$AAxx means Master GBA wants to restart

	ldr r2,sending
	tst r2,#0x10000
	beq sio_err
	strne r0,received0		;store only if we were expecting something
sio_err
	strb r3,sending+2		;send completed, r3b=0
	bx lr

resetrequest
	ldr r2,joycfg
	strh r0,received0
	orr r2,r2,#0x01000000
	bic r2,r2,#0x08000000
	str r2,joycfg
	bx lr

sending DCD 0
lastsent DCD 0
received0 DCD 0
;---------------------------------------------
xmit	;send byte in r0
;returns REG_SIOCNT in r1, received byte in r2, lastsent in r3, Z set if successful, r4-r5 destroyed
;---------------------------------------------
	ldr r3,sending
	tst r3,#0x10000		;last send completed?
	movne pc,lr

	mov r5,#REG_BASE
	add r5,r5,#0x100
	ldrh r1,[r5,#REG_SIOCNT]
	tst r1,#0x80		;clear to send?
	movne pc,lr

	ldrb r4,frame
	eor r4,r4,#0x55
	bic r4,r4,#0x80
	orr r0,r0,r4,lsl#8	;r0=new data to send

	ldr r2,received0
	cmp r2,#-1			;Check for uninitialized
	eoreq r2,r2,#0xf00

	eor r4,r2,r2,lsr#16	;P1 & P2
	tst r4,#0xff00		;in sync yet?
	beq checkold
	ldr r1,lastsent
	eor r4,r1,r2,lsr#16	;Has P2 missed an interrupt?
	tst r4,#0xff00
	streq r1,sending	;Send the value before this.
	b iofail
checkold
	ldr r4,sending
	ldr r1,lastsent
	eor r4,r4,r1		;Did we send an old value last time?
	tst r4,#0xff00
	bne iogood		;bne
	ldr r1,sending
	str r0,sending
	str r1,lastsent
iofail
	orrs r4,r4,#1		;Z=0 fail
	b notyet
iogood
	ands r4,r4,#0		;Z=1 ok
notyet
	ldr r1,sending
	streq r1,lastsent
	movne r0,r1		;resend last.

	orr r0,r0,#0x10000
	str r0,sending
	strh r0,[r5,#REG_SIOMLT_SEND]	;put data in buffer
	ldrh r1,[r5,#REG_SIOCNT]
	tst r1,#0x4			;Check if we're Master.
	bne endSIO

multip
	ldrh r1,[r5,#REG_SIOCNT]
	tst r1,#0x8			;Check if all machines are in multi mode.
	beq multip

	orr r1,r1,#0x80			;Set send bit
	strh r1,[r5,#REG_SIOCNT]	;start send

endSIO
	teq r4,#0
	mov pc,lr
	LTORG
;----------------------------------------------------------------------------
VKB_Array
	DCW 32*10+2	;Pos
	DCB 0x02	;Key, 1
	DCB 0		;Dummy
	DCB 1		;Go right from this key
	DCB 2		;Go left from this key
	DCB 9		;Go up from this key
	DCB 3		;Go down from this key

	DCW 32*10+4
	DCB 0x08,0	;2
	DCB 2,0,10,4

	DCW 32*10+6
	DCB 0x03,0	;3
	DCB 0,1,11,5

	DCW 32*13+2
	DCB 0x0D,0	;4
	DCB 4,5,0,6

	DCW 32*13+4
	DCB 0x0C,0	;5
	DCB 5,3,1,7

	DCW 32*13+6
	DCB 0x01,0	;6
	DCB 3,4,2,8

	DCW 32*16+2
	DCB 0x0A,0	;7
	DCB 7,8,3,9

	DCW 32*16+4
	DCB 0x0E,0	;8
	DCB 8,6,4,10

	DCW 32*16+6
	DCB 0x04,0	;9
	DCB 6,7,5,11

	DCW 32*18+2
	DCB 0x06,0	;*
	DCB 10,11,6,0

	DCW 32*18+4
	DCB 0x05,0	;0
	DCB 11,9,7,1

	DCW 32*18+6
	DCB 0x09,0	;#
	DCB 9,10,8,2

;----------------------------------------------------------------------------
Keyboard_Control				;Virtual keyboard
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r7,lr}

	mov r0,#0					;clear previous joykeys.
	strb r0,joy0extra

;	ldr r0,AGBjoypad
	ldr r0,=AGBinput
	ldr r0,[r0]
	ldr r1,VKB_OldKeys
	eor r1,r1,r0
	and r1,r1,r0
	str r0,VKB_OldKeys

	ldr r7,=0x6006800			;keyboard tilemap
	ldr r2,VKB_Pos
	adr r5,VKB_Array
	add r3,r5,r2,lsl#3
	ldrh r4,[r3],#4
	mov r4,r4,lsl#1
	ldrb r6,[r7,r4]				;clear old keytile.
	strh r6,[r7,r4]


	tst r1,#0x10
	ldrneb r2,[r3]
	tst r1,#0x20
	ldrneb r2,[r3,#1]
	tst r1,#0x40
	ldrneb r2,[r3,#2]
	tst r1,#0x80
	ldrneb r2,[r3,#3]
	str r2,VKB_Pos

	add r3,r5,r2,lsl#3
	ldrh r4,[r3]
	mov r4,r4,lsl#1
	ldrh r6,[r7,r4]
	orr r6,r6,#0x4000
	strh r6,[r7,r4]
	
	mov r2,#-1
	str r2,g_CfgKey
	tst r0,#0x01				;A button
	beq nokeypress
	ldrb r4,[r3,#2]
	str r4,g_CfgKey
	strb r4,joy0extra

;	adr r2,Keyb_trans
;	mov r4,r4,lsl#1
;	ldrh r4,[r2,r4]
;	adr r2,Keyboard_M
;	ldrb r1,[r2,r4,lsr#8]
;	bic r1,r1,r4
;	strb r1,[r2,r4,lsr#8]
nokeypress


	ands r0,r0,#0				;Z=1
	ldmfd sp!,{r4-r7,lr}
	bx lr

VKB_OldKeys	DCD 0
VKB_Pos		DCD 0
g_CfgKey	DCD 0
;----------------------------------------------------------------------------
refreshEMUjoypads	;call every frame
;exits with Z flag clear if update incomplete (waiting for other player)
;is my multiplayer code butt-ugly?  yes, I thought so.
;i'm not trying to win any contests here.
;----------------------------------------------------------------------------
	ldrb r0,keyb_scroll
	cmp r0,#88
	beq Keyboard_Control

	mov r6,lr					;return with this..

		ldr r4,frame
		movs r0,r4,lsr#2		;C=frame&2 (autofire alternates every other frame)
	ldr r1,EMUjoypad
	mov r4,r1
	and r0,r1,#0xf0
		ldr r2,joycfg
		andcs r1,r1,r2
		movcss addy,r1,lsr#9	;R?
		andcs r1,r1,r2,lsr#16
	adr addy,dulr2lrud
	ldrb r0,[addy,r0,lsr#4]		;downupleftright

	ands r3,r1,#3
	cmpne r3,#3
	eorne r3,r3,#3

	tst r2,#0x400				;Swap A/B?
	andne r3,r1,#3
	orr r0,r0,r3,lsl#5			;Button 1

	and r5,r1,#0xC
	mov r1,r3,lsl#6				;Button 2
	tst r5,#0x4					;Select
	ldrb r3,g_keymap_Select
	orrne r1,r1,r3				;(3)
	tst r5,#0x8					;Start
	ldrb r3,g_keymap_Start
	orrne r1,r1,r3				;(1)

	tst r4,#0x200				;L
	ldrb r3,g_keymap_L
	orrne r1,r1,r3				;(#)
	tst r4,#0x100				;R
	ldrb r3,g_keymap_R
	orrne r1,r1,r3				;(*)


	tst r2,#0x80000000
	bne multi

	tst r2,#0x40000000			;Player2?
	streqb r0,joy0state
	strneb r0,joy1state
	streqb r1,joy0extra
	strneb r1,joy1extra
fin	ands r0,r0,#0				;Z=1
	mov pc,r6
multi							;r2=joycfg
	tst r2,#0x08000000			;link active?
	beq link_sync

	bl xmit						;send joypad data for NEXT frame
	movne pc,r6					;send was incomplete!

	strb r2,joy0state			;master is player 1
	mov r2,r2,lsr#16
	strb r2,joy1state			;slave1 is player 2
	b fin

link_sync
	mov r1,#0x8000
	str r1,lastsent
	tst r2,#0x03000000
	beq stage0
	tst r2,#0x02000000
	beq stage1
stage2
	mov r0,#0x2200
	bl xmit						;wait til other side is ready to go

	moveq r1,#0x8000
	streq r1,lastsent
	ldr r2,joycfg
	biceq r2,r2,#0x03000000
	orreq r2,r2,#0x08000000
	str r2,joycfg

	b badmonkey
stage1							;other GBA wants to reset
	bl sendreset				;one last time..
	bne badmonkey

	orr r2,r2,#0x02000000		;on to stage 2..
	str r2,joycfg

	ldr r0,romnumber
	tst r4,#0x4					;who are we?
	beq sg1
	ldrb r3,received0			;slaves uses master's timing flags
	bic r1,r1,#COUNTRY+PALTIMING
	orr r1,r1,r3
sg1	bl loadcart		;game reset

	mov r1,#0
	str r1,sending		;reset sequence numbers
	str r1,received0
badmonkey
	orrs r0,r0,#1		;Z=0 (incomplete xfer)
	mov pc,r6
stage0	;self-initiated link reset
	bl sendreset		;keep sending til we get a reply
	b badmonkey
sendreset       ;exits with r1=emuflags, r4=REG_SIOCNT, Z=1 if send was OK
	mov r5,#REG_BASE
	add r5,r5,#0x100

	ldr r1,emuflags
	and r0,r1,#COUNTRY+PALTIMING
	orr r0,r0,#0xaa00		;$AAxx, xx=timing flags

	ldrh r4,[r5,#REG_SIOCNT]
	tst r4,#0x80			;ok to send?
	movne pc,lr

	strh r0,[r5,#REG_SIOMLT_SEND]
	orr r4,r4,#0x80
	strh r4,[r5,#REG_SIOCNT]	;send!
	mov pc,lr

joycfg DCD 0x00ff01ff ;byte0=auto mask, byte1=(saves R), byte2=R auto mask
;bit 31=single/multi, 30=1P/2P, 27=(multi) link active, 24=reset signal received
joy0state DCB 0
joy1state DCB 0
joy0extra DCB 0
joy1extra DCB 0
dulr2lrud	DCB 0x00,0x02,0x08,0x0A, 0x01,0x03,0x09,0x0B
			DCB 0x04,0x06,0x0C,0x0E, 0x05,0x07,0x0D,0x0F
joymode		DCB 0
			DCB 0,0,0
g_keymap_L		DCB 0
g_keymap_R		DCB 0
g_keymap_Start	DCB 0
g_keymap_Select	DCB 0

;----------------------------------------------------------------------------
IOPortA_R		;Player1...
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joymode
	cmp r0,#0
	ldreqb r0,joy0state
	ldrneb r0,joy0extra
	and r0,r0,#0x4F				;bit 4 & 5 for extra controller?
	eor r0,r0,#0x7F
	mov pc,lr
;----------------------------------------------------------------------------
IOPortB_R		;Player2...
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joymode
	cmp r0,#0
	ldreqb r0,joy1state
	ldrneb r0,joy1extra
	and r0,r0,#0x4F
	eor r0,r0,#0x7F
	mov pc,lr
;----------------------------------------------------------------------------
SetKeypad_W						;0x80 written?
;----------------------------------------------------------------------------
	mov r0,#1
	strb r0,joymode
	mov pc,lr
;----------------------------------------------------------------------------
SetJoystick_W					;0x80 written?
;----------------------------------------------------------------------------
	mov r0,#0
	strb r0,joymode
	mov pc,lr


;----------------------------------------------------------------------------
	INCLUDE visoly.s
 AREA wram_code1, CODE, READWRITE
;-- - - - - - - - - - - - - - - - - - - - - -

thumbcall_r1 bx r1


;----------------------------------------------------------------------------
Z80_IN_C
;----------------------------------------------------------------------------
	mov addy,z80bc,lsr#16
	and addy,addy,#0xE1
;----------------------------------------------------------------------------
Z80_IN
;----------------------------------------------------------------------------
	mov r1,addy,lsl#31
	orr r1,r1,addy,lsr#5
	ldr pc,[pc,r1,ror#29]
	DCD 0
IN_Table
	DCD empty_IO_R
	DCD empty_IO_R
	DCD empty_IO_R
	DCD empty_IO_R
	DCD empty_IO_R
	DCD empty_IO_R
	DCD empty_IO_R
	DCD empty_IO_R

	DCD empty_IO_R
	DCD empty_IO_R
	DCD VDPdata_R
	DCD VDPstat_R
	DCD empty_IO_R
	DCD empty_IO_R
	DCD IOPortA_R
	DCD IOPortB_R
;----------------------------------------------------------------------------
Z80_OUT_C
;----------------------------------------------------------------------------
	mov addy,z80bc,lsr#16
	and addy,addy,#0xE1
;----------------------------------------------------------------------------
Z80_OUT
;----------------------------------------------------------------------------
	mov r1,addy,lsl#31
	orr r1,r1,addy,lsr#5
	ldr pc,[pc,r1,ror#29]
	DCD 0
OUT_Table
	DCD empty_IO_W
	DCD empty_IO_W
	DCD empty_IO_W
	DCD empty_IO_W
	DCD empty_IO_W
	DCD empty_IO_W
	DCD empty_IO_W
	DCD empty_IO_W

	DCD SetKeypad_W
	DCD SetKeypad_W
	DCD VDPdata_W
	DCD VDPctrl_W
	DCD SetJoystick_W
	DCD SetJoystick_W
	DCD SN_0_W
	DCD SN_0_W

;------------------------------------------------------------------------------
reBankSwitch0_W					;0x0000-0x3FFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap0
;------------------------------------------------------------------------------
BankSwitch0_W					;0x0000-0x3FFF
;------------------------------------------------------------------------------
	strb r0,BankMap0
	ldr r0,biosbase
	adr r2,memmap_tbl
	b Map16k

;------------------------------------------------------------------------------
reBankSwitch1_W					;0x4000-0x5FFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap1
;------------------------------------------------------------------------------
BankSwitch1_W					;0x4000-0x5FFF
;------------------------------------------------------------------------------
	strb r0,BankMap1
	ldr r0,biosbase
	mov r1,r0
	adr r2,memmap_tbl+16*4
	b Map8k

;------------------------------------------------------------------------------
reBankSwitch2_W					;0x8000-0xBFFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap2
;------------------------------------------------------------------------------
BankSwitch2_W					;0x8000-0xBFFF
;------------------------------------------------------------------------------
	strb r0,BankMap2
	ldr r1,rombase
	sub r1,r1,#0x8000
	add r0,r1,r0,lsl#14
	adr r2,memmap_tbl+32*4
	b Map16k

;------------------------------------------------------------------------------
reBankSwitch3_W					;0xC000-0xBFFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap3
;------------------------------------------------------------------------------
BankSwitch3_W					;0xC000-0xFFFF
;------------------------------------------------------------------------------
	strb r0,BankMap3

	ldr r1,rombase
	sub r1,r1,#0xC000
	add r0,r1,r0,lsl#14
	adr r2,memmap_tbl+48*4
Map16k
	mov r1,r0
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
Map8k
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl

;------------------------------------------
flush		;update cpu_pc & lastbank
;------------------------------------------
	ldr r1,lastbank
	sub z80pc,z80pc,r1
	encodePC
	mov pc,lr
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
	END
