	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE z80mac.h
	INCLUDE z80.h
	INCLUDE io.h
	INCLUDE gfx.h
	INCLUDE sound.h

	IMPORT findrom		;from main.c
	IMPORT pogoshell	;from main.c
	IMPORT pogosize		;from main.c

	EXPORT loadcart
	EXPORT bg_finish
	EXPORT savestate
	EXPORT loadstate
	EXPORT g_emuflags
	EXPORT romstart
	EXPORT romnum
	EXPORT g_BIOSBASE
	EXPORT g_scaling
	EXPORT g_cartflags
	EXPORT g_config
;-------------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
loadcart ;called from C:  r0=rom number, r1=emuflags
;-------------------------------------------------------------------------------
	mov r2,#0
;-------------------------------------------------------------------------------
loadcartnew ;called from C:  r0=rom number, r1=emuflags, r2=clearmem?
;-------------------------------------------------------------------------------
	stmfd sp!,{r0-r2,r4-r11,lr}

	ldr r1,=findrom
	bl thumbcall_r1
	add r3,r0,#64		;r0 now points to rom image (including header)

	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd

	ldmfd sp!,{r0-r1}
	str r0,romnumber
	str r1,emuflags

	ldr r1,=pogoshell
	ldrb r1,[r1]
	cmp r1,#0
						;r3=rombase til end of loadcart so DON'T FUCK IT UP
	ldrne r1,=pogosize
	ldrne r1,[r1]		;Size from Pogoshell
	ldreq r1,[r3,#-60]	;size of rom in bytes (from rombuilder).
	str r3,rombase		;set rom base

	mov r1,#0x010000	;
	movs r2,r1,lsr#14
	subne r2,r2,#1		;rommask=romsize-1

	ldr r4,=MEMMAPTBL_
	ldr r6,=WRMEMTBL_
	ldr r8,=rom_W
	mov r0,#0

tbloop1
	and r1,r0,r2
	add r1,r3,r1,lsl#14
	str r1,[r4,r0,lsl#2]
	str r8,[r6,r0,lsl#2]
	add r0,r0,#1
	cmp r0,#3
	bne tbloop1

	ldr r1,biosbase
	cmp r1,#0
	moveq r1,r3
	str r1,biosbase
	mov r0,#7				;7 BIOS
	str r1,[r4,r0,lsl#2]	;MemMap
	str r8,[r6,r0,lsl#2]	;WrMem

	ldr r1,=EMU_RAM
	ldr r8,=ram_W
	mov r0,#3				;3 RAM
	str r1,[r4,r0,lsl#2]	;MemMap
	str r8,[r6,r0,lsl#2]	;WrMem
	add r0,r0,#1

;	ldr r8,=ram0_W			;4 RAM
;	str r1,[r4,r0,lsl#2]	;MemMap
;	str r8,[r6,r0,lsl#2]	;WrMem
;	add r0,r0,#1

;	ldr r1,=EMU_SRAM-0x8000
;	ldr r8,=sram0_W			;5 SRAM
;	str r1,[r4,r0,lsl#2]	;MemMap
;	str r8,[r6,r0,lsl#2]	;WrMem
;	add r0,r0,#1

;	ldr r1,=EMU_SRAM-0x4000
;	ldr r8,=sram1_W			;6 SRAM
;	str r1,[r4,r0,lsl#2]	;MemMap
;	str r8,[r6,r0,lsl#2]	;WrMem


	ldr r0,=default_scanlinehook
	str r0,scanlinehook

	mov z80pc,#0			;(eliminates any encodePC errors during mapper*init)
	str z80pc,lastbank


;	ldrb r1,config
;	tst r1,#0x80		;BIOS on/off
;	moveq r4,#0x08
;	movne r4,#0x40

	bl InitMapper_
	ldr r0,=0x01000000
	str r0,BankMap0
;	strb r4,BankMap4		;BIOS disable
	bl reBankSwitch0_W
	bl reBankSwitch1_W
	bl reBankSwitch2_W
	bl reBankSwitch3_W

	ldmfd sp!,{r2}
	cmp r2,#0
	bne NoMemClear

	ldr r0,=EMU_RAM			;clear RAM
	mov r1,#0		
	mov r2,#0x4400/4
	bl memset_
NoMemClear

	bl GFX_reset
	bl IO_reset
	bl Sound_reset
	bl CPU_reset
	ldmfd sp!,{r4-r11,lr}
	bx lr

;----------------------------------------------------------------------------
InitMapper_	;rom paging..
;----------------------------------------------------------------------------

	ldr r2,=WRMEMTBL_
	adr r1,writemem_tbl

	ldr r0,[r2]				;ROM
	ldr r3,[r2,#3*4]		;RAM
	str r0,[r1],#4			;writemem_tbl, WRITE_ROM
	str r0,[r1],#4			;writemem_tbl
	str r0,[r1],#4			;writemem_tbl
	str r3,[r1],#4			;writemem_tbl, RAM
	str r0,[r1],#4			;writemem_tbl
	str r0,[r1],#4			;writemem_tbl
	str r0,[r1],#4			;writemem_tbl
	str r0,[r1],#4+32*3		;writemem_tbl

	ldr r0,[r2,#32+3*4]			;MEMMAPTBL_
	sub r0,r0,#0x6000
	str r0,[r1],#4				;memmap_tbl
	sub r0,r0,#0x400
	str r0,[r1],#4				;memmap_tbl
	sub r0,r0,#0x400
	str r0,[r1],#4				;memmap_tbl
	sub r0,r0,#0x400
	str r0,[r1],#4				;memmap_tbl
	sub r0,r0,#0x400
	str r0,[r1],#4				;memmap_tbl
	sub r0,r0,#0x400
	str r0,[r1],#4				;memmap_tbl
	sub r0,r0,#0x400
	str r0,[r1],#4				;memmap_tbl
	sub r0,r0,#0x400
	str r0,[r1],#4				;memmap_tbl

	bx lr

;-------------------------------------------------------------------------------
savestate	;called from ui.c.
;int savestate(void *here): copy state to <here>, return size
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r6,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

	bl fixCpuPC_save			;adjust cpu pc (so savestates are valid after moving roms around)

;	mov r6,r0					;r6=where to copy state
	ldr r6,=STATEPTR			;r6=where state is at
	mov r0,#0					;r0 holds total size (return value)

	adr r4,savelst				;r4=list of stuff to copy
	mov r3,#(lstend-savelst)/8	;r3=items in list
ss1	ldmia r4!,{r1,r2}			;r1=what to copy, r2=how much to copy
	add r0,r0,r2
ss0	ldr r5,[r1],#4
	str r5,[r6],#4
	subs r2,r2,#4
	bne ss0
	subs r3,r3,#1
	bne ss1

	mov r4,r0					;save r0.
	bl fixCpuPC_load
	ldr r1,=0x4400				;Size of all RAM.
	add r0,r1,r4

	ldmfd sp!,{r4-r6,globalptr,lr}
	bx lr

;savelst	DCD rominfo,8,EMU_RAM,0x6000,cpustate,104,gfxstate,40
savelst	DCD rominfo,8,cpustate,104,gfxstate-16,40,SoundVariables,68,BankState,16
lstend

fixCpuPC_save
	ldr r2,lastbank
	ldr r3,cpuregs+6*4	;Z80 PC
	sub r3,r3,r2
	str r3,cpuregs+6*4

	mov pc,lr

fixCpuPC_load
	ldr z80pc,cpuregs+6*4	;Z80 PC
	encodePC
	str z80pc,cpuregs+6*4

	mov pc,lr
;-------------------------------------------------------------------------------
loadstate	;called from ui.c
;void loadstate(int rom#,u32 *stateptr)	 (stateptr must be word aligned)
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r7,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

;	ldr r0,romnumber
;	mov r6,r1					;r6=where state is at
	ldr r6,=STATEPTR			;r6=where state is at
;	ldrb r4,scalemode			;preserve scalmode config

	ldr r1,[r6]					;emuflags
;	ldrb r2,[r6,#1]				;emuflags
;	strb r2,scalemode			;change scalemode before loadcart

	mov r2,#1
	bl loadcartnew				;cart init, without memclear.
;	strb r4,scalemode			;restore scalemode config

	mov r0,#(lstend-savelst)/8	;read entire state
	adr r4,savelst
ls1	ldmia r4!,{r1,r2}
ls0	ldr r5,[r6],#4
	str r5,[r1],#4
	subs r2,r2,#4
	bne ls0
	subs r0,r0,#1
	bne ls1

	bl reBankSwitch0_W
	bl reBankSwitch1_W
	bl reBankSwitch2_W

	bl fixCpuPC_load

	ldr r0,=DIRTYTILES
	mov r1,#0
	mov r2,#128
	bl memset_

	ldmfd sp!,{r4-r7,globalptr,lr}
	bx lr



;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
bg_finish	;end of frame...
;-------------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,lr}

	mov r3,#AGB_VRAM
	ldr r0,BGoffset2
	add r3,r3,r0,lsl#3
	ldr r6,=0x80008000
	mov r7,r6,lsr#15	;ldr r7,=0x00010001
	ldr r8,=TMAPBUFF
	ldrb r1,[r8,#4]
	ldr r2,=VDP_RAM
	and r1,r1,#0xF
	add r2,r2,r1,lsl#10

	ldrb r0,vdpmode1
	ands r8,r0,#2		;mode2 or 0?
	ldrne r8,=0x01000100
	ldrb r9,pgoffset
	and r9,r9,#3
	eorne r9,r9,#3
	orr r9,r9,r9,lsl#16
	mov r9,r9,lsl#8
	orreq r6,r6,r9
	moveq r9,#0
	mov r11,r6
	

	mov r1,#0
	mov r5,#3
	ldrb r0,vdpmode2
	tst r0,#0x10				;mode1?
	beq bgmode02
;-------------------------------------------------------------------------------
bgmode1
	mov r5,#24
bgm1loop2
	mov r4,#16
bgm1loop
	ldrh r0,[r2],#2				;Read from Coleco Tilemap RAM
	orr r0,r0,r0,lsl#8
	bic r0,r0,#0xFF00
	orr r0,r0,r11

	str r0,[r3],#4				;Write to GBA Tilemap RAM, behind sprites
	subs r4,r4,#1
	bne bgm1loop
	add r2,r2,#8
	subs r5,r5,#1
	bne bgm1loop2

	ldmfd sp!,{r3-r9,r11,pc}

;-------------------------------------------------------------------------------
 AREA wram_code4, CODE, READWRITE
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;bgchrfinish	;end of frame...
;-------------------------------------------------------------------------------
bgmode02			;fake

bgm2loop2
	mov r4,#16*8
bgm2loop
	ldrh r0,[r2],#2				;Read from Coleco Tilemap RAM
	orr r0,r0,r0,lsl#8
	bic r0,r0,#0xFF00
	orr r0,r0,r11

;	str r1,[r3,#0x800]			;Write to GBA Tilemap RAM, BGR color
	str r0,[r3],#4				;Write to GBA Tilemap RAM, behind sprites
	subs r4,r4,#1
	bne bgm2loop
	add r6,r6,r8
	bic r11,r6,r9
	subs r5,r5,#1
	bne bgm2loop2

	ldmfd sp!,{r3-r9,r11,pc}


;----------------------------------------------------------------------------
 AREA wram_globals2, CODE, READWRITE

romstart
	DCD 0 ;rombase
romnum
	DCD 0 ;romnumber
rominfo                 ;keep emuflags/BGmirror together for savestate/loadstate
g_emuflags	DCB 0 ;emuflags        (label this so UI.C can take a peek) see equates.h for bitfields
g_scaling	DCB SCALED_SPRITES ;(display type)
	% 2   ;(sprite follow val)

	DCD 0 ;BGoffset1
	DCD 0 ;BGoffset2
	DCD 0 ;BGoffset3
g_BIOSBASE
	DCD 0 ;biosbase
BankState
	DCB 0,0,0,0	;BankMap0,1,2,3
	DCB 0,0,0,0	;BankMap4, IO control (BIOS select), + alignment.
g_cartflags
	DCB 0 ;cartflags
g_config
	DCB 0		;config, bit 7=BIOS on/off, bit 6=R as Start,
;----------------------------------------------------------------------------
	END

