#pragma once

#include "system/types.h"


#define USE_VERTEX_PTR		1

typedef union
{
	uint32	i;
	struct
	{
		sint16	ss;
		sint16	ignore1;
	};
	struct
	{
		uint16	us;
		uint16	ignore2;
	};
	struct
	{
		uint8	ub;
		uint8	ub_ignore1;
		uint8	ub_ignore2;
		uint8	ub_ignore3;
	};
	struct
	{
		sint8	sb;
		sint8	sb_ignore1;
		sint8	sb_ignore2;
		sint8	sb_ignore3;
	};
	float	f;
} vx_vertex_t;

#if USE_VERTEX_PTR
typedef union
{
	sint8	*sbp;
	uint8	*ubp;
	sint16	*ssp;
	uint16	*usp;
	sint32	*slp;
	uint32	*ulp;
	float	*fp;
} vx_vertex_ptr_t;
#endif

#define	VX_MAX_CMDS	256

#if USE_VERTEX_PTR
extern	vx_vertex_ptr_t	vx_vertex_ptr;
extern uint8			vx_vertex_data_ub[VX_MAX_CMDS * 4 * 4];

#else
extern	vx_vertex_t	*vx_vertex_data;
extern	vx_vertex_t vx_vertex_data_static[VX_MAX_CMDS];
#endif

extern	uint8		*vx_vertex_data_size;

void vx_invalidate_cache(uint32 pos);

uint32 vx_prepare_table(uint32 vat);
void vx_process_commands(void);

typedef enum vxb_t
{
	VX_QUADS,
	VX_QUAD_STRIP,
	VX_LINES,
	VX_LINE_STRIP,
	VX_POINTS,
	VX_TRIANGLES,
	VX_TRIANGLE_STRIP,
	VX_TRIANGLE_FAN
};
void vx_begin(vxb_t mode);
void vx_begin_count(uint32 count);
void vx_end(void);

