#pragma once

#include "system/types.h"

enum {
	TEX_FMT_I4			=	0,
	TEX_FMT_I8			=	1,
	TEX_FMT_IA4			=	2,
	TEX_FMT_IA8			=	3,
	TEX_FMT_RGB565		=	4,
	TEX_FMT_RGB5A3		=	5,
	TEX_FMT_RGBA8		=	6,
	TEX_FMT_RESERVED1	=	7,
	TEX_FMT_C4			=	8,
	TEX_FMT_C8			=	9,
	TEX_FMT_C14X2		=	10,
	TEX_FMT_RESERVED2	=	11,
	TEX_FMT_RESERVED3	=	12,
	TEX_FMT_RESERVED4	=	13,
	TEX_FMT_CMP			=	14,
	TEX_FMT_RESERVED5	=	15
};

void *convert_tex(uint8 *srcp, int w, int h, uint32 paletized, uint8 tex_format);
void calc_pow2(int sw, int sh, int *out_wp, int *out_hp);
void tex_convert_tlut(uint32 fmt, uint32 size);
void *txc_upload_texture(uint32 tex_format, void *texture);


