
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "config.h"
#include "syslog.h"
#include "tracers.h"

char *log_id[LOG_TYPE_MAX] =
{
	"[CP]",
	"[BP]",
	"[VX]",
	"[GX]",
	"[XF]",
	"[TE]",
	"[D3D]"
};

uint32 log_trace_on[LOG_TYPE_MAX];

static	char tmpbuf[255];

void syslog_output(char *text)
{
	tmpbuf[254] = 0;
	printf(text);
}

#if WITH_LOGGING
void syslog(int type, char *fmt,...)
{
	va_list marker;
	va_start(marker,fmt);

	if(log_trace_on[type])
	{
		syslog_output(log_id[type]);
		vsprintf(tmpbuf, fmt, marker );
		syslog_output(tmpbuf);
	}
	va_end(marker);
}
#endif

void syslog_error(int type, char *fmt,...)
{
	va_list marker;
	va_start(marker,fmt);
	vsprintf(tmpbuf, fmt, marker );
	va_end(marker);

	syslog_output(log_id[type]);
	syslog_output("<ERROR> ");
	syslog_output(tmpbuf);
	fflush(stdout);
	exit(0);
}

void syslog_warn(int type, char *fmt,...)
{
	va_list marker;
	va_start(marker,fmt);
	vsprintf(tmpbuf, fmt, marker );
	va_end(marker);
	syslog_output(log_id[type]);
	syslog_output("<WARNING> ");
	syslog_output(tmpbuf);
}
