/***************************************************************************
                          cp_regs.c  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2005 by Duddie
    email                : duddie@walla.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
//*************************************************************************//

#include "stdafx.h"
#include "texture_environment.h"
#define _IN_TEXENV
#include "externals.h"

///////////////////////////////////////////////////////////////////////////
// GLOBALS + DEFINES

uint32  te_used_color[0x10000];
uint32  te_used_alpha[0x10000];

uint16  tev_stage[16];

uint32  te_combiner_regs[32];

uint16  tev_konst[16];

uint32  tev_konst_modified;
uint32  tev_stage_modified;

uint8   te_active_stages;
uint8   te_swap_table[4];

bool    te_modified;

const char *te_color_inputs[16] = 
{
    "CC_CPREV",
    "CC_APREV",
    "CC_C0   ",
    "CC_A0   ",
    "CC_C1   ",
    "CC_A1   ",
    "CC_C2   ",
    "CC_A2   ",
    "CC_TEXC ",
    "CC_TEXA ",
    "CC_RASC ",
    "CC_RASA ",
    "CC_ONE  ",
    "CC_HALF ",
    "CC_KONST",
    "CC_ZERO "
};

const char *te_alpha_inputs[16] = 
{
    "CA_APREV",
    "CA_A0   ",
    "CA_A1   ",
    "CA_A2   ",
    "CA_TEXA ",
    "CA_RASA ",
    "CA_KONST",
    "CA_ZERO "
};

typedef struct
{
    uint32  cc;
    uint32  combiner;
    uint32  arg_0;
    uint32  arg_1;
    uint32  arg_2;
    uint32  op_0;
    uint32  op_1;
    uint32  op_2;
    uint32  const_reg;
} te_param_t;


float te_reg_col[8][4] = 
{
    {0.0f, 0.0f, 0.0f, 0.0f},
    {1.0f, 1.0f, 1.0f, 1.0f},
    {0.5f, 0.5f, 0.5f, 0.5f},
//  {0.25f, 0.25f, 0.25f, 0.25f},
    {0.75f, 0.75f, 0.75f, 0.75f},
};

float te_reg_col_s10[8][4];

#define     TE_COL_PARAM_COUNT  17

char *te_kcsel[32] = 
{
    "KCSEL_1   ",
    "KCSEL_7_8 ",
    "KCSEL_3_4 ",
    "KCSEL_5_8 ",
    "KCSEL_1_2 ",
    "KCSEL_3_8 ",
    "KCSEL_1_4 ",
    "KCSEL_1_8 ",
    "KCSEL_NONE",
    "KCSEL_NONE",
    "KCSEL_NONE",
    "KCSEL_NONE",
    "KCSEL_K0  ",
    "KCSEL_K1  ",
    "KCSEL_K2  ",
    "KCSEL_K3  ",
    "KCSEL_K0_R",
    "KCSEL_K1_R",
    "KCSEL_K2_R",
    "KCSEL_K3_R",
    "KCSEL_K0_G",
    "KCSEL_K1_G",
    "KCSEL_K2_G",
    "KCSEL_K3_G",
    "KCSEL_K0_B",
    "KCSEL_K1_B",
    "KCSEL_K2_B",
    "KCSEL_K3_B",
    "KCSEL_K0_A",
    "KCSEL_K1_A",
    "KCSEL_K2_A",
    "KCSEL_K3_A"
};

char *te_kasel[32] = 
{
    "KASEL_1   ",
    "KASEL_7_8 ",
    "KASEL_3_4 ",
    "KASEL_5_8 ",
    "KASEL_1_2 ",
    "KASEL_3_8 ",
    "KASEL_1_4 ",
    "KASEL_1_8 ",
    "KASEL_NONE",
    "KASEL_NONE",
    "KASEL_NONE",
    "KASEL_NONE",
    "KASEL_NONE",
    "KASEL_NONE",
    "KASEL_NONE",
    "KASEL_NONE",
    "KASEL_K0_R",
    "KASEL_K1_R",
    "KASEL_K2_R",
    "KASEL_K3_R",
    "KASEL_K0_G",
    "KASEL_K1_G",
    "KASEL_K2_G",
    "KASEL_K3_G",
    "KASEL_K0_B",
    "KASEL_K1_B",
    "KASEL_K2_B",
    "KASEL_K3_B",
    "KASEL_K0_A",
    "KASEL_K1_A",
    "KASEL_K2_A",
    "KASEL_K3_A"
};

te_param_t  te_col_param[TE_COL_PARAM_COUNT] = 
{
    {0x00fff8,  GL_REPLACE,     GL_TEXTURE,         GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x00fffa,  GL_REPLACE,     GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
//  {0x00fffa,  GL_REPLACE,     GL_CONSTANT,        GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
//  {0x00fff8,  GL_REPLACE,     GL_CONSTANT,        GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x00fff2,  GL_REPLACE,     GL_CONSTANT,        GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_REG_C0},
    {0x00f8e0,  GL_MODULATE,    GL_TEXTURE,         GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_QUARTER},
    {0x00f8e2,  GL_MODULATE,    GL_TEXTURE,         GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_QUARTER},
    {0x00ffcf,  GL_REPLACE,     GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x00ffc8,  GL_REPLACE,     GL_TEXTURE,         GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x00f8cf,  GL_REPLACE,     GL_TEXTURE,         GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x00f8a2,  GL_MODULATE,    GL_TEXTURE,         GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x00f8af,  GL_MODULATE,    GL_TEXTURE,         GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ONE},
    {0x00f82f,  GL_MODULATE,    GL_TEXTURE,         GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x00fa8f,  GL_MODULATE,    GL_TEXTURE,         GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x002fff,  GL_REPLACE,     GL_CONSTANT,        GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_REG_C0},
    {0x00afff,  GL_REPLACE,     GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
//  {0x002fff,  GL_MODULATE_ADD_ATI,GL_CONSTANT,    GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    {0x00fe2f,  GL_REPLACE,     GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ZERO},
    // rasc * (1 - texa) + texc * texc                                                                                      
    {0x00a89f,  GL_INTERPOLATE, GL_TEXTURE,         GL_PRIMARY_COLOR,   GL_TEXTURE,         GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_ALPHA,   CC_ZERO},
    {0x00ac8f,  GL_INTERPOLATE, GL_CONSTANT,        GL_PRIMARY_COLOR,   GL_TEXTURE,         GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR,   CC_ONE},
//  {0x00f83a,  GL_MODULATE,    GL_TEXTURE,         GL_PRIMARY_COLOR,   GL_CONSTANT,        GL_SRC_COLOR,       GL_SRC_COLOR,       GL_SRC_COLOR},
};

float te_reg_cc[4][4];
float te_reg_kc[4][4];
float te_reg_cc_s10[4][4];
float te_reg_kc_s10[4][4];

#define NOT(X)  ((X))
#define COL_DIVIDER 1024.0f

///////////////////////////////////////////////////////////////////////////
// CODE

void te_set_color_reg_ra(uint32 data, uint8 reg)
{
 sint32 temp;

 if NOT(data & (1 << 23))
  {
   te_reg_kc[reg][3] = ((data >> 12) & 0xff) / 255.0f;
   te_reg_kc[reg][0] = ((data >> 0) & 0xff) / 255.0f;

   temp = ((data >> 12) & 0x7ff) << 21;
   temp >>= 21;
   te_reg_kc_s10[reg][3] = temp / COL_DIVIDER;
   temp = (data & 0x7ff) << 21;
   temp >>= 21;
   te_reg_kc_s10[reg][0] = temp / COL_DIVIDER;
  }
 else
  {
   te_reg_cc[reg][3] = ((data >> 12) & 0xff) / 255.0f;
   te_reg_cc[reg][0] = ((data >> 0) & 0xff) / 255.0f;

   temp = ((data >> 12) & 0x7ff) << 21;
   temp >>= 21;
   te_reg_cc_s10[reg][3] = temp / COL_DIVIDER;
   temp = (data & 0x7ff) << 21;
   temp >>= 21;
   te_reg_cc_s10[reg][0] = temp / COL_DIVIDER;
  }
}

///////////////////////////////////////////////////////////////////////////

void te_set_color_reg_gb(uint32 data, uint8 reg)
{
 sint32 temp;

 if NOT(data & (1 << 23))
  {
   te_reg_kc[reg][1] = ((data >> 12) & 0xff) / 255.0f;
   te_reg_kc[reg][2] = ((data >> 0) & 0xff) / 255.0f;

   temp = ((data >> 12) & 0x7ff) << 21;
   temp >>= 21;
   te_reg_kc_s10[reg][1] = temp / COL_DIVIDER;
   temp = (data & 0x7ff) << 21;
   temp >>= 21;
   te_reg_kc_s10[reg][2] = temp / COL_DIVIDER;

   glProgramEnvParameter4fvARB_Ex(GL_FRAGMENT_PROGRAM_ARB, 4 + reg, te_reg_kc[reg]);
   glProgramEnvParameter4fvARB_Ex(GL_FRAGMENT_PROGRAM_ARB, 12 + reg, te_reg_kc_s10[reg]);
  }
 else
  {
   te_reg_cc[reg][1] = ((data >> 12) & 0xff) / 255.0f;
   te_reg_cc[reg][2] = ((data >> 0) & 0xff) / 255.0f;

   temp = ((data >> 12) & 0x7ff) << 21;
   temp >>= 21;
   te_reg_cc_s10[reg][1] = temp / COL_DIVIDER;
   temp = (data & 0x7ff) << 21;
   temp >>= 21;
   te_reg_cc_s10[reg][2] = temp / COL_DIVIDER;

   glProgramEnvParameter4fvARB_Ex(GL_FRAGMENT_PROGRAM_ARB, 0 + reg, te_reg_cc[reg]);
   glProgramEnvParameter4fvARB_Ex(GL_FRAGMENT_PROGRAM_ARB, 8 + reg, te_reg_cc_s10[reg]);
  }
}

///////////////////////////////////////////////////////////////////////////

void te_init(void)
{
 uint32 i;

 for(i = 0 ; i < 0x10000 ; i++)
  {
   te_used_alpha[i] = 0;
   te_used_color[i] = 0;
  }
}

///////////////////////////////////////////////////////////////////////////

void te_close(void)
{
/*
    uint32 i;
 
    syslog(TE,"Used colors:\n");

    for(i = 0 ; i < 0x10000 ; i++)
    {
        if (te_used_color[i])
        {
            uint32  input_a, input_b, input_c, input_d;
            uint32  color;
            color = te_used_color[i];
            input_a = (color >> 12) & 0x0f;
            input_b = (color >> 8) & 0x0f;
            input_c = (color >> 4) & 0x0f;
            input_d = (color >> 0) & 0x0f;
            syslog(TE,"C: %08x %s %s %s %s bias: %d sub: %d clamp: %d shift: %d dest: %d\n", color, te_color_inputs[input_a], te_color_inputs[input_b], te_color_inputs[input_c], te_color_inputs[input_d], (color >> 16) & 0x3, (color >> 18) & 0x1, (color >> 19) & 0x1, (color >> 20) & 0x3, (color >> 22) & 0x3);
        }
    }
    syslog(TE,"Used alpha:\n");
    for(i = 0 ; i < 0x10000 ; i++)
    {
        if (te_used_alpha[i])
        {
            uint32  input_a, input_b, input_c, input_d;
            uint32  color;
            color = te_used_alpha[i];
            input_a = (color >> 13) & 0x07;
            input_b = (color >> 10) & 0x07;
            input_c = (color >> 7) & 0x07;
            input_d = (color >> 4) & 0x07;
            syslog(TE,"A: %08x %s %s %s %s bias: %d sub: %d clamp: %d shift: %d dest: %d\n", color, te_alpha_inputs[input_a], te_alpha_inputs[input_b], te_alpha_inputs[input_c], te_alpha_inputs[input_d], (color >> 16) & 0x3, (color >> 18) & 0x1, (color >> 19) & 0x1, (color >> 20) & 0x3, (color >> 22) & 0x3);
        }
    }
*/
}

///////////////////////////////////////////////////////////////////////////

/*
void te_set_stage(uint32 stage, uint32 color, uint32 alpha)
{
 uint32  input_a, input_b, input_c, input_d;
 uint32  i;
 uint32  new_color;

 input_a = (color >> 12) & 0x0f;
 input_b = (color >> 8) & 0x0f;
 input_c = (color >> 4) & 0x0f;
 input_d = (color >> 0) & 0x0f;

 te_used_color[color & 0xffff] |= (color & 0xffffff) | (1 << (24 + stage));
 te_used_alpha[alpha & 0xffff] |= (alpha & 0xffffff) | (1 << (24 + stage));

 //syslog(TE,"CLR STAGE: %d inputs: %06x %s %s %s %s bias: %d sub: %d clamp: %d shift: %d dest: %d\n", stage, color, te_color_inputs[input_a], te_color_inputs[input_b], te_color_inputs[input_c], te_color_inputs[input_d], (color >> 16) & 0x3, (color >> 18) & 0x1, (color >> 19) & 0x1, (color >> 20) & 0x3, (color >> 22) & 0x3);

 if (stage > 0) return;

 //fsg_generate(stage, color, alpha);

 new_color = color;
 // currently we skip destination register
 new_color &= ~0xc00000;
 // and we skip clamping because we dont (?) have it in OpenGL
 new_color &= ~0x080000;
 // and we skip scaling because we dont (?) have it in OpenGL
 new_color &= ~0x300000;
 // and we mask out sub temporarily
 new_color &= ~0x040000;
 
 for(i = 0 ; i < TE_COL_PARAM_COUNT ; i++)
  {
   if(te_col_param[i].cc == new_color) break;
  }

 if (i == TE_COL_PARAM_COUNT)
  {
   //syslog(TE,"Unknown CC %06x\n", color);
   i = 0;
  }

 glActiveTextureARB_Ex(GL_TEXTURE0);
 glTexEnvfv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_COLOR, te_reg_col[te_col_param[i].const_reg]);
 glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE);

 glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB, te_col_param[i].combiner);
 glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_RGB, te_col_param[i].arg_0);
 glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_RGB, te_col_param[i].arg_1);
 glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE2_RGB, te_col_param[i].arg_2);

 glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_RGB, te_col_param[i].op_0);
 glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_RGB, te_col_param[i].op_1);
 glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND2_RGB, te_col_param[i].op_2);

 glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA, GL_MODULATE);
 glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_ALPHA, GL_TEXTURE);
 glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_ALPHA, GL_PRIMARY_COLOR);
 glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_ALPHA, GL_SRC_ALPHA);
 glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_ALPHA, GL_SRC_ALPHA);

 switch((color >> 20) & 0x3)
  {
   case 0x0:
    glTexEnvf(GL_TEXTURE_ENV, GL_RGB_SCALE, 1.0f);
    break;
 
   case 0x1:
    glTexEnvf(GL_TEXTURE_ENV, GL_RGB_SCALE, 2.0f);
    break;

   case 0x2:
    glTexEnvf(GL_TEXTURE_ENV, GL_RGB_SCALE, 4.0f);
    break;

   default:
    //syslog_error(TE,"Divider not implemented\n");
    break;
  }
}

*/
///////////////////////////////////////////////////////////////////////////
