/***************************************************************************
                       pe_interface.c  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2005 by Duddie
    email                : duddie@walla.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
//*************************************************************************//

#include "stdafx.h"
#include "pe_interface.h"
#define _IN_PE
#include "externals.h"

///////////////////////////////////////////////////////////////////////////
// DEFINES + GLOBALS

#define PE_REGS_SIZE    256

char  pe_regs[PE_REGS_SIZE];
bool  pe_finished=false;
uint8 pe_irq_enable=0;

#define PE_REG_UINT32(A)        *((uint32 *)(pe_regs + (A)))
#define PE_REG_UINT16(A)        *((uint16 *)(pe_regs + (A)))
#define PE_REG_UINT8(A)         *((uint8 *)(pe_regs + (A)))

#define PE_WRITE_UINT32(A, D)   PE_REG_UINT32(A) = byteswap32((D))
#define PE_WRITE_UINT16(A, D)   PE_REG_UINT16(A) = byteswap16((D))
#define PE_WRITE_UINT8(A, D)    PE_REG_UINT8(A) = (uint8)(D)

#define PE_READ_UINT32(A)       (byteswap32(PE_REG_UINT32(A)))
#define PE_READ_UINT16(A)       (byteswap16(PE_REG_UINT16(A)))
#define PE_READ_UINT8(A)        (PE_REG_UINT8(A))

///////////////////////////////////////////////////////////////////////////
// inline helpers

static __inline uint32 byteswap32(uint32 data)
{
 __asm
  {
   mov eax, data
   bswap eax
  }
}

static __inline uint16 byteswap16(uint16 data)
{
 return (data<<8)|(data>>8);
}

///////////////////////////////////////////////////////////////////////////

void pe_init(void)
{
 int i;

 for(i=0;i<PE_REGS_SIZE;i++)
  {
   pe_regs[i]=0;
  }
}

///////////////////////////////////////////////////////////////////////////

void pe_close(void)
{
}

///////////////////////////////////////////////////////////////////////////

void pe_write_register8(uint32 addr, uint8 data)
{
 PE_WRITE_UINT8(addr & 0xff, data);

 switch(addr & 0xff)
  {
   case 0x0a:
    if(data & 0x08) pe_finished=false;
    pe_irq_enable=data&3;
    break;

   default:
    break;
  }
}

///////////////////////////////////////////////////////////////////////////

void pe_write_register16(uint32 addr, uint16 data)
{
 PE_WRITE_UINT16(addr & 0xff, data);

 switch(addr & 0xff)
  {
   case 0x0a:
    if(data & 0x08) pe_finished=false;
    pe_irq_enable=data&3;
    break;

   default:
    break;
  }
}

///////////////////////////////////////////////////////////////////////////

void pe_write_register32(uint32 addr, uint32 data)
{
 PE_WRITE_UINT32(addr & 0xff, data);

 switch(addr & 0xff)
  {
   case 0x0a:
    if (data & 0x08) pe_finished=false;
    pe_irq_enable=data&3;
    break;

   default:
    break;
  }
}

///////////////////////////////////////////////////////////////////////////

uint8 pe_read_register8(uint32 addr)
{
 uint8 data;
 data = PE_READ_UINT8(addr & 0xff);

 switch(addr & 0xff)
  {
   case 0x0a:
    if (pe_finished) data|=0x04;
    break;

   default:
    break;
  }

 return data;
}

///////////////////////////////////////////////////////////////////////////

uint16 pe_read_register16(uint32 addr)
{
 uint16 data;

 data = PE_READ_UINT16(addr & 0xff);

 switch(addr & 0xff)
  {
   case 0x0a:
    if (pe_finished) data|=0x04;
    break;

   default:
    break;
  }

 return data;
}

///////////////////////////////////////////////////////////////////////////

uint32 pe_read_register32(uint32 addr)
{
 uint32 data;

 data = PE_READ_UINT32(addr & 0xff);

 switch(addr & 0xff)
  {
   case 0x0a:
    if (pe_finished) data |= 0x04;
    break;

   default:
    break;
  }

 return data;
}

///////////////////////////////////////////////////////////////////////////

bool pe_check_interrupt(void)
{
 return pe_finished;
}

///////////////////////////////////////////////////////////////////////////
