/*====================================================================

filename:     profiler.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
//
//  Profiler routines for finding out hot spots in the code
//
//

#include "system/types.h"
#include "profiler.h"

// profiling
uint64 tmp_cpu, total_cpu=0;
uint64 tmp_total, total_total=0;
uint64 tmp_io, total_io=0;

// starts profiling using dataptr location as storage
#if WITH_PROFILER
void profile_start(uint64 *dataptr)
{
	_asm
	{
		mov ecx, dataptr
		rdtsc
		mov [ecx], eax
		mov [ecx+4], edx
	}
}
// stops profile and returns number of cycles spend in given profile
uint64 profile_stop(uint64 *dataptr)
{
	uint64 res;

	profile_start(&res);
	return (res - *dataptr);
}

#endif