/*====================================================================

filename:     audio_interface.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include "system/types.h"
#include "audio_interface.h"
#include "hardware/hw_io.h"
#include "hardware/memory_interface.h"

#define AI_REGS_SIZE	256
char ai_regs[AI_REGS_SIZE];

void ai_init(void)
{
	int i;
	for (i = 0 ; i < AI_REGS_SIZE ; i++)
	{
		ai_regs[i] = 0;
	}

}

void ai_close(void)
{
}

#define AI_REG_CR	0x00
#define AI_REG_SCNT	0x08
uint32 ai_sample_counter;







#define AI_REG_UINT32(A)		*((uint32 *)(ai_regs + (A)))
#define AI_REG_UINT16(A)		*((uint16 *)(ai_regs + (A)))
#define AI_REG_UINT8(A)		*((uint8 *)(ai_regs + (A)))

#define AI_WRITE_UINT32(A, D)	AI_REG_UINT32(A) = byteswap32((D))
#define AI_WRITE_UINT16(A, D)	AI_REG_UINT16(A) = byteswap16((D))
#define AI_WRITE_UINT8(A, D)	AI_REG_UINT8(A) = (uint8)(D)

#define AI_READ_UINT32(A)		(byteswap32(AI_REG_UINT32(A)))
#define AI_READ_UINT16(A)		(byteswap16(AI_REG_UINT16(A)))
#define AI_READ_UINT8(A)		(AI_REG_UINT8(A))


void ai_write_register8(uint32 addr, uint8 data)
{
	AI_WRITE_UINT8(addr & 0xff, data);

	switch(addr & 0xff)
	{
	case AI_REG_CR:
		if (data & 0x20) ai_sample_counter = 0;
		break;
	default:
		break;
	}
}

void ai_write_register16(uint32 addr, uint16 data)
{
	AI_WRITE_UINT16(addr & 0xff, data);

	switch(addr & 0xff)
	{
	case AI_REG_CR:
		if (data & 0x20) ai_sample_counter = 0;
		break;
	default:
		break;
	}
}

void ai_write_register32(uint32 addr, uint32 data)
{
	AI_WRITE_UINT32(addr & 0xff, data);

	switch(addr & 0xff)
	{
	case AI_REG_CR:
		if (data & 0x20) ai_sample_counter = 0;
		break;
	default:
		break;
	}
}

uint8 ai_read_register8(uint32 addr)
{
	uint8 data;

	data = AI_READ_UINT8(addr & 0xff);

	switch(addr & 0xff)
	{
	case 0x0:
		data |= 0x08;
		break;
	case AI_REG_SCNT:
		data = ai_sample_counter++;
		break;
	default:
		break;
	}
	return data;
}

uint16 ai_read_register16(uint32 addr)
{
	uint16 data;

	data = AI_READ_UINT8(addr & 0xff);

	switch(addr & 0xff)
	{
	case 0x0:
		data |= 0x08;
		break;
	case AI_REG_SCNT:
		data = ai_sample_counter++;
		break;
	default:
		break;
	}
	return data;
}

uint32 ai_read_register32(uint32 addr)
{
	uint32 data;

	data = AI_READ_UINT8(addr & 0xff);

	switch(addr & 0xff)
	{
	case 0x0:
		data |= 0x08;
		break;
	case AI_REG_SCNT:
		data = ai_sample_counter++;
		break;
	default:
		break;
	}
	return data;
}
