/*====================================================================

filename:     gcm_wrapper.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gcm_wrapper.h"
#include "gcm/GCMutils.h"
#include "gcm/GCMextras.h" 

static FILE *gcmFile;
static char gcmFileName[256];
void gcm_init(void)
{
	gcmFile = NULL;
}

bool gcm_is_open(void)
{
	if (gcmFile)
		return true;
	return false;
}

bool gcm_open(char *filename) 
{
	if (gcmFile)
	{
		return true;
	}
	if (!filename) 
	{
		printf("Must provide filename\n");
		exit(1);
	}

	strcpy(gcmFileName, filename);

	gcm_close();
	if (!(gcmFile = fopen(gcmFileName, "rb"))) 
	{
		printf("error opening file... (%s)\n", gcmFileName);
		exit(1);
	}
	return true;
}

void gcm_close(void)
{
	if (gcmFile) fclose(gcmFile);
	gcmFile = NULL;
}

int gcm_read(char *buffer, int offset, int sz)
{
	//printf("sz: %08x\n", sz);
	fseek(gcmFile, offset, SEEK_SET);
	uint32 x = (uint32) fread(buffer, 1, sz, gcmFile);
	//printf("%08x\n", x);
	return 0;
}

void gcm_print_info(int hexFlag) 
{
	/*
	**  This just prints all of the relevant info for the ROM
	**  fun fun fun
	*/

	char format[256]; //this is for the hexFlag stuff...
	char systemID = GCMGetSystemID(gcmFile);
	
	char *gameID = (char*)malloc(GCM_GAME_ID_LENGTH + 1);
	GCMGetGameID(gcmFile, gameID);
	
	char regionCode = GCMGetRegionCode(gcmFile);
	
	char *makerCode = (char*)malloc(GCM_MAKER_CODE_LENGTH + 1);
	GCMGetMakerCode(gcmFile, makerCode);
	
	char *gameName = (char*)malloc(GCM_GAME_NAME_LENGTH);
	GCMGetGameName(gcmFile, gameName);
	
	printf("Filename:\t%s\n", gcmFileName);
	printf("System ID:\t%c (%s)\n", systemID, GCMSystemIDToStr(systemID));
	printf("Game ID:\t%s\n", gameID);
	printf("Region:  \t%c (%s)\n", regionCode, GCMRegionCodeToStr(regionCode));
	printf("Maker Code:\t%s (%s)\n", makerCode, GCMMakerCodeToStr(makerCode));
	printf("Game Name:\t%s\n", gameName);
	
	
	strcpy(format, "DOL offset:\t");
	strcat(format, (hexFlag) ? "%08X" : "%ld");
	strcat(format, "\n");
	printf(format, GCMGetDolOffset(gcmFile));
	
	strcpy(format, "Apploader:\t");
	strcat(format, (hexFlag) ? "%08X" : "%ld");
	strcat(format, "\n");
	printf(format, GCM_APPLOADER_OFFSET);
	
	strcpy(format,"ApploaderSize:\t");
	strcat(format, (hexFlag) ? "%08X" : "%ld");
	strcat(format, "\n");
	printf(format, GCMGetApploaderSize(gcmFile));
	
	strcpy(format, "FST:      \t");
	strcat(format, (hexFlag) ? "%08X" : "%ld");
	strcat(format, "\n");
	printf(format, GCMGetFSTOffset(gcmFile));
	
	GCMFileEntryStruct *r = GCMGetRootFileEntry(gcmFile);
	uint32 entryCount = r->length;
	printf("File count:\t%ld\n", entryCount);
	GCMFreeFileEntryStruct(r);
} 