/*
 *  GCMDiskHeaderInfo.h
 *  gcmtool
 *
 *  Created by spike on Mon May 24 2004.
 *  Copyright (c) 2004 Sadistech. All rights reserved.
 *
 */

/*
**  Utility functions for dealing with bi2.bin from a gamecube dvd image (.gcm or .iso)
*/

#ifndef _GCM_DISK_HEADER_INFO_H_
#define _GCM_DISK_HEADER_INFO_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "system/types.h"

typedef struct gcm_disk_header_info_struct {
	uint32		debugMonitorSize;
	uint32		simulatedMemorySize;
	uint32		argumentOffset;
	uint32		debugFlag;
	uint32		trackLocation;
	uint32		trackSize;
	uint32		countryCode;
	uint32		unknown1;
	uint32		unknown2;
}GCMDiskHeaderInfoStruct;

//functions and stuff

void GCMDiskHeaderInfoStructToRaw(GCMDiskHeaderInfoStruct *d, char *buf);
GCMDiskHeaderInfoStruct *GCMRawDiskHeaderInfoToStruct(char *rawInfo);

//free up memory
void GCMFreeDiskHeaderInfoStruct(GCMDiskHeaderInfoStruct *dhi);

#ifdef __cplusplus
};
#endif

#endif /* _GCM_DISK_HEADER_INFO_H_ */
