/*
 *  GCMDiskHeaderInfo.c
 *  gcmtool
 *
 *  Created by spike on Mon May 24 2004.
 *  Copyright (c) 2004 Sadistech. All rights reserved.
 *
 */

#include "GCMDiskHeaderInfo.h"
#include "GCMutils.h"
#include <string.h>
#include <stdlib.h>
#include <winsock.h>

void bzero(char *s, int n)
{
	while(n--)
		*s++ = 0;
}

void GCMDiskHeaderInfoStructToRaw(GCMDiskHeaderInfoStruct *d, char *buf) {
	/*
	**  sets buf to a DiskHeaderInfoStruct as raw data
	**  suitable for writing to a file or dumping back to a GCM
	**  
	**  when allocating memory for buf, you should use GCM_DISK_HEADER_INFO_LENGTH
	*/
	
	if (!d || !buf) return;
	
	char *start = buf;
	
	//first, let's zero out the buffer
	bzero(buf, GCM_DISK_HEADER_INFO_LENGTH);
	
	uint32 *debugMonitorSize = (uint32*)malloc(sizeof(uint32));
	*debugMonitorSize = htonl(d->debugMonitorSize);
	memcpy(buf, debugMonitorSize, sizeof(uint32));
	free(debugMonitorSize);
	buf += sizeof(uint32);
	
	uint32 *simulatedMemorySize = (uint32*)malloc(sizeof(uint32));
	*simulatedMemorySize = htonl(d->simulatedMemorySize);
	memcpy(buf, simulatedMemorySize, sizeof(uint32));
	free(simulatedMemorySize);
	buf += sizeof(uint32);
	
	uint32 *argumentOffset = (uint32*)malloc(sizeof(uint32));
	*argumentOffset = htonl(d->argumentOffset);
	memcpy(buf, argumentOffset, sizeof(uint32));
	free(argumentOffset);
	buf += sizeof(uint32);
	
	uint32 *debugFlag = (uint32*)malloc(sizeof(uint32));
	*debugFlag = htonl(d->debugFlag);
	memcpy(buf, debugFlag, sizeof(uint32));
	free(debugFlag);
	buf += sizeof(uint32);
	
	uint32 *trackLocation = (uint32*)malloc(sizeof(uint32));
	*trackLocation = htonl(d->trackLocation);
	memcpy(buf, trackLocation, sizeof(uint32));
	free(trackLocation);
	buf += sizeof(uint32);
	
	uint32 *trackSize = (uint32*)malloc(sizeof(uint32));
	*trackSize = htonl(d->trackSize);
	memcpy(buf, trackSize, sizeof(uint32));
	free(trackSize);
	buf += sizeof(uint32);
	
	uint32 *countryCode = (uint32*)malloc(sizeof(uint32));
	*countryCode = htonl(d->countryCode);
	memcpy(buf, countryCode, sizeof(uint32));
	free(countryCode);
	buf += sizeof(uint32);
	
	uint32 *unknown1 = (uint32*)malloc(sizeof(uint32));
	*unknown1 = htonl(d->unknown1);
	memcpy(buf, unknown1, sizeof(uint32));
	free(unknown1);
	buf += sizeof(uint32);
	
	uint32 *unknown2 = (uint32*)malloc(sizeof(uint32));
	*unknown2 = htonl(d->unknown2);
	memcpy(buf, unknown2, sizeof(uint32));
	free(unknown2);
	buf += sizeof(uint32);
	
	buf = start;
}

GCMDiskHeaderInfoStruct *GCMRawDiskHeaderInfoToStruct(char *rawInfo) {
	/*
	**  experimental function for creating a struct out of the diskheaderinfo
	**  
	*/

	GCMDiskHeaderInfoStruct *d = (GCMDiskHeaderInfoStruct*)malloc(sizeof(GCMDiskHeaderInfoStruct));
	uint32 *ri = (uint32 *)rawInfo;
	d->debugMonitorSize		= ntohl(*ri++);
	d->simulatedMemorySize  = ntohl(*ri++);
	d->argumentOffset		= ntohl(*ri++);
	d->debugFlag			= ntohl(*ri++);
	d->trackLocation		= ntohl(*ri++);
	d->trackSize			= ntohl(*ri++);
	d->countryCode			= ntohl(*ri++);
	d->unknown1				= ntohl(*ri++);
	d->unknown2				= ntohl(*ri++);
	
	return d;
}

void GCMFreeDiskHeaderInfoStruct(GCMDiskHeaderInfoStruct *dhi) {
	/*
	**  convenience method for freeing a DiskHeaderInfoStruct
	*/

	if (!dhi) return;
	
	free(dhi);
}