/*====================================================================

filename:     elf_file.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include <stdio.h>
#include <stdlib.h>

#include "elf.h"
#include "hardware/memory_interface.h"

#define MEM_ADDRESS(addr) (mem + (addr & 0x3fffffff))

int is_elf (char *filename)
{
	FILE *f;
	Elf32_Ehdr hdr;


	f = fopen (filename, "rb");
	if (!f)
		return false;

	fread (&hdr, sizeof (hdr), 1, f);
	if ((hdr.e_ident[EI_MAG0] == 0x7f  &&
			 hdr.e_ident[EI_MAG1] == 'E'   &&
			 hdr.e_ident[EI_MAG2] == 'L'   &&
			 hdr.e_ident[EI_MAG3] == 'F')  &&
			 hdr.e_ident[EI_CLASS] == ELFCLASS32)
	{
		if (byteswap16(hdr.e_type) != ET_EXEC)
		{
			printf(".elf: file %s is not executable (%d)", filename, hdr.e_type);
			return false;
		}
		
		if (hdr.e_ident[EI_DATA] != ELFDATA2MSB)
		{
			printf(".elf: only MSB encoding supported (%d)", hdr.e_ident[EI_DATA]);
			return false;
		}

		return true;
	}
	else
		return false;
}

//#define MEM_ADDRESS(addr) (gMemory + (addr & 0x3fffffff))
uint32 elf_load_file(char *filename, uint8 *mem, uint32 &entry_point)
{
	FILE *elf;
	Elf32_Ehdr hdr;
	Elf32_Phdr phdr;
	int i;


	if (!is_elf (filename))
		return false;

	elf = fopen (filename, "rb");
	fread (&hdr, sizeof (hdr), 1, elf);

	hdr.e_phoff = byteswap32 (hdr.e_phoff);
	hdr.e_phnum = byteswap16 (hdr.e_phnum);
	for (i = 0; i < hdr.e_phnum; i++)
	{
		fseek (elf, hdr.e_phoff + i*sizeof (phdr), SEEK_SET);
		fread (&phdr, sizeof (phdr), 1, elf);

		if (byteswap32 (phdr.p_type) == PT_LOAD && phdr.p_filesz != 0)
		{
			fseek (elf, byteswap32 (phdr.p_offset), SEEK_SET);
			fread (MEM_ADDRESS (byteswap32 (phdr.p_vaddr)),
						 byteswap32 (phdr.p_filesz), 1, elf);

			printf(".elf: section with size 0x%x loaded at 0x%x\n", byteswap32 (phdr.p_filesz), byteswap32 (phdr.p_vaddr));
		}
	}

	fclose (elf);

	printf(".elf: opened %s with entrypoint at 0x%x\n", filename, byteswap32 (hdr.e_entry));
	entry_point = byteswap32 (hdr.e_entry);

	return true;
}

 