/*====================================================================

filename:     gdsp_memory.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include <stdio.h>
#include "dtypes.h"
#include "gdsp_interpreter.h"
#include "gdsp_memory.h"
#include "dbg.h"
#include "gdsp_ifx.h"

uint16 dsp_swap16(uint16 x)
{
	return (x >> 8) | (x << 8);
}

uint16 *gdsp_get_iram(void)
{
	return dsp->iram;
}

uint16 *gdsp_get_irom(void)
{
	return dsp->irom;
}

uint16 *gdsp_get_dram(void)
{
	return dsp->dram;
}

uint16 *gdsp_get_drom(void)
{
	return dsp->drom;
}


uint16 dsp_imem_read(uint16 addr)
{
	uint16 opc;
#if ENABLE_PARANOID
	if (addr & 0x7000)
	{
		dbg_error("Wrong address");
		return 0;
	}
#endif // ENABLE_PARANOID

	if (dsp->pc & 0x8000)
	{
		opc = dsp->irom[addr & DSP_IROM_MASK];
	}
	else
	{
		opc = dsp->iram[addr & DSP_IRAM_MASK];
	}
	return dsp_swap16(opc);
}

uint16	dsp_dmem_read(uint16 addr)
{
	uint16 val;

	switch(addr >> 12)
	{
/*	case 0x8:	// 8xxx DROM 
		val = dsp->drom[addr & DSP_DROM_MASK];
		val = dsp_swap16(val);
		break;
*/	case 0xf:	// Fxxx HW regs
		val = gdsp_ifx_read(addr);
		break;
	case 0x0:	// 0xxx DRAM
		val = dsp->dram[addr & DSP_DRAM_MASK];
		val = dsp_swap16(val);
		break;
	default:	// error
		fprintf(stderr, "%04x DSP ERROR: Read from UNKNOWN (%04x) memory\n", dsp->pc, addr);
		val = 0;
		break;
	}
	//fprintf(stderr, "%04x MR %04x %04x\n", dsp->pc, addr, val);
	return val;
}

bool dsp_dmem_write(uint16 addr, uint16 val)
{
	//fprintf(stderr, "%04x MW %04x %04x\n", dsp->pc, addr, val);
	//if (addr == 0x800)	printf("%04x MW %04x %04x\n", dsp->pc, addr, val);
	switch(addr >> 12)
	{
	case 0x8:	// 8xxx DROM 
		val = dsp_swap16(val);
		dsp->drom[addr & DSP_DROM_MASK] = val;
		break;
	case 0xf:	// Fxxx HW regs
		gdsp_ifx_write(addr, val);
		break;
	case 0x0:	// 0xxx DRAM
		val = dsp_swap16(val);
		dsp->dram[addr & DSP_DRAM_MASK] = val;
		break;
	default:	// error
		break;
	}
	return true;
}
uint16 dsp_fetch_code(void)
{
	uint16 opc;
	opc = dsp_imem_read(dsp->pc);
	dsp->pc++;
	return opc;
}

uint16 dsp_peek_code(void)
{
	return dsp_imem_read(dsp->pc);
}