/*====================================================================

filename:     trx_ppc_rec.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#ifndef TRX_PPC_REC_H
#define TRX_PPC_REC_H

extern int use_sse;

extern struct TRX_PPC_Registers trxCPUrec;

extern uint32 block_start_x86_pos;

extern double *trx_rec_ps0_double;
extern double *trx_rec_ps1_double;
extern uint64 *trx_rec_ps0_int;
extern uint64 *trx_rec_ps1_int;

extern void *p_rec_mem_read8;
extern void *p_rec_mem_read16;
extern void *p_rec_mem_read32;
extern void *p_rec_mem_write8;
extern void *p_rec_mem_write16;
extern void *p_rec_mem_write32;

extern uint32 *translation_table;
extern uint32 address_of_translation_table;
extern uint8 *translation_memory;
extern uint32 translation_size;
extern uint32 translation_pos;

int trx_rec_init();
int rec_cache_init(void);
void trx_rec_cacheflush(void);
void trx_rec_run();
void trx_rec_stop();
void rec_patchmeup();
void trx_rec_runcpu(void);

void rec_cache_snoop(uint32 address);
void rec_cache_snoop_area(uint32 address, uint32 size);

void rec_mem_read8(void);
void rec_mem_read16(void);
void rec_mem_read32(void);
void rec_mem_read64(void);

void rec_mem_write8(void);
void rec_mem_write16(void);
void rec_mem_write32(void);
void rec_mem_write64(void);

void rec_slave_mem_read8(void);
void rec_slave_mem_read16(void);
void rec_slave_mem_read32(void);

void rec_slave_mem_write8(void);
void rec_slave_mem_write16(void);
void rec_slave_mem_write32(void);

void regc_start(void);
uint32 regc_end(void);
uint32 regc_getcachereg(uint32 ppcreg);
void regc_load(uint32 dstreg, uint32 ppcreg);
void regc_store(uint32 srcreg, uint32 ppcreg);
uint32 regc_load_constant(uint32 ppcreg);
void regc_store_constant(uint32 value, uint32 ppcreg);
uint32 regc_is_constant(uint32 ppcreg);
uint32 regc_getconstant(uint32 ppcreg);



#endif
