/*====================================================================

filename:     trx_ppc_int.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "config.h"
#include "system/types.h"
#include "trx_ppc_cpu.h"
#include "trx_ppc_int_opcodes.h"
#include "trx_ppc_int_fpu_ps_opcodes.h"
#include "ppc_disasm.h"
#include "w32_display.h"
#include "cpu/trx_ppc_int.h"
#include "profiler.h"
#include "hardware/hw_io.h"
#include "pad.h"

uint8 (*mem_read8_int)(uint32 address);
uint16 (*mem_read16_int)(uint32 address);
uint32 (*mem_read32_int)(uint32 address);
void (*mem_write8_int)(uint32 address, uint8 val);
void (*mem_write16_int)(uint32 address, uint16 val);
void (*mem_write32_int)(uint32 address, uint32 val);

struct TRX_PPC_Registers trxCPUint;
double *trx_int_ps0_double;
double *trx_int_ps1_double;
uint64 *trx_int_ps0_int;
uint64 *trx_int_ps1_int;

/*
void dump_mmu(void)
{
	uint32 i, d;
	printf("MMU DUMP\n");
	if(trxCPUint.spr[25] == 0)
	{
		printf("invalid pagetable (0)\n");
		return;
	}
	for(i = 0; i < 4; i++)
	{
		// IBAT0U: 528 IBAT0L: 529
		printf("IBAT%d: start: %x size: %d kbyte phys: %x\n", i, (trxCPUint.spr[528+i] & 0xfffe0000), (((trxCPUint.spr[528+i]&0x1ffc)>>2)<<17)/1024, (trxCPUint.spr[529+i] & 0xfffe0000)) ;
	}
	for(i=0; i< 16; i++)
	{
        printf("SR%d: %x\n", i, trxCPUint.sr[i]);
	}
	printf("SDR1: pagetable start: %x size: %d kbyte (%x)\n", trxCPUint.spr[25]& 0xffff0000, ((( (trxCPUint.spr[25]&0x1ff)<<16) | 0xffff)+1) /1024, trxCPUint.spr[25]);
	for(i=0 ; i < ((( (trxCPUint.spr[25]&0x1ff)<<16) | 0xffff)+1); i+=8)
	{
		d = mem_read32(trxCPUint.spr[25]+i);
		// valid ?
		if(d>>31)
		{
			printf("%d: V=%d VSID=%d H=%d API=%d (%x)\n", i, d>>31, d>>7, (d>>5)&1, d&0x1f, d);
			d = mem_read32(trxCPUint.spr[25]+i+4);
			printf("%d: RPN=%x R=%d C=%d WIMG=%x PP=%x (%x)\n", i, d&0xffff0000, (d>>8)&1, (d>>7)&1, (d>>3)&0xf, d&3, d);
		}
	}
}*/




//==============================================================================
//
// TLB related functions
//

void trx_ppc_tlbie()
{
	uint32 rB;

	rB = ((trxCPUint.opcode)>>11)&0x1f;
//	printf("TLBIE: %x\n", trxCPUint.gpr[rB]);
}

void trx_int_step()
{
	trxCPUint.npc = trxCPUint.pc + 4;
	trxCPUint.opcode = mem_iread(trxCPUint.pc);
	trx_cpu_interpret_single();
	trxCPUint.pc = trxCPUint.npc;
}

void trx_int_runcpu()
{
	while(cpuslice_left >= 0)
	{
		trxCPUint.block_startPC = trxCPUint.pc;
		trxCPUint.block_instr = 0;
		trxCPUint.blockend = BLOCKEND_CONT;

		for(; (trxCPUint.blockend != BLOCKEND_STOP && (trxCPUint.block_instr < MAX_BLOCK_SIZE)) ; trxCPUint.block_instr++)
		{
			trxCPUint.npc = trxCPUint.pc + 4;
			trxCPUint.opcode = mem_iread(trxCPUint.pc);
			trx_cpu_interpret_single();
			trxCPUint.pc = trxCPUint.npc;
		}
		cpuslice_left -= trxCPUint.block_instr;
	}
}

void trx_int_run()
{
	bool done = false;
	uint32 cpu_instr_ran = 0;

	int ops=0;
	int cyclecount = 0;

	uint32 blocksran = 0; 

	while (!done) 
	{
		cpuslice = config_instructions_per_line;
		if(cpuslice > trxCPUint.spr[PPC_DEC]) cpuslice = trxCPUint.spr[PPC_DEC];
#if FORCE_ONE_BLOCK_MODE
		cpuslice = 0;
#endif
		cpuslice_left = cpuslice;
		trx_int_runcpu();

		cpu_instr_ran = cpuslice + (-cpuslice_left);

		ops += cpu_instr_ran;

		blocksran++;
		if(blocksran % 10000 == 0)
		{
			printf("blocks ran: %d @%x\n", blocksran, trxCPUint.pc);
		}

		// the time base register seems to be updated every 8 cycles or so.
		cyclecount += cpu_instr_ran;
		if(cyclecount > 8)
		{
			uint64 tb;
			tb = (trxCPUint.spr[PPC_TBL])+(trxCPUint.spr[PPC_TBH]<<32);
			tb += (cyclecount>>3); 
			cyclecount -= ((cyclecount>>3)<<3);
			trxCPUint.spr[PPC_TBL] = tb;
			trxCPUint.spr[PPC_TBH] = (tb>>32); 
		}
		if(cpu_instr_ran > trxCPUint.spr[PPC_DEC])
		{
			trxCPUint.spr[PPC_DEC] = 0xffffffff;
			trxCPUint.exception_pending = true;
			trxCPUint.dec_exception = true;
		}
		else
		{
			trxCPUint.spr[PPC_DEC] -= cpu_instr_ran;
		}

		if(ops >= config_instructions_per_line) 
		{
			ops = 0;
			static int exitcheck=0;
			vi_next_scanline();
			if (pi_check_interrupt_lines()) 
			{
				trxCPUint.exception_pending = true;
				trxCPUint.ext_exception = true;
			}
			exitcheck++;
			if(exitcheck>10) 
			{
				exitcheck = 0;
				pad_read();
				done = w32_check_events();
				syslog(CPU,"@%08x (%d ops) dec: %08x lr: %08x\r", trxCPUint.pc, ops, trxCPUint.spr[PPC_DEC], trxCPUint.lr);
			}
		}
		
		trxCPUint.pc = trxCPUint.npc;
		if (trxCPUint.exception_pending)
		{
			if (trxCPUint.stop_exception) 
			{
				trxCPUint.stop_exception = false;
				if (!trxCPUint.dec_exception && !trxCPUint.ext_exception) trxCPUint.exception_pending = false;
				break;
			}
			if (trxCPUint.msr & MSR_EE) 
			{
				if (trxCPUint.ext_exception) 
				{
					//printf("Entering exception @%8.8x\n", trxCPUint.pc);
					trx_ppc_exception(PPC_EXC_EXT_INT, 0);
					trxCPUint.pc = trxCPUint.npc;
					trxCPUint.ext_exception = false;
					if (!trxCPUint.dec_exception) trxCPUint.exception_pending = false;
					continue;
				}
				if (trxCPUint.dec_exception) {
					trxCPUint.dec_exception = false;
					trxCPUint.exception_pending = false;
					trx_ppc_exception(PPC_EXC_DEC, 0);
					trxCPUint.pc = trxCPUint.npc;
					continue;
				}
			}
		}
	}
}

void trx_ppc_int_group19(void)
{
	switch((trxCPUint.opcode>>1)&0x3ff)
	{
	case 0:		trx_ppc_int_mcrf(); break;
	case 16:	trx_ppc_int_bclrx();break;
	case 33:	trx_ppc_int_crnor();break;
	case 50:	trx_ppc_int_rfi();break;
	case 150:	break; // isync
	case 193:	trx_ppc_int_crxor();break;
	case 289:	trx_ppc_int_creqv(); break;
	case 449:   trx_ppc_int_cror(); break;
	case 528:	trx_ppc_int_bcctrx();break;
	default:
		{
			char buf[64], opStr[16], parmStr[32];
			uint32 target;
			
			GekkoDisassemble(opStr, parmStr, trxCPUint.opcode, trxCPUint.pc, &target);
			sprintf(buf, "%-10s %s", opStr, parmStr);    
			printf("[trxCPUint] Group19: %.8X  %.8X  %s\n", trxCPUint.pc, trxCPUint.opcode, buf);
			printf("[trxCPUint] Group19 unhandled op: %d\n", (trxCPUint.opcode>>1)& 0x3ff);
			exit(0);
		}
		break;
	}
}

void trx_ppc_int_group31(void)
{
	switch((trxCPUint.opcode>>1)&0x3ff)
	{
	case 0:		trx_ppc_int_cmp();break;
	case 8:		trx_ppc_int_subfcx();break;
	case 10:	trx_ppc_int_addcx();break;
	case 11:	trx_ppc_int_mulhwux();break;
	case 19:	trx_ppc_int_mfcr();break;
	case 23:	trx_ppc_int_lwzx();break;
	case 24:	trx_ppc_int_slwx();break;
	case 26:	trx_ppc_int_cntlzwx();break;
	case 28:	trx_ppc_int_andx();break;
	case 32:	trx_ppc_int_cmpl();break;
	case 40:	trx_ppc_int_subfx();break;
	case 54:	break; // dcbst ignored for now
	case 55:	trx_ppc_int_lwzux();break;
	case 60:	trx_ppc_int_andcx(); break;
	case 75:	trx_ppc_int_mulhwx(); break;
	case 83:	trx_ppc_int_mfmsr();break;
	case 86:	break;// dcbf data cache block flush, we dont care
	case 87:	trx_ppc_int_lbzx(); break;
	case 104:	trx_ppc_int_negx(); break;
	case 119:	trx_ppc_int_lbzux();break;
	case 124:	trx_ppc_int_norx();break;
	case 136:	trx_ppc_int_subfex();break;
	case 138:	trx_ppc_int_addex();break;
	case 144:	trx_ppc_int_mtcrf();break;
	case 146:	trx_ppc_int_mtmsr(); break;
	case 151:	trx_ppc_int_stwx();break;
	case 183:	trx_ppc_int_stwux();break;
	case 200:	trx_ppc_int_subfzex(); break;
	case 202:	trx_ppc_int_addzex(); break;
	case 210:	trx_ppc_int_mtsr(); break;
	case 215:	trx_ppc_int_stbx();break;
	case 234:	trx_ppc_int_addmex();break;
	case 235:	trx_ppc_int_mullwx(); break;
	case 242:	trx_ppc_int_mtsrin();break;
	case 247:	trx_ppc_int_stbux();break;
	case 266:	trx_ppc_int_addx();break;
	case 278:	break;// dcbt data cache block touch, we dont care
	case 279:	trx_ppc_int_lhzx();break;
	case 284:	trx_ppc_int_eqvx(); break;
	case 306:	break;//trx_ppc_int_tlbie();break;
	case 316:	trx_ppc_int_xorx();break;
	case 339:	trx_ppc_int_mfspr();break;
	case 343:	trx_ppc_int_lhax(); break;
	case 371:	trx_ppc_int_mftb();break;
	case 407:	trx_ppc_int_sthx();break;
	case 412:	trx_ppc_int_orcx();break;
	case 444:	trx_ppc_int_orx();break;
	case 459:	trx_ppc_int_divwux();break;
	case 467:	trx_ppc_int_mtspr();break;
	case 470:	break; // dcbi data cache block invalidate, we dont care
	case 476:	trx_ppc_int_nandx(); break;
	case 491:	trx_ppc_int_divwx();break;
	case 512:	trx_ppc_int_mcrxr();break;
	case 534:	trx_ppc_int_lwbrx(); break;
	case 535:	trx_ppc_int_lfsx(); break;
	case 536:	trx_ppc_int_srwx();break;
	case 566:	printf("warning ! tlbsync() called\n");break;
	case 567:	trx_ppc_int_lfsux();break;
	case 595:	trx_ppc_int_mfsr();break;
	case 597:	trx_ppc_int_lswi();break;
	case 598:	break; // sync we dont care about it.
	case 599:	trx_ppc_int_lfdx(); break;
	case 631:	trx_ppc_int_lfdux();break;
	case 662:	trx_ppc_int_stwbrx(); break;
	case 659:	trx_ppc_int_mfsrin();break;
	case 663:	trx_ppc_int_stfsx();break;
	case 695:	trx_ppc_int_stfsux(); break;
	case 725:	trx_ppc_int_stswi(); break;
	case 727:	trx_ppc_int_stfdx();break;
	case 759:	trx_ppc_int_stfdux();break;
	case 790:	trx_ppc_int_lhbrx();break;
	case 792:	trx_ppc_int_srawx();break;
	case 824:	trx_ppc_int_srawix();break;
	case 918:	trx_ppc_int_sthbrx();break;
	case 922:	trx_ppc_int_extshx();break;
	case 954:	trx_ppc_int_extsbx();break;
	case 982:	break; // icbc Instruction Cache Block Invalidate, we dont care,we snoop for self modifying code like x86
	case 983:	trx_ppc_int_stfiwx();break;
	case 1014:  trx_ppc_int_dcbz(); break;
	default:
		{
			char buf[64], opStr[16], parmStr[32];
			uint32 target;
			
			GekkoDisassemble(opStr, parmStr, trxCPUint.opcode, trxCPUint.pc, &target);
			sprintf(buf, "%-10s %s", opStr, parmStr);    
			printf("[trxCPUint] Group31: %.8X  %.8X  %s\n", trxCPUint.pc, trxCPUint.opcode, buf);
			printf("[trxCPUint] Group31 unhandled op: %d\n", (trxCPUint.opcode>>1)& 0x3ff);
			exit(0);
		}
		break;
	}
}
// main opcode 59
void trx_ppc_int_group59()
{
	if ((trxCPUint.msr & MSR_FP) == 0) 
	{
		trx_ppc_exception(PPC_EXC_NO_FPU, 0);
		return;
	}

	uint32 ext = ((trxCPUint.opcode>>1)&0x3ff);

	switch (ext & 0x1f) 
	{
		case 18: trx_ppc_int_fdivsx(); break;
		case 20: trx_ppc_int_fsubsx(); break;
		case 21: trx_ppc_int_faddsx(); break;
//		case 22: ppc_alt_int_fsqrtsx(); return;
		case 24: trx_ppc_int_fresx(); return;
		case 25: trx_ppc_int_fmulsx(); break;
		case 28: trx_ppc_int_fmsubsx(); return;
		case 29: trx_ppc_int_fmaddsx(); break;
		case 30: trx_ppc_int_fnmsubsx(); break;
		case 31: trx_ppc_int_fnmaddsx(); break;
		default:
			{
			char buf[64], opStr[16], parmStr[32];
			uint32 target;
				
			GekkoDisassemble(opStr, parmStr, trxCPUint.opcode, trxCPUint.pc, &target);
			sprintf(buf, "%-10s %s", opStr, parmStr);    
			printf("[trxCPUint] Group59: %.8X  %.8X  %s\n", trxCPUint.pc, trxCPUint.opcode, buf);
			printf("[trxCPUint] Group59 unhandled op: %d\n", (trxCPUint.opcode>>1)& 0x3ff);
			exit(0);
			}
	}
}
// main opcode 63, floating point instructions
void trx_ppc_int_group63()
{
	if ((trxCPUint.msr & MSR_FP) == 0) 
	{
		trx_ppc_exception(PPC_EXC_NO_FPU, 0);
		return;
	}

	if (((trxCPUint.opcode>>1)&0x3ff) & 16) 
	{
		switch (((trxCPUint.opcode>>1)&0x3ff) & 0x1f) 
		{
		case 18: trx_ppc_int_fdivx(); return;
		case 20: trx_ppc_int_fsubx(); return;
		case 21: trx_ppc_int_faddx(); return;
		//case 22: ppc_alt_fsqrtx(); return;
		//case 23: trx_ppc_int_fsel(); return;
		case 25: trx_ppc_int_fmulx(); return;
		case 26: trx_ppc_int_frsqrtex(); return;
		case 28: trx_ppc_int_fmsubx(); return;
		case 29: trx_ppc_int_fmaddx(); return;
		case 30: trx_ppc_int_fnmsubx(); return;
		//case 31: ppc_alt_fnmaddx(); return;
		}
	} else {
		switch (((trxCPUint.opcode>>1)&0x3ff)) 
		{
		case 0: trx_ppc_int_fcmpu(); return;
		case 12: trx_ppc_int_frspx(); return;
		case 14: trx_ppc_int_fctiwx(); return;
		case 15: trx_ppc_int_fctiwzx(); return;
		//--
		case 32: trx_ppc_int_fcmpo(); return;
		case 38: trx_ppc_int_mtfsb1x(); return;
		case 40: trx_ppc_int_fnegx(); return;
		case 64: trx_ppc_int_mcrfs(); return;
		case 70: trx_ppc_int_mtfsb0x(); return;
		case 72: trx_ppc_int_fmrx(); return;
		//case 134: ppc_opc_mtfsfix(); return;
		case 136: trx_ppc_int_fnabsx(); return;
		case 264: trx_ppc_int_fabsx(); return;
		case 583: trx_ppc_int_mffsx(); return;
		case 711: trx_ppc_int_mtfsfx(); return;
		}
	}

	{
		{
			char buf[64], opStr[16], parmStr[32];
			uint32 target;
				
			GekkoDisassemble(opStr, parmStr, trxCPUint.opcode, trxCPUint.pc, &target);
			sprintf(buf, "%-10s %s", opStr, parmStr);    
			printf("[trxCPUint] Group63: %.8X  %.8X  %s\n", trxCPUint.pc, trxCPUint.opcode, buf);
			printf("[trxCPUint] Group63 unhandled op: %d\n", (trxCPUint.opcode>>1)& 0x3ff);
			exit(0);
		}
	}
}

// decode and interpretively execute a single instruction
void trx_cpu_interpret_single(void)
{
	if( (((trxCPUint.opcode>>26) & 0x3f) == 4) || (((trxCPUint.opcode>>26) & 0x3f) > 47) )
	{
		if ((trxCPUint.msr & MSR_FP) == 0) 
		{
			trx_ppc_exception(PPC_EXC_NO_FPU, 0);
			return;
		}
	}

	// decode and execute
	switch((trxCPUint.opcode>>26) & 0x3f)
	{
	case 4:		trx_ppc_int_gekko();break;
	case 7:		trx_ppc_int_mulli();break;
	case 8:		trx_ppc_int_subfic();break;
	case 10:	trx_ppc_int_cmpli();break;
	case 11:	trx_ppc_int_cmpi();break;
	case 12:	trx_ppc_int_addic();break;
	case 13:	trx_ppc_int_addic_();break;
	case 14: 	trx_ppc_int_addi(); break;
	case 15:	trx_ppc_int_addis(); break;
	case 16:	trx_ppc_int_bcx(); break;
	case 17:	trx_ppc_int_sc(); break;
	case 18:	trx_ppc_int_bx(); break;
	case 19:	trx_ppc_int_group19(); break;
	case 20:	trx_ppc_int_rlwimix();break;
	case 21:	trx_ppc_int_rlwinmx();break;
	case 23:	trx_ppc_int_rlwnmx(); break;
	case 24:	trx_ppc_int_ori();break;
	case 25:	trx_ppc_int_oris();break;
	case 26:	trx_ppc_int_xori(); break;
	case 27:	trx_ppc_int_xoris();break;
	case 28:	trx_ppc_int_andi_();break;
	case 29:	trx_ppc_int_andis_(); break;
	case 31:	trx_ppc_int_group31(); break;
	case 32:	trx_ppc_int_lwz(); break;
	case 33:	trx_ppc_int_lwzu(); break;
	case 34:	trx_ppc_int_lbz(); break;
	case 35:	trx_ppc_int_lzbu(); break;
	case 36:	trx_ppc_int_stw(); break;
	case 37:	trx_ppc_int_stwu(); break;
	case 38:	trx_ppc_int_stb(); break;
	case 39:	trx_ppc_int_stbu(); break;
	case 40:	trx_ppc_int_lhz();break;
	case 41:	trx_ppc_int_lhzu();break;					
	case 42:	trx_ppc_int_lha();break;					
	case 43:	trx_ppc_int_lhau();break;					
	case 44:	trx_ppc_int_sth(); break;
	case 45:	trx_ppc_int_sthu(); break;
	case 46:	trx_ppc_int_lmw(); break;
	case 47:	trx_ppc_int_stmw(); break;	
	case 48:	trx_ppc_int_lfs();break;
	case 49:	trx_ppc_int_lfsu(); break;
	case 50:	trx_ppc_int_lfd();break; 
	case 51:	trx_ppc_int_lfdu();break; 
	case 52:	trx_ppc_int_stfs();break; 
	case 53:	trx_ppc_int_stfsu(); break;
	case 54:	trx_ppc_int_stfd(); break;
	case 55:	trx_ppc_int_stfdu(); break;
	case 56:	trx_ppc_int_psq_l(); break;
	case 57:	trx_ppc_int_psq_lu(); break;
	case 59:	trx_ppc_int_group59(); break;// floating point opcodes
	case 60:	trx_ppc_int_psq_st(); break;
	case 61:	trx_ppc_int_psq_stu(); break;
	case 63:	trx_ppc_int_group63(); break;
	default:
		printf("[trxCPUint] unhandled op: %d at: %x\n", (trxCPUint.opcode>>26), trxCPUint.pc);
		exit(0);
		break;
	}
}