/*====================================================================

filename:     asm_x86.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#ifndef ASM_X86_H
#define ASM_X86_H

// counts number of instructions assembled in total
extern uint32 gen_asm_total;

void gen_asm(uint32 opcode, uint32 arg1 = 0, uint32 arg2 = 0, uint32 arg3 = 0);

enum genasm_regnames
{
	EAX = 0,
	ECX,
	EDX,
	EBX,
	ESP,
	EBP,
	ESI,
	EDI
};
enum genasm_regnames8
{
	AL = 0,
	CL,
	DL,
	BL,
	AH,
	CH,
	DH,
	BH
};

enum genasm_types
{
	SETC_R8,
	OR_R8R8,
	MOV_MR8,
	MOV_RR,
	MOV_RM,
	MOV_MR,
	MOV_RI32,
	MOV_RMRI32,
	MOV_MRRI32,
	MOV_R8MRI32,
	MOV_M8RRI32,
	MOV_R16MRI32,
	MOV_M16RRI32,
	MOV_M32I32,
	CMP_M32I8,
	SUB_M32I8,
	SUB_M32I32,
	MOVSX3216_RR,
	MOVSX328_RR,
	TEST_RR,
	BSR_RR,
	XOR_RR,
	XOR_RI32,
	XOR_RM,
	OR_RR,
	OR_RI32,
	OR_RM,
	SUB_RR,
	SUB_RI32,
	SUB_RM,
	ADD_RI32,
	ADD_RI8,
	ADD_RM,
	ADD_MRI32I8,
	ADD_RR,
	AND_RI32,
	AND_RM,
	AND_RR,
	CMP_RI32,
	CMP_RM,
	CMP_RR,
	ADC_RM,
	ROL_RI8,
	ROL_CL,
	SHL_RI8,
	SHL_CL,
	SHR_RI8,
	SHR_CL,
	SAR_RI8,
	SAR_CL,
	PUSH_R,
	PUSH_I32,
	JNE_I8,
	JNE_I32,
	JE_I8,
	JAE_I8,
	JS_I8,
	JS_I32,
	JMP_I8,
	JMP_M,
	MUL_R,
	POP_R,
	CALL_M,
	CALL_R,
	JMP_R,
	CMOVG_M,
	CMOVL_M,
	CMOVA_M,
	CMOVB_M,
	CMOVE_M,
	CMOVNE_M,
	CMOVP_M,
	CMOVE_R,
	CMOVNE_R,
	SETC_M,
	SETNE_M,
	INC_R,
	NOT_R,
	NEG_R,
	DIV_R,
	IDIV_R,
	IMUL_R,
	BSWAP_R,
	RET,
	BREAK,
	FLD32_M,
	FLD64_M,
	FSTP32_M,
	FSTP64_M,
	FST32_M,
	FST64_M,
	FISTP64_M,
	FISTP32_M,
	FLD1,
	FLDZ,
	FSUB64_M,
	FADD64_M,
	FMUL64_M,
	FDIV64_M,
	FCHS,
	FUCOMIP,
	FSQRT,
	FDIV,
	FCMOVB_M,
	FCMOVU_M,
	FCMOVNB_M,
	FPOP,
	FNSTCW_M,
	FLDCW_M,
	CDQ,
	MOV_R8I8,
	SUB_R8R8,
	MOV_R8R8,
	SETNE_R8,
	TEST_R8R8,
	XCHG_R8R8,
	MOVAPD_RM,
	MOVAPD_RMRI32,
	MOVAPD_MR,
	MOVAPD_RR,
	MOVLPD_RM,
	MOVLPD_MR,
	MOVHPD_RM,
	MOVHPD_MR,
	DIVSD_RR,
	SHUFPD_RR,
	SUBSD_RR,
	MOVSD_RR,
	MULSD_RR,
	XORPD_RM,
	CVTSD2SS_RR,
	CVTSS2SD_RR,
	ANDPD_RM,
	ORPD_RM,
	ADDSD_RR,
	SQRTSD_RR,
	UCOMISD_RR,
	CVTTSD2SI_RR,
	CVTSD2SI_RR,
	MULPD_RR,
	SUBPD_RR,
	ADDPD_RR,
	DIVPD_RR,
	SQRTPD_RR
};
#endif
