#include "ogl.h"

#include <stdio.h>
#include <windows.h>
#include <GL/glew.h>
//#include <GL/wglew.h>
#include "debug/tracers.h"

typedef void (APIENTRY * WGLSWAPINTERVALEXT) (int);

static HDC		ogl_hdc;
static HGLRC	ogl_hrc;
static HWND		ogl_wnd;

bool ogl_set_pixel_format(HDC hdc);
void ogl_error(void);

void ogl_init(HWND wnd)
{
	int Width = 640;
	int Height = 480;

	ogl_wnd = wnd;
	ogl_hdc = GetDC(ogl_wnd);

	if (!ogl_set_pixel_format(ogl_hdc))						// This sets our pixel format/information
		ogl_error();

	ogl_hrc = wglCreateContext(ogl_hdc);

	if(ogl_hrc == NULL)
		ogl_error();
	//printf("hdc: %08x, hrc: %08x\n", w32_hdc, w32_hrc);

	if (!wglMakeCurrent(ogl_hdc, ogl_hrc))
		ogl_error();

	if(glewInit() != GLEW_OK)
	{
		syslog_error(MAIN, "Cannot initialize GLEW\n");
	}



	glViewport(0, 0, Width, Height);
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glEnable(GL_DEPTH_TEST);
	glShadeModel(GL_SMOOTH);

	// do not sync to vsync
//	wglSwapIntervalEXT(0);
}

void ogl_info(void)
{
	GLint result;
	glGetIntegerv(GL_MAX_TEXTURE_UNITS, &result);
	printf("Texture Units: %d\n", result);
	glGetIntegerv(GL_MAX_TEXTURE_IMAGE_UNITS_ARB, &result);
	printf("Texture Image Units: %d\n", result);
	glGetIntegerv(GL_MAX_TEXTURE_COORDS_ARB, &result);
	printf("Texture Image Coords: %d\n", result);
	glGetIntegerv(GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB, &result);
	printf("Fragment Uniform Components: %d\n", result);
	

	printf("OpenGL version %s\n", glGetString(GL_VERSION));
	printf("Supported extensions: %s\n", glGetString(GL_EXTENSIONS));

	GLint temp, temp1, temp2;

	printf("Vertex Shader:\n");
	glGetProgramivARB(GL_VERTEX_PROGRAM_ARB, GL_MAX_PROGRAM_INSTRUCTIONS_ARB, &temp1);
	glGetProgramivARB(GL_VERTEX_PROGRAM_ARB, GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB, &temp2);
	if (temp1 != temp2)
	{
		printf(" instructions: %d != native instructions: %d\n", temp1, temp2);
	}
	else
	{
		printf(" instructions: %d\n", temp1);
	}
	glGetProgramivARB(GL_VERTEX_PROGRAM_ARB, GL_MAX_PROGRAM_PARAMETERS_ARB, &temp);
	printf(" parameters: %d\n", temp);

	printf("Fragment Shader:\n");
	glGetProgramivARB(GL_FRAGMENT_PROGRAM_ARB, GL_MAX_PROGRAM_INSTRUCTIONS_ARB, &temp1);
	glGetProgramivARB(GL_FRAGMENT_PROGRAM_ARB, GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB, &temp2);
	if (temp1 != temp2)
	{
		printf(" instructions: %d != native instructions: %d\n", temp1, temp2);
	}
	else
	{
		printf(" instructions: %d\n", temp1);
	}
	glGetProgramivARB(GL_FRAGMENT_PROGRAM_ARB, GL_MAX_PROGRAM_PARAMETERS_ARB, &temp);
	printf(" parameters: %d\n", temp);
	glGetProgramivARB(GL_FRAGMENT_PROGRAM_ARB, GL_MAX_PROGRAM_TEMPORARIES_ARB, &temp);
	printf(" temporaries: %d\n", temp);
	glGetProgramivARB(GL_FRAGMENT_PROGRAM_ARB, GL_MAX_PROGRAM_ENV_PARAMETERS_ARB, &temp);
	printf(" env parameters: %d\n", temp);
}

void ogl_finish_render(void)
{
	glFlush();
	SwapBuffers(ogl_hdc);
}



void ogl_error(void)
{
	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL );
	syslog_error(MAIN, "%s\n", (char *)lpMsgBuf);
}


#define SCREEN_DEPTH 32


bool ogl_set_pixel_format(HDC hdc) 
{ 
	PIXELFORMATDESCRIPTOR pfd; 
	int pixelformat; 

	pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);			// Set the size of the structure
	pfd.nVersion = 1;									// Always set this to 1
	// Pass in the appropriate OpenGL flags
	pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER; 
	pfd.dwLayerMask = PFD_MAIN_PLANE;					// We want the standard mask (this is ignored anyway)
	pfd.iPixelType = PFD_TYPE_RGBA;						// We want RGB and Alpha pixel type
	pfd.cColorBits = SCREEN_DEPTH;						// Here we use our #define for the color bits
	pfd.cDepthBits = SCREEN_DEPTH;						// Depthbits is ignored for RGBA, but we do it anyway
	pfd.cAccumBits = 0;									// No special bitplanes needed
	pfd.cStencilBits = 0;								// We desire no stencil bits

	// This gets us a pixel format that best matches the one passed in from the device
	if ( (pixelformat = ChoosePixelFormat(hdc, &pfd)) == FALSE ) 
	{ 
		syslog_error(MAIN, "ChoosePixelFormat failed\n");
	} 

	// This sets the pixel format that we extracted from above
	if (SetPixelFormat(hdc, pixelformat, &pfd) == FALSE) 
	{ 
		syslog_error(MAIN, "SetPixelFormat failed\n");
	} 

	return TRUE;										// Return a success!
}


