#pragma once

//#define WITH_PBUFFER			1

#define WITH_REAL_DSP			1
#define WITH_DSP_ON_THREAD		1

#if !WITH_REAL_DSP
#undef WITH_DSP_ON_THREAD
#define WITH_DSP_ON_THREAD		0
#endif

#define WITH_FRAGMENT_SHADER	1
#define	WITH_VERTEX_SHADER_GENERATOR	1
#define WITH_VERTEX_SHADER		0
#define WITH_CG					0

#define HOTBLOCK_PROFILE		0

#define WITH_PALETTED_AT_SHADER	1

#if WITH_PALETTED_AT_SHADER && !WITH_FRAGMENT_SHADER
#error Cannot make paletted textures at shader if shader is disabled :)
#endif

enum ecpumodes
{
	CPU_RECOMPILER,
	CPU_INTERPRETER,
	CPU_SELFCHECKMODE
};

// runtime configuration options
extern int	config_cpumode; // part of CPU actually
extern int	config_disable_sse2;
extern int  config_stackinram;
extern int	config_skipidle;
extern int config_region; 
extern int	config_instructions_per_line;
extern int	config_debugasm;
extern int	config_constantaddress;
// hotkey logging button
extern int config_hotkeylogging;
extern int config_debug;

#define VART_BOOL   0
#define VART_INT    1
#define VART_FUNC   2
#define VART_FUNCP  3

typedef struct
{
    int     type;
    char    *name;
	char	short_name;
    int     *var;
    int     value;
    int     (*function)(char *);    
    char    *description;
}variable_def_t;

void config_init(void);
int config_help(char *a);
unsigned char config_variable(char *varname);
