#include "config.h"

#include <d3d9.h>
#include <stdio.h>
#include <stdlib.h>
#include "texture_cache.h"
#include "gx_cache.h"
#include "system/types.h"
#include "d3d_fun.h"

typedef struct
{
	uint32	addr;
	void	*tex;
} texture_cache_entry_t;

#define TC_BLOCK_SIZE 32
texture_cache_entry_t tc_cache[24 * 1024 * 1024 / TC_BLOCK_SIZE];

void tc_init(void)
{
	uint32 i;
	for(i = 0 ; i < 24 * 1024 * 1024 / TC_BLOCK_SIZE ; i++)
	{
		tc_cache[i].addr = 0xffffffff;
		tc_cache[i].tex = 0;
	}
}
void tc_invalidate_entry(uint32 tex_addr)
{
	uint32 cache_entry = tex_addr / TC_BLOCK_SIZE;
	tc_cache[cache_entry].addr = 0xffffffff;
	if (tc_cache[cache_entry].tex)
	{
		// TODO: Implement deleting of texture 
		//glDeleteTextures(1, (GLuint *)&tc_cache[cache_entry].tex);
		d3d_delete_texture(tc_cache[cache_entry].tex);
		tc_cache[cache_entry].tex = NULL;
	}
}
void * tc_check(uint32 tex_addr, uint32 tex_size, void **tex_name)
{
	uint32 cache_entry = tex_addr / TC_BLOCK_SIZE;
	if (tc_cache[cache_entry].addr == 0xffffffff)
		return NULL;
	if (tc_cache[cache_entry].addr == tex_addr)
	{
		// cache hit, now check if valid
		if(0 == gx_cache_check(tex_addr, tex_size))
		{
			// cache hit, texture is cached
			//fprintf(stderr, "@");
			*tex_name = tc_cache[cache_entry].tex;
			return tc_check;//tc_cache[cache_entry].tex;
		}
		else
		{
			// part of texture has been invalidated
			tc_invalidate_entry(tex_addr);
			//fprintf(stderr, "texture invalid (addr: %08x size: %08x)", tex_addr, tex_size);
			return NULL;
		}
	}
	else
	{
		fprintf(stderr, "location contains wrong entry %08x %08x\n", tc_cache[cache_entry].addr, tex_addr);
	}
	return NULL;
}

void tc_store_entry(uint32 tex_addr, void *pc_addr, void *tex)
{
	uint32 cache_entry = tex_addr / TC_BLOCK_SIZE;
	if (tc_cache[cache_entry].addr != 0xffffffff)
	{
		fprintf(stderr, "texture cache not empty %08x (new: %08x), strange! DEBUG!\n", tc_cache[cache_entry].addr, tex_addr);
		tc_invalidate_entry(tex_addr);
	}
	tc_cache[cache_entry].tex = tex;
	tc_cache[cache_entry].addr = tex_addr;
}

