#include <d3d9.h>
#include <dxerr9.h>
#include <Windows.h>
#include <stdio.h>
#include "debug/tracers.h"
#include "d3d_fun.h"
#include "byteswap.h"


IDirect3D9 *g_pD3D = NULL;
IDirect3DDevice9 *g_pd3dDevice = NULL;
IDirect3DVertexBuffer9 *g_pVB = NULL;


void d3d_error(char *fun, HRESULT hr)
{
	syslog_error(DXX, "%s: %s %s\n", fun, DXGetErrorString9(hr), DXGetErrorDescription9(hr));
}
void d3d_init(void)
{
	g_pD3D = Direct3DCreate9( D3D_SDK_VERSION);
	if(!g_pD3D)
	{
		d3d_error("Direct3DCreate9", 0);
	}
}

void d3d_shutdown(void)
{
	if(g_pD3D)
	{
		g_pD3D->Release();
		g_pD3D=NULL;
	}
}

void d3d_beginscene(void)
{
	syslog(DXX, "Begin of scene\n");

	g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0, 0, 0), 1.0f, 0 );

	g_pd3dDevice->BeginScene();
}

bool d3d_open(HWND wnd)
{
	HRESULT hr;
	D3DPRESENT_PARAMETERS pp;
	D3DFORMAT format = D3DFMT_A8R8G8B8;//  D3DFMT_R5G6B5; //For simplicity we'll hard-code this for now.

	hr = g_pD3D->CheckDeviceType(	D3DADAPTER_DEFAULT,//Adapter
									D3DDEVTYPE_HAL,    //DeviceType
									D3DFMT_R5G6B5,     //DisplayFormat
									D3DFMT_R5G6B5,     //BackBufferFormat
									false);            //Windowed

	//d3d_error("CheckDeviceType", hr);
	//exit(0);

	D3DDISPLAYMODE pMode;
	g_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &pMode);
	int i;
	for (i = 0 ; i < 1000 ; i++)
	{
		hr = g_pD3D->CheckDeviceFormat(	D3DADAPTER_DEFAULT, 
			D3DDEVTYPE_HAL, 
			pMode.Format, 
			0, 
			D3DRTYPE_TEXTURE, 
			(D3DFORMAT)i);
		if (SUCCEEDED(hr))
			syslog(DXX, "SUP: %d\n", i);
	}
	
	//exit(0);
	
	ZeroMemory(&pp, sizeof(D3DPRESENT_PARAMETERS));

	pp.BackBufferCount = 1;						// We only need a single back buffer
	pp.BackBufferFormat = D3DFMT_UNKNOWN;
	pp.MultiSampleType = D3DMULTISAMPLE_NONE;	// No multi-sampling
	pp.MultiSampleQuality = 0;					// No multi-sampling
	pp.SwapEffect = D3DSWAPEFFECT_DISCARD;		// Throw away previous frames, we don't need them
	pp.hDeviceWindow = wnd;						// This is our main (and only) window
	pp.Flags = D3DPRESENTFLAG_DISCARD_DEPTHSTENCIL;									// No flags to set
	pp.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT; //Default Refresh Rate
	pp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE; //D3DPRESENT_INTERVAL_DEFAULT;  - Use to sync
	pp.BackBufferFormat = format;      //Display format
	pp.EnableAutoDepthStencil = TRUE; //No depth/stencil buffer
	pp.AutoDepthStencilFormat = D3DFMT_D24X8;
	pp.Windowed = TRUE;

	hr = g_pD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, wnd, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &pp, &g_pd3dDevice);
	
	if (FAILED(hr))	d3d_error("CreateDevice", hr);

	g_pd3dDevice->SetRenderState(D3DRS_FILLMODE, D3DFILL_SOLID);
	//g_pd3dDevice->SetRenderState(D3DRS_FILLMODE, D3DFILL_WIREFRAME);
	
	g_pd3dDevice->SetRenderState(D3DRS_LIGHTING, FALSE);

	g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);

	g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);

	g_pd3dDevice->SetRenderState(D3DRS_NORMALIZENORMALS, FALSE);

	// this should be only enabled when needed
	for(i = 0 ; i < 8 ; i++)
		g_pd3dDevice->SetTextureStageState(i, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );

	D3DCAPS9 caps;
	int max_tex_size;

	g_pd3dDevice->GetDeviceCaps(&caps);

	max_tex_size=caps.MaxTextureWidth;
	if(caps.TextureCaps & D3DPTEXTURECAPS_POW2)
	{
		fprintf(stderr, "DX9 pot textures\n");
		if(caps.TextureCaps & D3DPTEXTURECAPS_NONPOW2CONDITIONAL)
		{
			fprintf(stderr, "DX9 npot textures conditional\n");
		}
	}
	return true;
}


void d3d_endscene(void)
{
	//HRESULT hr;

/*
	VOID* pVertices;
	hr = g_pVB->Lock(0, sizeof(test), (void**)&pVertices, 0);
	if (FAILED(hr))
	    d3d_error("Lock", hr);
	memcpy( pVertices, test_buffer, sizeof(test) );
	g_pVB->Unlock();

   g_pd3dDevice->SetStreamSource(0,                   //StreamNumber
                                 g_pVB,           //StreamData
                                 0,                   //OffsetInBytes
                                 sizeof(tri_vertex2)); //Stride
*/
	//g_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0, 8);
	//g_pd3dDevice->DrawPrimitiveUP(D3DPT_TRIANGLELIST, 8, test_buffer, sizeof(tri_vertex2));	

	D3DVIEWPORT9 vp;
	vp.X = 0;
	vp.Y = 0;
	vp.Width = 640;
	vp.Height = 480;
	vp.MaxZ = 1.0;
	vp.MinZ = 0;
	g_pd3dDevice->SetViewport(&vp);

	g_pd3dDevice->EndScene();
	g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	static uint32 dxx_scene = 0;
	syslog(DXX, "End of scene %d\n", dxx_scene++);
}

D3DFORMAT d3d_texture_format[] = 
{
	D3DFMT_A8R8G8B8, D3DFMT_A8R8G8B8,
};

void *d3d_create_texture(uint32 fmt, uint32 w, uint32 h, void *bits)
{
	HRESULT hr;

	IDirect3DTexture9	*pd3dTexture;
	IDirect3DSurface9	*pd3ds_Src;
	IDirect3DSurface9	*pd3ds_Dst;

	D3DLOCKED_RECT		pLockedRect;

	D3DFORMAT			format;


	format = d3d_texture_format[fmt];
	// Textures can be made either static or dynamic
	
	// Static textures
	hr = g_pd3dDevice->CreateTexture(w, h, 0, 0, format, D3DPOOL_DEFAULT, &pd3dTexture, NULL);
	if (FAILED(hr))	d3d_error("CreateTexture", hr);

	hr = g_pd3dDevice->CreateOffscreenPlainSurface(w, h, format, D3DPOOL_SYSTEMMEM, &pd3ds_Src, NULL);
	if (FAILED(hr))	d3d_error("CreateOffscreenPlainSurface", hr);

	hr = pd3ds_Src->LockRect(&pLockedRect, NULL, D3DLOCK_DISCARD);
	if (FAILED(hr))	d3d_error("LockRect", hr);

	int i;
	uint32 xx = 0x000000ff;
	switch(fmt)
	{
	case D3D_GC_TF_I8:
		for(i = 0 ; i < w * h ; i++)
		{
			uint32 val = ((uint8 *)bits)[i];
			//val = xx;
			//if (i == 0) val = 0x00ff0000;
			val = val << 16 | val << 8 | val;
			((uint32 *)(pLockedRect.pBits))[i] = val;
		}
		break;
	case D3D_GC_TF_ARGB8:
		for(i = 0 ; i < w * h ; i++)
		{
			uint32 val = ((uint32 *)bits)[i];
			
			//val = byteswap32(val);
			//val = (val >> 24) | (val << 8);
			val =  (val & 0xff00ff00) | (val & 0x00ff0000) >> 16 | (val & 0x000000ff) << 16;
			((uint32 *)(pLockedRect.pBits))[i] = val;
		}
		break;
	default:
		syslog_error(DXX, "Unsupported Texture format\n");
		break;
	}

	pd3ds_Src->UnlockRect();


	hr = pd3dTexture->GetSurfaceLevel(0, &pd3ds_Dst);
	if (FAILED(hr))	d3d_error("GetSurfaceLevel", hr);

	hr = g_pd3dDevice->UpdateSurface(pd3ds_Src, NULL, pd3ds_Dst, NULL);
	if (FAILED(hr))	d3d_error("UpdateSurface", hr);

	pd3ds_Dst->Release();
	pd3ds_Src->Release();

	return pd3dTexture;
}

void d3d_delete_texture(void *tex)
{
	((IDirect3DTexture9 *)tex)->Release();
}

void d3d_set_texture(uint32 id, void *tex)
{
	g_pd3dDevice->SetTexture(id, (IDirect3DTexture9 *)tex);
}