#pragma once

typedef unsigned char	uint8;
typedef unsigned short	uint16;
typedef unsigned int	uint32;

#ifdef _WINDOWS
typedef __int64 uint64;
#else
typedef unsigned long long uint64;
#endif

typedef unsigned int	uint;
typedef signed char	sint8;
typedef signed short	sint16;
typedef signed int	sint32;

#ifdef _WINDOWS
typedef __int64 sint64;
//#define sint64 __int64 
#else
typedef signed long long sint64;
#endif

typedef unsigned char bool;
#define true  1
#define false 0

//-----------------------------------------------------//
// vertex defines
                                                       
typedef union
{
	uint32	i;
	struct
	{
		sint16	ss;
		sint16	ignore1;
	};
	struct
	{
		uint16	us;
		uint16	ignore2;
	};
	struct
	{
		uint8	ub;
		uint8	ub_ignore1;
		uint8	ub_ignore2;
		uint8	ub_ignore3;
	};
	struct
	{
		sint8	sb;
		sint8	sb_ignore1;
		sint8	sb_ignore2;
		sint8	sb_ignore3;
	};
	float	f;
} vx_vertex_t;

typedef union
{
	sint8	*sbp;
	uint8	*ubp;
	sint16	*ssp;
	uint16	*usp;
	sint32	*slp;
	uint32	*ulp;
	float	*fp;
} vx_vertex_ptr_t;


typedef union 
{
	uint32	i;
	float	f;
} gp_reg;

//-------------------------------------//

typedef struct bp_efb_info_tag
{
 uint32     xfb_address;

 int        left;
 int        top;
 int        right;
 int        bottom;

 int        yscale;

} bp_efb_info;
         
//-------------------------------------//


#define NUM_CBTS	1
#define CBT_IRQ_SIGNAL	0

typedef struct
{
	uint32 id;
	void (*fn)(void);
} gxcb_t;

//-------------------------------------//
