/***************************************************************************
                   ogl_vertex_processor.c  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2005 by Duddie
    email                : duddie@walla.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2005/06/04 - Pete
// - fixed tex coord of stage 4
//
// there are lotta things to do here, methinks
//
//*************************************************************************//

#include "stdafx.h"
#include "vertex_processor.h"
#include "fragment_shader_gen.h"
#define _IN_VTX_PROC
#include "externals.h"


///////////////////////////////////////////////////////////////////////////
// GLOBALS + DEFINES

#define STRUT_LN        130     // long side of strut
#define STRUT_SD        4       // short side of strut
#define JOINT_SD        10      // joint is a cube

vx_vertex_ptr_t vx_vertex_ptr;
uint8           vx_vertex_data_ub[VX_MAX_CMDS * 4 * 4];
uint8 *         vx_vertex_data_size;
uint32          vx_started=0;

// three parameters describe almost every data: type, cnt, fmt
// fmt is the 

enum vx_type
{
    VX_T_NONE = 0,
    VX_T_NORM,
    VX_T_IDX8,
    VX_T_IDX16
};

enum vx_form
{
    VX_F_U8 = 0,
    VX_F_S8,
    VX_F_U16,
    VX_F_S16,
    VX_F_F32,
};

enum vx_col_fmt
{
    VX_F_RGB565 = 0,
    VX_F_RGB8,
    VX_F_RGBX8,
    VX_F_RGBA4,
    VX_F_RGBA6,
    VX_F_RGBA8
};


typedef struct
{
    // maximum 22 different values describing vertex. Actually 21 + 1 NULL
    // however position 0 is reserved for POS processor
    void    (*jump_table[22])(uint32);
    uint32  param[22];
    uint8   expected_size[VX_MAX_CMDS];
    uint32  size;           // one packet size
    uint32  vcd_lo, vcd_hi, vat_a, vat_b, vat_c;
    uint32  cmd_count;
} vx_table_t;

typedef struct
{
    void    (*processor)(uint32);
    uint32  exp_size;
    uint32  exp_count;
} vx_command_t;

// prototype
uint32 vx_get_text_vat(uint32 vat, uint32 i);

// 8 tables for 8 vertex descriptors
vx_table_t vx_table[8];
vx_table_t *vx_table_selected;


///////////////////////////////////////////////////////////////////////////
// tables
///////////////////////////////////////////////////////////////////////////

vx_command_t vx_cmds_pos_n[16] =
{
    // VAT_A bit 0 - XY/XYZ bits 1-3 FMT
    vx_pos_n_xy_u8,         1,  2,      // VX_F_U8 | VX_C_XY
    vx_pos_n_xyz_u8,        1,  3,      // VX_F_U8 | VX_C_XYZ
    vx_pos_n_xy_s8,         1,  2,      // VX_F_S8 | VX_C_XY
    vx_pos_n_xyz_s8,        1,  3,      // VX_F_S8 | VX_C_XYZ
    vx_pos_n_xy_u16,        2,  2,      // VX_F_U16 | VX_C_XY
    vx_pos_n_xyz_u16,       2,  3,      // VX_F_U16 | VX_C_XYZ
    vx_pos_n_xy_s16,        2,  2,      // VX_F_S16 | VX_C_XY
    vx_pos_n_xyz_s16,       2,  3,      // VX_F_S16 | VX_C_XYZ
    vx_pos_n_xy_f32,        4,  2,      // VX_F_F32 | VX_C_XY
    vx_pos_n_xyz_f32,       4,  3,      // VX_F_F32 | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XYZ
};

// pos 
vx_command_t vx_cmds_pos_i8[16] =
{
    // VAT_A bit 0 - XY/XYZ bits 1-3 FMT
    vx_pos_unknown,         1,  1,      // VX_F_U8 | VX_C_XY
    vx_pos_i8_xyz_u8,       1,  1,      // VX_F_U8 | VX_C_XYZ
    vx_pos_i8_xy_s8,        1,  1,      // VX_F_S8 | VX_C_XY
    vx_pos_i8_xyz_s8,       1,  1,      // VX_F_S8 | VX_C_XYZ
    vx_pos_unknown,         1,  1,      // VX_F_U16 | VX_C_XY
    vx_pos_unknown,         1,  1,      // VX_F_U16 | VX_C_XYZ
    vx_pos_i8_xy_s16,       1,  1,      // VX_F_S16 | VX_C_XY
    vx_pos_i8_xyz_s16,      1,  1,      // VX_F_S16 | VX_C_XYZ
    vx_pos_unknown,         1,  1,      // VX_F_F32 | VX_C_XY
    vx_pos_i8_xyz_f32,      1,  1,      // VX_F_F32 | VX_C_XYZ
    vx_pos_unknown,         1,  1,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         1,  1,      // VX_F_UNK | VX_C_XYZ
    vx_pos_unknown,         1,  1,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         1,  1,      // VX_F_UNK | VX_C_XYZ
    vx_pos_unknown,         1,  1,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         1,  1,      // VX_F_UNK | VX_C_XYZ
};

vx_command_t vx_cmds_pos_i16[16] =
{
    // VAT_A bit 0 - XY/XYZ bits 1-3 FMT
    vx_pos_unknown,         2,  1,      // VX_F_U8 | VX_C_XY
    vx_pos_unknown,         2,  1,      // VX_F_U8 | VX_C_XYZ
    vx_pos_unknown,         2,  1,      // VX_F_S8 | VX_C_XY
    vx_pos_i16_xyz_s8,      2,  1,      // VX_F_S8 | VX_C_XYZ
    vx_pos_unknown,         2,  1,      // VX_F_U16 | VX_C_XY
    vx_pos_unknown,         2,  1,      // VX_F_U16 | VX_C_XYZ
    vx_pos_unknown,         2,  1,      // VX_F_S16 | VX_C_XY
    vx_pos_i16_xyz_s16,     2,  1,      // VX_F_S16 | VX_C_XYZ
    vx_pos_unknown,         2,  1,      // VX_F_F32 | VX_C_XY
    vx_pos_i16_xyz_f32,     2,  1,      // VX_F_F32 | VX_C_XYZ
    vx_pos_unknown,         2,  1,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         2,  1,      // VX_F_UNK | VX_C_XYZ
    vx_pos_unknown,         2,  1,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         2,  1,      // VX_F_UNK | VX_C_XYZ
    vx_pos_unknown,         2,  1,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         2,  1,      // VX_F_UNK | VX_C_XYZ
};

// ---------------------- Normal Tables ---------------------------------

vx_command_t vx_cmds_nor_n[16] =
{
    vx_nor_unknown,         7,  5,      // VX_F_U8 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_U8 | VX_N_NBT
    vx_nor_n_nor_s8,        1,  3,      // VX_F_S8 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_S8 | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_U16 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_U16 | VX_N_NBT
    vx_nor_n_nor_s16,       2,  3,      // VX_F_S16 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_S16 | VX_N_NBT
    vx_nor_n_nor_f32,       4,  3,      // VX_F_F32 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_F32 | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
};

vx_command_t vx_cmds_nor_i8[16] =
{
    vx_nor_unknown,         7,  5,      // VX_F_U8 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_U8 | VX_N_NBT
    vx_nor_i8_nor_s8,       1,  1,      // VX_F_S8 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_S8 | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_U16 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_U16 | VX_N_NBT
    vx_nor_i8_nor_s16,      1,  1,      // VX_F_S16 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_S16 | VX_N_NBT
    vx_nor_i8_nor_f32,      1,  1,      // VX_F_F32 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_F32 | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
};

vx_command_t vx_cmds_nor_i16[16] =
{
    vx_nor_unknown,         7,  5,      // VX_F_U8 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_U8 | VX_N_NBT
    vx_nor_i16_nor_s16,     2,  1,      // VX_F_S8 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_S8 | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_U16 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_U16 | VX_N_NBT
    vx_nor_i16_nor_s16,     2,  1,      // VX_F_S16 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_S16 | VX_N_NBT
    vx_nor_i16_nor_f32,     2,  1,      // VX_F_F32 | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_F32 | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NOR
    vx_nor_unknown,         7,  5,      // VX_F_UNK | VX_N_NBT
};
// ----------------------------------------------------------------------

// col
vx_command_t vx_cmds_col_n[16] =
{                      // size  count
    vx_col_unknown,         7,  5,      // VX_F_RGB565 | VX_C_RGB
    vx_col_unknown,         7,  5,      // VX_F_RGB565 | VX_C_RGBA
    vx_col_n_rgb_rgb8,      1,  3,      // VX_F_RGB8   | VX_C_RGB

    vx_col_unknown,         7,  5,      // VX_F_RGB8   | VX_C_RGBA

    vx_col_unknown,         7,  5,      // VX_F_RGBX8  | VX_C_RGB

    vx_col_unknown,         1,  4,      // VX_F_RGBX8  | VX_C_RGBA

    vx_col_unknown,         7,  5,      // VX_F_RGBA4  | VX_C_RGB
    vx_col_n_rgba_rgba4,    2,  1,      // VX_F_RGBA4  | VX_C_RGBA

// fixme 
    vx_col_unknown,         1,  3,      // VX_F_RGBA6  | VX_C_RGB
    vx_col_unknown,         1,  3,      // VX_F_RGBA6  | VX_C_RGBA

    vx_col_unknown,         7,  5,      // VX_F_RGBA8  | VX_C_RGB
//dudd:
//  vx_col_n_rgba_rgba8,    3,   4,      // VX_F_RGBA8  | VX_C_RGBA
    vx_col_n_rgba_rgba8,    1,   4,      // VX_F_RGBA8  | VX_C_RGBA

    vx_col_unknown,         7,  5,      // VX_F_UNK    | VX_C_RGB
    vx_col_unknown,         7,  5,      // VX_F_UNK    | VX_C_RGBA
    vx_col_unknown,         7,  5,      // VX_F_UNK    | VX_C_RGB
    vx_col_unknown,         7,  5,      // VX_F_UNK    | VX_C_RGBA
};

// col
vx_command_t vx_cmds_col_i8[16] =
{
    vx_col_i8_rgb_rgb565,   1,  1,      // VX_F_RGB565 | VX_C_RGB
    vx_col_unknown,         1,  1,      // VX_F_RGB565 | VX_C_RGBA
    vx_col_i8_rgb_rgb8,     1,  1,      // VX_F_RGB8   | VX_C_RGB
    vx_col_unknown,         1,  1,      // VX_F_RGB8   | VX_C_RGBA
    vx_col_unknown,         1,  1,      // VX_F_RGBX8  | VX_C_RGB
    vx_col_unknown,         1,  1,      // VX_F_RGBX8  | VX_C_RGBA
    vx_col_unknown,         1,  1,      // VX_F_RGBA4  | VX_C_RGB
    vx_col_i8_rgba_rgba4,   1,  1,      // VX_F_RGBA4  | VX_C_RGBA
    vx_col_unknown,         1,  1,      // VX_F_RGBA6  | VX_C_RGB
    vx_col_unknown,         1,  1,      // VX_F_RGBA6  | VX_C_RGBA
    vx_col_unknown,         1,  1,      // VX_F_RGBA8  | VX_C_RGB
    vx_col_i8_rgba_rgba8,   1,  1,      // VX_F_RGBA8  | VX_C_RGBA
    vx_col_unknown,         1,  1,      // VX_F_UNK    | VX_C_RGB
    vx_col_unknown,         1,  1,      // VX_F_UNK    | VX_C_RGBA
    vx_col_unknown,         1,  1,      // VX_F_UNK    | VX_C_RGB
    vx_col_unknown,         1,  1,      // VX_F_UNK    | VX_C_RGBA
};

vx_command_t vx_cmds_col_i16[16] =
{
    vx_col_i16_rgb_rgb565,  2,  1,      // VX_F_RGB565 | VX_C_RGB
    vx_col_unknown,         2,  1,      // VX_F_RGB565 | VX_C_RGBA
    vx_col_i16_rgb_rgb8,    2,  1,      // VX_F_RGB8   | VX_C_RGB
    vx_col_unknown,         2,  1,      // VX_F_RGB8   | VX_C_RGBA
    vx_col_unknown,         2,  1,      // VX_F_RGBX8  | VX_C_RGB
    vx_col_unknown,         2,  1,      // VX_F_RGBX8  | VX_C_RGBA
    vx_col_unknown,         2,  1,      // VX_F_RGBA4  | VX_C_RGB
    vx_col_i16_rgba_rgba4,  2,  1,      // VX_F_RGBA4  | VX_C_RGBA
    vx_col_unknown,         2,  1,      // VX_F_RGBA6  | VX_C_RGB
    vx_col_unknown,         2,  1,      // VX_F_RGBA6  | VX_C_RGBA
    vx_col_unknown,         2,  1,      // VX_F_RGBA8  | VX_C_RGB
    vx_col_i16_rgba_rgba8,  2,  1,      // VX_F_RGBA8  | VX_C_RGBA
    vx_col_unknown,         2,  1,      // VX_F_UNK    | VX_C_RGB
    vx_col_unknown,         2,  1,      // VX_F_UNK    | VX_C_RGBA
    vx_col_unknown,         2,  1,      // VX_F_UNK    | VX_C_RGB
    vx_col_unknown,         2,  1,      // VX_F_UNK    | VX_C_RGBA
};

vx_command_t vx_cmds_tex_n[16] =
{
    vx_tex_unknown,         7,  5,      // VX_F_U8 | VX_T_S
    vx_tex_n_st_u8,         1,  2,      // VX_F_U8 | VX_T_ST
    vx_tex_unknown,         7,  5,      // VX_F_S8 | VX_T_S
    vx_tex_n_st_s8,         1,  2,      // VX_F_S8 | VX_T_ST
    vx_tex_unknown,         7,  5,      // VX_F_U16 | VX_T_S
    vx_tex_n_st_u16,        2,  2,      // VX_F_U16 | VX_T_ST
    vx_tex_unknown,         7,  5,      // VX_F_S16 | VX_T_S
    vx_tex_n_st_s16,        2,  2,      // VX_F_S16 | VX_T_ST
    vx_tex_unknown,         7,  5,      // VX_F_F32 | VX_T_S
    vx_tex_n_st_f32,        4,  2,      // VX_F_F32 | VX_T_ST
    vx_tex_unknown,         7,  5,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         7,  5,      // VX_F_UNK | VX_T_ST
    vx_tex_unknown,         7,  5,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         7,  5,      // VX_F_UNK | VX_T_ST
    vx_tex_unknown,         7,  5,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         7,  5,      // VX_F_UNK | VX_T_ST
};

vx_command_t vx_cmds_tex_i8[16] =
{
    vx_tex_unknown,         1,  1,      // VX_F_U8 | VX_T_S
    vx_tex_i8_st_u8,        1,  1,      // VX_F_U8 | VX_T_ST
    vx_tex_unknown,         1,  1,      // VX_F_S8 | VX_T_S
    vx_tex_i8_st_s8,        1,  1,      // VX_F_S8 | VX_T_ST
    vx_tex_unknown,         1,  1,      // VX_F_U16 | VX_T_S
    vx_tex_unknown,         1,  1,      // VX_F_U16 | VX_T_ST
    vx_tex_unknown,         1,  1,      // VX_F_S16 | VX_T_S
    vx_tex_i8_st_s16,       1,  1,      // VX_F_S16 | VX_T_ST
    vx_tex_unknown,         1,  1,      // VX_F_F32 | VX_T_S
    vx_tex_i8_st_f32,       1,  1,      // VX_F_F32 | VX_T_ST
    vx_tex_unknown,         1,  1,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         1,  1,      // VX_F_UNK | VX_T_ST
    vx_tex_unknown,         1,  1,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         1,  1,      // VX_F_UNK | VX_T_ST
    vx_tex_unknown,         1,  1,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         1,  1,      // VX_F_UNK | VX_T_ST
};

vx_command_t vx_cmds_tex_i16[16] =
{
    vx_tex_unknown,         2,  1,      // VX_F_U8 | VX_T_S
    vx_tex_unknown,         2,  1,      // VX_F_U8 | VX_T_ST
    vx_tex_unknown,         2,  1,      // VX_F_S8 | VX_T_S
    vx_tex_unknown,         2,  1,      // VX_F_S8 | VX_T_ST
    vx_tex_unknown,         2,  1,      // VX_F_U16 | VX_T_S
    vx_tex_i16_st_u16,      2,  1,      // VX_F_U16 | VX_T_ST
    vx_tex_unknown,         2,  1,      // VX_F_S16 | VX_T_S
    vx_tex_i16_st_s16,      2,  1,      // VX_F_S16 | VX_T_ST
    vx_tex_unknown,         2,  1,      // VX_F_F32 | VX_T_S
    vx_tex_i16_st_f32,      2,  1,      // VX_F_F32 | VX_T_ST
    vx_tex_unknown,         2,  1,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         2,  1,      // VX_F_UNK | VX_T_ST
    vx_tex_unknown,         2,  1,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         2,  1,      // VX_F_UNK | VX_T_ST
    vx_tex_unknown,         2,  1,      // VX_F_UNK | VX_T_S
    vx_tex_unknown,         2,  1,      // VX_F_UNK | VX_T_ST
};

/* generic
vx_command_t vx_cmds_pos[16] =
{
    vx_pos_unknown,         7,  5,      // VX_F_U8 | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_U8 | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_S8 | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_S8 | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_U16 | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_U16 | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_S16 | VX_C_XY
    vx_pos_n_xyz_s16,       2,  3,      // VX_F_S16 | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_F32 | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_F32 | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XYZ
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XY
    vx_pos_unknown,         7,  5,      // VX_F_UNK | VX_C_XYZ
};
*/

// For debug purposes
uint32  vx_nor_debug_fmt;
uint32  vx_nor_debug_cnt;
uint32  vx_nor_debug_type;

uint32  vx_pos_debug_fmt;
uint32  vx_pos_debug_cnt;
uint32  vx_pos_debug_type;

uint32  vx_col_debug_fmt;
uint32  vx_col_debug_cnt;
uint32  vx_col_debug_type;

uint32  vx_tex_debug_fmt[8];
uint32  vx_tex_debug_cnt[8];
uint32  vx_tex_debug_type[8];

char *vx_str_type[4] = 
{
    "NONE", "NORM", "IDX8", "IDX16"
};

char *vx_str_fmt[8] = 
{
    "U8", "S8", "U16", "S16", 
    "F32", "UNK", "UNK", "UNK"
};

char *vx_str_col_fmt[8] = 
{
    "RGB565", "RGB8", "RGBX8", "RGBA4", "RGBA6", "RGBA8", "UNK", "UNK"
};

char *vx_str_pos_cnt[2] = 
{
    "XY", "XYZ"
};

char *vx_str_nor_cnt[2] = 
{
    "NOR", "N/B/T"
};

char *vx_str_col_cnt[2] = 
{
    "RGB", "RGBA"
};

char *vx_str_tex_cnt[2] = 
{
    "S", "ST"
};

///////////////////////////////////////////////////////////////////////////
// CODE

uint16 vx_swap16(uint16 data)
{
 return ((data >> 8) | (data << 8));
}

uint32 vx_swap32(uint32 data)
{
 return (data>>24)|((data>>8)&0xff00)|((data<<8)&0xff0000)|(data<<24);
}

///////////////////////////////////////////////////////////////////////////

void vx_invalidate_cache(uint32 pos)
{
/*
    uint32 i;
    switch(pos)
    {
    case 0x0:
        for(i = 0 ; i < vx_pos_watermark ; i++)
            vx_pos_valid[i] = 0;
        vx_pos_watermark = 0;
        break;
    case 0x1:
        for(i = 0 ; i < vx_nor_watermark ; i++)
            vx_nor_valid[i] = 0;
        vx_nor_watermark = 0;
        break;
    case 0x2:
        for(i = 0 ; i < vx_col_watermark ; i++)
            vx_col_valid[i] = 0;
        vx_col_watermark = 0;
        break;
    case 0x4:
        for(i = 0 ; i < vx_tex_watermark ; i++)
            vx_tex_valid[i] = 0;
        vx_tex_watermark = 0;
        break;
    default:
        printf("GX: Vertex Cache invalidate called with wrong parameter: %d\n", pos);
        gpu_exit(1,31);
        break;
    }
*/
}

///////////////////////////////////////////////////////////////////////////

void vx_begin(uint32 mode)
{
 if(vx_started) 
  {
#ifdef AUX_ILLEGALCALLS
   auxprintf("illegal begin!\n");
#endif
   glEnd();
  }

 if (te_modified) fsg_generate();

 glBegin(mode);

 vx_started=mode+1;
}

void vx_end(void)
{
 if(!vx_started) return;
 glEnd();
 vx_started=0;
}

///////////////////////////////////////////////////////////////////////////

void vx_set_requested_size(uint32 pos, uint32 count, uint8 size)
{
 do
  {
// PETE: MMMMM???
   vx_vertex_data_size[pos] = (count << 4) * size;

   vx_vertex_data_size[pos++] = (count << 4) | size;
  } 
 while(--count);
}

///////////////////////////////////////////////////////////////////////////

void vertex_null_function(uint32 pos)
{
 //syslog("Matrix Index %d\n", vx_vertex_ptr.ubp[pos]);
}

///////////////////////////////////////////////////////////////////////////

uint32 vx_prepare_table(uint32 vat)
{
 uint32 jump_table_pos;
 uint32 vcd_hi, vcd_lo;
 uint32 cmd_count;
 uint32 vat_a;
 uint32 mode;

 vx_table_selected = &vx_table[vat];
 vx_vertex_data_size = vx_table_selected->expected_size;

 vcd_lo = gp_cp_regs[0x50];
 vcd_hi = gp_cp_regs[0x60];

 vat_a  = gp_cp_regs[0x70 + vat];

 if (vx_table_selected->vcd_lo == vcd_lo)
  if (vx_table_selected->vcd_hi == vcd_hi)
   if (vx_table_selected->vat_a == vat_a)
    if (vx_table_selected->vat_b == gp_cp_regs[0x80 + vat])
     if (vx_table_selected->vat_c == gp_cp_regs[0x90 + vat])
      return vx_table_selected->cmd_count;

 vx_table_selected->vcd_lo = vcd_lo;
 vx_table_selected->vcd_hi = vcd_hi;
 vx_table_selected->vat_a  = vat_a;
 vx_table_selected->vat_b  = gp_cp_regs[0x80 + vat];
 vx_table_selected->vat_c  = gp_cp_regs[0x90 + vat];

 //syslog(VX,"Check for changed VAT and VCD should be added here\n");

 // for now lets build table every time

 jump_table_pos = 1;
 cmd_count = 0;
                                                        
 //----------------------------------------------------//
 if (vcd_lo & (1 << 0))
  {
   // PMIDX : Position/Normal Matrix Index
   // syslog(VX,"PT: Position/Normal Matrix Index - NOT SUPPORTED\n");

   vx_table_selected->jump_table[jump_table_pos] = vertex_null_function;
   vx_table_selected->param[jump_table_pos] = cmd_count;
   cmd_count += 1;
   jump_table_pos++;

  }
 //----------------------------------------------------//
 if (vcd_lo & (0xff << 1))
  {
   // TnMIDX : Texture Matrix Index
   // syslog_error(VI,"PT: Texture Matrix Index (%d) - NOT SUPPORTED\n", (vcd_lo >> 1) & 0xff);

//PETE: well, inc at least the cmd_count to prevent strange crashes

   vx_table_selected->jump_table[jump_table_pos] = vertex_null_function;
   vx_table_selected->param[jump_table_pos] = cmd_count;
   cmd_count += 1;
   jump_table_pos++;


  }
 //----------------------------------------------------//
 if (vcd_lo & (0x3 << 9))
  {
   // POS : Position
   // for debugging purposes
   vx_pos_debug_type = (vcd_lo >> 9) & 0x3;
   vx_pos_debug_fmt  = (vat_a >> 1) & 0x7;
   vx_pos_debug_cnt  = (vat_a) & 0x1;

   switch((vcd_lo >> 9) & 0x3)
    {
     case VX_T_NORM:
      mode = (vat_a) & 0xf;
      vx_table_selected->jump_table[0] = vx_cmds_pos_n[mode].processor;
      vx_table_selected->param[0] = cmd_count | ((vat_a << 4) & 0x1f00) | ((vat_a << 16) & 0x0f0000);
      cmd_count += vx_cmds_pos_n[mode].exp_count * vx_cmds_pos_n[mode].exp_size;
      break;

     case VX_T_IDX8:
      mode = (vat_a) & 0xf;
      vx_table_selected->jump_table[0] = vx_cmds_pos_i8[mode].processor;
      vx_table_selected->param[0] = cmd_count | ((vat_a << 4) & 0x1f00) | ((vat_a << 16) & 0x0f0000);
      cmd_count += vx_cmds_pos_i8[mode].exp_count * vx_cmds_pos_i8[mode].exp_size;
      break;

     case VX_T_IDX16:
      mode = (vat_a) & 0xf;
      vx_table_selected->jump_table[0] = vx_cmds_pos_i16[mode].processor;
      vx_table_selected->param[0] = cmd_count | ((vat_a << 4) & 0x1f00) | ((vat_a << 16) & 0x0f0000);
      cmd_count += vx_cmds_pos_i16[mode].exp_count * vx_cmds_pos_i16[mode].exp_size;
      break;

     default:
      //syslog_error(VI,"PT: Position (%d) - NOT SUPPORTED\n", (vcd_lo >> 9) & 0x03);
      break;
    }
  }
 //----------------------------------------------------//
 if (vcd_lo & (0x3 << 11))
  {
   // NRM : Normal
   if (vat_a & (1 << 9))
    {
     // NBT
     // syslog_error(VI,"PT: NBT not supported\n");
    }

   vx_nor_debug_type = (vcd_lo >> 11) & 0x03;
   vx_nor_debug_fmt =  (vat_a >> 10) & 0x7;
   vx_nor_debug_cnt =  (vat_a >> 9) & 0x1;

   switch((vcd_lo >> 11) & 0x3)
    {
     case VX_T_NORM:
      mode = (vat_a >> 9) & 0xf;
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_nor_n[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      cmd_count += vx_cmds_nor_n[mode].exp_count * vx_cmds_nor_n[mode].exp_size;
      jump_table_pos++;
      break;

     case VX_T_IDX8:
      mode = (vat_a >> 9) & 0xf;
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_nor_i8[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      cmd_count += vx_cmds_nor_i8[mode].exp_count * vx_cmds_nor_i8[mode].exp_size;
      jump_table_pos++;
      break;

     case VX_T_IDX16:
      mode = (vat_a >> 9) & 0xf;
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_nor_i16[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      cmd_count += vx_cmds_nor_i16[mode].exp_count * vx_cmds_nor_i16[mode].exp_size;
      jump_table_pos++;
      break;

     default:
      //syslog_error(VI,"PT: Normal/Binormal/Tangent (%d) - NOT SUPPORTED\n", (vcd_lo >> 11) & 0x03);
      break;
    }
  }
 //----------------------------------------------------//
 if (vcd_lo & (0x3 << 13))
  {
   // COL0 : Color0

   // for debugging purposes
   vx_col_debug_type = (vcd_lo >> 13) & 0x03;
   vx_col_debug_fmt =  (vat_a >> 14) & 0x7;
   vx_col_debug_cnt =  (vat_a >> 13) & 0x1;

   switch((vcd_lo >> 13) & 0x3)
    {
     case VX_T_NORM:
      mode = (vat_a >> 13) & 0xf;
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_col_n[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      cmd_count += vx_cmds_col_n[mode].exp_count * vx_cmds_col_n[mode].exp_size;
      jump_table_pos++;
      break;

     case VX_T_IDX8:
      mode = (vat_a >> 13) & 0xf;
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_col_i8[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      cmd_count += vx_cmds_col_i8[mode].exp_count * vx_cmds_col_i8[mode].exp_size;
      jump_table_pos++;
      break;

     case VX_T_IDX16:
      mode = (vat_a >> 13) & 0xf;
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_col_i16[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      cmd_count += vx_cmds_col_i16[mode].exp_count * vx_cmds_col_i16[mode].exp_size;
      jump_table_pos++;
      break;

     default:
      //syslog_error(VI,"PT: Color0 (%d) - NOT SUPPORTED\n", (vcd_lo >> 13) & 0x03);
      break;
    }
  }
 //----------------------------------------------------//
 if (vcd_lo & (0x3 << 15))
  {
   // COL1 : Color1

   // for debugging purposes
   vx_col_debug_type = (vcd_lo >> 15) & 0x03;
   vx_col_debug_fmt =  (vat_a >> 18) & 0x7;
   vx_col_debug_cnt =  (vat_a >> 17) & 0x1;

   mode = (vat_a >> 17) & 0xf;
   switch((vcd_lo >> 15) & 0x3)
    {  
     case VX_T_NORM:
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_col_n[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      vx_set_requested_size(cmd_count, vx_cmds_col_n[mode].exp_count, (uint8)vx_cmds_col_n[mode].exp_size);
      cmd_count += vx_cmds_col_n[mode].exp_count;
      jump_table_pos++;
      break;
 
     case VX_T_IDX8:
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_col_i8[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      vx_set_requested_size(cmd_count, vx_cmds_col_i8[mode].exp_count, (uint8)vx_cmds_col_i8[mode].exp_size);
      cmd_count += vx_cmds_col_i8[mode].exp_count;
      jump_table_pos++;
      break;

     case VX_T_IDX16:
      vx_table_selected->jump_table[jump_table_pos] = vx_cmds_col_i16[mode].processor;
      vx_table_selected->param[jump_table_pos] = cmd_count;
      vx_set_requested_size(cmd_count, vx_cmds_col_i16[mode].exp_count, (uint8)vx_cmds_col_i16[mode].exp_size);
      cmd_count += vx_cmds_col_i16[mode].exp_count;
      jump_table_pos++;
      break;

     default:
      //syslog_error(VI,"PT: Color1 (%d) - NOT SUPPORTED\n", (vcd_lo >> 15) & 0x03);
      break;
    }
  }
 //----------------------------------------------------//
 if (vcd_hi & 0xffff)
  {
   // TEXn : Texture Coordinate n
   uint16 temp;
   uint32 text_vat;
   int i;

   temp = vcd_hi & 0xffff;
   for(i = 0 ; i < 8 ; i++)
    {
     vx_tex_debug_type[i] = temp & 0x3;

     //if (i != 0 && temp != VX_T_NONE) syslog_error(VI,"Unsupported multitexturing\n");
                
     switch(temp & 0x3)
      {
       case VX_T_NONE:
        break;

       case VX_T_NORM:
        text_vat = vx_get_text_vat(vat, i);
        vx_tex_debug_fmt[i] = (text_vat >> 1) & 0x7;
        vx_tex_debug_cnt[i] = (text_vat >> 0) & 0x1;
        mode = text_vat & 0xf;
        vx_table_selected->jump_table[jump_table_pos] = vx_cmds_tex_n[mode].processor;
        vx_table_selected->param[jump_table_pos] = cmd_count | (i << 24) | ((text_vat << 4) & 0x1f00) | ((text_vat << 16) & 0x0f0000);
        cmd_count += vx_cmds_tex_n[mode].exp_count * vx_cmds_tex_n[mode].exp_size;
        jump_table_pos++;
        break;

       case VX_T_IDX8:
        text_vat = vx_get_text_vat(vat, i);
        vx_tex_debug_fmt[i] = (text_vat >> 1) & 0x7;
        vx_tex_debug_cnt[i] = (text_vat >> 0) & 0x1;
        mode = text_vat & 0xf;
        vx_table_selected->jump_table[jump_table_pos] = vx_cmds_tex_i8[mode].processor;
        vx_table_selected->param[jump_table_pos] = cmd_count | (i << 24) | ((text_vat << 4) & 0x1f00) | ((text_vat << 16) & 0x0f0000);
        cmd_count += vx_cmds_tex_i8[mode].exp_count * vx_cmds_tex_i8[mode].exp_size;
        jump_table_pos++;
        break;

       case VX_T_IDX16:
        text_vat = vx_get_text_vat(vat, i);
        vx_tex_debug_fmt[i] = (text_vat >> 1) & 0x7;
        vx_tex_debug_cnt[i] = (text_vat >> 0) & 0x1;
        mode = text_vat & 0xf;
        vx_table_selected->jump_table[jump_table_pos] = vx_cmds_tex_i16[mode].processor;
        vx_table_selected->param[jump_table_pos] = cmd_count | (i << 24) | ((text_vat << 4) & 0x1f00) | ((text_vat << 16) & 0x0f0000);
        cmd_count += vx_cmds_tex_i16[mode].exp_count * vx_cmds_tex_i16[mode].exp_size;
        jump_table_pos++;
        break;

       default:
        //syslog_error(VI,"PT: TEX%d Texture Coordinate (%d) - NOT SUPPORTED\n", i, temp & 0x3);
        break;
      }
     temp >>= 2;
    }
  }
 //----------------------------------------------------//

 vx_table[vat].jump_table[jump_table_pos] = NULL;
 vx_table[vat].cmd_count = cmd_count;

 return cmd_count;
}

///////////////////////////////////////////////////////////////////////////
// processing commands main loop

void vx_process_commands(void)
{
 uint32 pos;

 //syslog(VX,"Processor START\n");

 pos = 1;

 while(vx_table_selected->jump_table[pos])
  {
   vx_table_selected->jump_table[pos](vx_table_selected->param[pos]);
   pos++;
  };

 if(vx_table_selected->jump_table[0])
  vx_table_selected->jump_table[0](vx_table_selected->param[0]);

 //syslog(VX,"Processor END\n");
}


///////////////////////////////////////////////////////////////////////////
// POS Functions
// param:
// -------- -------s ssssssss pppppppp
// p - pos in vertex table
// s - shift (fractional bits)

void vx_pos_unknown(uint32 param)
{
 //syslog_error(VI,"POS *NOT IMPLEMENTED* Type %s Cnt %s Format %s\n", vx_str_type[vx_pos_debug_type], vx_str_pos_cnt[vx_pos_debug_cnt], vx_str_fmt[vx_pos_debug_fmt]);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xy_u8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y;
 uint8 *tptr;

//syslog(VX,"pos_n_xyz_u8(%d)\n", pos);

 divider = (1 << s);

 tptr = (uint8 *)(vx_vertex_ptr.ubp + pos);
 x = tptr[0];
 y = tptr[1];

 x /= divider;
 y /= divider;

//syslog(VX,"glVertex2f(%f, %f)\n", x, y);

 glVertex2f(x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xyz_u8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y, z;
 uint8 *tptr;

//syslog(VX,"pos_n_xyz_u8(%d)\n", pos);

 divider = (1 << s);

 tptr = (uint8 *)(vx_vertex_ptr.ubp + pos);
 x = tptr[0];
 y = tptr[1];
 z = tptr[2];

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xy_s8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y;
 sint8 *tptr;

//syslog(VX,"pos_n_xy_s8(%d) glVertex2f()\n", pos);

 divider = (1 << s);

 tptr = (sint8 *)(vx_vertex_ptr.ubp + pos);

 x = tptr[0];
 y = tptr[1];

 x /= divider;
 y /= divider;

//syslog(VX,"glVertex2f(%f, %f)\n", x, y);

 glVertex2f(x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xyz_s8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y, z;
 sint8 *tptr;

//syslog(VX,"pos_n_xyz_s8(%d) glVertex3f()\n", pos);

 divider = (1 << s);

 tptr = (sint8 *)(vx_vertex_ptr.ubp + pos);

 x = tptr[0];
 y = tptr[1];
 z = tptr[2];

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xy_u16(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y;
 uint16 *tptr;

//syslog(VX,"pos_n_xy_u16(%d)\n", pos);

 divider = (1 << s);

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 x = (uint16)vx_swap16(tptr[0]);
 y = (uint16)vx_swap16(tptr[1]);

 x /= divider;
 y /= divider;

//syslog(VX,"glVertex2f(%f, %f)\n", x, y);

 glVertex2f(x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xyz_u16(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y, z;
 uint16 *tptr;

//syslog(VX,"pos_n_xyz_u16(%d)\n", pos);

 divider = (1 << s);

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 x = (uint16)vx_swap16(tptr[0]);
 y = (uint16)vx_swap16(tptr[1]);
 z = (uint16)vx_swap16(tptr[2]);

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xy_s16(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y;
 uint16 *tptr;

//syslog(VX,"pos_n_xy_s16(%d)\n", pos);

 divider = (1 << s);

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 x = (sint16)vx_swap16(tptr[0]);
 y = (sint16)vx_swap16(tptr[1]);

 x /= divider;
 y /= divider;

//syslog(VX,"glVertex2f(%f, %f)\n", x, y);

 glVertex2f(x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xyz_s16(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y, z;
 uint16 *tptr;

//syslog(VX,"pos_n_xyz_s16(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 divider = (1 << s);

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 x = (sint16)vx_swap16(tptr[0]);
 y = (sint16)vx_swap16(tptr[1]);
 z = (sint16)vx_swap16(tptr[2]);

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xy_f32(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 vx_vertex_t x, y;
 uint32 *tptr;

//syslog(VX,"pos_n_xy_f32(%d)\n", pos);

//if(s) syslog_error(VI,"Fractional bits in float: %d\n", s);

 tptr = (uint32 *)(vx_vertex_ptr.ubp + pos);

 x.i = (uint32)vx_swap32(tptr[0]);
 y.i = (uint32)vx_swap32(tptr[1]);

//syslog(VX,"glVertex2f(%f, %f)\n", x.f, y.f);

 glVertex2f(x.f, y.f);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_n_xyz_f32(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 vx_vertex_t x, y, z;
 uint32 *tptr;

//syslog(VX,"pos_n_xyz_f32(%d)\n", pos);

//if(s) syslog_error(VI,"Fractional bits in float: %d\n", s);

 tptr = (uint32 *)(vx_vertex_ptr.ubp + pos);

 x.i = (uint32)vx_swap32(tptr[0]);
 y.i = (uint32)vx_swap32(tptr[1]);
 z.i = (uint32)vx_swap32(tptr[2]);

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x.f, y.f, z.f);

 glVertex3f(x.f, y.f, z.f);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i8_xy_s8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y;

//syslog(VX,"pos_i8_xy_s8(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = index_ptr.sbp[0];
 y = index_ptr.sbp[1];

 x /= divider;
 y /= divider;

//syslog(VX,"glVertex2f(%f, %f, %f)\n", x, y);

 glVertex2f(x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i8_xyz_s8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y, z;

//syslog(VX,"pos_i8_xyz_s8(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = index_ptr.sbp[0];
 y = index_ptr.sbp[1];
 z = index_ptr.sbp[2];

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i8_xyz_u8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y, z;

//syslog(VX,"pos_i8_xyz_s8(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = index_ptr.ubp[0];
 y = index_ptr.ubp[1];
 z = index_ptr.ubp[2];

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i8_xy_s16(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y;

//syslog(VX,"pos_i8_xy_s16(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = (sint16)vx_swap16(index_ptr.usp[0]);
 y = (sint16)vx_swap16(index_ptr.usp[1]);

 x /= divider;
 y /= divider;

//syslog(VX,"glVertex2f(%f, %f)\n", x, y);

 glVertex2f(x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i8_xyz_s16(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y, z;

//syslog(VX,"pos_i8_xyz_s16(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = (sint16)vx_swap16(index_ptr.usp[0]);
 y = (sint16)vx_swap16(index_ptr.usp[1]);
 z = (sint16)vx_swap16(index_ptr.usp[2]);

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i8_xyz_f32(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 vx_vertex_t x, y, z;
    
//syslog(VX,"pos_i8_xyz_f32(%d)\n", pos);

//if(s) syslog_error(VI,"Fractional bits in float: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x.i = vx_swap32(index_ptr.ulp[0]);
 y.i = vx_swap32(index_ptr.ulp[1]);
 z.i = vx_swap32(index_ptr.ulp[2]);

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x.f, y.f, z.f);

 glVertex3f(x.f, y.f, z.f);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i16_xyz_s8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 uint16 *tptr;
 float divider, x, y, z;

//syslog(VX,"pos_i8_xyz_s8(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = index_ptr.sbp[0];
 y = index_ptr.sbp[1];
 z = index_ptr.sbp[2];

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i16_xyz_s16(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 uint16 *tptr;
 float divider, x, y, z;

//syslog(VX,"pos_i16_xyz_s16(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = (sint16)vx_swap16(index_ptr.usp[0]);
 y = (sint16)vx_swap16(index_ptr.usp[1]);
 z = (sint16)vx_swap16(index_ptr.usp[2]);

 x /= divider;
 y /= divider;
 z /= divider;

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x, y, z);

 glVertex3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_pos_i16_xyz_f32(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 uint16 *tptr;
 vx_vertex_t x, y, z;

//syslog(VX,"pos_i16_xyz_f32(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa0];
 index_size = gp_cp_regs[0xb0];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x.i = vx_swap32(index_ptr.ulp[0]);
 y.i = vx_swap32(index_ptr.ulp[1]);
 z.i = vx_swap32(index_ptr.ulp[2]);

//syslog(VX,"glVertex3f(%f, %f, %f)\n", x.f, y.f, z.f);

 glVertex3f(x.f, y.f, z.f);
}

///////////////////////////////////////////////////////////////////////////
// NOR Functions
// param:
// -------- -------- -------- pppppppp
// p - pos in vertex table

void vx_nor_unknown(uint32 param)
{
// uint32 pos = param & 0xff;
// syslog_error(VI,"NOR *NOT IMPLEMENTED* Pos: %d Type %s Cnt %s Format %s\n", pos, vx_str_type[vx_nor_debug_type], vx_str_nor_cnt[vx_nor_debug_cnt], vx_str_fmt[vx_nor_debug_fmt]);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_n_nor_s8(uint32 param)
{
 uint32 pos = param & 0xff;
 float x, y, z;

//syslog(VX,"nor_n_nor_s8(%d)\n", pos);

 x = vx_vertex_ptr.sbp[pos + 0];
 y = vx_vertex_ptr.sbp[pos + 1];
 z = vx_vertex_ptr.sbp[pos + 2];

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x, y, z);

 glNormal3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_n_nor_s16(uint32 param)
{
 uint32 pos = param & 0xff;
 float x, y, z;
 uint16 *tptr;

//syslog(VX,"nor_n_nor_s8(%d)\n", pos);

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 x = (sint16)vx_swap16(tptr[0]);
 y = (sint16)vx_swap16(tptr[1]);
 z = (sint16)vx_swap16(tptr[2]);

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x, y, z);

 glNormal3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_n_nor_f32(uint32 param)
{
 uint32 pos = param & 0xff;
 vx_vertex_t x, y, z;
 uint32 *tptr;

//syslog(VX,"nor_n_nor_f32(%d)\n", pos);

 tptr = (uint32 *)(vx_vertex_ptr.ubp + pos);

 x.i = (uint32)vx_swap32(tptr[0]);
 y.i = (uint32)vx_swap32(tptr[1]);
 z.i = (uint32)vx_swap32(tptr[2]);

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x.f, y.f, z.f);

 glNormal3f(x.f, y.f, z.f);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_i8_nor_s8(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 float x, y, z;

//syslog(VX,"nor_i8_nor_s8(%d)\n", pos);

/*  uint32 s = (param >> 8) & 0x1f;
    if (s)
    {
        syslog(VX,"Fractional bits: %d\n", s);
    }
*/

 index_mem = gp_cp_regs[0xa1];
 index_size = gp_cp_regs[0xb1];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x = index_ptr.sbp[0];
 y = index_ptr.sbp[1];
 z = index_ptr.sbp[2];

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x, y, z);

 glNormal3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_i8_nor_s16(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 float x, y, z;

//syslog(VX,"nor_i8_nor_s16(%d)\n", pos);

/*  uint32 s = (param >> 8) & 0x1f;
    if (s)
    {
        syslog(VX,"Fractional bits: %d\n", s);
    }
*/

 index_mem = gp_cp_regs[0xa1];
 index_size = gp_cp_regs[0xb1];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x = (sint16)vx_swap16(index_ptr.usp[0]);
 y = (sint16)vx_swap16(index_ptr.usp[1]);
 z = (sint16)vx_swap16(index_ptr.usp[2]);

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x, y, z);

 glNormal3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_i8_nor_f32(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 vx_vertex_t x, y, z;

//syslog(VX,"nor_i8_nor_f32(%d)\n", pos);

/*  uint32 s = (param >> 8) & 0x1f;
    if (s)
    {
        syslog(VX,"Fractional bits: %d\n", s);
    }
*/

 index_mem = gp_cp_regs[0xa1];
 index_size = gp_cp_regs[0xb1];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x.i = vx_swap32(index_ptr.ulp[0]);
 y.i = vx_swap32(index_ptr.ulp[1]);
 z.i = vx_swap32(index_ptr.ulp[2]);

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x.f, y.f, z.f);

 glNormal3f(x.f, y.f, z.f);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_i16_nor_s8(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint16 *tptr;
 float x, y, z;

//syslog(VX,"nor_i8_nor_s8(%d)\n", pos);

/*  uint32 s = (param >> 8) & 0x1f;
    if (s)
    {
        syslog(VX,"Fractional bits: %d\n", s);
    }
*/

 index_mem = gp_cp_regs[0xa1];
 index_size = gp_cp_regs[0xb1];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);
 index_pos = (uint16)vx_swap16(tptr[0]);
 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x = index_ptr.sbp[0];
 y = index_ptr.sbp[1];
 z = index_ptr.sbp[2];

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x, y, z);

 glNormal3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_i16_nor_s16(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint16 *tptr;
 float x, y, z;

//syslog(VX,"nor_i16_nor_s16(%d)\n", pos);

/*  uint32 s = (param >> 8) & 0x1f;
    if (s)
    {
        syslog(VX,"Fractional bits: %d\n", s);
    }
*/

 index_mem = gp_cp_regs[0xa1];
 index_size = gp_cp_regs[0xb1];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x = (sint16)vx_swap16(index_ptr.usp[0]);
 y = (sint16)vx_swap16(index_ptr.usp[1]);
 z = (sint16)vx_swap16(index_ptr.usp[2]);

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x, y, z);

 glNormal3f(x, y, z);
}

///////////////////////////////////////////////////////////////////////////

void vx_nor_i16_nor_f32(uint32 param)
{
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint16 *tptr;
 vx_vertex_t x, y, z;

//syslog(VX,"nor_i16_nor_f32(%d)\n", pos);

/*  uint32 s = (param >> 8) & 0x1f;
    if (s)
    {
        syslog(VX,"Fractional bits: %d\n", s);
    }
*/

 index_mem = gp_cp_regs[0xa1];
 index_size = gp_cp_regs[0xb1];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x.i = vx_swap32(index_ptr.ulp[0]);
 y.i = vx_swap32(index_ptr.ulp[1]);
 z.i = vx_swap32(index_ptr.ulp[2]);

//syslog(VX,"glNormal3f(%f, %f, %f)\n", x.f, y.f, z.f);

 glNormal3f(x.f, y.f, z.f);
}

///////////////////////////////////////////////////////////////////////////

/*
void vx_nor_i8_xyz_u8(uint32 param)
{
    uint32 pos = param & 0xff;
    uint32 index_pos;
    uint32 index_mem;
    uint32 index_size;

    index_mem = gp_cp_regs[0xa1];
    index_size = gp_cp_regs[0xb1];
    index_pos = vx_vertex_data[pos].ub;

    syslog(VX,"nor_i8_xyz_u8(%d) * CACHE NOT IMPLEMENTED *\n", pos);
    //glVertex3f(((char)gx_memory[index_mem + index_pos * index_size])/1.0f, ((char)gx_memory[index_mem + index_pos * index_size + 1])/1.0f, ((char)gx_memory[index_mem + index_pos * index_size + 2])/1.0f);
    glNormal3f(((uint8 *)&gx_memory[index_mem + index_pos * index_size])[0], ((uint8 *)&gx_memory[index_mem + index_pos * index_size])[1], ((uint8 *)&gx_memory[index_mem + index_pos * index_size])[2]);
}
*/


///////////////////////////////////////////////////////////////////////////
// COLn Functions
// param:
// -------n -------- -------- pppppppp
// n - COLn
// p - pos in vertex table

void vx_col_unknown(uint32 param)
{
// uint32 pos = param & 0xff;
// syslog_error(VI,"COL *NOT IMPLEMENTED* Pos: %d Type %s Cnt %s Format %s\n", pos, vx_str_type[vx_col_debug_type], vx_str_col_cnt[vx_col_debug_cnt], vx_str_col_fmt[vx_col_debug_fmt]);
}

///////////////////////////////////////////////////////////////////////////

void vx_col_n_rgb_rgb8(uint32 param)
{
 uint32 pos = param & 0xff;

//syslog(VX,"col_n_rgb_rgb8(%d) glColor3ub()\n", pos);

 glColor3ubv(&vx_vertex_ptr.ubp[pos]);
}

///////////////////////////////////////////////////////////////////////////

void vx_col_n_rgba_rgba4(uint32 param)
{
 uint32 pos = param & 0xff;
 uint16 data;
 uint16 *tptr;

//syslog_error(VI,"col_n_rgba_rgba4(%d)\n", pos);

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);
 data = tptr[0];


 glColor4ub((GLubyte)((data >> 8) & 0xf0), 
            (GLubyte)((data >> 4) & 0xf0),
            (GLubyte)((data >> 0) & 0xf0),
            (GLubyte)((data << 4) & 0xf0));
}

///////////////////////////////////////////////////////////////////////////

void vx_col_n_rgba_rgba8(uint32 param)
{
 uint32 pos = param & 0xff;

//syslog(VX,"col_n_rgba_rgba8(%d) glColor4ub()\n", pos);

 glColor4ubv(vx_vertex_ptr.ubp + pos);
}

///////////////////////////////////////////////////////////////////////////

void vx_col_i16_rgba_rgba8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos;
 uint32 index_mem;
 uint32 index_size;
 uint16 *tptr;

//syslog(VX,"col_i16_rgb_rgb8(%d)\n", pos);

 index_mem = gp_cp_regs[0xa2];
 index_size = gp_cp_regs[0xb2];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 glColor4ubv(&gx_memory[index_mem + index_pos * index_size]);
}

///////////////////////////////////////////////////////////////////////////

void vx_col_i8_rgb_rgb8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos;
 uint32 index_mem;
 uint32 index_size;

//syslog(VX,"col_i8_rgba_rgba8(%d)\n", pos);

 index_mem = gp_cp_regs[0xa2];
 index_size = gp_cp_regs[0xb2];

 index_pos = vx_vertex_ptr.ubp[pos];

 glColor3ubv(&gx_memory[index_mem + index_pos * index_size]);
}

///////////////////////////////////////////////////////////////////////////

void vx_col_i8_rgba_rgba8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos;
 uint32 index_mem;
 uint32 index_size;

//syslog(VX,"col_i8_rgba_rgba8(%d)\n", pos);

 index_mem = gp_cp_regs[0xa2];
 index_size = gp_cp_regs[0xb2];

 index_pos = vx_vertex_ptr.ubp[pos];

 glColor4ubv(&gx_memory[index_mem + index_pos * index_size]);
}

///////////////////////////////////////////////////////////////////////////

void vx_col_i8_rgb_rgb565(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint8 *tptr;   
 uint16 data;

// syslog(VX,"col_i8_rgb_rgb565(%d)\n", pos);

 index_mem = gp_cp_regs[0xa2];
 index_size = gp_cp_regs[0xb2];

 tptr = (uint8 *)(vx_vertex_ptr.ubp + pos);
 index_pos = tptr[0];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 data = index_ptr.usp[0];
 data = vx_swap16(data);

 glColor3ub((GLubyte)((data >> 8) & 0xf8),
            (GLubyte)((data >> 3) & 0xfc),
            (GLubyte)((data << 3) & 0xf8));
}

///////////////////////////////////////////////////////////////////////////

void vx_col_i8_rgba_rgba4(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint8 *tptr;
 uint16 data;

//syslog(VX,"col_i8_rgba_rgba4(%d)\n", pos);

 index_mem = gp_cp_regs[0xa2];
 index_size = gp_cp_regs[0xb2];

 tptr = (uint8 *)(vx_vertex_ptr.ubp + pos);
 index_pos = tptr[0];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 data = index_ptr.usp[0];
 data = vx_swap16(data);

 glColor4ub((GLubyte)((data >> 8) & 0xf0),
            (GLubyte)((data >> 4) & 0xf0),
            (GLubyte)((data >> 0) & 0xf0),
            (GLubyte)((data << 4) & 0xf0));
}

///////////////////////////////////////////////////////////////////////////

void vx_col_i16_rgb_rgb565(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint16 *tptr;
 uint16 data;

//syslog(VX,"col_i16_rgb_rgb565(%d)\n", pos);

 index_mem = gp_cp_regs[0xa2];
 index_size = gp_cp_regs[0xb2];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 data = index_ptr.usp[0];
 data = vx_swap16(data);

 glColor3ub((GLubyte)((data >> 8) & 0xf8),
            (GLubyte)((data >> 3) & 0xfc),
            (GLubyte)((data << 3) & 0xf8));
}

///////////////////////////////////////////////////////////////////////////

void vx_col_i16_rgba_rgba4(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint16 *tptr;
 uint16 data;

//syslog(VX,"col_i16_rgba_rgba4(%d)\n", pos);

 index_mem = gp_cp_regs[0xa2];
 index_size = gp_cp_regs[0xb2];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 data = index_ptr.usp[0];
 data = vx_swap16(data);

 glColor4ub((GLubyte)((data >> 8) & 0xf0),
            (GLubyte)((data >> 4) & 0xf0),
            (GLubyte)((data >> 0) & 0xf0),
            (GLubyte)((data << 4) & 0xf0));
}

///////////////////////////////////////////////////////////////////////////

void vx_col_i16_rgb_rgb8(uint32 param)
{
 uint32 pos = param & 0xff;
 uint32 index_pos;
 uint32 index_mem;
 uint32 index_size;
 uint16 *tptr;

//syslog(VX,"col_i16_rgb_rgb8(%d) glColor3ub()\n", pos);

 index_mem = gp_cp_regs[0xa2];
 index_size = gp_cp_regs[0xb2];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 glColor3ubv(&gx_memory[index_mem + index_pos * index_size]);
}

///////////////////////////////////////////////////////////////////////////
// TEXn Functions
// param:
// -----nnn -------s ssssssss pppppppp
// n - TEXn
// p - pos in vertex table
// s - shift (fractional bits)

void vx_tex_unknown(uint32 param)
{
// auxprintf("unknown\n");
// uint32 n = (param >> 24) & 0x7;
// uint32 s = (param >> 8) & 0x1f;
// syslog_error(VI,"TEX%d *NOT IMPLEMENTED* Type %s Cnt %s Format %s Fractional bits: %d\n", n, vx_str_type[vx_tex_debug_type[n]], vx_str_tex_cnt[vx_tex_debug_cnt[n]], vx_str_fmt[vx_tex_debug_fmt[n]], s);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_n_st_s8(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider,x,y;
 sint8 *tptr;
    
// auxprintf("vx_tex_n_st_s8\n");
//syslog(VX,"tex_n_st_s8(%d)\n", pos);

 divider = (1 << s);
    
 tptr = (sint8 *)(vx_vertex_ptr.ubp + pos);

 x = tptr[0];
 y = tptr[1];

 x /= divider;
 y /= divider;

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];


 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_n_st_u8(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider,x,y;
 uint8 *tptr;

//auxprintf("vx_tex_n_st_u8\n");
//syslog(VX,"tex_n_st_u8(%d)\n", pos);

 divider = (1 << s);
 
 tptr = (uint8 *)(vx_vertex_ptr.ubp + pos);

 x = tptr[0];
 y = tptr[1];

 x /= divider;
 y /= divider;

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_n_st_s16(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider,x,y;
 uint16 *tptr;
   
// auxprintf("vx_tex_n_st_s16\n");
//syslog(VX,"tex_n_st_s16(%d)\n", pos);

 divider = (1 << s);

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 x = (sint16)vx_swap16(tptr[0]);
 y = (sint16)vx_swap16(tptr[1]);

 x /= divider;
 y /= divider;


//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

/*
// PETE: that's most likely an hack (to get the texts in the GC sdk visible)
// mmm... on the other hand it works in bust-a-move (intro) as well


// if(tex_width[n] && tex_height[n] && (((param>>1)&7)==3) && tex_fmt[n]<2)
 if((((param>>1)&7)==3) && tex_fmt[n]<2)
  {
//   x/=tex_width[n];
//   y/=tex_height[n];

//auxprintf("-> %d;%d;%d, %d %d, %d\n",n,(param>>1)&7,param&1,
//                                    tex_width[n], tex_height[n], tex_fmt[n]);

  }
*/

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_n_st_u16(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 float divider,x,y;
 uint16 *tptr;

//auxprintf("vx_tex_n_st_u16\n");
//syslog(VX,"tex_n_st_u16(%d)\n", pos);

 divider = (1 << s);

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 x = (uint16)vx_swap16(tptr[0]);
 y = (uint16)vx_swap16(tptr[1]);

 x /= divider;
 y /= divider;

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);

//HACK!!!!
// glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n+1, x, y);
// glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n+2, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_n_st_f32(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32 pos = param & 0xff;
 uint32 s = (param >> 8) & 0x1f;
 vx_vertex_t x, y;
 uint32 *tptr;

//auxprintf("vx_tex_n_st_f32\n");
//syslog(VX,"tex_n_st_f32(%d)\n", pos);

//if(s) syslog_error(VI,"Fractional bits in float: %d\n", s);
    
 tptr = (uint32 *)(vx_vertex_ptr.ubp + pos);

 x.i = (uint32)vx_swap32(tptr[0]);
 y.i = (uint32)vx_swap32(tptr[1]);

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x.f, y.f);

// x.f*=xf_texture_matrix[n][0];
// y.f*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x.f, y.f);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_i8_st_u8(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32 s = (param >> 8) & 0x1f;
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 float divider, x, y;

//auxprintf("vx_tex_i8_st_u8\n");
//syslog(VX,"tex_i8_st_u8(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa4];
 index_size = gp_cp_regs[0xb4];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = index_ptr.ubp[0];
 y = index_ptr.ubp[1];

 x /= divider;
 y /= divider;

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_i8_st_s8(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32 pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 float divider, x, y;

//auxprintf("vx_tex_i8_st_s8\n");
//syslog(VX,"i8_st_s8(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa4];
 index_size = gp_cp_regs[0xb4];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = index_ptr.sbp[0];
 y = index_ptr.sbp[1];

 x /= divider;
 y /= divider;

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_i8_st_s16(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 float divider,x, y;

//auxprintf("vx_tex_i8_st_s16\n");
//syslog(VX,"tex_i8_st_s16(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa4];
 index_size = gp_cp_regs[0xb4];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);
    
 divider = (1 << s);

 x = (sint16)vx_swap16(index_ptr.usp[0]);
 y = (sint16)vx_swap16(index_ptr.usp[1]);

 x /= divider;
 y /= divider;

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_i8_st_f32(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 vx_vertex_t x, y;

//auxprintf("vx_tex_i8_st_f32\n");
//syslog(VX,"tex_i8_st_f32(%d)\n", pos);

//if(s) syslog_error(VI,"Fractional bits in float: %d\n", s);

 index_mem = gp_cp_regs[0xa4];
 index_size = gp_cp_regs[0xb4];

 index_pos = vx_vertex_ptr.ubp[pos];

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x.i = vx_swap32(index_ptr.ulp[0]);
 y.i = vx_swap32(index_ptr.ulp[1]);

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x.f, y.f);

// x.f*=xf_texture_matrix[n][0];
// y.f*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x.f, y.f);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_i16_st_u16(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 uint16 *tptr;
 float divider, x, y;

//auxprintf("vx_tex_i16_st_u16\n");
//syslog(VX,"tex_i16_st_f32(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa4];
 index_size = gp_cp_regs[0xb4];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = (uint16)vx_swap16(index_ptr.usp[0]);
 y = (uint16)vx_swap16(index_ptr.usp[1]);

 x /= divider;
 y /= divider;

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_i16_st_s16(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 uint16 *tptr;
 float divider,x, y;

//auxprintf("vx_tex_i16_st_s16\n");
//syslog(VX,"tex_i16_st_f32(%d)\n", pos);

//if(s) syslog(VX,"Fractional bits: %d\n", s);

 index_mem = gp_cp_regs[0xa4];
 index_size = gp_cp_regs[0xb4];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 divider = (1 << s);

 x = (sint16)vx_swap16(index_ptr.usp[0]);
 y = (sint16)vx_swap16(index_ptr.usp[1]);

 x /= divider;
 y /= divider;

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x, y);

// x*=xf_texture_matrix[n][0];
// y*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x, y);
}

///////////////////////////////////////////////////////////////////////////

void vx_tex_i16_st_f32(uint32 param)
{
 uint32 n = (param >> 24) & 0x7;
 uint32  pos = param & 0xff;
 uint32 index_pos, index_mem, index_size;
 vx_vertex_ptr_t index_ptr;
 uint32 s = (param >> 8) & 0x1f;
 uint16 *tptr;
 vx_vertex_t x, y;

//auxprintf("vx_tex_i16_st_f32\n");
//syslog(VX,"tex_i16_st_f32(%d)\n", pos);

//if(s) syslog_error(VI,"Fractional bits in float: %d\n", s);

 index_mem = gp_cp_regs[0xa4];
 index_size = gp_cp_regs[0xb4];

 tptr = (uint16 *)(vx_vertex_ptr.ubp + pos);

 index_pos = (uint16)vx_swap16(tptr[0]);

 index_ptr.ubp = gx_memory + index_mem + (index_pos * index_size);

 x.i = vx_swap32(index_ptr.ulp[0]);
 y.i = vx_swap32(index_ptr.ulp[1]);

//syslog(VX,"glMultiTexCoord2f(GL_TEXTURE%d_ARB, %f, %f)\n", n, x.f, y.f);

// x.f*=xf_texture_matrix[n][0];
// y.f*=xf_texture_matrix[n][5];

 glMultiTexCoord2fARB_Ex(GL_TEXTURE0_ARB + n, x.f, y.f);
}

///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////

uint32 vx_get_text_vat(uint32 vat, uint32 i)
{
 uint32 text_vat, vat_x;

//PETE: yagcd says: shift of TEX4 is in vat_c!!!!

 if (i == 0)
  {
   // for TEX0 params are in vat_a
   // VAT_A

   vat_x = gp_cp_regs[0x70 + vat];
   text_vat = vat_x >> 21;
  }
 else 
 if (i < 4)
  {
   // for TEX1-3 params are in vat_b
   vat_x = gp_cp_regs[0x80 + vat];
   text_vat = vat_x >> (i - 1) * 9;
  }
 else
 if (i == 4)
  {
   // for TEX4 params are in vat_b/vat_c
   vat_x = gp_cp_regs[0x80 + vat];
   text_vat = vat_x >> 27;
   text_vat &= 0x0f;
   vat_x = gp_cp_regs[0x90 + vat];
   text_vat |= vat_x << 4;
  }
 else
  {
   // for TEX5-7 params are in vat_c
   vat_x = gp_cp_regs[0x90 + vat];
   text_vat = vat_x >> (((i - 5) * 9)+5);
  }

/*
 if (i == 0)
  {
   // for TEX0 params are in vat_a
   // VAT_A

   vat_x = gp_cp_regs[0x70 + vat];
   text_vat = vat_x >> 21;
  }
 else 
 if (i < 5)
  {
   // for TEX1-4 params are in vat_b
   vat_x = gp_cp_regs[0x80 + vat];
   text_vat = vat_x >> (i - 1) * 9;
  }
 else
  {
   // for TEX5-7 params are in vat_c
   vat_x = gp_cp_regs[0x90 + vat];
   text_vat = vat_x >> (i - 5) * 9;
  }
*/

 text_vat &= 0x1ff;

 return text_vat;
}

///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////

GLuint vpShader=0;

char shaderASM[]=
{
"!!ARBvp1.0\n"
"\n"
"OPTION ARB_position_invariant;\n"
"\n"
//"MOV result.texcoord[ 0 ], vertex.texcoord[ 0 ];\n"
//"MOV result.texcoord[ 1 ], vertex.texcoord[ 1 ];\n"
//"MOV result.texcoord[ 2 ], vertex.texcoord[ 2 ];\n"
//"MOV result.texcoord[ 3 ], vertex.texcoord[ 3 ];\n"
//"MOV result.texcoord[ 4 ], vertex.texcoord[ 4 ];\n"
//"MOV result.texcoord[ 5 ], vertex.texcoord[ 5 ];\n"
//"MOV result.texcoord[ 6 ], vertex.texcoord[ 6 ];\n"
//"MOV result.texcoord[ 7 ], vertex.texcoord[ 7 ];\n"

"PARAM mat0[4]= {state.matrix.texture[0]};\n"
"PARAM mat1[4]= {state.matrix.texture[1]};\n"
"PARAM mat2[4]= {state.matrix.texture[2]};\n"
"PARAM mat3[4]= {state.matrix.texture[3]};\n"
"PARAM mat4[4]= {state.matrix.texture[4]};\n"
"PARAM mat5[4]= {state.matrix.texture[5]};\n"
"PARAM mat6[4]= {state.matrix.texture[6]};\n"
"PARAM mat7[4]= {state.matrix.texture[7]};\n"

"DP4 result.texcoord[ 0 ].x,vertex.texcoord[ 0 ],mat0[ 0 ];"
"DP4 result.texcoord[ 0 ].y,vertex.texcoord[ 0 ],mat0[ 1 ];"
"DP4 result.texcoord[ 0 ].z,vertex.texcoord[ 0 ],mat0[ 2 ];"
"DP4 result.texcoord[ 0 ].w,vertex.texcoord[ 0 ],mat0[ 3 ];"

"DP4 result.texcoord[ 1 ].x,vertex.texcoord[ 1 ],mat1[ 0 ];"
"DP4 result.texcoord[ 1 ].y,vertex.texcoord[ 1 ],mat1[ 1 ];"
"DP4 result.texcoord[ 1 ].z,vertex.texcoord[ 1 ],mat1[ 2 ];"
"DP4 result.texcoord[ 1 ].w,vertex.texcoord[ 1 ],mat1[ 3 ];"

"DP4 result.texcoord[ 2 ].x,vertex.texcoord[ 2 ],mat2[ 0 ];"
"DP4 result.texcoord[ 2 ].y,vertex.texcoord[ 2 ],mat2[ 1 ];"
"DP4 result.texcoord[ 2 ].z,vertex.texcoord[ 2 ],mat2[ 2 ];"
"DP4 result.texcoord[ 2 ].w,vertex.texcoord[ 2 ],mat2[ 3 ];"

"DP4 result.texcoord[ 3 ].x,vertex.texcoord[ 3 ],mat3[ 0 ];"
"DP4 result.texcoord[ 3 ].y,vertex.texcoord[ 3 ],mat3[ 1 ];"
"DP4 result.texcoord[ 3 ].z,vertex.texcoord[ 3 ],mat3[ 2 ];"
"DP4 result.texcoord[ 3 ].w,vertex.texcoord[ 3 ],mat3[ 3 ];"

"DP4 result.texcoord[ 4 ].x,vertex.texcoord[ 4 ],mat4[ 0 ];"
"DP4 result.texcoord[ 4 ].y,vertex.texcoord[ 4 ],mat4[ 1 ];"
"DP4 result.texcoord[ 4 ].z,vertex.texcoord[ 4 ],mat4[ 2 ];"
"DP4 result.texcoord[ 4 ].w,vertex.texcoord[ 4 ],mat4[ 3 ];"

"DP4 result.texcoord[ 5 ].x,vertex.texcoord[ 5 ],mat5[ 0 ];"
"DP4 result.texcoord[ 5 ].y,vertex.texcoord[ 5 ],mat5[ 1 ];"
"DP4 result.texcoord[ 5 ].z,vertex.texcoord[ 5 ],mat5[ 2 ];"
"DP4 result.texcoord[ 5 ].w,vertex.texcoord[ 5 ],mat5[ 3 ];"

"DP4 result.texcoord[ 6 ].x,vertex.texcoord[ 6 ],mat6[ 0 ];"
"DP4 result.texcoord[ 6 ].y,vertex.texcoord[ 6 ],mat6[ 1 ];"
"DP4 result.texcoord[ 6 ].z,vertex.texcoord[ 6 ],mat6[ 2 ];"
"DP4 result.texcoord[ 6 ].w,vertex.texcoord[ 6 ],mat6[ 3 ];"

"DP4 result.texcoord[ 7 ].x,vertex.texcoord[ 7 ],mat7[ 0 ];"
"DP4 result.texcoord[ 7 ].y,vertex.texcoord[ 7 ],mat7[ 1 ];"
"DP4 result.texcoord[ 7 ].z,vertex.texcoord[ 7 ],mat7[ 2 ];"
"DP4 result.texcoord[ 7 ].w,vertex.texcoord[ 7 ],mat7[ 3 ];"

"MOV result.color.primary, vertex.color.primary;\n"
"MOV result.color.secondary, vertex.color.secondary;\n"


"\n"
"END\n"
"\0"
};

//state.matrix.texture[0]

void vx_create_shader(void)
{
 int i;
 
 //------------------------
 // no shader for now

 return;
 //------------------------

 glGenProgramsARB_Ex(1,&vpShader);
 glBindProgramARB_Ex(GL_VERTEX_PROGRAM_ARB,vpShader);

 glProgramStringARB_Ex(GL_VERTEX_PROGRAM_ARB, 
                       GL_PROGRAM_FORMAT_ASCII_ARB,
                       strlen(shaderASM ),shaderASM);

 glGetIntegerv( GL_PROGRAM_ERROR_POSITION_ARB, (int*)&i);
 if(i!=-1)
  {
   if(vpShader) glDeleteProgramsARB_Ex(1,&vpShader);
   vpShader=0;
  }

 glEnable(GL_VERTEX_PROGRAM_ARB);
}

///////////////////////////////////////////////////////////////////////////












